/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.common;

import com.netsdk.common.Res;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DateChooserJButtonEx
extends JButton {
    private static final long serialVersionUID = 1L;
    int startYear = 1980;
    int lastYear = 2050;
    private DateChooser dateChooser = null;
    private String preLabel = "";
    private String originalText = null;
    private SimpleDateFormat sdf = null;
    private JSpinner yearSpin;
    private JSpinner monthSpin;
    private JSpinner daySpin;
    private JSpinner hourSpin;
    private JSpinner minuteSpin;
    private JSpinner secondSpin;

    public DateChooserJButtonEx() {
        this(DateChooserJButtonEx.getNowDate());
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DateChooserJButtonEx(String dateString) {
        this();
        this.setText(DateChooserJButtonEx.getDefaultDateFormat(), dateString);
        this.initOriginalText(dateString);
    }

    public DateChooserJButtonEx(SimpleDateFormat df, String dateString) {
        this();
        this.setText(df, dateString);
        this.sdf = df;
        Date originalDate = null;
        try {
            originalDate = df.parse(dateString);
        }
        catch (ParseException ex) {
            originalDate = DateChooserJButtonEx.getNowDate();
        }
        this.initOriginalText(originalDate);
    }

    public DateChooserJButtonEx(Date date) {
        this("", date);
        this.initOriginalText(date);
    }

    public DateChooserJButtonEx(String preLabel, Date date) {
        if (preLabel != null) {
            this.preLabel = preLabel;
        }
        this.setDate(date);
        this.initOriginalText(date);
        this.setBorder(null);
        this.setCursor(new Cursor(12));
        super.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DateChooserJButtonEx.this.dateChooser == null) {
                    DateChooserJButtonEx.this.dateChooser = new DateChooser();
                }
                DateChooserJButtonEx.this.dateChooser.showDateChooser();
            }
        });
    }

    public void setStartYear(int startYear) {
        this.startYear = startYear;
    }

    public void setLastYear(int lastYear) {
        this.lastYear = lastYear;
    }

    private static Date getNowDate() {
        return Calendar.getInstance().getTime();
    }

    private static SimpleDateFormat getDefaultDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public SimpleDateFormat getCurrentSimpleDateFormat() {
        if (this.sdf != null) {
            return this.sdf;
        }
        return DateChooserJButtonEx.getDefaultDateFormat();
    }

    private void initOriginalText(String dateString) {
        this.originalText = dateString;
    }

    private void initOriginalText(Date date) {
        this.originalText = this.preLabel + DateChooserJButtonEx.getDefaultDateFormat().format(date);
    }

    public String getOriginalText() {
        return this.originalText;
    }

    @Override
    public void setText(String s) {
        Date date;
        try {
            date = DateChooserJButtonEx.getDefaultDateFormat().parse(s);
        }
        catch (ParseException e) {
            date = DateChooserJButtonEx.getNowDate();
        }
        this.setDate(date);
        this.initOriginalText(date);
    }

    public void setText(SimpleDateFormat df, String s) {
        Date date;
        try {
            date = df.parse(s);
        }
        catch (ParseException e) {
            date = DateChooserJButtonEx.getNowDate();
        }
        this.setDate(date);
        this.initOriginalText(date);
    }

    public void setDate(Date date) {
        super.setText(this.preLabel + DateChooserJButtonEx.getDefaultDateFormat().format(date));
    }

    public Date getDate() {
        String dateString = this.getText().substring(this.preLabel.length());
        try {
            SimpleDateFormat currentSdf = this.getCurrentSimpleDateFormat();
            return currentSdf.parse(dateString);
        }
        catch (ParseException e) {
            return DateChooserJButtonEx.getNowDate();
        }
    }

    @Override
    public void addActionListener(ActionListener listener) {
    }

    private class DateChooser
    extends JPanel
    implements MouseListener,
    ChangeListener {
        private static final long serialVersionUID = 1L;
        JLabel yearLabel;
        JLabel monthLabel;
        JLabel dayLabel;
        int width = 485;
        int height = 230;
        Color backGroundColor = Color.gray;
        Color palletTableColor = Color.white;
        Color todayBackColor = Color.orange;
        Color weekFontColor = Color.blue;
        Color dateFontColor = Color.black;
        Color weekendFontColor = Color.red;
        Color controlLineColor = Color.pink;
        Color controlTextColor = Color.white;
        JDialog dialog;
        JLabel[][] daysLabels = new JLabel[6][7];

        DateChooser() {
            this.setLayout(new BorderLayout());
            this.setBorder(new LineBorder(this.backGroundColor, 2));
            this.setBackground(this.backGroundColor);
            JPanel topYearAndMonth = this.createYearAndMonthPanal();
            this.add((Component)topYearAndMonth, "North");
            JPanel centerWeekAndDay = this.createWeekAndDayPanal();
            this.add((Component)centerWeekAndDay, "Center");
            JPanel buttonBarPanel = this.createButtonBarPanel();
            this.add((Component)buttonBarPanel, "South");
        }

        private JPanel createYearAndMonthPanal() {
            Calendar c = this.getCalendar();
            int currentYear = c.get(1);
            int currentMonth = c.get(2) + 1;
            int currentDay = c.get(5);
            JPanel result = new JPanel();
            result.setLayout(new FlowLayout());
            result.setBackground(this.controlLineColor);
            DateChooserJButtonEx.this.yearSpin = new JSpinner(new SpinnerNumberModel(currentYear, DateChooserJButtonEx.this.startYear, DateChooserJButtonEx.this.lastYear, 1));
            DateChooserJButtonEx.this.yearSpin.setPreferredSize(new Dimension(48, 20));
            DateChooserJButtonEx.this.yearSpin.setName("Year");
            DateChooserJButtonEx.this.yearSpin.setEditor(new JSpinner.NumberEditor(DateChooserJButtonEx.this.yearSpin, "####"));
            DateChooserJButtonEx.this.yearSpin.addChangeListener(this);
            result.add(DateChooserJButtonEx.this.yearSpin);
            this.yearLabel = new JLabel(Res.string().getYear());
            this.yearLabel.setForeground(this.controlTextColor);
            result.add(this.yearLabel);
            DateChooserJButtonEx.this.monthSpin = new JSpinner(new SpinnerNumberModel(currentMonth, 1, 12, 1));
            DateChooserJButtonEx.this.monthSpin.setPreferredSize(new Dimension(35, 20));
            DateChooserJButtonEx.this.monthSpin.setName("Month");
            DateChooserJButtonEx.this.monthSpin.addChangeListener(this);
            result.add(DateChooserJButtonEx.this.monthSpin);
            this.monthLabel = new JLabel(Res.string().getMonth());
            this.monthLabel.setForeground(this.controlTextColor);
            result.add(this.monthLabel);
            DateChooserJButtonEx.this.daySpin = new JSpinner(new SpinnerNumberModel(currentDay, 1, 31, 1));
            DateChooserJButtonEx.this.daySpin.setPreferredSize(new Dimension(35, 20));
            DateChooserJButtonEx.this.daySpin.setName("Day");
            DateChooserJButtonEx.this.daySpin.addChangeListener(this);
            DateChooserJButtonEx.this.daySpin.setEnabled(false);
            result.add(DateChooserJButtonEx.this.daySpin);
            this.dayLabel = new JLabel(Res.string().getDay());
            this.dayLabel.setForeground(this.controlTextColor);
            result.add(this.dayLabel);
            return result;
        }

        private JPanel createWeekAndDayPanal() {
            int i;
            Res.string().getWeek();
            JPanel result = new JPanel();
            result.setFont(new Font("\u5b8b\u4f53", 0, 12));
            result.setLayout(new GridLayout(7, 7));
            result.setBackground(Color.white);
            for (i = 0; i < 7; ++i) {
                JLabel cell = new JLabel(Res.string().getWeek()[i]);
                cell.setHorizontalAlignment(4);
                if (i == 0 || i == 6) {
                    cell.setForeground(this.weekendFontColor);
                } else {
                    cell.setForeground(this.weekFontColor);
                }
                result.add(cell);
            }
            for (i = 0; i < 6; ++i) {
                for (int j = 0; j < 7; ++j) {
                    JLabel numberLabel = new JLabel();
                    numberLabel.setBorder(null);
                    numberLabel.setHorizontalAlignment(4);
                    numberLabel.addMouseListener(this);
                    numberLabel.setBackground(this.palletTableColor);
                    numberLabel.setForeground(this.dateFontColor);
                    if (j == 0 || j == 6) {
                        numberLabel.setForeground(this.weekendFontColor);
                    } else {
                        numberLabel.setForeground(this.dateFontColor);
                    }
                    this.daysLabels[i][j] = numberLabel;
                    result.add(numberLabel);
                }
            }
            return result;
        }

        public String getTextOfDateChooserButton() {
            return DateChooserJButtonEx.this.getText();
        }

        public void restoreTheOriginalDate() {
            String originalText = DateChooserJButtonEx.this.getOriginalText();
            DateChooserJButtonEx.this.setText(originalText);
        }

        private JPanel createButtonBarPanel() {
            JPanel panel = new JPanel();
            panel.setLayout(new GridLayout(1, 2));
            JButton ok = new JButton(Res.string().getConfirm());
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DateChooserJButtonEx.this.initOriginalText(DateChooser.this.getTextOfDateChooserButton());
                    DateChooser.this.dialog.setVisible(false);
                }
            });
            panel.add(ok);
            JButton cancel = new JButton(Res.string().getCancel());
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DateChooser.this.restoreTheOriginalDate();
                    DateChooser.this.dialog.setVisible(false);
                }
            });
            panel.add(cancel);
            return panel;
        }

        private JDialog createDialog() {
            JDialog result = new JDialog();
            result.setTitle(Res.string().getDateChooser());
            result.setDefaultCloseOperation(2);
            result.getContentPane().add((Component)this, "Center");
            result.pack();
            result.setSize(this.width, this.height);
            result.setModal(true);
            result.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    DateChooser.this.restoreTheOriginalDate();
                    DateChooser.this.dialog.setVisible(false);
                }
            });
            return result;
        }

        void showDateChooser() {
            if (this.dialog == null) {
                this.dialog = this.createDialog();
            }
            this.dialog.setLocationRelativeTo(null);
            this.flushWeekAndDay();
            this.dialog.setVisible(true);
        }

        private Calendar getCalendar() {
            Calendar result = Calendar.getInstance();
            result.setTime(DateChooserJButtonEx.this.getDate());
            return result;
        }

        private int getSelectedYear() {
            return (Integer)DateChooserJButtonEx.this.yearSpin.getValue();
        }

        private int getSelectedMonth() {
            return (Integer)DateChooserJButtonEx.this.monthSpin.getValue();
        }

        private int getSelectedHour() {
            return (Integer)DateChooserJButtonEx.this.hourSpin.getValue();
        }

        private int getSelectedMinite() {
            return (Integer)DateChooserJButtonEx.this.minuteSpin.getValue();
        }

        private int getSelectedSecond() {
            return (Integer)DateChooserJButtonEx.this.secondSpin.getValue();
        }

        private void dayColorUpdate(boolean isOldDay) {
            Calendar c = this.getCalendar();
            int day = c.get(5);
            c.set(5, 1);
            int actionCommandId = day - 2 + c.get(7);
            int i = actionCommandId / 7;
            int j = actionCommandId % 7;
            if (isOldDay) {
                this.daysLabels[i][j].setForeground(this.dateFontColor);
            } else {
                this.daysLabels[i][j].setForeground(this.todayBackColor);
            }
        }

        private void flushWeekAndDay() {
            int i;
            Calendar c = this.getCalendar();
            c.set(5, 1);
            int maxDayNo = c.getActualMaximum(5);
            int dayNo = 2 - c.get(7);
            for (int i2 = 0; i2 < 6; ++i2) {
                for (int j = 0; j < 7; ++j) {
                    String s = "";
                    if (dayNo >= 1 && dayNo <= maxDayNo) {
                        s = String.valueOf(dayNo);
                    }
                    this.daysLabels[i2][j].setText(s);
                    ++dayNo;
                }
            }
            String[] date1 = DateChooserJButtonEx.this.getText().split(" ")[0].split("-");
            DateChooserJButtonEx.this.yearSpin.setValue(new Integer(date1[0]));
            DateChooserJButtonEx.this.monthSpin.setValue(new Integer(date1[1]));
            DateChooserJButtonEx.this.daySpin.setValue(new Integer(date1[2]));
            for (i = 0; i < 6; ++i) {
                for (int j = 0; j < 7; ++j) {
                    if (this.daysLabels[i][j].getText().equals("")) continue;
                    this.daysLabels[i][j].setForeground(Color.BLACK);
                }
            }
            for (i = 0; i < 6; ++i) {
                if (!this.daysLabels[i][0].getText().equals("")) {
                    this.daysLabels[i][0].setForeground(this.weekendFontColor);
                }
                if (this.daysLabels[i][6].getText().equals("")) continue;
                this.daysLabels[i][6].setForeground(this.weekendFontColor);
            }
            for (i = 0; i < 6; ++i) {
                for (int j = 0; j < 7; ++j) {
                    if (!this.daysLabels[i][j].getText().equals(date1[2])) continue;
                    this.daysLabels[i][j].setForeground(this.todayBackColor);
                }
            }
            this.dayColorUpdate(false);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSpinner source = (JSpinner)e.getSource();
            Calendar c = this.getCalendar();
            if (source.getName().equals("Hour")) {
                c.set(11, this.getSelectedHour());
                DateChooserJButtonEx.this.setDate(c.getTime());
                return;
            }
            if (source.getName().equals("Minute")) {
                c.set(12, this.getSelectedMinite());
                DateChooserJButtonEx.this.setDate(c.getTime());
                return;
            }
            if (source.getName().equals("Second")) {
                c.set(13, this.getSelectedSecond());
                DateChooserJButtonEx.this.setDate(c.getTime());
                return;
            }
            this.dayColorUpdate(true);
            if (source.getName().equals("Year")) {
                c.set(1, this.getSelectedYear());
            } else if (source.getName().equals("Month")) {
                c.set(2, this.getSelectedMonth() - 1);
            }
            DateChooserJButtonEx.this.setDate(c.getTime());
            this.flushWeekAndDay();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JLabel source = (JLabel)e.getSource();
            if (source.getText().length() == 0) {
                return;
            }
            this.dayColorUpdate(true);
            source.setForeground(this.todayBackColor);
            int newDay = Integer.parseInt(source.getText());
            Calendar c = this.getCalendar();
            c.set(5, newDay);
            DateChooserJButtonEx.this.setDate(c.getTime());
            DateChooserJButtonEx.this.daySpin.setValue(newDay);
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    }
}

