/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame;

import com.netsdk.common.BorderEx;
import com.netsdk.common.FunctionList;
import com.netsdk.common.LoginPanel;
import com.netsdk.common.Res;
import com.netsdk.demo.module.AlarmListenModule;
import com.netsdk.demo.module.LoginModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;

class AlarmListenFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private DisConnect disConnect = new DisConnect();
    private static HaveReConnect haveReConnect = new HaveReConnect();
    private static JFrame frame = new JFrame();
    private Component target = this;
    Vector<AlarmEventInfo> data = new Vector();
    private fAlarmDataCB cbMessage = new fAlarmDataCB();
    private static HashMap<Integer, String> alarmMessageMap = new HashMap<Integer, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(8449, Res.string().getExternalAlarm());
            this.put(8450, Res.string().getMotionAlarm());
            this.put(8451, Res.string().getVideoLostAlarm());
            this.put(8452, Res.string().getShelterAlarm());
            this.put(8454, Res.string().getDiskFullAlarm());
            this.put(8455, Res.string().getDiskErrorAlarm());
        }
    };
    private LoginPanel loginPanel;
    private AlarmListenPanel alarmListenPanel;
    private ShowAlarmEventPanel showAlarmPanel;

    public AlarmListenFrame() {
        this.setTitle(Res.string().getAlarmListen());
        this.setLayout(new BorderLayout());
        this.pack();
        this.setSize(800, 530);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        LoginModule.init(this.disConnect, haveReConnect);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loginPanel = new LoginPanel();
        this.alarmListenPanel = new AlarmListenPanel();
        this.showAlarmPanel = new ShowAlarmEventPanel();
        JSplitPane splitPane = new JSplitPane(0, this.loginPanel, this.alarmListenPanel);
        splitPane.setDividerSize(0);
        this.add((Component)splitPane, "North");
        this.add((Component)this.showAlarmPanel, "Center");
        this.loginPanel.addLoginBtnActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AlarmListenFrame.this.loginPanel.checkLoginText() && AlarmListenFrame.this.login()) {
                    frame = ToolKits.getFrame(e);
                    frame.setTitle(Res.string().getAlarmListen() + " : " + Res.string().getOnline());
                }
            }
        });
        this.loginPanel.addLogoutBtnActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setTitle(Res.string().getAlarmListen());
                AlarmListenFrame.this.logout();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AlarmListenModule.stopListen();
                LoginModule.logout();
                LoginModule.cleanup();
                AlarmListenFrame.this.dispose();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FunctionList demo = new FunctionList();
                        demo.setVisible(true);
                    }
                });
            }
        });
    }

    public boolean login() {
        if (!LoginModule.login(this.loginPanel.ipTextArea.getText(), Integer.parseInt(this.loginPanel.portTextArea.getText()), this.loginPanel.nameTextArea.getText(), new String(this.loginPanel.passwordTextArea.getPassword()))) {
            JOptionPane.showMessageDialog(null, Res.string().getLoginFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return false;
        }
        this.loginPanel.setButtonEnable(true);
        this.alarmListenPanel.setButtonEnable(true);
        return true;
    }

    public void logout() {
        AlarmListenModule.stopListen();
        LoginModule.logout();
        this.loginPanel.setButtonEnable(false);
        this.alarmListenPanel.initButtonEnable();
        this.showAlarmPanel.clean();
    }

    public Vector<String> convertAlarmEventInfo(AlarmEventInfo alarmEventInfo) {
        Vector<String> vector = new Vector<String>();
        vector.add(String.valueOf(alarmEventInfo.id));
        vector.add(this.formatDate(alarmEventInfo.date));
        vector.add(String.valueOf(alarmEventInfo.chn));
        String status = null;
        status = alarmEventInfo.status == AlarmStatus.ALARM_START ? Res.string().getStart() : Res.string().getStop();
        vector.add(alarmMessageMap.get(alarmEventInfo.type) + status);
        return vector;
    }

    private String formatDate(Date date) {
        SimpleDateFormat simpleDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDate.format(date);
    }

    @Override
    protected void processEvent(AWTEvent event) {
        if (event instanceof AlarmListenEvent) {
            AlarmEventInfo alarmEventInfo = ((AlarmListenEvent)event).getAlarmEventInfo();
            this.showAlarmPanel.insert(alarmEventInfo);
        } else {
            super.processEvent(event);
        }
    }

    static class AlarmEventInfo {
        public static long index = 0L;
        public long id;
        public int chn;
        public int type;
        public Date date;
        public AlarmStatus status;

        public AlarmEventInfo(int chn, int type, AlarmStatus status) {
            this.chn = chn;
            this.type = type;
            this.status = status;
            this.date = new Date();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AlarmEventInfo showInfo = (AlarmEventInfo)o;
            return this.chn == showInfo.chn && this.type == showInfo.type;
        }
    }

    static enum AlarmStatus {
        ALARM_START,
        ALARM_STOP;

    }

    private class ShowAlarmEventPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private static final int MIN_SHOW_LINES = 20;
        private static final int MAX_SHOW_LINES = 100;
        private int currentRowNums = 0;
        private JTable table = null;
        private DefaultTableModel tableModel = null;

        public ShowAlarmEventPanel() {
            BorderEx.set(this, Res.string().getShowAlarmEvent(), 2);
            this.setLayout(new BorderLayout());
            Vector<String> columnNames = new Vector<String>();
            columnNames.add(Res.string().getIndex());
            columnNames.add(Res.string().getEventTime());
            columnNames.add(Res.string().getChannel());
            columnNames.add(Res.string().getAlarmMessage());
            this.tableModel = new DefaultTableModel(null, columnNames);
            this.table = new JTable(this.tableModel){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return false;
                }
            };
            this.tableModel.setRowCount(20);
            this.table.setSelectionMode(0);
            this.table.getColumnModel().getColumn(0).setPreferredWidth(90);
            this.table.getColumnModel().getColumn(1).setPreferredWidth(200);
            this.table.getColumnModel().getColumn(2).setPreferredWidth(80);
            this.table.getColumnModel().getColumn(3).setPreferredWidth(400);
            this.table.setAutoResizeMode(0);
            this.table.setAutoscrolls(false);
            this.table.getTableHeader().setReorderingAllowed(false);
            JScrollPane scrollPane = new JScrollPane(this.table);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setHorizontalScrollBarPolicy(31);
            this.add((Component)scrollPane, "Center");
        }

        public void insert(AlarmEventInfo alarmEventInfo) {
            this.tableModel.insertRow(0, AlarmListenFrame.this.convertAlarmEventInfo(alarmEventInfo));
            if (this.currentRowNums < 100) {
                ++this.currentRowNums;
            }
            if (this.currentRowNums <= 20) {
                this.tableModel.setRowCount(20);
            } else if (this.currentRowNums == 100) {
                this.tableModel.setRowCount(100);
            }
            this.table.updateUI();
        }

        public void clean() {
            this.currentRowNums = 0;
            AlarmListenFrame.this.data.clear();
            AlarmEventInfo.index = 0L;
            this.tableModel.setRowCount(0);
            this.tableModel.setRowCount(20);
            this.table.updateUI();
        }
    }

    private class AlarmListenPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JButton btnStartListen;
        private JButton btnStopListen;

        public AlarmListenPanel() {
            BorderEx.set(this, Res.string().getAlarmListen(), 2);
            this.setLayout(new FlowLayout());
            this.btnStartListen = new JButton(Res.string().getStartListen());
            this.btnStopListen = new JButton(Res.string().getStopListen());
            this.btnStartListen.setPreferredSize(new Dimension(150, 20));
            this.btnStopListen.setPreferredSize(new Dimension(150, 20));
            this.add(this.btnStartListen);
            this.add(new JLabel("                  "));
            this.add(this.btnStopListen);
            this.initButtonEnable();
            this.btnStartListen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AlarmListenModule.startListen(AlarmListenFrame.this.cbMessage)) {
                        AlarmListenPanel.this.setButtonEnable(false);
                    } else {
                        JOptionPane.showMessageDialog(null, Res.string().getAlarmListenFailed() + "," + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                    }
                }
            });
            this.btnStopListen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AlarmListenModule.stopListen()) {
                        AlarmListenFrame.this.showAlarmPanel.clean();
                        AlarmListenPanel.this.setButtonEnable(true);
                    } else {
                        JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                    }
                }
            });
        }

        public void setButtonEnable(boolean b) {
            this.btnStartListen.setEnabled(b);
            this.btnStopListen.setEnabled(!b);
        }

        public void initButtonEnable() {
            this.btnStartListen.setEnabled(false);
            this.btnStopListen.setEnabled(false);
        }
    }

    class AlarmListenEvent
    extends AWTEvent {
        private static final long serialVersionUID = 1L;
        public static final int EVENT_ID = 2000;
        private AlarmEventInfo alarmEventInfo;

        public AlarmListenEvent(Object target, AlarmEventInfo alarmEventInfo) {
            super(target, 2000);
            this.alarmEventInfo = alarmEventInfo;
            this.alarmEventInfo.id = ++AlarmEventInfo.index;
        }

        public AlarmEventInfo getAlarmEventInfo() {
            return this.alarmEventInfo;
        }
    }

    private class fAlarmDataCB
    implements NetSDKLib.fMessCallBack {
        private final EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();

        private fAlarmDataCB() {
        }

        @Override
        public boolean invoke(int lCommand, NetSDKLib.LLong lLoginID, Pointer pStuEvent, int dwBufLen, String strDeviceIP, NativeLong nDevicePort, Pointer dwUser) {
            switch (lCommand) {
                case 8449: 
                case 8450: 
                case 8451: 
                case 8452: 
                case 8454: 
                case 8455: {
                    byte[] alarm = new byte[dwBufLen];
                    pStuEvent.read(0L, alarm, 0, dwBufLen);
                    for (int i = 0; i < dwBufLen; ++i) {
                        AlarmEventInfo alarmEventInfo;
                        if (alarm[i] == 1) {
                            alarmEventInfo = new AlarmEventInfo(i, lCommand, AlarmStatus.ALARM_START);
                            if (AlarmListenFrame.this.data.contains(alarmEventInfo)) continue;
                            AlarmListenFrame.this.data.add(alarmEventInfo);
                            this.eventQueue.postEvent(new AlarmListenEvent(AlarmListenFrame.this.target, alarmEventInfo));
                            continue;
                        }
                        alarmEventInfo = new AlarmEventInfo(i, lCommand, AlarmStatus.ALARM_STOP);
                        if (!AlarmListenFrame.this.data.remove(alarmEventInfo)) continue;
                        this.eventQueue.postEvent(new AlarmListenEvent(AlarmListenFrame.this.target, alarmEventInfo));
                    }
                    break;
                }
            }
            return true;
        }
    }

    private static class HaveReConnect
    implements NetSDKLib.fHaveReConnect {
        private HaveReConnect() {
        }

        @Override
        public void invoke(NetSDKLib.LLong m_hLoginHandle, String pchDVRIP, int nDVRPort, Pointer dwUser) {
            System.out.printf("ReConnect Device[%s] Port[%d]\n", pchDVRIP, nDVRPort);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.setTitle(Res.string().getAlarmListen() + " : " + Res.string().getOnline());
                }
            });
        }
    }

    private class DisConnect
    implements NetSDKLib.fDisConnect {
        @Override
        public void invoke(NetSDKLib.LLong m_hLoginHandle, String pchDVRIP, int nDVRPort, Pointer dwUser) {
            System.out.printf("Device[%s] Port[%d] DisConnect!\n", pchDVRIP, nDVRPort);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.setTitle(Res.string().getAlarmListen() + " : " + Res.string().getDisConnectReconnecting());
                }
            });
        }
    }
}

