/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.Attendance;

import com.netsdk.common.BorderEx;
import com.netsdk.common.Res;
import com.netsdk.demo.module.AttendanceModule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AttendanceOperateShareDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private AttendanceModule.OPERATE_TYPE emType = AttendanceModule.OPERATE_TYPE.UNKNOWN;
    private boolean bSuccess = false;
    private UserOperateListener operateListener;
    private JTextField userIdTextField;
    private JTextField userNameTextField;
    private JTextField cardNoTextField;
    private JTextField fingerPrintIdTextField;
    private JButton confirmBtn;
    private JButton cancelBtn;

    public AttendanceOperateShareDialog(AttendanceModule.OPERATE_TYPE emType, AttendanceModule.UserData userData) {
        this(emType, userData, "");
    }

    public AttendanceOperateShareDialog(AttendanceModule.OPERATE_TYPE emType, String fingerPrintId) {
        this(emType, null, fingerPrintId);
    }

    public AttendanceOperateShareDialog(AttendanceModule.OPERATE_TYPE emType, AttendanceModule.UserData userData, String fingerPrintId) {
        this.setTitle(Res.string().getPersonOperate());
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.pack();
        this.setSize(300, 200);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        JPanel personInfoPanel = new JPanel();
        BorderEx.set(personInfoPanel, "", 4);
        Dimension dimLable = new Dimension(80, 20);
        JLabel userIdLabel = new JLabel(Res.string().getUserId());
        JLabel userNameLabel = new JLabel(Res.string().getUserName(true));
        JLabel cardNoLabel = new JLabel(Res.string().getCardNo());
        JLabel fingerPrintIdLabel = new JLabel(Res.string().getFingerPrintId());
        userIdLabel.setPreferredSize(dimLable);
        userNameLabel.setPreferredSize(dimLable);
        cardNoLabel.setPreferredSize(dimLable);
        fingerPrintIdLabel.setPreferredSize(new Dimension(85, 20));
        Dimension dimValue = new Dimension(150, 20);
        this.userIdTextField = new JTextField();
        this.userNameTextField = new JTextField();
        this.cardNoTextField = new JTextField();
        this.fingerPrintIdTextField = new JTextField();
        this.userIdTextField.setPreferredSize(dimValue);
        this.userNameTextField.setPreferredSize(dimValue);
        this.cardNoTextField.setPreferredSize(dimValue);
        this.fingerPrintIdTextField.setPreferredSize(dimValue);
        if (userData != null) {
            if (userData.userId != null) {
                this.userIdTextField.setText(userData.userId);
            }
            if (userData.userName != null) {
                this.userNameTextField.setText(userData.userName);
            }
            if (userData.cardNo != null) {
                this.cardNoTextField.setText(userData.cardNo);
            }
        }
        if (!fingerPrintId.isEmpty()) {
            this.fingerPrintIdTextField.setText(fingerPrintId);
        }
        if (emType == AttendanceModule.OPERATE_TYPE.DELETE_FINGERPRINT_BY_ID) {
            JPanel fingerPrintPanel = new JPanel();
            fingerPrintPanel.add(fingerPrintIdLabel);
            fingerPrintPanel.add(this.fingerPrintIdTextField);
            personInfoPanel.setLayout(new FlowLayout(1, 5, 40));
            personInfoPanel.add(fingerPrintPanel);
        } else {
            personInfoPanel.setLayout(new FlowLayout(1, 5, 10));
            personInfoPanel.add(userIdLabel);
            personInfoPanel.add(this.userIdTextField);
            personInfoPanel.add(userNameLabel);
            personInfoPanel.add(this.userNameTextField);
            personInfoPanel.add(cardNoLabel);
            personInfoPanel.add(this.cardNoTextField);
            if (emType == AttendanceModule.OPERATE_TYPE.DELETE_FINGERPRINT_BY_USERID || emType == AttendanceModule.OPERATE_TYPE.DELETE_USER) {
                JLabel promptLabel = new JLabel(" " + Res.string().getDeleteFingerPrintPrompt() + " ");
                promptLabel.setEnabled(false);
                personInfoPanel.add(promptLabel);
            }
        }
        JPanel functionPanel = new JPanel();
        this.confirmBtn = new JButton(Res.string().getConfirm());
        this.cancelBtn = new JButton(Res.string().getCancel());
        this.confirmBtn.setPreferredSize(new Dimension(100, 20));
        this.cancelBtn.setPreferredSize(new Dimension(100, 20));
        functionPanel.add(this.confirmBtn);
        functionPanel.add(this.cancelBtn);
        this.add((Component)personInfoPanel, "Center");
        this.add((Component)functionPanel, "South");
        this.operateListener = new UserOperateListener();
        this.confirmBtn.addActionListener(this.operateListener);
        this.cancelBtn.addActionListener(this.operateListener);
        this.emType = emType;
        switch (emType) {
            case ADD_USER: {
                this.setTitle(Res.string().getAddPerson());
                this.confirmBtn.setText(Res.string().getAdd());
                break;
            }
            case MODIFIY_USER: {
                this.setTitle(Res.string().getModifyPerson());
                this.confirmBtn.setText(Res.string().getModify());
                this.userIdTextField.setEnabled(false);
                break;
            }
            case DELETE_USER: {
                this.setTitle(Res.string().getDelPerson());
                this.confirmBtn.setText(Res.string().getDelete());
                this.userIdTextField.setEnabled(false);
                this.userNameTextField.setEnabled(false);
                this.cardNoTextField.setEnabled(false);
                break;
            }
            case DELETE_FINGERPRINT_BY_USERID: 
            case DELETE_FINGERPRINT_BY_ID: {
                this.setTitle(Res.string().getDeleteFingerPrint());
                this.confirmBtn.setText(Res.string().getDelete());
                this.userIdTextField.setEnabled(false);
                this.userNameTextField.setEnabled(false);
                this.cardNoTextField.setEnabled(false);
                this.fingerPrintIdTextField.setEditable(false);
            }
        }
    }

    public boolean checkDataValidity() {
        if (this.emType == AttendanceModule.OPERATE_TYPE.ADD_USER) {
            if (this.userIdTextField.getText().isEmpty()) {
                JOptionPane.showMessageDialog(null, Res.string().getInput() + Res.string().getUserId(), Res.string().getErrorMessage(), 0);
                return false;
            }
            try {
                if (this.userIdTextField.getText().getBytes("UTF-8").length > 31) {
                    JOptionPane.showMessageDialog(null, Res.string().getUserIdExceedLength(), Res.string().getErrorMessage(), 0);
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (this.userNameTextField.getText().getBytes("UTF-8").length > 35) {
                JOptionPane.showMessageDialog(null, Res.string().getUserNameExceedLength(), Res.string().getErrorMessage(), 0);
                return false;
            }
            if (this.cardNoTextField.getText().getBytes("UTF-8").length > 31) {
                JOptionPane.showMessageDialog(null, Res.string().getCardNoExceedLength(), Res.string().getErrorMessage(), 0);
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public AttendanceModule.UserData getUserData() {
        AttendanceModule.UserData userData = new AttendanceModule.UserData();
        userData.cardNo = this.userIdTextField.getText();
        userData.userName = this.userNameTextField.getText();
        userData.cardNo = this.cardNoTextField.getText();
        return userData;
    }

    private class UserOperateListener
    implements ActionListener {
        private UserOperateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getSource() == AttendanceOperateShareDialog.this.cancelBtn) {
                AttendanceOperateShareDialog.this.dispose();
            } else if (arg0.getSource() == AttendanceOperateShareDialog.this.confirmBtn) {
                switch (AttendanceOperateShareDialog.this.emType) {
                    case ADD_USER: {
                        if (!AttendanceOperateShareDialog.this.checkDataValidity()) {
                            return;
                        }
                        AttendanceOperateShareDialog.this.bSuccess = AttendanceModule.addUser(AttendanceOperateShareDialog.this.userIdTextField.getText(), AttendanceOperateShareDialog.this.userNameTextField.getText(), AttendanceOperateShareDialog.this.cardNoTextField.getText());
                        break;
                    }
                    case MODIFIY_USER: {
                        if (!AttendanceOperateShareDialog.this.checkDataValidity()) {
                            return;
                        }
                        AttendanceOperateShareDialog.this.bSuccess = AttendanceModule.modifyUser(AttendanceOperateShareDialog.this.userIdTextField.getText(), AttendanceOperateShareDialog.this.userNameTextField.getText(), AttendanceOperateShareDialog.this.cardNoTextField.getText());
                        break;
                    }
                    case DELETE_USER: {
                        AttendanceOperateShareDialog.this.bSuccess = AttendanceModule.deleteUser(AttendanceOperateShareDialog.this.userIdTextField.getText());
                        break;
                    }
                    case DELETE_FINGERPRINT_BY_USERID: {
                        AttendanceOperateShareDialog.this.bSuccess = AttendanceModule.removeFingerByUserId(AttendanceOperateShareDialog.this.userIdTextField.getText());
                        break;
                    }
                    case DELETE_FINGERPRINT_BY_ID: {
                        AttendanceOperateShareDialog.this.bSuccess = AttendanceModule.removeFingerRecord(Integer.parseInt(AttendanceOperateShareDialog.this.fingerPrintIdTextField.getText()));
                        break;
                    }
                    default: {
                        System.err.println("Can't Deal Operate Type: " + (Object)((Object)AttendanceOperateShareDialog.this.emType));
                    }
                }
                if (AttendanceOperateShareDialog.this.bSuccess) {
                    JOptionPane.showMessageDialog(null, Res.string().getSucceed(), Res.string().getPromptMessage(), 1);
                } else {
                    JOptionPane.showMessageDialog(null, Res.string().getFailed(), Res.string().getErrorMessage(), 0);
                }
                AttendanceOperateShareDialog.this.dispose();
            } else {
                System.err.println("Unknown Event: " + arg0.getSource());
            }
        }
    }
}

