/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.Attendance;

import com.netsdk.common.BorderEx;
import com.netsdk.common.Res;
import com.netsdk.demo.module.AttendanceModule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class AttendanceShowPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static int userIndex = 0;
    public static int eventIndex = 0;
    private static HashMap<Integer, String> openDoorMethodMap = new HashMap<Integer, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(7, Res.string().getFingerPrint());
            this.put(2, Res.string().getCard());
        }
    };
    public UserInfoShowPanel userShowPanel;
    public EventInfoShowPanel eventShowPanel;

    public AttendanceShowPanel() {
        this.setLayout(new BorderLayout());
        this.userShowPanel = new UserInfoShowPanel();
        this.eventShowPanel = new EventInfoShowPanel();
        JSplitPane splitPane = new JSplitPane();
        splitPane.setDividerSize(0);
        splitPane.setBorder(null);
        splitPane.add((Component)this.userShowPanel, "left");
        splitPane.add((Component)this.eventShowPanel, "right");
        this.add(splitPane);
    }

    public void clearup() {
        this.userShowPanel.clearData();
        this.eventShowPanel.clearEvent();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Res.string().switchLanguage(Res.LanguageType.English);
        AttendanceShowPanel demo = new AttendanceShowPanel();
        JFrame frame = new JFrame();
        frame.setSize(800, 560);
        frame.add(demo);
        System.out.println("AttendanceShowPanel Test");
        frame.setVisible(true);
    }

    public class EventInfoShowPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private static final int INDEX = 0;
        private static final int USER_ID = 1;
        private static final int CARD_NO = 2;
        private static final int EVENT_TIME = 3;
        private static final int DOOR_OPEN_METHOD = 4;
        private static final int MIN_SHOW_LINES = 17;
        private static final int MAX_SHOW_LINES = 50;
        private JTable table = null;
        private DefaultTableModel tableModel = null;

        public EventInfoShowPanel() {
            BorderEx.set(this, Res.string().getEventInfo(), 1);
            this.setLayout(new BorderLayout());
            this.setPreferredSize(new Dimension(395, 400));
            Vector<String> columnNames = new Vector<String>();
            columnNames.add(Res.string().getIndex());
            columnNames.add(Res.string().getUserId());
            columnNames.add(Res.string().getCardNo());
            columnNames.add(Res.string().getEventTime());
            columnNames.add(Res.string().getDoorOpenMethod());
            this.tableModel = new DefaultTableModel(null, columnNames);
            this.table = new JTable(this.tableModel){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return false;
                }
            };
            this.tableModel.setRowCount(17);
            this.table.setSelectionMode(0);
            this.table.getColumnModel().getColumn(0).setPreferredWidth(80);
            this.table.getColumnModel().getColumn(1).setPreferredWidth(150);
            this.table.getColumnModel().getColumn(2).setPreferredWidth(150);
            this.table.getColumnModel().getColumn(3).setPreferredWidth(150);
            this.table.getColumnModel().getColumn(4).setPreferredWidth(120);
            ((DefaultTableCellRenderer)this.table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
            this.table.setAutoResizeMode(0);
            JScrollPane scrollPane = new JScrollPane(this.table);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setHorizontalScrollBarPolicy(30);
            this.add((Component)scrollPane, "Center");
        }

        public void clearEvent() {
            eventIndex = 0;
            this.tableModel.setRowCount(0);
            this.tableModel.setRowCount(17);
            this.table.updateUI();
        }

        public void insertEvent(AttendanceModule.AccessEventInfo accessEventInfo) {
            if (accessEventInfo == null) {
                return;
            }
            this.tableModel.insertRow(0, this.convertEventData(accessEventInfo));
            if (++eventIndex <= 17) {
                this.tableModel.setRowCount(17);
            } else if (eventIndex >= 50) {
                this.tableModel.setRowCount(50);
            }
            this.table.updateUI();
        }

        private Vector<String> convertEventData(AttendanceModule.AccessEventInfo accessEventInfo) {
            Vector<String> vector = new Vector<String>();
            vector.add(String.valueOf(eventIndex));
            vector.add(accessEventInfo.userId);
            vector.add(accessEventInfo.cardNo);
            vector.add(accessEventInfo.eventTime.replace("/", "-"));
            String openDoor = (String)openDoorMethodMap.get(accessEventInfo.openDoorMethod);
            if (openDoor == null) {
                openDoor = Res.string().getUnKnow();
            }
            vector.add(openDoor);
            return vector;
        }
    }

    public class UserInfoShowPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        public static final int INDEX = 0;
        public static final int USER_ID = 1;
        public static final int USER_NAME = 2;
        public static final int CARD_NO = 3;
        public static final int FINGERPRINT_ID = 4;
        public static final int FINGERPRINT_DATA = 5;
        public static final int QUERY_SHOW_COUNT = 15;
        private int realRows = 0;
        private JTable table = null;
        private DefaultTableModel tableModel = null;
        public JButton prePageBtn;
        public JButton nextPageBtn;

        public UserInfoShowPanel() {
            BorderEx.set(this, Res.string().getUserList(), 1);
            this.setLayout(new BorderLayout());
            this.setPreferredSize(new Dimension(395, 400));
            Vector<String> columnNames = new Vector<String>();
            columnNames.add(Res.string().getIndex());
            columnNames.add(Res.string().getUserId());
            columnNames.add(Res.string().getUserName());
            columnNames.add(Res.string().getCardNo());
            this.tableModel = new DefaultTableModel(null, columnNames);
            this.table = new JTable(this.tableModel){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return false;
                }
            };
            this.tableModel.setRowCount(15);
            this.table.setSelectionMode(0);
            this.table.getColumnModel().getColumn(0).setPreferredWidth(80);
            this.table.getColumnModel().getColumn(1).setPreferredWidth(150);
            this.table.getColumnModel().getColumn(2).setPreferredWidth(150);
            this.table.getColumnModel().getColumn(3).setPreferredWidth(150);
            ((DefaultTableCellRenderer)this.table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
            this.table.setAutoResizeMode(0);
            JScrollPane scrollPane = new JScrollPane(this.table);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setHorizontalScrollBarPolicy(30);
            JPanel functionPanel = new JPanel(new FlowLayout(1));
            this.prePageBtn = new JButton(Res.string().getPreviousPage());
            this.nextPageBtn = new JButton(Res.string().getNextPage());
            this.prePageBtn.setPreferredSize(new Dimension(120, 20));
            this.nextPageBtn.setPreferredSize(new Dimension(120, 20));
            this.prePageBtn.setEnabled(false);
            this.nextPageBtn.setEnabled(false);
            functionPanel.add(this.prePageBtn);
            functionPanel.add(new JLabel("    "));
            functionPanel.add(this.nextPageBtn);
            this.add((Component)scrollPane, "Center");
            this.add((Component)functionPanel, "South");
        }

        public int getRows() {
            return this.realRows;
        }

        public AttendanceModule.UserData GetSelectedItem() {
            int currentRow = this.table.getSelectedRow();
            if (currentRow < 0 || currentRow + 1 > this.realRows) {
                return null;
            }
            AttendanceModule.UserData userData = new AttendanceModule.UserData();
            userData.userId = (String)this.tableModel.getValueAt(currentRow, 1);
            userData.userName = (String)this.tableModel.getValueAt(currentRow, 2);
            userData.cardNo = (String)this.tableModel.getValueAt(currentRow, 3);
            return userData;
        }

        public void updateSelectedItem(AttendanceModule.UserData userData) {
            int currentRow = this.table.getSelectedRow();
            if (currentRow < 0 || currentRow + 1 > this.realRows) {
                return;
            }
            this.tableModel.setValueAt(userData.userName, currentRow, 2);
            this.tableModel.setValueAt(userData.cardNo, currentRow, 3);
            this.table.updateUI();
        }

        public void insertData(AttendanceModule.UserData[] arrUserData) {
            if (arrUserData == null) {
                return;
            }
            this.realRows = 0;
            this.tableModel.setRowCount(0);
            for (AttendanceModule.UserData userData : arrUserData) {
                this.insertUserData(userData);
            }
            this.tableModel.setRowCount(15);
            this.table.updateUI();
            this.setButtonEnable(true);
        }

        public void setButtonEnable(boolean b) {
            if (b) {
                if (AttendanceModule.UserData.nTotalUser - userIndex > 0) {
                    this.nextPageBtn.setEnabled(true);
                } else {
                    this.nextPageBtn.setEnabled(false);
                }
                if (userIndex - 15 > 0) {
                    this.prePageBtn.setEnabled(true);
                } else {
                    this.prePageBtn.setEnabled(false);
                }
            } else {
                this.prePageBtn.setEnabled(false);
                this.nextPageBtn.setEnabled(false);
            }
        }

        public void insertData(AttendanceModule.UserData userData) {
            if (userData == null) {
                return;
            }
            this.clearData();
            this.tableModel.setRowCount(0);
            this.insertUserData(userData);
            this.tableModel.setRowCount(15);
            this.table.updateUI();
            this.setButtonEnable(false);
        }

        private void insertUserData(AttendanceModule.UserData userData) {
            ++this.realRows;
            Vector<String> vector = new Vector<String>();
            vector.add(String.valueOf(++userIndex));
            vector.add(userData.userId);
            vector.add(userData.userName);
            vector.add(userData.cardNo);
            this.tableModel.addRow(vector);
        }

        public void clearData() {
            this.realRows = 0;
            userIndex = 0;
            this.tableModel.setRowCount(0);
            this.tableModel.setRowCount(15);
            this.table.updateUI();
            this.prePageBtn.setEnabled(false);
            this.nextPageBtn.setEnabled(false);
        }
    }
}

