/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.AutoRegister;

import com.netsdk.common.BorderEx;
import com.netsdk.common.DeviceManagerListener;
import com.netsdk.common.FunctionList;
import com.netsdk.common.PaintPanel;
import com.netsdk.common.Res;
import com.netsdk.common.SavePath;
import com.netsdk.demo.frame.AutoRegister.AddDeviceDialog;
import com.netsdk.demo.frame.AutoRegister.DeviceConfigDialog;
import com.netsdk.demo.frame.AutoRegister.ModifyDeviceDialog;
import com.netsdk.demo.module.AutoRegisterModule;
import com.netsdk.demo.module.LoginModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.Pointer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

class AutoRegisterFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private DisConnect disConnectCallback = new DisConnect();
    private ServiceCB servicCallback = new ServiceCB();
    public CaptureReceiveCB captureCallback = new CaptureReceiveCB();
    private boolean isExist = false;
    private TreeCellRender treeCellRender = new TreeCellRender();
    private NetSDKLib.LLong realplayHandle = new NetSDKLib.LLong(0L);
    private ChannelTreeNode realplayChannelTreeNode = null;
    private DeviceTreeNode talkDeviceTreeNode = null;
    private DefaultMutableTreeNode rootNode;
    private DefaultTreeModel treeModel;
    private JTree tree;
    private Panel realplayWindowPanel;
    private PaintPanel capturePanel;
    private JTextField ipTextField;
    private JTextField portTextField;
    private JButton startListenBtn;
    private JButton stopListenBtn;
    private JButton addDeviceBtn;
    private JButton modifyDeviceBtn;
    private JButton deleteDeviceBtn;
    private JButton clearDeviceBtn;
    private JButton importDeviceBtn;
    private JButton exportDeviceBtn;
    private JButton logoutBtn;
    private JButton startRealPlayBtn;
    private JButton stopRealPlayBtn;
    private JButton startTalkBtn;
    private JButton stopTalkBtn;
    private JButton captureBtn;
    private JFileChooser jfc;

    public AutoRegisterFrame() {
        this.setTitle(Res.string().getAutoRegister());
        this.setLayout(new BorderLayout());
        this.pack();
        this.setSize(780, 540);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        LoginModule.init(this.disConnectCallback, null);
        AutoRegisterModule.setSnapRevCallBack(this.captureCallback);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AutoRegisterTreePanel autoRegisterTreePanel = new AutoRegisterTreePanel();
        RealPlayPanel realplayPanel = new RealPlayPanel();
        ListenDeviceManagerPanel listenDeviceManagerPanel = new ListenDeviceManagerPanel();
        this.add((Component)autoRegisterTreePanel, "West");
        this.add((Component)realplayPanel, "Center");
        this.add((Component)listenDeviceManagerPanel, "East");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (AutoRegisterModule.m_hTalkHandle.longValue() != 0L) {
                    AutoRegisterModule.stopTalk(AutoRegisterModule.m_hTalkHandle);
                    AutoRegisterFrame.this.talkDeviceTreeNode = null;
                }
                if (AutoRegisterFrame.this.realplayHandle.longValue() != 0L) {
                    AutoRegisterModule.stopRealPlay(AutoRegisterFrame.this.realplayHandle);
                    AutoRegisterFrame.this.realplayWindowPanel.repaint();
                    AutoRegisterFrame.this.realplayChannelTreeNode = null;
                }
                for (int i = 0; i < AutoRegisterFrame.this.rootNode.getChildCount(); ++i) {
                    DeviceTreeNode deviceTreeNode = (DeviceTreeNode)AutoRegisterFrame.this.rootNode.getChildAt(i);
                    if (deviceTreeNode.getDeviceInfo().getLoginHandle().longValue() == 0L) continue;
                    AutoRegisterModule.logout(deviceTreeNode.getDeviceInfo().getLoginHandle());
                }
                AutoRegisterModule.stopServer();
                LoginModule.cleanup();
                AutoRegisterFrame.this.dispose();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FunctionList demo = new FunctionList();
                        demo.setVisible(true);
                    }
                });
            }
        });
    }

    private void showPopupMenu(Component component, int x, int y) {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem logoutMenuItem = new JMenuItem(Res.string().getLogout());
        JMenuItem addDeviceMenuItem = new JMenuItem(Res.string().getAddDevice());
        JMenuItem modifyDeviceMenuItem = new JMenuItem(Res.string().getModifyDevice());
        JMenuItem deleteDeviceMenuItem = new JMenuItem(Res.string().getDeleteDevice());
        JMenuItem clearDeviceMenuItem = new JMenuItem(Res.string().getClearDevice());
        JMenuItem importDeviceMenuItem = new JMenuItem(Res.string().getImportDevice());
        JMenuItem exportDeviceMenuItem = new JMenuItem(Res.string().getExportDevice());
        JMenuItem realplayMenuItem = new JMenuItem(Res.string().getStartRealPlay());
        JMenuItem stopRealplayMenuItem = new JMenuItem(Res.string().getStopRealPlay());
        JMenuItem startTalkMenuItem = new JMenuItem(Res.string().getStartTalk());
        JMenuItem stopTalkMenuItem = new JMenuItem(Res.string().getStopTalk());
        JMenuItem captureMenuItem = new JMenuItem(Res.string().getRemoteCapture());
        if (this.tree.getLastSelectedPathComponent() instanceof DeviceTreeNode) {
            DeviceTreeNode deviceTreeNode = (DeviceTreeNode)this.tree.getLastSelectedPathComponent();
            if (deviceTreeNode != null && deviceTreeNode.getDeviceInfo().getLoginHandle().longValue() != 0L) {
                popupMenu.add(logoutMenuItem);
                popupMenu.add(deleteDeviceMenuItem);
                if (deviceTreeNode == this.talkDeviceTreeNode) {
                    popupMenu.add(stopTalkMenuItem);
                } else {
                    popupMenu.add(startTalkMenuItem);
                }
            } else {
                popupMenu.add(modifyDeviceMenuItem);
                popupMenu.add(deleteDeviceMenuItem);
            }
        } else if (this.tree.getLastSelectedPathComponent() instanceof ChannelTreeNode) {
            ChannelTreeNode channelTreeNode = (ChannelTreeNode)this.tree.getLastSelectedPathComponent();
            if (channelTreeNode == this.realplayChannelTreeNode) {
                popupMenu.add(stopRealplayMenuItem);
            } else {
                popupMenu.add(realplayMenuItem);
            }
            popupMenu.add(captureMenuItem);
        } else {
            popupMenu.add(addDeviceMenuItem);
            popupMenu.add(clearDeviceMenuItem);
            popupMenu.add(importDeviceMenuItem);
            popupMenu.add(exportDeviceMenuItem);
            this.logoutBtn.setEnabled(false);
            this.modifyDeviceBtn.setEnabled(false);
            this.deleteDeviceBtn.setEnabled(false);
            this.startRealPlayBtn.setEnabled(false);
            this.stopRealPlayBtn.setEnabled(false);
            this.startTalkBtn.setEnabled(false);
            this.stopTalkBtn.setEnabled(false);
            this.captureBtn.setEnabled(false);
        }
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        popupMenu.show(component, x, y);
        logoutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AutoRegisterFrame.this.logout();
                    }
                });
            }
        });
        addDeviceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AutoRegisterFrame.this.addDevice();
            }
        });
        modifyDeviceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AutoRegisterFrame.this.modifyDevice();
            }
        });
        deleteDeviceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AutoRegisterFrame.this.deleteDevice();
            }
        });
        clearDeviceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AutoRegisterFrame.this.clearDevice();
            }
        });
        importDeviceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AutoRegisterFrame.this.importDevice();
            }
        });
        exportDeviceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AutoRegisterFrame.this.exportDevice();
            }
        });
        realplayMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AutoRegisterFrame.this.startRealplay();
                    }
                });
            }
        });
        stopRealplayMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AutoRegisterFrame.this.stopRealplay();
                    }
                });
            }
        });
        startTalkMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AutoRegisterFrame.this.startTalk();
                    }
                });
            }
        });
        stopTalkMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AutoRegisterFrame.this.stopTalk();
                    }
                });
            }
        });
        captureMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AutoRegisterFrame.this.capture();
            }
        });
    }

    private void addDevice() {
        this.isExist = false;
        AddDeviceDialog addDeviceDialog = new AddDeviceDialog();
        addDeviceDialog.addDeviceManagerListener(new DeviceManagerListener(){

            @Override
            public void onDeviceManager(String deviceId, String username, String password) {
                if (!deviceId.equals("")) {
                    DeviceTreeNode childNode;
                    if (AutoRegisterFrame.this.rootNode.getChildCount() >= 100) {
                        JOptionPane.showMessageDialog(null, Res.string().getMaximumSupport(), Res.string().getErrorMessage(), 0);
                        return;
                    }
                    for (int i = 0; i < AutoRegisterFrame.this.rootNode.getChildCount(); ++i) {
                        childNode = (DeviceTreeNode)AutoRegisterFrame.this.rootNode.getChildAt(i);
                        if (!deviceId.equals(childNode.getDeviceInfo().getDevcieId())) continue;
                        AutoRegisterFrame.this.isExist = true;
                        JOptionPane.showMessageDialog(null, Res.string().getAlreadyExisted(), Res.string().getErrorMessage(), 0);
                        break;
                    }
                    if (!AutoRegisterFrame.this.isExist) {
                        DEVICE_INFO deviceInfo = new DEVICE_INFO();
                        deviceInfo.setDevcieId(deviceId);
                        deviceInfo.setUsername(username);
                        deviceInfo.setPassword(password);
                        childNode = new DeviceTreeNode();
                        childNode.setDeviceInfo(deviceInfo);
                        childNode.setUserObject(deviceId);
                        AutoRegisterFrame.this.rootNode.add(childNode);
                        AutoRegisterFrame.this.tree.expandPath(new TreePath(AutoRegisterFrame.this.rootNode));
                        AutoRegisterFrame.this.tree.updateUI();
                        AutoRegisterFrame.this.tree.setCellRenderer(AutoRegisterFrame.this.treeCellRender);
                        JOptionPane.showMessageDialog(null, Res.string().getSucceed(), Res.string().getPromptMessage(), 1);
                    }
                }
            }
        });
        addDeviceDialog.setVisible(true);
    }

    private void modifyDevice() {
        this.isExist = false;
        final DeviceTreeNode deviceTreeNode = (DeviceTreeNode)this.tree.getLastSelectedPathComponent();
        if (deviceTreeNode == null) {
            return;
        }
        ModifyDeviceDialog modifyDeviceDialog = new ModifyDeviceDialog(deviceTreeNode.getDeviceInfo().devcieId, deviceTreeNode.getDeviceInfo().username, deviceTreeNode.getDeviceInfo().password);
        modifyDeviceDialog.addDeviceManagerListener(new DeviceManagerListener(){

            @Override
            public void onDeviceManager(String deviceId, String username, String password) {
                if (deviceTreeNode.getDeviceInfo().getLoginHandle().longValue() != 0L) {
                    JOptionPane.showMessageDialog(null, Res.string().getDeviceLogined(), Res.string().getErrorMessage(), 1);
                    return;
                }
                if (!deviceId.equals("")) {
                    if (!deviceId.equals(deviceTreeNode.getDeviceInfo().devcieId)) {
                        for (int i = 0; i < AutoRegisterFrame.this.rootNode.getChildCount(); ++i) {
                            DeviceTreeNode childNode = (DeviceTreeNode)AutoRegisterFrame.this.rootNode.getChildAt(i);
                            if (!deviceId.equals(childNode.getDeviceInfo().getDevcieId())) continue;
                            AutoRegisterFrame.this.isExist = true;
                            JOptionPane.showMessageDialog(null, Res.string().getAlreadyExisted(), Res.string().getErrorMessage(), 0);
                            break;
                        }
                    }
                    if (!AutoRegisterFrame.this.isExist) {
                        deviceTreeNode.getDeviceInfo().setDevcieId(deviceId);
                        deviceTreeNode.getDeviceInfo().setUsername(username);
                        deviceTreeNode.getDeviceInfo().setPassword(password);
                        deviceTreeNode.setUserObject(deviceId);
                        deviceTreeNode.removeAllChildren();
                        AutoRegisterFrame.this.tree.updateUI();
                        JOptionPane.showMessageDialog(null, Res.string().getSucceed(), Res.string().getPromptMessage(), 1);
                    }
                }
            }
        });
        modifyDeviceDialog.setVisible(true);
    }

    private void deleteDevice() {
        DeviceTreeNode deviceTreeNode = (DeviceTreeNode)this.tree.getLastSelectedPathComponent();
        if (deviceTreeNode == null) {
            return;
        }
        if (deviceTreeNode == this.talkDeviceTreeNode) {
            AutoRegisterModule.stopTalk(AutoRegisterModule.m_hTalkHandle);
            this.talkDeviceTreeNode = null;
        }
        for (int i = 0; i < deviceTreeNode.getChildCount(); ++i) {
            ChannelTreeNode channelTreeNode = (ChannelTreeNode)deviceTreeNode.getChildAt(i);
            if (channelTreeNode != this.realplayChannelTreeNode) continue;
            AutoRegisterModule.stopRealPlay(this.realplayHandle);
            this.realplayWindowPanel.repaint();
            this.realplayChannelTreeNode = null;
            break;
        }
        if (deviceTreeNode.getDeviceInfo().getLoginHandle().longValue() != 0L) {
            AutoRegisterModule.logout(deviceTreeNode.getDeviceInfo().getLoginHandle());
            this.logoutBtn.setEnabled(false);
            this.modifyDeviceBtn.setEnabled(true);
        }
        deviceTreeNode.setUserObject(deviceTreeNode.getDeviceInfo().getDevcieId());
        this.treeModel.removeNodeFromParent(deviceTreeNode);
        this.tree.updateUI();
        this.modifyDeviceBtn.setEnabled(false);
        this.deleteDeviceBtn.setEnabled(false);
    }

    private void clearDevice() {
        if (this.realplayHandle.longValue() != 0L) {
            AutoRegisterModule.stopRealPlay(this.realplayHandle);
            this.realplayWindowPanel.repaint();
            this.realplayChannelTreeNode = null;
        }
        if (AutoRegisterModule.m_hTalkHandle.longValue() != 0L) {
            AutoRegisterModule.stopTalk(AutoRegisterModule.m_hTalkHandle);
            this.talkDeviceTreeNode = null;
        }
        for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
            DeviceTreeNode deviceTreeNode = (DeviceTreeNode)this.rootNode.getChildAt(i);
            if (deviceTreeNode.getDeviceInfo().getLoginHandle().longValue() == 0L) continue;
            AutoRegisterModule.logout(deviceTreeNode.getDeviceInfo().getLoginHandle());
        }
        this.capturePanel.setOpaque(true);
        this.capturePanel.repaint();
        this.rootNode.removeAllChildren();
        this.tree.updateUI();
        this.logoutBtn.setEnabled(false);
        this.modifyDeviceBtn.setEnabled(false);
        this.deleteDeviceBtn.setEnabled(false);
        this.startRealPlayBtn.setEnabled(false);
        this.stopRealPlayBtn.setEnabled(false);
        this.startTalkBtn.setEnabled(false);
        this.stopTalkBtn.setEnabled(false);
        this.captureBtn.setEnabled(false);
    }

    private void importDevice() {
        this.jfc = new JFileChooser("./");
        this.jfc.setMultiSelectionEnabled(false);
        this.jfc.setAcceptAllFileFilterUsed(false);
        this.jfc.setDialogTitle(Res.string().getImportDevice());
        this.jfc.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith("csv") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return ".csv";
            }
        });
        if (this.jfc.showOpenDialog(null) == 0) {
            String path = this.jfc.getSelectedFile().getAbsolutePath();
            if (!path.endsWith("csv")) {
                path = path + ".csv";
            }
            this.importFile(path, "GB2312");
        }
    }

    private void exportDevice() {
        this.jfc = new JFileChooser("./");
        this.jfc.setMultiSelectionEnabled(false);
        this.jfc.setAcceptAllFileFilterUsed(false);
        this.jfc.setDialogTitle(Res.string().getExportDevice());
        this.jfc.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith("csv") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return ".csv";
            }
        });
        if (this.jfc.showSaveDialog(null) == 0) {
            String path = this.jfc.getSelectedFile().toString();
            if (!path.endsWith("csv")) {
                path = path + ".csv";
            }
            System.out.println(path);
            File file = new File(path);
            if (file.exists()) {
                int result = JOptionPane.showConfirmDialog(null, Res.string().getWhetherNoToCover(), Res.string().getPromptMessage(), 0);
                if (result == 0) {
                    if (!file.renameTo(file)) {
                        JOptionPane.showMessageDialog(null, Res.string().getFileOpened(), Res.string().getErrorMessage(), 0);
                    } else {
                        this.exportFile(file);
                    }
                }
            } else {
                this.exportFile(file);
            }
        }
    }

    private void logout() {
        DeviceTreeNode deviceTreeNode = (DeviceTreeNode)this.tree.getLastSelectedPathComponent();
        if (deviceTreeNode == null) {
            return;
        }
        if (deviceTreeNode == this.talkDeviceTreeNode) {
            AutoRegisterModule.stopTalk(AutoRegisterModule.m_hTalkHandle);
            this.talkDeviceTreeNode = null;
        }
        for (int i = 0; i < deviceTreeNode.getChildCount(); ++i) {
            ChannelTreeNode channelTreeNode = (ChannelTreeNode)deviceTreeNode.getChildAt(i);
            if (channelTreeNode != this.realplayChannelTreeNode) continue;
            AutoRegisterModule.stopRealPlay(this.realplayHandle);
            this.realplayWindowPanel.repaint();
            this.realplayChannelTreeNode = null;
            break;
        }
        if (deviceTreeNode.getDeviceInfo().getLoginHandle().longValue() != 0L) {
            AutoRegisterModule.logout(deviceTreeNode.getDeviceInfo().getLoginHandle());
            this.logoutBtn.setEnabled(false);
            this.modifyDeviceBtn.setEnabled(true);
        }
        deviceTreeNode.setUserObject(deviceTreeNode.getDeviceInfo().getDevcieId());
        deviceTreeNode.removeAllChildren();
        this.tree.updateUI();
    }

    private void startRealplay() {
        ChannelTreeNode channelTreeNode = (ChannelTreeNode)this.tree.getLastSelectedPathComponent();
        if (channelTreeNode == null) {
            return;
        }
        DeviceTreeNode deviceTreeNode = (DeviceTreeNode)channelTreeNode.getParent();
        if (this.realplayHandle.longValue() != 0L) {
            AutoRegisterModule.stopRealPlay(this.realplayHandle);
            this.realplayWindowPanel.repaint();
            this.realplayChannelTreeNode = null;
        }
        this.realplayHandle = AutoRegisterModule.startRealPlay(deviceTreeNode.getDeviceInfo().getLoginHandle(), channelTreeNode.getChn() - 1, 0, this.realplayWindowPanel);
        if (this.realplayHandle.longValue() != 0L) {
            this.startRealPlayBtn.setEnabled(false);
            this.stopRealPlayBtn.setEnabled(true);
            this.realplayChannelTreeNode = channelTreeNode;
        } else {
            JOptionPane.showMessageDialog(null, Res.string().getRealplay() + Res.string().getFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
        }
        this.tree.updateUI();
    }

    private void stopRealplay() {
        if (this.realplayHandle.longValue() != 0L) {
            AutoRegisterModule.stopRealPlay(this.realplayHandle);
            this.realplayWindowPanel.repaint();
            this.realplayChannelTreeNode = null;
            this.startRealPlayBtn.setEnabled(true);
            this.stopRealPlayBtn.setEnabled(false);
        }
        this.tree.updateUI();
    }

    private void startTalk() {
        DeviceTreeNode deviceTreeNode = (DeviceTreeNode)this.tree.getLastSelectedPathComponent();
        if (deviceTreeNode == null) {
            return;
        }
        if (AutoRegisterModule.m_hTalkHandle.longValue() != 0L) {
            AutoRegisterModule.stopTalk(AutoRegisterModule.m_hTalkHandle);
            this.talkDeviceTreeNode = null;
        }
        if (AutoRegisterModule.startTalk(deviceTreeNode.getDeviceInfo().getLoginHandle())) {
            this.startTalkBtn.setEnabled(false);
            this.stopTalkBtn.setEnabled(true);
            this.talkDeviceTreeNode = deviceTreeNode;
        } else {
            JOptionPane.showMessageDialog(null, Res.string().getTalk() + Res.string().getFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
        }
        this.tree.updateUI();
    }

    private void stopTalk() {
        if (AutoRegisterModule.m_hTalkHandle.longValue() != 0L) {
            AutoRegisterModule.stopTalk(AutoRegisterModule.m_hTalkHandle);
            this.talkDeviceTreeNode = null;
            this.startTalkBtn.setEnabled(true);
            this.stopTalkBtn.setEnabled(false);
        }
        this.tree.updateUI();
    }

    private void capture() {
        ChannelTreeNode channelTreeNode = (ChannelTreeNode)this.tree.getLastSelectedPathComponent();
        if (channelTreeNode == null) {
            return;
        }
        DeviceTreeNode deviceTreeNode = (DeviceTreeNode)channelTreeNode.getParent();
        AutoRegisterModule.snapPicture(deviceTreeNode.getDeviceInfo().getLoginHandle(), channelTreeNode.getChn() - 1);
    }

    private NetSDKLib.LLong login(DeviceTreeNode deviceTreeNode) {
        if (deviceTreeNode.getDeviceInfo().getLoginHandle().longValue() != 0L) {
            return null;
        }
        NetSDKLib.LLong loginHandleLong = AutoRegisterModule.login(deviceTreeNode.getDeviceInfo().getDeviceIp(), deviceTreeNode.getDeviceInfo().getDevicePort(), deviceTreeNode.getDeviceInfo().getUsername(), deviceTreeNode.getDeviceInfo().getPassword(), deviceTreeNode.getDeviceInfo().getDevcieId());
        if (loginHandleLong.longValue() != 0L) {
            System.out.printf("Login Success [Device IP %s][port %d][DeviceID %s]\n", deviceTreeNode.getDeviceInfo().getDeviceIp(), deviceTreeNode.getDeviceInfo().getDevicePort(), deviceTreeNode.getDeviceInfo().getDevcieId());
        } else {
            System.err.printf("Login Failed[Device IP %s] [Port %d][DeviceID %s] %s", deviceTreeNode.getDeviceInfo().getDeviceIp(), deviceTreeNode.getDeviceInfo().getDevicePort(), deviceTreeNode.getDeviceInfo().getDevcieId(), ToolKits.getErrorCodePrint());
        }
        return loginHandleLong;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFile(String filePath, String encoding) {
        File file = new File(filePath);
        if (!file.exists()) {
            JOptionPane.showMessageDialog(null, Res.string().getFileNotExist(), Res.string().getErrorMessage(), 0);
            return;
        }
        FileInputStream input = null;
        InputStreamReader reader = null;
        BufferedReader bReader = null;
        try {
            input = new FileInputStream(file);
            reader = encoding == null ? new InputStreamReader(input) : new InputStreamReader((InputStream)input, encoding);
            bReader = new BufferedReader(reader);
            String line = bReader.readLine();
            String everyLine = "";
            while ((line = bReader.readLine()) != null) {
                DeviceTreeNode childNode;
                everyLine = line;
                if (this.rootNode.getChildCount() >= 100) {
                    return;
                }
                String[] infos = everyLine.split(",");
                this.isExist = false;
                if (infos[0].equals("")) continue;
                for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
                    childNode = (DeviceTreeNode)this.rootNode.getChildAt(i);
                    if (!infos[0].equals(childNode.getDeviceInfo().getDevcieId())) continue;
                    this.isExist = true;
                    break;
                }
                if (this.isExist) continue;
                DEVICE_INFO deviceInfo = new DEVICE_INFO();
                deviceInfo.setDevcieId(infos[0]);
                if (infos.length == 1) {
                    deviceInfo.setUsername("");
                    deviceInfo.setPassword("");
                } else if (infos.length == 2) {
                    deviceInfo.setUsername(infos[1]);
                    deviceInfo.setPassword("");
                } else if (infos.length == 3) {
                    deviceInfo.setUsername(infos[1]);
                    deviceInfo.setPassword(infos[2]);
                }
                childNode = new DeviceTreeNode();
                childNode.setDeviceInfo(deviceInfo);
                childNode.setUserObject(infos[0]);
                this.rootNode.add(childNode);
                this.tree.expandPath(new TreePath(this.rootNode));
                this.tree.updateUI();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != bReader) {
                try {
                    bReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.tree.setCellRenderer(this.treeCellRender);
            JOptionPane.showMessageDialog(null, Res.string().getImportCompletion(), Res.string().getPromptMessage(), 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportFile(File file) {
        FileOutputStream output = null;
        OutputStreamWriter osWriter = null;
        BufferedWriter bWriter = null;
        try {
            output = new FileOutputStream(file);
            osWriter = new OutputStreamWriter((OutputStream)output, "GB2312");
            bWriter = new BufferedWriter(osWriter);
            bWriter.write("DeviceId,UserName,Password");
            bWriter.newLine();
            for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
                DeviceTreeNode childNode = (DeviceTreeNode)this.rootNode.getChildAt(i);
                String deviceId = childNode.getDeviceInfo().getDevcieId();
                String username = childNode.getDeviceInfo().getUsername();
                String password = childNode.getDeviceInfo().getPassword();
                bWriter.write(deviceId + "," + username + "," + password);
                bWriter.newLine();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != bWriter) {
                try {
                    bWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            JOptionPane.showMessageDialog(null, Res.string().getExportCompletion(), Res.string().getPromptMessage(), 1);
        }
    }

    private String getHostAddress() {
        String address = "";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            address = inetAddress.getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return address;
    }

    public class CaptureReceiveCB
    implements NetSDKLib.fSnapRev {
        BufferedImage bufferedImage = null;

        @Override
        public void invoke(NetSDKLib.LLong lLoginID, Pointer pBuf, int RevLen, int EncodeType, int CmdSerial, Pointer dwUser) {
            if (pBuf != null && RevLen > 0) {
                String strFileName = SavePath.getSavePath().getSaveCapturePath();
                System.out.println("strFileName = " + strFileName);
                byte[] buf = pBuf.getByteArray(0L, RevLen);
                ByteArrayInputStream byteArrInput = new ByteArrayInputStream(buf);
                try {
                    this.bufferedImage = ImageIO.read(byteArrInput);
                    if (this.bufferedImage == null) {
                        return;
                    }
                    ImageIO.write((RenderedImage)this.bufferedImage, "jpg", new File(strFileName));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AutoRegisterFrame.this.capturePanel.setOpaque(false);
                        AutoRegisterFrame.this.capturePanel.setImage(CaptureReceiveCB.this.bufferedImage);
                        AutoRegisterFrame.this.capturePanel.repaint();
                    }
                });
            }
        }
    }

    private class TreeCellRender
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        private TreeCellRender() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof DeviceTreeNode) {
                this.setIcon(new ImageIcon("./libs/device.png"));
                DeviceTreeNode deviceTreeNode = (DeviceTreeNode)value;
                if (deviceTreeNode.getDeviceInfo().getLoginHandle().longValue() != 0L) {
                    if (deviceTreeNode == AutoRegisterFrame.this.talkDeviceTreeNode) {
                        this.setForeground(Color.RED);
                    } else {
                        this.setForeground(Color.GREEN);
                    }
                } else {
                    this.setForeground(Color.BLACK);
                }
                if (selected) {
                    AutoRegisterFrame.this.startRealPlayBtn.setEnabled(false);
                    AutoRegisterFrame.this.stopRealPlayBtn.setEnabled(false);
                    AutoRegisterFrame.this.captureBtn.setEnabled(false);
                    AutoRegisterFrame.this.deleteDeviceBtn.setEnabled(true);
                    if (deviceTreeNode.getDeviceInfo().getLoginHandle().longValue() != 0L) {
                        AutoRegisterFrame.this.logoutBtn.setEnabled(true);
                        AutoRegisterFrame.this.modifyDeviceBtn.setEnabled(false);
                        if (deviceTreeNode == AutoRegisterFrame.this.talkDeviceTreeNode) {
                            AutoRegisterFrame.this.startTalkBtn.setEnabled(false);
                            AutoRegisterFrame.this.stopTalkBtn.setEnabled(true);
                        } else {
                            AutoRegisterFrame.this.startTalkBtn.setEnabled(true);
                            AutoRegisterFrame.this.stopTalkBtn.setEnabled(false);
                        }
                    } else {
                        AutoRegisterFrame.this.logoutBtn.setEnabled(false);
                        AutoRegisterFrame.this.modifyDeviceBtn.setEnabled(true);
                        AutoRegisterFrame.this.startTalkBtn.setEnabled(false);
                        AutoRegisterFrame.this.stopTalkBtn.setEnabled(false);
                    }
                }
            } else if (value instanceof ChannelTreeNode) {
                this.setIcon(new ImageIcon("./libs/camera.png"));
                ChannelTreeNode channelTreeNode = (ChannelTreeNode)value;
                if (channelTreeNode == AutoRegisterFrame.this.realplayChannelTreeNode) {
                    this.setForeground(Color.RED);
                } else {
                    this.setForeground(Color.BLACK);
                }
                if (selected) {
                    AutoRegisterFrame.this.logoutBtn.setEnabled(false);
                    AutoRegisterFrame.this.captureBtn.setEnabled(true);
                    AutoRegisterFrame.this.modifyDeviceBtn.setEnabled(false);
                    AutoRegisterFrame.this.deleteDeviceBtn.setEnabled(false);
                    AutoRegisterFrame.this.startTalkBtn.setEnabled(false);
                    AutoRegisterFrame.this.stopTalkBtn.setEnabled(false);
                    if (channelTreeNode == AutoRegisterFrame.this.realplayChannelTreeNode) {
                        AutoRegisterFrame.this.startRealPlayBtn.setEnabled(false);
                        AutoRegisterFrame.this.stopRealPlayBtn.setEnabled(true);
                    } else {
                        AutoRegisterFrame.this.startRealPlayBtn.setEnabled(true);
                        AutoRegisterFrame.this.stopRealPlayBtn.setEnabled(false);
                    }
                }
            }
            return this;
        }
    }

    private class DEVICE_INFO {
        private String devcieId = "";
        private String username = "";
        private String password = "";
        private String deviceIp = "";
        private int port = 0;
        private NetSDKLib.LLong loginHandle = new NetSDKLib.LLong(0L);

        private DEVICE_INFO() {
        }

        public String getDevcieId() {
            return this.devcieId;
        }

        public void setDevcieId(String devcieId) {
            this.devcieId = devcieId;
        }

        public String getDeviceIp() {
            return this.deviceIp;
        }

        public void setDeviceIp(String deviceIp) {
            this.deviceIp = deviceIp;
        }

        public int getDevicePort() {
            return this.port;
        }

        public void setDevicePort(int port) {
            this.port = port;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public NetSDKLib.LLong getLoginHandle() {
            return this.loginHandle;
        }

        public void setLoginHandle(NetSDKLib.LLong loginHandle) {
            this.loginHandle = loginHandle;
        }
    }

    private class ChannelTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        private int nChn = 0;

        public int getChn() {
            return this.nChn;
        }

        public void setChn(int nChn) {
            this.nChn = nChn;
        }
    }

    private class DeviceTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        private DEVICE_INFO deviceInfo;

        @Override
        public Object getUserObject() {
            return super.getUserObject();
        }

        @Override
        public void setUserObject(Object arg0) {
            super.setUserObject(arg0);
        }

        public DEVICE_INFO getDeviceInfo() {
            return this.deviceInfo;
        }

        public void setDeviceInfo(DEVICE_INFO deviceInfo) {
            this.deviceInfo = deviceInfo;
        }
    }

    public class ServiceCB
    implements NetSDKLib.fServiceCallBack {
        @Override
        public int invoke(NetSDKLib.LLong lHandle, String pIp, int wPort, int lCommand, Pointer pParam, int dwParamLen, Pointer dwUserData) {
            byte[] buffer = new byte[dwParamLen];
            pParam.read(0L, buffer, 0, dwParamLen);
            String deviceId = "";
            try {
                deviceId = new String(buffer, "GBK").trim();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            System.out.printf("Register Device Info [Device address %s][port %s][DeviceID %s] \n", pIp, wPort, deviceId);
            block2 : switch (lCommand) {
                case -1: {
                    for (int i = 0; i < AutoRegisterFrame.this.rootNode.getChildCount(); ++i) {
                        if (!deviceId.equals(((DeviceTreeNode)AutoRegisterFrame.this.rootNode.getChildAt(i)).getDeviceInfo().getDevcieId())) continue;
                        DeviceTreeNode deviceTreeNode = (DeviceTreeNode)AutoRegisterFrame.this.rootNode.getChildAt(i);
                        deviceTreeNode.getDeviceInfo().setDeviceIp("");
                        deviceTreeNode.getDeviceInfo().setDevicePort(0);
                        break block2;
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < AutoRegisterFrame.this.rootNode.getChildCount(); ++i) {
                        if (!deviceId.equals(((DeviceTreeNode)AutoRegisterFrame.this.rootNode.getChildAt(i)).getDeviceInfo().getDevcieId())) continue;
                        final DeviceTreeNode deviceTreeNode = (DeviceTreeNode)AutoRegisterFrame.this.rootNode.getChildAt(i);
                        deviceTreeNode.getDeviceInfo().setDeviceIp(pIp);
                        deviceTreeNode.getDeviceInfo().setDevicePort(wPort);
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                        new SwingWorker<NetSDKLib.LLong, String>(){

                            @Override
                            protected NetSDKLib.LLong doInBackground() {
                                return AutoRegisterFrame.this.login(deviceTreeNode);
                            }

                            @Override
                            protected void done() {
                                try {
                                    if (this.get() == null) {
                                        return;
                                    }
                                    if (((NetSDKLib.LLong)this.get()).longValue() != 0L) {
                                        deviceTreeNode.getDeviceInfo().setLoginHandle((NetSDKLib.LLong)this.get());
                                        for (int i = 0; i < AutoRegisterModule.m_stDeviceInfo.byChanNum; ++i) {
                                            ChannelTreeNode chnNode = new ChannelTreeNode();
                                            chnNode.setChn(i + 1);
                                            chnNode.setUserObject(Res.string().getChannel() + " " + String.valueOf(i + 1));
                                            deviceTreeNode.add(chnNode);
                                        }
                                        deviceTreeNode.setUserObject(deviceTreeNode.getDeviceInfo().getDevcieId() + " (" + deviceTreeNode.getDeviceInfo().getDeviceIp() + ")");
                                        AutoRegisterFrame.this.tree.expandPath(new TreePath(AutoRegisterFrame.this.rootNode));
                                        AutoRegisterFrame.this.tree.setCellRenderer(AutoRegisterFrame.this.treeCellRender);
                                        AutoRegisterFrame.this.tree.updateUI();
                                    }
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                catch (ExecutionException e) {
                                    e.printStackTrace();
                                }
                            }
                        }.execute();
                        break block2;
                    }
                    break;
                }
            }
            return 0;
        }
    }

    private class ListenDeviceManagerPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public ListenDeviceManagerPanel() {
            this.setLayout(new BorderLayout());
            Dimension dimension = new Dimension();
            dimension.width = 230;
            this.setPreferredSize(dimension);
            JPanel listenPanel = new JPanel();
            JPanel deviceManagerPanel = new JPanel();
            JPanel functionOperatePanel = new JPanel();
            this.add((Component)listenPanel, "North");
            this.add((Component)deviceManagerPanel, "Center");
            this.add((Component)functionOperatePanel, "South");
            listenPanel.setBorder(BorderFactory.createTitledBorder(Res.string().getAutoRegisterListen()));
            listenPanel.setPreferredSize(new Dimension(200, 110));
            listenPanel.setLayout(new FlowLayout());
            JLabel ipLabel = new JLabel(Res.string().getRegisterAddress(), 0);
            JLabel portLabel = new JLabel(Res.string().getRegisterPort(), 0);
            ipLabel.setPreferredSize(new Dimension(100, 21));
            portLabel.setPreferredSize(new Dimension(100, 21));
            AutoRegisterFrame.this.ipTextField = new JTextField(AutoRegisterFrame.this.getHostAddress());
            AutoRegisterFrame.this.portTextField = new JTextField("9500");
            AutoRegisterFrame.this.ipTextField.setPreferredSize(new Dimension(100, 21));
            AutoRegisterFrame.this.portTextField.setPreferredSize(new Dimension(100, 21));
            AutoRegisterFrame.this.startListenBtn = new JButton(Res.string().getStartListen());
            AutoRegisterFrame.this.stopListenBtn = new JButton(Res.string().getStopListen());
            AutoRegisterFrame.this.startListenBtn.setPreferredSize(new Dimension(105, 21));
            AutoRegisterFrame.this.stopListenBtn.setPreferredSize(new Dimension(100, 21));
            AutoRegisterFrame.this.stopListenBtn.setEnabled(false);
            listenPanel.add(ipLabel);
            listenPanel.add(AutoRegisterFrame.this.ipTextField);
            listenPanel.add(portLabel);
            listenPanel.add(AutoRegisterFrame.this.portTextField);
            listenPanel.add(AutoRegisterFrame.this.startListenBtn);
            listenPanel.add(AutoRegisterFrame.this.stopListenBtn);
            deviceManagerPanel.setBorder(BorderFactory.createTitledBorder(Res.string().getDeviceManager()));
            deviceManagerPanel.setLayout(new FlowLayout());
            AutoRegisterFrame.this.logoutBtn = new JButton(Res.string().getLogout());
            AutoRegisterFrame.this.addDeviceBtn = new JButton(Res.string().getAddDevice());
            AutoRegisterFrame.this.modifyDeviceBtn = new JButton(Res.string().getModifyDevice());
            AutoRegisterFrame.this.deleteDeviceBtn = new JButton(Res.string().getDeleteDevice());
            AutoRegisterFrame.this.clearDeviceBtn = new JButton(Res.string().getClearDevice());
            AutoRegisterFrame.this.importDeviceBtn = new JButton(Res.string().getImportDevice());
            AutoRegisterFrame.this.exportDeviceBtn = new JButton(Res.string().getExportDevice());
            AutoRegisterFrame.this.logoutBtn.setPreferredSize(new Dimension(210, 21));
            AutoRegisterFrame.this.addDeviceBtn.setPreferredSize(new Dimension(210, 21));
            AutoRegisterFrame.this.modifyDeviceBtn.setPreferredSize(new Dimension(210, 21));
            AutoRegisterFrame.this.deleteDeviceBtn.setPreferredSize(new Dimension(210, 21));
            AutoRegisterFrame.this.clearDeviceBtn.setPreferredSize(new Dimension(210, 21));
            AutoRegisterFrame.this.importDeviceBtn.setPreferredSize(new Dimension(210, 21));
            AutoRegisterFrame.this.exportDeviceBtn.setPreferredSize(new Dimension(210, 21));
            AutoRegisterFrame.this.logoutBtn.setEnabled(false);
            AutoRegisterFrame.this.modifyDeviceBtn.setEnabled(false);
            AutoRegisterFrame.this.deleteDeviceBtn.setEnabled(false);
            deviceManagerPanel.add(AutoRegisterFrame.this.logoutBtn);
            deviceManagerPanel.add(AutoRegisterFrame.this.addDeviceBtn);
            deviceManagerPanel.add(AutoRegisterFrame.this.modifyDeviceBtn);
            deviceManagerPanel.add(AutoRegisterFrame.this.deleteDeviceBtn);
            deviceManagerPanel.add(AutoRegisterFrame.this.clearDeviceBtn);
            deviceManagerPanel.add(AutoRegisterFrame.this.importDeviceBtn);
            deviceManagerPanel.add(AutoRegisterFrame.this.exportDeviceBtn);
            functionOperatePanel.setBorder(BorderFactory.createTitledBorder(Res.string().getFunctionOperate()));
            functionOperatePanel.setLayout(new FlowLayout());
            Dimension dimension1 = new Dimension();
            dimension1.height = 160;
            functionOperatePanel.setPreferredSize(dimension1);
            AutoRegisterFrame.this.startRealPlayBtn = new JButton(Res.string().getStartRealPlay());
            AutoRegisterFrame.this.stopRealPlayBtn = new JButton(Res.string().getStopRealPlay());
            AutoRegisterFrame.this.startTalkBtn = new JButton(Res.string().getStartTalk());
            AutoRegisterFrame.this.stopTalkBtn = new JButton(Res.string().getStopTalk());
            AutoRegisterFrame.this.captureBtn = new JButton(Res.string().getRemoteCapture());
            AutoRegisterFrame.this.startRealPlayBtn.setPreferredSize(new Dimension(210, 21));
            AutoRegisterFrame.this.stopRealPlayBtn.setPreferredSize(new Dimension(210, 21));
            AutoRegisterFrame.this.startTalkBtn.setPreferredSize(new Dimension(210, 21));
            AutoRegisterFrame.this.stopTalkBtn.setPreferredSize(new Dimension(210, 21));
            AutoRegisterFrame.this.captureBtn.setPreferredSize(new Dimension(210, 21));
            AutoRegisterFrame.this.startRealPlayBtn.setEnabled(false);
            AutoRegisterFrame.this.stopRealPlayBtn.setEnabled(false);
            AutoRegisterFrame.this.startTalkBtn.setEnabled(false);
            AutoRegisterFrame.this.stopTalkBtn.setEnabled(false);
            AutoRegisterFrame.this.captureBtn.setEnabled(false);
            functionOperatePanel.add(AutoRegisterFrame.this.startRealPlayBtn);
            functionOperatePanel.add(AutoRegisterFrame.this.stopRealPlayBtn);
            functionOperatePanel.add(AutoRegisterFrame.this.startTalkBtn);
            functionOperatePanel.add(AutoRegisterFrame.this.stopTalkBtn);
            functionOperatePanel.add(AutoRegisterFrame.this.captureBtn);
            AutoRegisterFrame.this.startListenBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (AutoRegisterFrame.this.ipTextField.getText().equals("")) {
                        JOptionPane.showMessageDialog(null, Res.string().getInput() + Res.string().getRegisterAddress(), Res.string().getErrorMessage(), 0);
                        return;
                    }
                    if (AutoRegisterFrame.this.portTextField.getText().equals("")) {
                        JOptionPane.showMessageDialog(null, Res.string().getInput() + Res.string().getRegisterPort(), Res.string().getErrorMessage(), 0);
                        return;
                    }
                    if (AutoRegisterModule.startServer(AutoRegisterFrame.this.ipTextField.getText(), Integer.parseInt(AutoRegisterFrame.this.portTextField.getText()), AutoRegisterFrame.this.servicCallback)) {
                        AutoRegisterFrame.this.startListenBtn.setEnabled(false);
                        AutoRegisterFrame.this.stopListenBtn.setEnabled(true);
                    }
                }
            });
            AutoRegisterFrame.this.stopListenBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (AutoRegisterModule.stopServer()) {
                        AutoRegisterFrame.this.startListenBtn.setEnabled(true);
                        AutoRegisterFrame.this.stopListenBtn.setEnabled(false);
                    }
                }
            });
            AutoRegisterFrame.this.addDeviceBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    AutoRegisterFrame.this.addDevice();
                }
            });
            AutoRegisterFrame.this.modifyDeviceBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    AutoRegisterFrame.this.modifyDevice();
                }
            });
            AutoRegisterFrame.this.deleteDeviceBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    AutoRegisterFrame.this.deleteDevice();
                }
            });
            AutoRegisterFrame.this.clearDeviceBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    AutoRegisterFrame.this.clearDevice();
                }
            });
            AutoRegisterFrame.this.importDeviceBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AutoRegisterFrame.this.importDevice();
                }
            });
            AutoRegisterFrame.this.exportDeviceBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AutoRegisterFrame.this.exportDevice();
                }
            });
            AutoRegisterFrame.this.logoutBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AutoRegisterFrame.this.logout();
                        }
                    });
                }
            });
            AutoRegisterFrame.this.startRealPlayBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AutoRegisterFrame.this.startRealplay();
                        }
                    });
                }
            });
            AutoRegisterFrame.this.stopRealPlayBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AutoRegisterFrame.this.stopRealplay();
                        }
                    });
                }
            });
            AutoRegisterFrame.this.startTalkBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AutoRegisterFrame.this.startTalk();
                        }
                    });
                }
            });
            AutoRegisterFrame.this.stopTalkBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AutoRegisterFrame.this.stopTalk();
                        }
                    });
                }
            });
            AutoRegisterFrame.this.captureBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    AutoRegisterFrame.this.capture();
                }
            });
        }
    }

    private class RealPlayPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public RealPlayPanel() {
            BorderEx.set(this, "", 0);
            this.setLayout(new BorderLayout());
            JPanel realplayPanel = new JPanel();
            JPanel picPanel = new JPanel();
            this.add((Component)realplayPanel, "North");
            this.add((Component)picPanel, "Center");
            realplayPanel.setBorder(BorderFactory.createTitledBorder(Res.string().getRealplay()));
            Dimension dimension = new Dimension();
            dimension.height = 250;
            realplayPanel.setPreferredSize(dimension);
            realplayPanel.setLayout(new BorderLayout());
            AutoRegisterFrame.this.realplayWindowPanel = new Panel();
            AutoRegisterFrame.this.realplayWindowPanel.setBackground(Color.GRAY);
            realplayPanel.add((Component)AutoRegisterFrame.this.realplayWindowPanel, "Center");
            picPanel.setBorder(BorderFactory.createTitledBorder(Res.string().getCapturePicture()));
            picPanel.setLayout(new BorderLayout());
            AutoRegisterFrame.this.capturePanel = new PaintPanel();
            picPanel.add((Component)AutoRegisterFrame.this.capturePanel, "Center");
        }
    }

    private class AutoRegisterTreePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public AutoRegisterTreePanel() {
            this.setLayout(new BorderLayout());
            Dimension dimension = new Dimension();
            dimension.width = 210;
            this.setPreferredSize(dimension);
            JPanel configPanel = new JPanel();
            JPanel deviceListPanel = new JPanel();
            this.add((Component)configPanel, "North");
            this.add((Component)deviceListPanel, "Center");
            configPanel.setBorder(BorderFactory.createTitledBorder(Res.string().getOperate()));
            configPanel.setPreferredSize(new Dimension(200, 55));
            configPanel.setLayout(new FlowLayout());
            JButton configBtn = new JButton(Res.string().getDeviceConfig());
            configBtn.setPreferredSize(new Dimension(180, 21));
            configPanel.add(configBtn);
            deviceListPanel.setBorder(BorderFactory.createTitledBorder(Res.string().getDeviceList()));
            deviceListPanel.setLayout(new BorderLayout());
            AutoRegisterFrame.this.rootNode = new DefaultMutableTreeNode();
            AutoRegisterFrame.this.treeModel = new DefaultTreeModel(AutoRegisterFrame.this.rootNode);
            AutoRegisterFrame.this.tree = new JTree(AutoRegisterFrame.this.treeModel);
            AutoRegisterFrame.this.tree.setBackground(Color.LIGHT_GRAY);
            AutoRegisterFrame.this.tree.setForeground(Color.BLACK);
            AutoRegisterFrame.this.tree.setEditable(false);
            AutoRegisterFrame.this.tree.getSelectionModel().setSelectionMode(1);
            AutoRegisterFrame.this.tree.setRootVisible(false);
            AutoRegisterFrame.this.tree.expandPath(new TreePath(AutoRegisterFrame.this.rootNode));
            AutoRegisterFrame.this.tree.setShowsRootHandles(true);
            JScrollPane jScrollPane = new JScrollPane(AutoRegisterFrame.this.tree);
            deviceListPanel.add((Component)jScrollPane, "Center");
            configBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    DeviceConfigDialog deviceConfigDialog = new DeviceConfigDialog();
                    deviceConfigDialog.setVisible(true);
                }
            });
            AutoRegisterFrame.this.tree.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        TreePath treePath = AutoRegisterFrame.this.tree.getPathForLocation(e.getX(), e.getY());
                        AutoRegisterFrame.this.tree.setSelectionPath(treePath);
                        AutoRegisterFrame.this.showPopupMenu(e.getComponent(), e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    ChannelTreeNode channelTreeNode;
                    if (e.getClickCount() > 1 && AutoRegisterFrame.this.tree.getLastSelectedPathComponent() instanceof ChannelTreeNode && (channelTreeNode = (ChannelTreeNode)AutoRegisterFrame.this.tree.getLastSelectedPathComponent()) != AutoRegisterFrame.this.realplayChannelTreeNode) {
                        AutoRegisterFrame.this.startRealplay();
                    }
                }
            });
        }
    }

    private class DisConnectRunnable
    implements Runnable {
        DeviceTreeNode devicetTreeNode;

        public DisConnectRunnable(DeviceTreeNode devicetTreeNode) {
            this.devicetTreeNode = devicetTreeNode;
        }

        @Override
        public void run() {
            this.devicetTreeNode.setUserObject(this.devicetTreeNode.getDeviceInfo().getDevcieId());
            this.devicetTreeNode.removeAllChildren();
            AutoRegisterFrame.this.tree.updateUI();
        }
    }

    private class DisConnect
    implements NetSDKLib.fDisConnect {
        private DisConnect() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invoke(NetSDKLib.LLong m_hLoginHandle, String pchDVRIP, int nDVRPort, Pointer dwUser) {
            System.out.printf("Device[%s] Port[%d] DisConnect!\n", pchDVRIP, nDVRPort);
            for (int i = 0; i < AutoRegisterFrame.this.rootNode.getChildCount(); ++i) {
                DeviceTreeNode deviceTreeNode = (DeviceTreeNode)AutoRegisterFrame.this.rootNode.getChildAt(i);
                if (!pchDVRIP.equals(deviceTreeNode.getDeviceInfo().getDeviceIp()) || nDVRPort != deviceTreeNode.getDeviceInfo().getDevicePort()) continue;
                DisConnect disConnect = this;
                synchronized (disConnect) {
                    if (deviceTreeNode == AutoRegisterFrame.this.talkDeviceTreeNode) {
                        AutoRegisterModule.stopTalk(AutoRegisterModule.m_hTalkHandle);
                        AutoRegisterFrame.this.talkDeviceTreeNode = null;
                    }
                    for (int j = 0; j < deviceTreeNode.getChildCount(); ++j) {
                        ChannelTreeNode channelTreeNode = (ChannelTreeNode)deviceTreeNode.getChildAt(j);
                        if (channelTreeNode != AutoRegisterFrame.this.realplayChannelTreeNode) continue;
                        AutoRegisterModule.stopRealPlay(AutoRegisterFrame.this.realplayHandle);
                        AutoRegisterFrame.this.realplayWindowPanel.repaint();
                        AutoRegisterFrame.this.realplayChannelTreeNode = null;
                        break;
                    }
                    if (deviceTreeNode.getDeviceInfo().getLoginHandle().longValue() != 0L) {
                        AutoRegisterModule.logout(deviceTreeNode.getDeviceInfo().getLoginHandle());
                    }
                    SwingUtilities.invokeLater(new DisConnectRunnable(deviceTreeNode));
                    break;
                }
            }
        }
    }
}

