/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame;

import com.netsdk.common.BorderEx;
import com.netsdk.common.FunctionList;
import com.netsdk.common.LoginPanel;
import com.netsdk.common.PaintPanel;
import com.netsdk.common.Res;
import com.netsdk.common.SavePath;
import com.netsdk.demo.module.CapturePictureModule;
import com.netsdk.demo.module.LoginModule;
import com.netsdk.demo.module.RealPlayModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

class CapturePictureFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Vector<String> chnlist = new Vector();
    private boolean bRealPlay = false;
    private boolean bTimerCapture = false;
    private static DisConnect disConnect = new DisConnect();
    private static HaveReConnect haveReConnect = new HaveReConnect();
    public static NetSDKLib.LLong m_hPlayHandle = new NetSDKLib.LLong(0L);
    private static JFrame frame = new JFrame();
    public fCaptureReceiveCB m_CaptureReceiveCB = new fCaptureReceiveCB();
    private LoginPanel loginPanel;
    private RealPanel realPanel;
    private JPanel realplayPanel;
    private Panel realPlayWindow;
    private Panel channelPanel;
    private JLabel chnlabel;
    private JComboBox chnComboBox;
    private JLabel streamLabel;
    private JComboBox streamComboBox;
    private JButton realplayBtn;
    private PICPanel picPanel;
    private JPanel pictureShowPanel;
    private JPanel capturePanel;
    private PaintPanel pictureShowWindow;
    private JButton localCaptureBtn;
    private JButton remoteCaptureBtn;
    private JButton timerCaptureBtn;

    public CapturePictureFrame() {
        this.setTitle(Res.string().getCapturePicture());
        this.setLayout(new BorderLayout());
        this.pack();
        this.setSize(800, 560);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        LoginModule.init(disConnect, haveReConnect);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loginPanel = new LoginPanel();
        this.realPanel = new RealPanel();
        this.picPanel = new PICPanel();
        this.add((Component)this.loginPanel, "North");
        this.add((Component)this.realPanel, "Center");
        this.add((Component)this.picPanel, "East");
        this.loginPanel.addLoginBtnActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CapturePictureFrame.this.loginPanel.checkLoginText() && CapturePictureFrame.this.login()) {
                    frame = ToolKits.getFrame(e);
                    frame.setTitle(Res.string().getCapturePicture() + " : " + Res.string().getOnline());
                }
            }
        });
        this.loginPanel.addLogoutBtnActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setTitle(Res.string().getCapturePicture());
                CapturePictureFrame.this.logout();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RealPlayModule.stopRealPlay(m_hPlayHandle);
                LoginModule.logout();
                LoginModule.cleanup();
                CapturePictureFrame.this.dispose();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FunctionList demo = new FunctionList();
                        demo.setVisible(true);
                    }
                });
            }
        });
    }

    public boolean login() {
        Native.setCallbackThreadInitializer(this.m_CaptureReceiveCB, new CallbackThreadInitializer(false, false, "snapPicture callback thread"));
        if (LoginModule.login(this.loginPanel.ipTextArea.getText(), Integer.parseInt(this.loginPanel.portTextArea.getText()), this.loginPanel.nameTextArea.getText(), new String(this.loginPanel.passwordTextArea.getPassword()))) {
            this.loginPanel.setButtonEnable(true);
            this.setButtonEnable(true);
            for (int i = 1; i < LoginModule.m_stDeviceInfo.byChanNum + 1; ++i) {
                this.chnlist.add(Res.string().getChannel() + " " + String.valueOf(i));
            }
        } else {
            JOptionPane.showMessageDialog(null, Res.string().getLoginFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return false;
        }
        this.chnComboBox.setModel(new DefaultComboBoxModel<String>(this.chnlist));
        CapturePictureModule.setSnapRevCallBack(this.m_CaptureReceiveCB);
        return true;
    }

    public void logout() {
        if (this.bTimerCapture) {
            CapturePictureModule.stopCapturePicture(this.chnComboBox.getSelectedIndex());
        }
        RealPlayModule.stopRealPlay(m_hPlayHandle);
        LoginModule.logout();
        this.loginPanel.setButtonEnable(false);
        this.setButtonEnable(false);
        this.realPlayWindow.repaint();
        this.pictureShowWindow.setOpaque(true);
        this.pictureShowWindow.repaint();
        this.bRealPlay = false;
        this.realplayBtn.setText(Res.string().getStartRealPlay());
        for (int i = 0; i < LoginModule.m_stDeviceInfo.byChanNum; ++i) {
            this.chnlist.clear();
        }
        this.chnComboBox.setModel(new DefaultComboBoxModel());
        this.bTimerCapture = false;
        this.timerCaptureBtn.setText(Res.string().getTimerCapture());
    }

    public void realplay() {
        if (!this.bRealPlay) {
            m_hPlayHandle = RealPlayModule.startRealPlay(this.chnComboBox.getSelectedIndex(), this.streamComboBox.getSelectedIndex() == 0 ? 0 : 3, this.realPlayWindow);
            if (m_hPlayHandle.longValue() != 0L) {
                this.realPlayWindow.repaint();
                this.bRealPlay = true;
                this.chnComboBox.setEnabled(false);
                this.streamComboBox.setEnabled(false);
                this.realplayBtn.setText(Res.string().getStopRealPlay());
            }
        } else {
            RealPlayModule.stopRealPlay(m_hPlayHandle);
            this.realPlayWindow.repaint();
            this.bRealPlay = false;
            this.chnComboBox.setEnabled(!this.bTimerCapture);
            this.streamComboBox.setEnabled(true);
            this.realplayBtn.setText(Res.string().getStartRealPlay());
        }
    }

    private void setButtonEnable(boolean bln) {
        this.localCaptureBtn.setEnabled(bln);
        this.remoteCaptureBtn.setEnabled(bln);
        this.timerCaptureBtn.setEnabled(bln);
        this.realPlayWindow.setEnabled(bln);
        this.chnComboBox.setEnabled(bln);
        this.streamComboBox.setEnabled(bln);
        this.realplayBtn.setEnabled(bln);
    }

    public class fCaptureReceiveCB
    implements NetSDKLib.fSnapRev {
        BufferedImage bufferedImage = null;

        @Override
        public void invoke(NetSDKLib.LLong lLoginID, Pointer pBuf, int RevLen, int EncodeType, int CmdSerial, Pointer dwUser) {
            if (pBuf != null && RevLen > 0) {
                String strFileName = SavePath.getSavePath().getSaveCapturePath();
                System.out.println("strFileName = " + strFileName);
                byte[] buf = pBuf.getByteArray(0L, RevLen);
                ByteArrayInputStream byteArrInput = new ByteArrayInputStream(buf);
                try {
                    this.bufferedImage = ImageIO.read(byteArrInput);
                    if (this.bufferedImage == null) {
                        return;
                    }
                    ImageIO.write((RenderedImage)this.bufferedImage, "jpg", new File(strFileName));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CapturePictureFrame.this.pictureShowWindow.setOpaque(false);
                        CapturePictureFrame.this.pictureShowWindow.setImage(fCaptureReceiveCB.this.bufferedImage);
                        CapturePictureFrame.this.pictureShowWindow.repaint();
                    }
                });
            }
        }
    }

    private class PICPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public PICPanel() {
            this.setPreferredSize(new Dimension(350, 600));
            BorderEx.set(this, Res.string().getCapturePicture(), 2);
            this.setLayout(new BorderLayout());
            CapturePictureFrame.this.pictureShowPanel = new JPanel();
            CapturePictureFrame.this.capturePanel = new JPanel();
            this.add((Component)CapturePictureFrame.this.pictureShowPanel, "Center");
            this.add((Component)CapturePictureFrame.this.capturePanel, "South");
            CapturePictureFrame.this.capturePanel.setLayout(new GridLayout(3, 1));
            CapturePictureFrame.this.localCaptureBtn = new JButton(Res.string().getLocalCapture());
            CapturePictureFrame.this.remoteCaptureBtn = new JButton(Res.string().getRemoteCapture());
            CapturePictureFrame.this.timerCaptureBtn = new JButton(Res.string().getTimerCapture());
            CapturePictureFrame.this.localCaptureBtn.setPreferredSize(new Dimension(150, 20));
            CapturePictureFrame.this.remoteCaptureBtn.setPreferredSize(new Dimension(150, 20));
            CapturePictureFrame.this.timerCaptureBtn.setPreferredSize(new Dimension(150, 20));
            CapturePictureFrame.this.capturePanel.add(CapturePictureFrame.this.localCaptureBtn);
            CapturePictureFrame.this.capturePanel.add(CapturePictureFrame.this.remoteCaptureBtn);
            CapturePictureFrame.this.capturePanel.add(CapturePictureFrame.this.timerCaptureBtn);
            CapturePictureFrame.this.localCaptureBtn.setEnabled(false);
            CapturePictureFrame.this.remoteCaptureBtn.setEnabled(false);
            CapturePictureFrame.this.timerCaptureBtn.setEnabled(false);
            CapturePictureFrame.this.pictureShowPanel.setLayout(new BorderLayout());
            CapturePictureFrame.this.pictureShowPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            CapturePictureFrame.this.pictureShowWindow = new PaintPanel();
            CapturePictureFrame.this.pictureShowPanel.add((Component)CapturePictureFrame.this.pictureShowWindow, "Center");
            CapturePictureFrame.this.localCaptureBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (!CapturePictureFrame.this.bRealPlay) {
                        JOptionPane.showMessageDialog(null, Res.string().getNeedStartRealPlay(), Res.string().getErrorMessage(), 0);
                        return;
                    }
                    String strFileName = SavePath.getSavePath().getSaveCapturePath();
                    System.out.println("strFileName = " + strFileName);
                    if (!CapturePictureModule.localCapturePicture(m_hPlayHandle, strFileName)) {
                        JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                        return;
                    }
                    BufferedImage bufferedImage = null;
                    try {
                        bufferedImage = ImageIO.read(new File(strFileName));
                        if (bufferedImage == null) {
                            return;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    CapturePictureFrame.this.pictureShowWindow.setOpaque(false);
                    CapturePictureFrame.this.pictureShowWindow.setImage(bufferedImage);
                    CapturePictureFrame.this.pictureShowWindow.repaint();
                }
            });
            CapturePictureFrame.this.remoteCaptureBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (!CapturePictureModule.remoteCapturePicture(CapturePictureFrame.this.chnComboBox.getSelectedIndex())) {
                        JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                    }
                }
            });
            CapturePictureFrame.this.timerCaptureBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (!CapturePictureFrame.this.bTimerCapture) {
                        if (!CapturePictureModule.timerCapturePicture(CapturePictureFrame.this.chnComboBox.getSelectedIndex())) {
                            JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                        } else {
                            CapturePictureFrame.this.bTimerCapture = true;
                            CapturePictureFrame.this.timerCaptureBtn.setText(Res.string().getStopCapture());
                            CapturePictureFrame.this.chnComboBox.setEnabled(false);
                            CapturePictureFrame.this.remoteCaptureBtn.setEnabled(false);
                        }
                    } else if (!CapturePictureModule.stopCapturePicture(CapturePictureFrame.this.chnComboBox.getSelectedIndex())) {
                        JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                    } else {
                        CapturePictureFrame.this.bTimerCapture = false;
                        CapturePictureFrame.this.timerCaptureBtn.setText(Res.string().getTimerCapture());
                        CapturePictureFrame.this.chnComboBox.setEnabled(!CapturePictureFrame.this.bRealPlay);
                        CapturePictureFrame.this.remoteCaptureBtn.setEnabled(true);
                    }
                }
            });
        }
    }

    private class RealPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public RealPanel() {
            BorderEx.set(this, Res.string().getRealplay(), 2);
            this.setLayout(new BorderLayout());
            CapturePictureFrame.this.channelPanel = new Panel();
            CapturePictureFrame.this.realplayPanel = new JPanel();
            this.add((Component)CapturePictureFrame.this.channelPanel, "South");
            this.add((Component)CapturePictureFrame.this.realplayPanel, "Center");
            CapturePictureFrame.this.realplayPanel.setLayout(new BorderLayout());
            CapturePictureFrame.this.realplayPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            CapturePictureFrame.this.realPlayWindow = new Panel();
            CapturePictureFrame.this.realPlayWindow.setBackground(Color.GRAY);
            CapturePictureFrame.this.realplayPanel.add((Component)CapturePictureFrame.this.realPlayWindow, "Center");
            CapturePictureFrame.this.chnlabel = new JLabel(Res.string().getChannel());
            CapturePictureFrame.this.chnComboBox = new JComboBox();
            CapturePictureFrame.this.streamLabel = new JLabel(Res.string().getStreamType());
            String[] stream = new String[]{Res.string().getMasterStream(), Res.string().getSubStream()};
            CapturePictureFrame.this.streamComboBox = new JComboBox<String>(stream);
            CapturePictureFrame.this.realplayBtn = new JButton(Res.string().getStartRealPlay());
            CapturePictureFrame.this.channelPanel.setLayout(new FlowLayout());
            CapturePictureFrame.this.channelPanel.add(CapturePictureFrame.this.chnlabel);
            CapturePictureFrame.this.channelPanel.add(CapturePictureFrame.this.chnComboBox);
            CapturePictureFrame.this.channelPanel.add(CapturePictureFrame.this.streamLabel);
            CapturePictureFrame.this.channelPanel.add(CapturePictureFrame.this.streamComboBox);
            CapturePictureFrame.this.channelPanel.add(CapturePictureFrame.this.realplayBtn);
            CapturePictureFrame.this.chnComboBox.setPreferredSize(new Dimension(90, 20));
            CapturePictureFrame.this.streamComboBox.setPreferredSize(new Dimension(90, 20));
            CapturePictureFrame.this.realplayBtn.setPreferredSize(new Dimension(120, 20));
            CapturePictureFrame.this.realPlayWindow.setEnabled(false);
            CapturePictureFrame.this.chnComboBox.setEnabled(false);
            CapturePictureFrame.this.streamComboBox.setEnabled(false);
            CapturePictureFrame.this.realplayBtn.setEnabled(false);
            CapturePictureFrame.this.realplayBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CapturePictureFrame.this.realplay();
                }
            });
        }
    }

    private static class HaveReConnect
    implements NetSDKLib.fHaveReConnect {
        private HaveReConnect() {
        }

        @Override
        public void invoke(NetSDKLib.LLong m_hLoginHandle, String pchDVRIP, int nDVRPort, Pointer dwUser) {
            System.out.printf("ReConnect Device[%s] Port[%d]\n", pchDVRIP, nDVRPort);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.setTitle(Res.string().getCapturePicture() + " : " + Res.string().getOnline());
                }
            });
        }
    }

    private static class DisConnect
    implements NetSDKLib.fDisConnect {
        private DisConnect() {
        }

        @Override
        public void invoke(NetSDKLib.LLong m_hLoginHandle, String pchDVRIP, int nDVRPort, Pointer dwUser) {
            System.out.printf("Device[%s] Port[%d] DisConnect!\n", pchDVRIP, nDVRPort);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.setTitle(Res.string().getCapturePicture() + " : " + Res.string().getDisConnectReconnecting());
                }
            });
        }
    }
}

