/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame;

import com.netsdk.common.BorderEx;
import com.netsdk.common.DateChooserJButton;
import com.netsdk.common.FunctionList;
import com.netsdk.common.LoginPanel;
import com.netsdk.common.Res;
import com.netsdk.demo.module.DeviceControlModule;
import com.netsdk.demo.module.LoginModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.Pointer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class DeviceControlFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private DisConnect disConnect = new DisConnect();
    private static JFrame frame = new JFrame();
    private DeviceControlLoginPanel loginPanel;
    private DeviceControlPanel deviceCtlPanel;

    public DeviceControlFrame() {
        this.setTitle(Res.string().getDeviceControl());
        this.setLayout(new BorderLayout());
        this.pack();
        this.setSize(550, 350);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        LoginModule.init(this.disConnect, null);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loginPanel = new DeviceControlLoginPanel();
        this.deviceCtlPanel = new DeviceControlPanel();
        this.add((Component)this.loginPanel, "North");
        this.add((Component)this.deviceCtlPanel, "Center");
        this.loginPanel.addLoginBtnActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DeviceControlFrame.this.loginPanel.checkLoginText() && DeviceControlFrame.this.login()) {
                    frame = ToolKits.getFrame(e);
                    frame.setTitle(Res.string().getDeviceControl() + " : " + Res.string().getOnline());
                }
            }
        });
        this.loginPanel.addLogoutBtnActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setTitle(Res.string().getDeviceControl());
                DeviceControlFrame.this.logout();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LoginModule.logout();
                LoginModule.cleanup();
                DeviceControlFrame.this.dispose();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FunctionList demo = new FunctionList();
                        demo.setVisible(true);
                    }
                });
            }
        });
    }

    public boolean login() {
        if (!LoginModule.login(this.loginPanel.ipTextArea.getText(), Integer.parseInt(this.loginPanel.portTextArea.getText()), this.loginPanel.nameTextArea.getText(), new String(this.loginPanel.passwordTextArea.getPassword()))) {
            JOptionPane.showMessageDialog(null, Res.string().getLoginFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return false;
        }
        this.loginPanel.setButtonEnable(true);
        this.deviceCtlPanel.setButtonEnabled(true);
        return true;
    }

    public void logout() {
        LoginModule.logout();
        this.loginPanel.setButtonEnable(false);
        this.deviceCtlPanel.resetButtonEnabled();
    }

    private class DeviceControlLoginPanel
    extends LoginPanel {
        private static final long serialVersionUID = 1L;

        public DeviceControlLoginPanel() {
            this.setLayout(new GridLayout(3, 1));
            this.removeAll();
            JPanel ipPanel = new JPanel();
            JPanel userPanel = new JPanel();
            JPanel btnPanel = new JPanel();
            this.resetSize();
            ipPanel.add(this.ipLabel);
            ipPanel.add(this.ipTextArea);
            ipPanel.add(this.portLabel);
            ipPanel.add(this.portTextArea);
            userPanel.add(this.nameLabel);
            userPanel.add(this.nameTextArea);
            userPanel.add(this.passwordLabel);
            userPanel.add(this.passwordTextArea);
            btnPanel.add(this.loginBtn);
            btnPanel.add(new JLabel("  "));
            btnPanel.add(this.logoutBtn);
            this.add(ipPanel);
            this.add(userPanel);
            this.add(btnPanel);
        }

        private void resetSize() {
            this.ipLabel.setPreferredSize(new Dimension(70, 25));
            this.portLabel.setPreferredSize(new Dimension(70, 25));
            this.nameLabel.setText(Res.string().getUserName());
            this.nameLabel.setPreferredSize(new Dimension(70, 25));
            this.passwordLabel.setPreferredSize(new Dimension(70, 25));
            this.loginBtn.setPreferredSize(new Dimension(100, 20));
            this.logoutBtn.setPreferredSize(new Dimension(100, 20));
            this.ipTextArea.setPreferredSize(new Dimension(100, 20));
            this.portTextArea.setPreferredSize(new Dimension(100, 20));
            this.nameTextArea.setPreferredSize(new Dimension(100, 20));
            this.passwordTextArea.setPreferredSize(new Dimension(100, 20));
        }
    }

    private class DeviceControlPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JButton rebootBtn;
        private DateChooserJButton getDateChooser;
        private JButton getTimeBtn;
        private JCheckBox currentTimeCheckBox;
        private DateChooserJButton setDateChooser;
        private JButton setTimeBtn;

        public DeviceControlPanel() {
            BorderEx.set(this, Res.string().getDeviceControl(), 2);
            this.setLayout(new BorderLayout());
            this.setPreferredSize(new Dimension(350, 220));
            DeviceControlFrame.this.setResizable(false);
            JLabel nullLable = new JLabel();
            this.currentTimeCheckBox = new JCheckBox(Res.string().getCurrentTime());
            this.getDateChooser = new DateChooserJButton();
            this.setDateChooser = new DateChooserJButton(2000, 2037);
            this.rebootBtn = new JButton(Res.string().getReboot());
            this.getTimeBtn = new JButton(Res.string().getGetTime());
            this.setTimeBtn = new JButton(Res.string().getSetTime());
            nullLable.setPreferredSize(this.currentTimeCheckBox.getPreferredSize());
            this.getDateChooser.setPreferredSize(new Dimension(150, 20));
            this.setDateChooser.setPreferredSize(new Dimension(150, 20));
            this.rebootBtn.setPreferredSize(new Dimension(100, 20));
            this.getTimeBtn.setPreferredSize(new Dimension(100, 20));
            this.setTimeBtn.setPreferredSize(new Dimension(100, 20));
            JPanel rebootPanel = new JPanel();
            BorderEx.set(rebootPanel, Res.string().getDeviceReboot(), 2);
            rebootPanel.add(this.rebootBtn);
            JPanel timePanel = new JPanel(new GridLayout(2, 1));
            BorderEx.set(timePanel, Res.string().getSyncTime(), 2);
            JPanel getPanel = new JPanel();
            JPanel setPanel = new JPanel();
            getPanel.add(nullLable);
            getPanel.add(this.getDateChooser);
            getPanel.add(this.getTimeBtn);
            setPanel.add(this.currentTimeCheckBox);
            setPanel.add(this.setDateChooser);
            setPanel.add(this.setTimeBtn);
            timePanel.add(getPanel);
            timePanel.add(setPanel);
            JSplitPane splitPane = new JSplitPane();
            splitPane.setDividerSize(0);
            splitPane.setBorder(null);
            splitPane.add((Component)rebootPanel, "left");
            splitPane.add((Component)timePanel, "right");
            this.add(splitPane);
            this.getDateChooser.setEnabled(false);
            this.setButtonEnabled(false);
            this.rebootBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionDialog optionDialog = new OptionDialog();
                    optionDialog.setVisible(true);
                }
            });
            this.getTimeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String date = DeviceControlModule.getTime();
                    if (date == null) {
                        JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                    } else {
                        DeviceControlPanel.this.getDateChooser.setText(date);
                    }
                }
            });
            this.setTimeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String date = null;
                    if (!DeviceControlPanel.this.currentTimeCheckBox.isSelected()) {
                        date = DeviceControlPanel.this.setDateChooser.getText();
                    }
                    if (!DeviceControlModule.setTime(date)) {
                        JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                    } else {
                        JOptionPane.showMessageDialog(null, Res.string().getOperateSuccess(), Res.string().getPromptMessage(), -1);
                    }
                }
            });
            this.currentTimeCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JCheckBox jcb = (JCheckBox)e.getItem();
                    if (jcb.isSelected()) {
                        DeviceControlPanel.this.setDateChooser.setEnabled(false);
                    } else {
                        DeviceControlPanel.this.setDateChooser.setEnabled(true);
                    }
                }
            });
        }

        public void setButtonEnabled(boolean b) {
            this.currentTimeCheckBox.setEnabled(b);
            this.setDateChooser.setEnabled(b);
            this.rebootBtn.setEnabled(b);
            this.getTimeBtn.setEnabled(b);
            this.setTimeBtn.setEnabled(b);
        }

        public void resetButtonEnabled() {
            this.currentTimeCheckBox.setSelected(false);
            this.setButtonEnabled(false);
        }

        private class OptionDialog
        extends JDialog {
            private static final long serialVersionUID = 1L;
            private JButton confirmBtn;
            private JButton cancelBtn;

            public OptionDialog() {
                this.setDefaultCloseOperation(2);
                this.pack();
                this.setSize(250, 100);
                this.setLocationRelativeTo(null);
                this.setModal(true);
                this.setTitle(Res.string().getDeviceReboot());
                JLabel messageLable = new JLabel(Res.string().getRebootTips());
                this.confirmBtn = new JButton(Res.string().getConfirm());
                this.cancelBtn = new JButton(Res.string().getCancel());
                JPanel messagePanel = new JPanel();
                messagePanel.add(messageLable);
                JPanel btnPanel = new JPanel();
                btnPanel.add(this.cancelBtn);
                btnPanel.add(this.confirmBtn);
                this.add((Component)messagePanel, "North");
                this.add((Component)btnPanel, "Center");
                this.addListener();
            }

            private void addListener() {
                this.confirmBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        OptionDialog.this.cancelBtn.setEnabled(false);
                        if (!DeviceControlModule.reboot()) {
                            JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                        } else {
                            JOptionPane.showMessageDialog(null, Res.string().getOperateSuccess(), Res.string().getPromptMessage(), -1);
                        }
                        OptionDialog.this.dispose();
                    }
                });
                this.cancelBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        OptionDialog.this.dispose();
                    }
                });
            }
        }
    }

    private class DisConnect
    implements NetSDKLib.fDisConnect {
        private DisConnect() {
        }

        @Override
        public void invoke(NetSDKLib.LLong m_hLoginHandle, String pchDVRIP, int nDVRPort, Pointer dwUser) {
            System.out.printf("Device[%s] Port[%d] DisConnect!\n", pchDVRIP, nDVRPort);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, Res.string().getDisConnect(), Res.string().getErrorMessage(), 0);
                    frame.setTitle(Res.string().getDeviceControl());
                    DeviceControlFrame.this.logout();
                }
            });
        }
    }
}

