/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame;

import com.netsdk.common.BorderEx;
import com.netsdk.common.DateChooserJButton;
import com.netsdk.common.FunctionList;
import com.netsdk.common.LoginPanel;
import com.netsdk.common.Res;
import com.netsdk.common.SavePath;
import com.netsdk.demo.module.DownLoadRecordModule;
import com.netsdk.demo.module.LoginModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

class DownLoadRecordFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Vector<String> chnlist = new Vector();
    private DefaultTableModel model;
    private NetSDKLib.LLong m_hDownLoadByTimeHandle = new NetSDKLib.LLong(0L);
    private NetSDKLib.LLong m_hDownLoadByFileHandle = new NetSDKLib.LLong(0L);
    private boolean b_downloadByTime = false;
    private boolean b_downloadByFile = false;
    private IntByReference nFindCount = new IntByReference(0);
    private DisConnect disConnect = new DisConnect();
    private static HaveReConnect haveReConnect = new HaveReConnect();
    private NetSDKLib.NET_TIME stTimeStart = new NetSDKLib.NET_TIME();
    private NetSDKLib.NET_TIME stTimeEnd = new NetSDKLib.NET_TIME();
    private NetSDKLib.NET_RECORDFILE_INFO[] stFileInfo = (NetSDKLib.NET_RECORDFILE_INFO[])new NetSDKLib.NET_RECORDFILE_INFO().toArray(2000);
    Object[][] data = null;
    private static JFrame frame = new JFrame();
    private DownLoadPosCallBackByFile m_DownLoadPosByFile = new DownLoadPosCallBackByFile();
    private DownLoadPosCallBackByTime m_DownLoadPosByTime = new DownLoadPosCallBackByTime();
    private LoginPanel loginPanel;
    private DownLoadRecordPanel downloadRecordPanel;
    private DownLoadByTimePanel downloadByTimePanel;
    private JPanel downloadByFileSetPanel;
    private JPanel queryPanel;
    private JPanel downByFilePanel;
    private JButton queryRecordBtn;
    private JButton downloadByFileBtn;
    private JProgressBar downloadByFileProgressBar;
    private JButton downloadByTimeBtn;
    private JProgressBar downloadByTimeProgressBar;
    private JTable table;
    private DefaultTableModel defaultmodel;
    private JLabel chnlabel;
    private JComboBox chnComboBoxByFile;
    private JComboBox chnComboBoxByTime;
    private JLabel streamLabel;
    private JComboBox streamComboBoxByFile;
    private JComboBox streamComboBoxByTime;
    private DateChooserJButton dateChooserStartByFile;
    private DateChooserJButton dateChooserEndByFile;
    private DownLoadByFilePanel downloadByFilePanel;
    private JPanel downloadByTimeSetPanel;
    private JPanel downByTimePanel;
    private DateChooserJButton dateChooserStartByTime;
    private DateChooserJButton dateChooserEndByTime;

    public DownLoadRecordFrame() {
        this.setTitle(Res.string().getDownloadRecord());
        this.setLayout(new BorderLayout());
        this.pack();
        this.setSize(800, 560);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        LoginModule.init(this.disConnect, haveReConnect);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loginPanel = new LoginPanel();
        this.downloadRecordPanel = new DownLoadRecordPanel();
        this.add((Component)this.loginPanel, "North");
        this.add((Component)this.downloadRecordPanel, "Center");
        this.loginPanel.addLoginBtnActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DownLoadRecordFrame.this.loginPanel.checkLoginText() && DownLoadRecordFrame.this.login()) {
                    frame = ToolKits.getFrame(e);
                    frame.setTitle(Res.string().getDownloadRecord() + " : " + Res.string().getOnline());
                }
            }
        });
        this.loginPanel.addLogoutBtnActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setTitle(Res.string().getDownloadRecord());
                DownLoadRecordFrame.this.logout();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DownLoadRecordModule.stopDownLoadRecordFile(DownLoadRecordFrame.this.m_hDownLoadByFileHandle);
                DownLoadRecordModule.stopDownLoadRecordFile(DownLoadRecordFrame.this.m_hDownLoadByTimeHandle);
                LoginModule.logout();
                LoginModule.cleanup();
                DownLoadRecordFrame.this.dispose();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FunctionList demo = new FunctionList();
                        demo.setVisible(true);
                    }
                });
            }
        });
    }

    public boolean login() {
        Native.setCallbackThreadInitializer(this.m_DownLoadPosByFile, new CallbackThreadInitializer(false, false, "downloadbyfile callback thread"));
        Native.setCallbackThreadInitializer(this.m_DownLoadPosByTime, new CallbackThreadInitializer(false, false, "downloadbytime callback thread"));
        if (LoginModule.login(this.loginPanel.ipTextArea.getText(), Integer.parseInt(this.loginPanel.portTextArea.getText()), this.loginPanel.nameTextArea.getText(), new String(this.loginPanel.passwordTextArea.getPassword()))) {
            this.loginPanel.setButtonEnable(true);
            this.setButtonEnable(true);
            for (int i = 1; i < LoginModule.m_stDeviceInfo.byChanNum + 1; ++i) {
                this.chnlist.add(Res.string().getChannel() + " " + String.valueOf(i));
            }
        } else {
            JOptionPane.showMessageDialog(null, Res.string().getLoginFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return false;
        }
        DownLoadRecordModule.setStreamType(this.streamComboBoxByFile.getSelectedIndex());
        this.chnComboBoxByFile.setModel(new DefaultComboBoxModel<String>(this.chnlist));
        this.chnComboBoxByTime.setModel(new DefaultComboBoxModel<String>(this.chnlist));
        return true;
    }

    public void logout() {
        LoginModule.logout();
        this.loginPanel.setButtonEnable(false);
        this.setButtonEnable(false);
        this.data = new Object[14][5];
        this.table.setModel(new DefaultTableModel(this.data, Res.string().getDownloadTableName()));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(23);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(28);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(50);
        for (int i = 0; i < LoginModule.m_stDeviceInfo.byChanNum; ++i) {
            this.chnlist.clear();
        }
        this.chnComboBoxByFile.setModel(new DefaultComboBoxModel());
        this.chnComboBoxByTime.setModel(new DefaultComboBoxModel());
        this.b_downloadByFile = false;
        this.downloadByFileBtn.setText(Res.string().getDownload());
        this.b_downloadByTime = false;
        this.downloadByTimeBtn.setText(Res.string().getDownload());
    }

    private void setButtonEnable(boolean bln) {
        this.queryRecordBtn.setEnabled(bln);
        this.downloadByFileBtn.setEnabled(bln);
        this.downloadByFileProgressBar.setValue(0);
        this.downloadByFileProgressBar.setEnabled(bln);
        this.downloadByTimeBtn.setEnabled(bln);
        this.downloadByTimeProgressBar.setValue(0);
        this.downloadByTimeProgressBar.setEnabled(bln);
        this.chnComboBoxByFile.setEnabled(bln);
        this.streamComboBoxByFile.setEnabled(bln);
        this.chnComboBoxByTime.setEnabled(bln);
        this.streamComboBoxByTime.setEnabled(bln);
        this.dateChooserStartByFile.setEnabled(bln);
        this.dateChooserEndByFile.setEnabled(bln);
        this.dateChooserStartByTime.setEnabled(bln);
        this.dateChooserEndByTime.setEnabled(bln);
    }

    class DownLoadPosCallBackByTime
    implements NetSDKLib.fTimeDownLoadPosCallBack {
        DownLoadPosCallBackByTime() {
        }

        @Override
        public void invoke(NetSDKLib.LLong lLoginID, final int dwTotalSize, final int dwDownLoadSize, int index, NetSDKLib.NET_RECORDFILE_INFO.ByValue recordfileinfo, Pointer dwUser) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DownLoadRecordFrame.this.downloadByTimeProgressBar.setValue(dwDownLoadSize * 100 / dwTotalSize);
                    if (dwDownLoadSize == -1) {
                        DownLoadRecordFrame.this.downloadByTimeProgressBar.setValue(100);
                        DownLoadRecordModule.stopDownLoadRecordFile(DownLoadRecordFrame.this.m_hDownLoadByTimeHandle);
                        DownLoadRecordFrame.this.b_downloadByTime = false;
                        DownLoadRecordFrame.this.downloadByTimeBtn.setText(Res.string().getDownload());
                        DownLoadRecordFrame.this.chnComboBoxByTime.setEnabled(true);
                        DownLoadRecordFrame.this.streamComboBoxByTime.setEnabled(true);
                        DownLoadRecordFrame.this.dateChooserStartByTime.setEnabled(true);
                        DownLoadRecordFrame.this.dateChooserEndByTime.setEnabled(true);
                        JOptionPane.showMessageDialog(null, Res.string().getDownloadCompleted(), Res.string().getPromptMessage(), 1);
                    }
                }
            });
        }
    }

    class DownLoadPosCallBackByFile
    implements NetSDKLib.fTimeDownLoadPosCallBack {
        DownLoadPosCallBackByFile() {
        }

        @Override
        public void invoke(NetSDKLib.LLong lLoginID, final int dwTotalSize, final int dwDownLoadSize, int index, NetSDKLib.NET_RECORDFILE_INFO.ByValue recordfileinfo, Pointer dwUser) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DownLoadRecordFrame.this.downloadByFileProgressBar.setValue(dwDownLoadSize * 100 / dwTotalSize);
                    if (dwDownLoadSize == -1) {
                        DownLoadRecordFrame.this.downloadByFileProgressBar.setValue(100);
                        DownLoadRecordModule.stopDownLoadRecordFile(DownLoadRecordFrame.this.m_hDownLoadByFileHandle);
                        DownLoadRecordFrame.this.b_downloadByFile = false;
                        DownLoadRecordFrame.this.downloadByFileBtn.setText(Res.string().getDownload());
                        JOptionPane.showMessageDialog(null, Res.string().getDownloadCompleted(), Res.string().getPromptMessage(), 1);
                    }
                }
            });
        }
    }

    private class DownLoadByTimePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public DownLoadByTimePanel() {
            BorderEx.set(this, Res.string().getDownloadByTime(), 2);
            this.setLayout(new BorderLayout());
            DownLoadRecordFrame.this.downloadByTimeSetPanel = new JPanel();
            DownLoadRecordFrame.this.downByTimePanel = new JPanel();
            this.add((Component)DownLoadRecordFrame.this.downloadByTimeSetPanel, "North");
            this.add((Component)DownLoadRecordFrame.this.downByTimePanel, "Center");
            JPanel startTimeByTime = new JPanel();
            JPanel endTimeByTime = new JPanel();
            JPanel chnByTime = new JPanel();
            JPanel streamByTime = new JPanel();
            DownLoadRecordFrame.this.downloadByTimeSetPanel.setLayout(new GridLayout(2, 2));
            DownLoadRecordFrame.this.downloadByTimeSetPanel.add(startTimeByTime);
            DownLoadRecordFrame.this.downloadByTimeSetPanel.add(endTimeByTime);
            DownLoadRecordFrame.this.downloadByTimeSetPanel.add(chnByTime);
            DownLoadRecordFrame.this.downloadByTimeSetPanel.add(streamByTime);
            startTimeByTime.setBorder(new EmptyBorder(5, 5, 5, 20));
            startTimeByTime.setLayout(new GridLayout(2, 1));
            JLabel startLabel = new JLabel(Res.string().getStartTime());
            DownLoadRecordFrame.this.dateChooserStartByTime = new DateChooserJButton();
            Dimension dimension = new Dimension();
            dimension.height = 20;
            DownLoadRecordFrame.this.dateChooserStartByTime.setPreferredSize(dimension);
            startTimeByTime.add(startLabel);
            startTimeByTime.add(DownLoadRecordFrame.this.dateChooserStartByTime);
            endTimeByTime.setBorder(new EmptyBorder(5, 20, 5, 5));
            endTimeByTime.setLayout(new GridLayout(2, 1));
            JLabel endLabel = new JLabel(Res.string().getEndTime());
            DownLoadRecordFrame.this.dateChooserEndByTime = new DateChooserJButton();
            DownLoadRecordFrame.this.dateChooserEndByTime.setPreferredSize(dimension);
            endTimeByTime.add(endLabel);
            endTimeByTime.add(DownLoadRecordFrame.this.dateChooserEndByTime);
            chnByTime.setBorder(new EmptyBorder(5, 10, 0, 5));
            chnByTime.setLayout(new FlowLayout());
            DownLoadRecordFrame.this.chnlabel = new JLabel(Res.string().getChannel());
            DownLoadRecordFrame.this.chnComboBoxByTime = new JComboBox();
            DownLoadRecordFrame.this.chnComboBoxByTime.setPreferredSize(new Dimension(115, 20));
            chnByTime.add(DownLoadRecordFrame.this.chnlabel);
            chnByTime.add(DownLoadRecordFrame.this.chnComboBoxByTime);
            streamByTime.setBorder(new EmptyBorder(5, 10, 0, 5));
            streamByTime.setLayout(new FlowLayout());
            DownLoadRecordFrame.this.streamLabel = new JLabel(Res.string().getStreamType());
            String[] stream = new String[]{Res.string().getMasterAndSub(), Res.string().getMasterStream(), Res.string().getSubStream()};
            DownLoadRecordFrame.this.streamComboBoxByTime = new JComboBox();
            DownLoadRecordFrame.this.streamComboBoxByTime.setModel(new DefaultComboBoxModel<String>(stream));
            DownLoadRecordFrame.this.streamComboBoxByTime.setPreferredSize(new Dimension(115, 20));
            streamByTime.add(DownLoadRecordFrame.this.streamLabel);
            streamByTime.add(DownLoadRecordFrame.this.streamComboBoxByTime);
            DownLoadRecordFrame.this.downByTimePanel.setLayout(new FlowLayout());
            DownLoadRecordFrame.this.downByTimePanel.setBorder(new EmptyBorder(0, 5, 0, 5));
            JPanel btnPanel2 = new JPanel();
            DownLoadRecordFrame.this.downloadByTimeProgressBar = new JProgressBar(0, 100);
            DownLoadRecordFrame.this.downloadByTimeProgressBar.setPreferredSize(new Dimension(355, 20));
            DownLoadRecordFrame.this.downloadByTimeProgressBar.setStringPainted(true);
            DownLoadRecordFrame.this.downByTimePanel.add(btnPanel2);
            DownLoadRecordFrame.this.downByTimePanel.add(DownLoadRecordFrame.this.downloadByTimeProgressBar);
            DownLoadRecordFrame.this.downloadByTimeBtn = new JButton(Res.string().getDownload());
            JLabel nullLabel = new JLabel();
            nullLabel.setPreferredSize(new Dimension(180, 20));
            DownLoadRecordFrame.this.downloadByTimeBtn.setPreferredSize(new Dimension(170, 20));
            btnPanel2.setLayout(new FlowLayout());
            btnPanel2.add(DownLoadRecordFrame.this.downloadByTimeBtn);
            btnPanel2.add(nullLabel);
            DownLoadRecordFrame.this.downloadByTimeBtn.setEnabled(false);
            DownLoadRecordFrame.this.downloadByTimeProgressBar.setEnabled(false);
            DownLoadRecordFrame.this.chnComboBoxByTime.setEnabled(false);
            DownLoadRecordFrame.this.streamComboBoxByTime.setEnabled(false);
            DownLoadRecordFrame.this.dateChooserStartByTime.setEnabled(false);
            DownLoadRecordFrame.this.dateChooserEndByTime.setEnabled(false);
            DownLoadRecordFrame.this.streamComboBoxByTime.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DownLoadRecordModule.setStreamType(DownLoadRecordFrame.this.streamComboBoxByTime.getSelectedIndex());
                }
            });
            DownLoadRecordFrame.this.downloadByTimeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int time = 0;
                    String[] dateStartByTime = DownLoadRecordFrame.this.dateChooserStartByTime.getText().split(" ");
                    String[] dateStart1 = dateStartByTime[0].split("-");
                    String[] dateStart2 = dateStartByTime[1].split(":");
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwYear = Integer.parseInt(dateStart1[0]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwMonth = Integer.parseInt(dateStart1[1]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwDay = Integer.parseInt(dateStart1[2]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwHour = Integer.parseInt(dateStart2[0]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwMinute = Integer.parseInt(dateStart2[1]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwSecond = Integer.parseInt(dateStart2[2]);
                    String[] dateEndByTime = DownLoadRecordFrame.this.dateChooserEndByTime.getText().split(" ");
                    String[] dateEnd1 = dateEndByTime[0].split("-");
                    String[] dateEnd2 = dateEndByTime[1].split(":");
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwYear = Integer.parseInt(dateEnd1[0]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwMonth = Integer.parseInt(dateEnd1[1]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwDay = Integer.parseInt(dateEnd1[2]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwHour = Integer.parseInt(dateEnd2[0]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwMinute = Integer.parseInt(dateEnd2[1]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwSecond = Integer.parseInt(dateEnd2[2]);
                    if (((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwYear != ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwYear || ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwMonth != ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwMonth || ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwDay - ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwDay > 1) {
                        JOptionPane.showMessageDialog(null, Res.string().getSelectTimeAgain(), Res.string().getErrorMessage(), 0);
                        return;
                    }
                    time = ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwDay - ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwDay == 1 ? (24 + ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwHour) * 60 * 60 + ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwMinute * 60 + ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwSecond - ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwHour * 60 * 60 - ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwMinute * 60 - ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwSecond : ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwHour * 60 * 60 + ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwMinute * 60 + ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwSecond - ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwHour * 60 * 60 - ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwMinute * 60 - ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwSecond;
                    System.out.println("time :" + time);
                    if (time > 21600 || time <= 0) {
                        JOptionPane.showMessageDialog(null, Res.string().getSelectTimeAgain(), Res.string().getErrorMessage(), 0);
                        return;
                    }
                    if (!DownLoadRecordFrame.this.b_downloadByTime) {
                        System.out.println("ByTime" + DownLoadRecordFrame.this.dateChooserStartByTime.getText() + "\n" + DownLoadRecordFrame.this.dateChooserEndByTime.getText());
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DownLoadRecordFrame.this.downloadByTimeProgressBar.setValue(0);
                            }
                        });
                        DownLoadRecordFrame.this.m_hDownLoadByTimeHandle = DownLoadRecordModule.downloadRecordFile(DownLoadRecordFrame.this.chnComboBoxByTime.getSelectedIndex(), 0, DownLoadRecordFrame.this.stTimeStart, DownLoadRecordFrame.this.stTimeEnd, SavePath.getSavePath().getSaveRecordFilePath(), DownLoadRecordFrame.this.m_DownLoadPosByTime);
                        if (DownLoadRecordFrame.this.m_hDownLoadByTimeHandle.longValue() != 0L) {
                            DownLoadRecordFrame.this.b_downloadByTime = true;
                            DownLoadRecordFrame.this.downloadByTimeBtn.setText(Res.string().getStopDownload());
                            DownLoadRecordFrame.this.chnComboBoxByTime.setEnabled(false);
                            DownLoadRecordFrame.this.streamComboBoxByTime.setEnabled(false);
                            DownLoadRecordFrame.this.dateChooserStartByTime.setEnabled(false);
                            DownLoadRecordFrame.this.dateChooserEndByTime.setEnabled(false);
                        } else {
                            JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                        }
                    } else {
                        DownLoadRecordModule.stopDownLoadRecordFile(DownLoadRecordFrame.this.m_hDownLoadByTimeHandle);
                        DownLoadRecordFrame.this.b_downloadByTime = false;
                        DownLoadRecordFrame.this.downloadByTimeBtn.setText(Res.string().getDownload());
                        DownLoadRecordFrame.this.chnComboBoxByTime.setEnabled(true);
                        DownLoadRecordFrame.this.streamComboBoxByTime.setEnabled(true);
                        DownLoadRecordFrame.this.dateChooserStartByTime.setEnabled(true);
                        DownLoadRecordFrame.this.dateChooserEndByTime.setEnabled(true);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DownLoadRecordFrame.this.downloadByTimeProgressBar.setValue(0);
                            }
                        });
                    }
                }
            });
        }
    }

    private class DownLoadByFilePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public DownLoadByFilePanel() {
            BorderEx.set(this, Res.string().getDownloadByFile(), 2);
            this.setLayout(new BorderLayout());
            DownLoadRecordFrame.this.downloadByFileSetPanel = new JPanel();
            DownLoadRecordFrame.this.queryPanel = new JPanel();
            DownLoadRecordFrame.this.downByFilePanel = new JPanel();
            this.add((Component)DownLoadRecordFrame.this.downloadByFileSetPanel, "North");
            this.add((Component)DownLoadRecordFrame.this.queryPanel, "Center");
            this.add((Component)DownLoadRecordFrame.this.downByFilePanel, "South");
            JPanel startTimeByFile = new JPanel();
            JPanel endTimeByFile = new JPanel();
            JPanel chnByFile = new JPanel();
            JPanel streamByFile = new JPanel();
            DownLoadRecordFrame.this.downloadByFileSetPanel.setLayout(new GridLayout(2, 2));
            DownLoadRecordFrame.this.downloadByFileSetPanel.add(startTimeByFile);
            DownLoadRecordFrame.this.downloadByFileSetPanel.add(endTimeByFile);
            DownLoadRecordFrame.this.downloadByFileSetPanel.add(chnByFile);
            DownLoadRecordFrame.this.downloadByFileSetPanel.add(streamByFile);
            startTimeByFile.setBorder(new EmptyBorder(5, 5, 5, 20));
            startTimeByFile.setLayout(new GridLayout(2, 1));
            JLabel startLabel = new JLabel(Res.string().getStartTime());
            DownLoadRecordFrame.this.dateChooserStartByFile = new DateChooserJButton();
            Dimension dimension = new Dimension();
            dimension.height = 20;
            DownLoadRecordFrame.this.dateChooserStartByFile.setPreferredSize(dimension);
            startTimeByFile.add(startLabel);
            startTimeByFile.add(DownLoadRecordFrame.this.dateChooserStartByFile);
            endTimeByFile.setBorder(new EmptyBorder(5, 20, 5, 5));
            endTimeByFile.setLayout(new GridLayout(2, 1));
            JLabel endLabel = new JLabel(Res.string().getEndTime());
            DownLoadRecordFrame.this.dateChooserEndByFile = new DateChooserJButton();
            DownLoadRecordFrame.this.dateChooserEndByFile.setPreferredSize(dimension);
            endTimeByFile.add(endLabel);
            endTimeByFile.add(DownLoadRecordFrame.this.dateChooserEndByFile);
            chnByFile.setBorder(new EmptyBorder(5, 10, 0, 5));
            chnByFile.setLayout(new FlowLayout());
            DownLoadRecordFrame.this.chnlabel = new JLabel(Res.string().getChannel());
            DownLoadRecordFrame.this.chnComboBoxByFile = new JComboBox();
            DownLoadRecordFrame.this.chnComboBoxByFile.setPreferredSize(new Dimension(115, 20));
            chnByFile.add(DownLoadRecordFrame.this.chnlabel);
            chnByFile.add(DownLoadRecordFrame.this.chnComboBoxByFile);
            streamByFile.setBorder(new EmptyBorder(5, 10, 0, 5));
            streamByFile.setLayout(new FlowLayout());
            DownLoadRecordFrame.this.streamLabel = new JLabel(Res.string().getStreamType());
            String[] stream = new String[]{Res.string().getMasterAndSub(), Res.string().getMasterStream(), Res.string().getSubStream()};
            DownLoadRecordFrame.this.streamComboBoxByFile = new JComboBox<String>(stream);
            DownLoadRecordFrame.this.streamComboBoxByFile.setModel(new DefaultComboBoxModel<String>(stream));
            DownLoadRecordFrame.this.streamComboBoxByFile.setPreferredSize(new Dimension(115, 20));
            streamByFile.add(DownLoadRecordFrame.this.streamLabel);
            streamByFile.add(DownLoadRecordFrame.this.streamComboBoxByFile);
            DownLoadRecordFrame.this.queryPanel.setLayout(new BorderLayout());
            DownLoadRecordFrame.this.queryPanel.setBorder(new EmptyBorder(0, 5, 5, 5));
            DownLoadRecordFrame.this.data = new Object[14][5];
            DownLoadRecordFrame.this.defaultmodel = new DefaultTableModel(DownLoadRecordFrame.this.data, Res.string().getDownloadTableName());
            DownLoadRecordFrame.this.table = new JTable(DownLoadRecordFrame.this.defaultmodel){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            DownLoadRecordFrame.this.table.setSelectionMode(0);
            DownLoadRecordFrame.this.table.getColumnModel().getColumn(0).setPreferredWidth(20);
            DownLoadRecordFrame.this.table.getColumnModel().getColumn(1).setPreferredWidth(20);
            DownLoadRecordFrame.this.table.getColumnModel().getColumn(2).setPreferredWidth(50);
            DefaultTableCellRenderer dCellRenderer = new DefaultTableCellRenderer();
            dCellRenderer.setHorizontalAlignment(0);
            DownLoadRecordFrame.this.table.setDefaultRenderer(Object.class, dCellRenderer);
            DownLoadRecordFrame.this.queryPanel.add((Component)new JScrollPane(DownLoadRecordFrame.this.table), "Center");
            DownLoadRecordFrame.this.downByFilePanel.setLayout(new BorderLayout());
            DownLoadRecordFrame.this.downByFilePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel btnPanel1 = new JPanel();
            DownLoadRecordFrame.this.downloadByFileProgressBar = new JProgressBar(0, 100);
            DownLoadRecordFrame.this.downloadByFileProgressBar.setPreferredSize(new Dimension(100, 20));
            DownLoadRecordFrame.this.downloadByFileProgressBar.setStringPainted(true);
            DownLoadRecordFrame.this.downByFilePanel.add((Component)btnPanel1, "Center");
            DownLoadRecordFrame.this.downByFilePanel.add((Component)DownLoadRecordFrame.this.downloadByFileProgressBar, "South");
            DownLoadRecordFrame.this.queryRecordBtn = new JButton(Res.string().getQuery());
            DownLoadRecordFrame.this.downloadByFileBtn = new JButton(Res.string().getDownload());
            DownLoadRecordFrame.this.queryRecordBtn.setPreferredSize(new Dimension(175, 20));
            DownLoadRecordFrame.this.downloadByFileBtn.setPreferredSize(new Dimension(175, 20));
            btnPanel1.setLayout(new FlowLayout());
            btnPanel1.add(DownLoadRecordFrame.this.queryRecordBtn);
            btnPanel1.add(DownLoadRecordFrame.this.downloadByFileBtn);
            DownLoadRecordFrame.this.queryRecordBtn.setEnabled(false);
            DownLoadRecordFrame.this.downloadByFileBtn.setEnabled(false);
            DownLoadRecordFrame.this.downloadByFileProgressBar.setEnabled(false);
            DownLoadRecordFrame.this.chnComboBoxByFile.setEnabled(false);
            DownLoadRecordFrame.this.streamComboBoxByFile.setEnabled(false);
            DownLoadRecordFrame.this.dateChooserStartByFile.setEnabled(false);
            DownLoadRecordFrame.this.dateChooserEndByFile.setEnabled(false);
            DownLoadRecordFrame.this.streamComboBoxByFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DownLoadRecordModule.setStreamType(DownLoadRecordFrame.this.streamComboBoxByFile.getSelectedIndex());
                }
            });
            DownLoadRecordFrame.this.queryRecordBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int i = 1;
                    int time = 0;
                    System.out.println(DownLoadRecordFrame.this.dateChooserStartByFile.getText() + "\n" + DownLoadRecordFrame.this.dateChooserEndByFile.getText());
                    String[] dateStartByFile = DownLoadRecordFrame.this.dateChooserStartByFile.getText().split(" ");
                    String[] dateStart1 = dateStartByFile[0].split("-");
                    String[] dateStart2 = dateStartByFile[1].split(":");
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwYear = Integer.parseInt(dateStart1[0]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwMonth = Integer.parseInt(dateStart1[1]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwDay = Integer.parseInt(dateStart1[2]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwHour = Integer.parseInt(dateStart2[0]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwMinute = Integer.parseInt(dateStart2[1]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwSecond = Integer.parseInt(dateStart2[2]);
                    String[] dateEndByFile = DownLoadRecordFrame.this.dateChooserEndByFile.getText().split(" ");
                    String[] dateEnd1 = dateEndByFile[0].split("-");
                    String[] dateEnd2 = dateEndByFile[1].split(":");
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwYear = Integer.parseInt(dateEnd1[0]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwMonth = Integer.parseInt(dateEnd1[1]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwDay = Integer.parseInt(dateEnd1[2]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwHour = Integer.parseInt(dateEnd2[0]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwMinute = Integer.parseInt(dateEnd2[1]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwSecond = Integer.parseInt(dateEnd2[2]);
                    if (((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwYear != ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwYear || ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwMonth != ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwMonth || ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwDay - ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwDay > 1) {
                        JOptionPane.showMessageDialog(null, Res.string().getSelectTimeAgain(), Res.string().getErrorMessage(), 0);
                        return;
                    }
                    time = ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwDay - ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwDay == 1 ? (24 + ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwHour) * 60 * 60 + ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwMinute * 60 + ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwSecond - ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwHour * 60 * 60 - ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwMinute * 60 - ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwSecond : ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwHour * 60 * 60 + ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwMinute * 60 + ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwSecond - ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwHour * 60 * 60 - ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwMinute * 60 - ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwSecond;
                    if (time > 21600 || time <= 0) {
                        JOptionPane.showMessageDialog(null, Res.string().getSelectTimeAgain(), Res.string().getErrorMessage(), 0);
                        return;
                    }
                    if (!DownLoadRecordModule.queryRecordFile(DownLoadRecordFrame.this.chnComboBoxByFile.getSelectedIndex(), DownLoadRecordFrame.this.stTimeStart, DownLoadRecordFrame.this.stTimeEnd, DownLoadRecordFrame.this.stFileInfo, DownLoadRecordFrame.this.nFindCount)) {
                        DownLoadRecordFrame.this.data = new Object[14][5];
                        DownLoadRecordFrame.this.table.setModel(new DefaultTableModel(DownLoadRecordFrame.this.data, Res.string().getDownloadTableName()));
                        DownLoadRecordFrame.this.table.getColumnModel().getColumn(0).setPreferredWidth(23);
                        DownLoadRecordFrame.this.table.getColumnModel().getColumn(1).setPreferredWidth(28);
                        DownLoadRecordFrame.this.table.getColumnModel().getColumn(2).setPreferredWidth(50);
                        JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                    } else {
                        System.out.println(DownLoadRecordFrame.this.nFindCount.getValue());
                        int count = 0;
                        count = DownLoadRecordFrame.this.nFindCount.getValue() > 14 ? DownLoadRecordFrame.this.nFindCount.getValue() : 14;
                        DownLoadRecordFrame.this.data = new Object[count][5];
                        DownLoadRecordFrame.this.table.setModel(new DefaultTableModel(DownLoadRecordFrame.this.data, Res.string().getDownloadTableName()));
                        DownLoadRecordFrame.this.table.getColumnModel().getColumn(0).setPreferredWidth(23);
                        DownLoadRecordFrame.this.table.getColumnModel().getColumn(1).setPreferredWidth(28);
                        DownLoadRecordFrame.this.table.getColumnModel().getColumn(2).setPreferredWidth(50);
                        if (DownLoadRecordFrame.this.nFindCount.getValue() == 0) {
                            return;
                        }
                        DownLoadRecordFrame.this.model = (DefaultTableModel)DownLoadRecordFrame.this.table.getModel();
                        for (int j = 0; j < DownLoadRecordFrame.this.nFindCount.getValue(); ++j) {
                            DownLoadRecordFrame.this.model.setValueAt(String.valueOf(i), j, 0);
                            DownLoadRecordFrame.this.model.setValueAt(String.valueOf(((DownLoadRecordFrame)DownLoadRecordFrame.this).stFileInfo[j].ch + 1), j, 1);
                            DownLoadRecordFrame.this.model.setValueAt(Res.string().getRecordTypeStr(((DownLoadRecordFrame)DownLoadRecordFrame.this).stFileInfo[j].nRecordFileType), j, 2);
                            DownLoadRecordFrame.this.model.setValueAt(((DownLoadRecordFrame)DownLoadRecordFrame.this).stFileInfo[j].starttime.toStringTime(), j, 3);
                            DownLoadRecordFrame.this.model.setValueAt(((DownLoadRecordFrame)DownLoadRecordFrame.this).stFileInfo[j].endtime.toStringTime(), j, 4);
                            ++i;
                        }
                    }
                }
            });
            DownLoadRecordFrame.this.downloadByFileBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = -1;
                    row = DownLoadRecordFrame.this.table.getSelectedRow();
                    if (DownLoadRecordFrame.this.model == null) {
                        JOptionPane.showMessageDialog(null, Res.string().getQueryRecord(), Res.string().getErrorMessage(), 0);
                        return;
                    }
                    if (row < 0) {
                        JOptionPane.showMessageDialog(null, Res.string().getSelectRowWithData(), Res.string().getErrorMessage(), 0);
                        return;
                    }
                    for (int m = 1; m < 5; ++m) {
                        if (DownLoadRecordFrame.this.model.getValueAt(row, m) != null && !String.valueOf(DownLoadRecordFrame.this.model.getValueAt(row, m)).trim().equals("")) continue;
                        JOptionPane.showMessageDialog(null, Res.string().getSelectRowWithData(), Res.string().getErrorMessage(), 0);
                        return;
                    }
                    String[] dateStart = String.valueOf(DownLoadRecordFrame.this.model.getValueAt(row, 3)).split(" ");
                    String[] dateStartByFile1 = dateStart[0].split("/");
                    String[] dateStartByFile2 = dateStart[1].split(":");
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwYear = Integer.parseInt(dateStartByFile1[0]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwMonth = Integer.parseInt(dateStartByFile1[1]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwDay = Integer.parseInt(dateStartByFile1[2]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwHour = Integer.parseInt(dateStartByFile2[0]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwMinute = Integer.parseInt(dateStartByFile2[1]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeStart.dwSecond = Integer.parseInt(dateStartByFile2[2]);
                    String[] dateEnd = String.valueOf(DownLoadRecordFrame.this.model.getValueAt(row, 4)).split(" ");
                    String[] dateEndByFile1 = dateEnd[0].split("/");
                    String[] dateEndByFile2 = dateEnd[1].split(":");
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwYear = Integer.parseInt(dateEndByFile1[0]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwMonth = Integer.parseInt(dateEndByFile1[1]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwDay = Integer.parseInt(dateEndByFile1[2]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwHour = Integer.parseInt(dateEndByFile2[0]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwMinute = Integer.parseInt(dateEndByFile2[1]);
                    ((DownLoadRecordFrame)DownLoadRecordFrame.this).stTimeEnd.dwSecond = Integer.parseInt(dateEndByFile2[2]);
                    if (!DownLoadRecordFrame.this.b_downloadByFile) {
                        System.out.println("ByFile" + String.valueOf(DownLoadRecordFrame.this.model.getValueAt(row, 3)) + "\n" + String.valueOf(DownLoadRecordFrame.this.model.getValueAt(row, 4)));
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DownLoadRecordFrame.this.downloadByFileProgressBar.setValue(0);
                            }
                        });
                        DownLoadRecordFrame.this.m_hDownLoadByFileHandle = DownLoadRecordModule.downloadRecordFile(Integer.parseInt(String.valueOf(DownLoadRecordFrame.this.model.getValueAt(row, 1))) - 1, Res.string().getRecordTypeInt(String.valueOf(DownLoadRecordFrame.this.model.getValueAt(row, 2))), DownLoadRecordFrame.this.stTimeStart, DownLoadRecordFrame.this.stTimeEnd, SavePath.getSavePath().getSaveRecordFilePath(), DownLoadRecordFrame.this.m_DownLoadPosByFile);
                        if (DownLoadRecordFrame.this.m_hDownLoadByFileHandle.longValue() != 0L) {
                            DownLoadRecordFrame.this.b_downloadByFile = true;
                            DownLoadRecordFrame.this.downloadByFileBtn.setText(Res.string().getStopDownload());
                        } else {
                            JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                        }
                    } else {
                        DownLoadRecordModule.stopDownLoadRecordFile(DownLoadRecordFrame.this.m_hDownLoadByFileHandle);
                        DownLoadRecordFrame.this.b_downloadByFile = false;
                        DownLoadRecordFrame.this.downloadByFileBtn.setText(Res.string().getDownload());
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DownLoadRecordFrame.this.downloadByFileProgressBar.setValue(0);
                            }
                        });
                    }
                }
            });
        }
    }

    private class DownLoadRecordPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public DownLoadRecordPanel() {
            BorderEx.set(this, Res.string().getDownloadRecord(), 2);
            this.setLayout(new GridLayout(1, 2));
            DownLoadRecordFrame.this.downloadByTimePanel = new DownLoadByTimePanel();
            DownLoadRecordFrame.this.downloadByFilePanel = new DownLoadByFilePanel();
            this.add(DownLoadRecordFrame.this.downloadByTimePanel);
            this.add(DownLoadRecordFrame.this.downloadByFilePanel);
        }
    }

    private static class HaveReConnect
    implements NetSDKLib.fHaveReConnect {
        private HaveReConnect() {
        }

        @Override
        public void invoke(NetSDKLib.LLong m_hLoginHandle, String pchDVRIP, int nDVRPort, Pointer dwUser) {
            System.out.printf("ReConnect Device[%s] Port[%d]\n", pchDVRIP, nDVRPort);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.setTitle(Res.string().getDownloadRecord() + " : " + Res.string().getOnline());
                }
            });
        }
    }

    private class DisConnect
    implements NetSDKLib.fDisConnect {
        private DisConnect() {
        }

        @Override
        public void invoke(NetSDKLib.LLong m_hLoginHandle, String pchDVRIP, int nDVRPort, Pointer dwUser) {
            System.out.printf("Device[%s] Port[%d] DisConnect!\n", pchDVRIP, nDVRPort);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.setTitle(Res.string().getDownloadRecord() + " : " + Res.string().getDisConnectReconnecting());
                    DownLoadRecordFrame.this.setButtonEnable(true);
                    DownLoadRecordFrame.this.b_downloadByFile = false;
                    DownLoadRecordFrame.this.downloadByFileBtn.setText(Res.string().getDownload());
                    DownLoadRecordFrame.this.b_downloadByTime = false;
                    DownLoadRecordFrame.this.downloadByTimeBtn.setText(Res.string().getDownload());
                    DownLoadRecordModule.stopDownLoadRecordFile(DownLoadRecordFrame.this.m_hDownLoadByFileHandle);
                    DownLoadRecordModule.stopDownLoadRecordFile(DownLoadRecordFrame.this.m_hDownLoadByTimeHandle);
                }
            });
        }
    }
}

