/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.FaceRecognition;

import com.netsdk.common.BorderEx;
import com.netsdk.common.Res;
import com.netsdk.demo.module.FaceRecognitionModule;
import com.netsdk.demo.module.LoginModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class DispositionOperateDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Vector<String> chnlist = new Vector();
    private int nChn;
    private ArrayList<Integer> arrayList;
    private HashMap<Integer, Integer> hashMap;
    String groupId;
    String groupName;
    private Object[][] data;
    private DefaultTableModel defaultTableModel;
    private JTable table;
    private JButton addBtn;
    private JButton refreshBtn;
    private JButton dispositionBtn;
    private JButton delDispositionBtn;
    private JTextField goroupIdTextField;
    private JTextField goroupNameTextField;
    private JComboBox chnComboBox;
    private JTextField similaryTextField;

    public DispositionOperateDialog(String groupId, String groupName) {
        this.nChn = LoginModule.m_stDeviceInfo.byChanNum;
        this.arrayList = new ArrayList();
        this.hashMap = new HashMap();
        this.groupId = "";
        this.groupName = "";
        this.setTitle(Res.string().getDisposition() + "/" + Res.string().getDelDisposition());
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.pack();
        this.setSize(450, 400);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        for (int i = 1; i < this.nChn + 1; ++i) {
            this.chnlist.add(Res.string().getChannel() + " " + String.valueOf(i));
        }
        this.groupId = groupId;
        this.groupName = groupName;
        DispositionListPanel dispositionListPanel = new DispositionListPanel();
        DispositionInfoPanel dispositionInfoPanel = new DispositionInfoPanel();
        this.add((Component)dispositionListPanel, "Center");
        this.add((Component)dispositionInfoPanel, "North");
        this.findChnAndSimilary();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DispositionOperateDialog.this.dispose();
            }
        });
    }

    private void findChnAndSimilary() {
        this.defaultTableModel.setRowCount(0);
        this.defaultTableModel.setRowCount(512);
        NetSDKLib.NET_FACERECONGNITION_GROUP_INFO[] groupInfos = FaceRecognitionModule.findGroupInfo(this.goroupIdTextField.getText());
        if (groupInfos == null) {
            return;
        }
        for (int i = 0; i < groupInfos[0].nRetChnCount; ++i) {
            this.defaultTableModel.setValueAt(String.valueOf(groupInfos[0].nChannel[i] + 1), i, 0);
            this.defaultTableModel.setValueAt(String.valueOf(groupInfos[0].nSimilarity[i]), i, 1);
        }
    }

    static /* synthetic */ Object[][] access$402(DispositionOperateDialog x0, Object[][] x1) {
        x0.data = x1;
        return x1;
    }

    private class DispositionInfoPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public DispositionInfoPanel() {
            BorderEx.set(this, "", 2);
            this.setLayout(new FlowLayout());
            Dimension dimension = new Dimension();
            dimension.height = 80;
            this.setPreferredSize(dimension);
            JLabel goroupIdLabel = new JLabel(Res.string().getFaceGroupId(), 0);
            JLabel goroupNameLabel = new JLabel(Res.string().getFaceGroupName(), 0);
            JLabel chnLabel = new JLabel(Res.string().getChannel(), 0);
            JLabel similaryLabel = new JLabel(Res.string().getSimilarity(), 0);
            DispositionOperateDialog.this.goroupIdTextField = new JTextField();
            DispositionOperateDialog.this.goroupNameTextField = new JTextField();
            DispositionOperateDialog.this.chnComboBox = new JComboBox(DispositionOperateDialog.this.chnlist);
            DispositionOperateDialog.this.similaryTextField = new JTextField();
            Dimension dimension1 = new Dimension();
            dimension1.width = 80;
            dimension1.height = 20;
            goroupIdLabel.setPreferredSize(dimension1);
            goroupNameLabel.setPreferredSize(dimension1);
            chnLabel.setPreferredSize(dimension1);
            similaryLabel.setPreferredSize(dimension1);
            DispositionOperateDialog.this.goroupIdTextField.setPreferredSize(new Dimension(120, 20));
            DispositionOperateDialog.this.goroupNameTextField.setPreferredSize(new Dimension(120, 20));
            DispositionOperateDialog.this.chnComboBox.setPreferredSize(new Dimension(120, 20));
            DispositionOperateDialog.this.similaryTextField.setPreferredSize(new Dimension(120, 20));
            this.add(goroupIdLabel);
            this.add(DispositionOperateDialog.this.goroupIdTextField);
            this.add(goroupNameLabel);
            this.add(DispositionOperateDialog.this.goroupNameTextField);
            this.add(chnLabel);
            this.add(DispositionOperateDialog.this.chnComboBox);
            this.add(similaryLabel);
            this.add(DispositionOperateDialog.this.similaryTextField);
            ToolKits.limitTextFieldLength(DispositionOperateDialog.this.similaryTextField, 3);
            DispositionOperateDialog.this.goroupIdTextField.setEditable(false);
            DispositionOperateDialog.this.goroupNameTextField.setEditable(false);
            DispositionOperateDialog.this.goroupIdTextField.setText(DispositionOperateDialog.this.groupId);
            DispositionOperateDialog.this.goroupNameTextField.setText(DispositionOperateDialog.this.groupName);
        }
    }

    private class DispositionListPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public DispositionListPanel() {
            BorderEx.set(this, "", 2);
            this.setLayout(new BorderLayout());
            JPanel panel = new JPanel();
            JPanel panel2 = new JPanel();
            JPanel panel3 = new JPanel();
            Dimension dimension = new Dimension();
            dimension.width = 145;
            panel.setPreferredSize(dimension);
            panel.setLayout(new BorderLayout());
            panel.add((Component)panel2, "North");
            panel.add((Component)panel3, "South");
            DispositionOperateDialog.this.addBtn = new JButton(Res.string().getAdd());
            DispositionOperateDialog.this.refreshBtn = new JButton(Res.string().getFresh());
            panel2.setLayout(new GridLayout(2, 1));
            panel2.add(DispositionOperateDialog.this.addBtn);
            panel2.add(DispositionOperateDialog.this.refreshBtn);
            DispositionOperateDialog.this.dispositionBtn = new JButton(Res.string().getDisposition());
            DispositionOperateDialog.this.delDispositionBtn = new JButton(Res.string().getDelDisposition());
            panel3.setLayout(new GridLayout(2, 1));
            panel3.add(DispositionOperateDialog.this.dispositionBtn);
            panel3.add(DispositionOperateDialog.this.delDispositionBtn);
            DispositionOperateDialog.access$402(DispositionOperateDialog.this, new Object[512][2]);
            DispositionOperateDialog.this.defaultTableModel = new DefaultTableModel(DispositionOperateDialog.this.data, Res.string().getDispositionTable());
            DispositionOperateDialog.this.table = new JTable(DispositionOperateDialog.this.defaultTableModel){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            DefaultTableCellRenderer dCellRenderer = new DefaultTableCellRenderer();
            dCellRenderer.setHorizontalAlignment(0);
            DispositionOperateDialog.this.table.setDefaultRenderer(Object.class, dCellRenderer);
            this.add((Component)new JScrollPane(DispositionOperateDialog.this.table), "Center");
            this.add((Component)panel, "East");
            DispositionOperateDialog.this.addBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int i;
                    boolean isExit = false;
                    String chn = String.valueOf(DispositionOperateDialog.this.chnComboBox.getSelectedIndex() + 1);
                    String similary = DispositionOperateDialog.this.similaryTextField.getText();
                    if (DispositionOperateDialog.this.similaryTextField.getText().equals("") || Integer.parseInt(DispositionOperateDialog.this.similaryTextField.getText()) > 100) {
                        JOptionPane.showMessageDialog(null, Res.string().getSimilarityRange(), Res.string().getErrorMessage(), 0);
                        return;
                    }
                    for (i = 0; i < DispositionOperateDialog.this.nChn; ++i) {
                        if (!chn.equals(String.valueOf(DispositionOperateDialog.this.defaultTableModel.getValueAt(i, 0)).trim())) continue;
                        DispositionOperateDialog.this.defaultTableModel.setValueAt(similary, i, 1);
                        isExit = true;
                        break;
                    }
                    if (isExit) {
                        return;
                    }
                    for (i = 0; i < DispositionOperateDialog.this.nChn; ++i) {
                        if (!String.valueOf(DispositionOperateDialog.this.defaultTableModel.getValueAt(i, 0)).trim().equals("") && DispositionOperateDialog.this.defaultTableModel.getValueAt(i, 0) != null) continue;
                        DispositionOperateDialog.this.defaultTableModel.setValueAt(chn, i, 0);
                        DispositionOperateDialog.this.defaultTableModel.setValueAt(similary, i, 1);
                        break;
                    }
                }
            });
            DispositionOperateDialog.this.refreshBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    DispositionOperateDialog.this.findChnAndSimilary();
                }
            });
            DispositionOperateDialog.this.dispositionBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    DispositionOperateDialog.this.hashMap.clear();
                    for (int i = 0; i < DispositionOperateDialog.this.nChn; ++i) {
                        if (String.valueOf(DispositionOperateDialog.this.defaultTableModel.getValueAt(i, 0)).trim().equals("") || DispositionOperateDialog.this.defaultTableModel.getValueAt(i, 0) == null) continue;
                        if (!String.valueOf(DispositionOperateDialog.this.defaultTableModel.getValueAt(i, 1)).trim().equals("") && DispositionOperateDialog.this.defaultTableModel.getValueAt(i, 1) != null) {
                            DispositionOperateDialog.this.hashMap.put(Integer.parseInt(String.valueOf(DispositionOperateDialog.this.defaultTableModel.getValueAt(i, 0)).trim()), Integer.parseInt(String.valueOf(DispositionOperateDialog.this.defaultTableModel.getValueAt(i, 1)).trim()));
                            continue;
                        }
                        DispositionOperateDialog.this.hashMap.put(Integer.parseInt(String.valueOf(DispositionOperateDialog.this.defaultTableModel.getValueAt(i, 0)).trim()), 0);
                    }
                    System.out.println("size:" + DispositionOperateDialog.this.hashMap.size());
                    if (DispositionOperateDialog.this.hashMap.size() == 0) {
                        JOptionPane.showMessageDialog(null, Res.string().getAddDispositionInfo(), Res.string().getErrorMessage(), 0);
                        return;
                    }
                    if (!FaceRecognitionModule.putDisposition(DispositionOperateDialog.this.goroupIdTextField.getText(), DispositionOperateDialog.this.hashMap)) {
                        JOptionPane.showMessageDialog(null, Res.string().getFailed() + "," + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                    } else {
                        JOptionPane.showMessageDialog(null, Res.string().getSucceed(), Res.string().getPromptMessage(), 1);
                    }
                    DispositionOperateDialog.this.findChnAndSimilary();
                }
            });
            DispositionOperateDialog.this.delDispositionBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    DispositionOperateDialog.this.arrayList.clear();
                    int[] rows = null;
                    rows = DispositionOperateDialog.this.table.getSelectedRows();
                    if (rows == null) {
                        JOptionPane.showMessageDialog(null, Res.string().getSelectDelDispositionInfo(), Res.string().getErrorMessage(), 0);
                        return;
                    }
                    for (int i = 0; i < rows.length; ++i) {
                        if (String.valueOf(DispositionOperateDialog.this.defaultTableModel.getValueAt(rows[i], 0)).trim().equals("") || DispositionOperateDialog.this.defaultTableModel.getValueAt(rows[i], 0) == null) continue;
                        DispositionOperateDialog.this.arrayList.add(Integer.parseInt(String.valueOf(DispositionOperateDialog.this.defaultTableModel.getValueAt(rows[i], 0)).trim()));
                    }
                    if (DispositionOperateDialog.this.arrayList.size() == 0) {
                        JOptionPane.showMessageDialog(null, Res.string().getSelectDelDispositionInfo(), Res.string().getErrorMessage(), 0);
                        return;
                    }
                    if (!FaceRecognitionModule.delDisposition(DispositionOperateDialog.this.goroupIdTextField.getText(), DispositionOperateDialog.this.arrayList)) {
                        JOptionPane.showMessageDialog(null, Res.string().getFailed() + "," + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                    } else {
                        JOptionPane.showMessageDialog(null, Res.string().getSucceed(), Res.string().getPromptMessage(), 1);
                    }
                    DispositionOperateDialog.this.findChnAndSimilary();
                }
            });
        }
    }
}

