/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.FaceRecognition;

import com.netsdk.common.PaintPanel;
import com.netsdk.common.Res;
import com.netsdk.demo.module.FaceRecognitionModule;
import com.netsdk.lib.ToolKits;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class DownloadPictureDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTextField picPathTextField;
    private PaintPanel paintPanel;
    private JButton downloadBth;

    public DownloadPictureDialog() {
        this.setTitle(Res.string().getDownLoadPicture());
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.pack();
        this.setSize(380, 500);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        JLabel picPathLabel = new JLabel(Res.string().getPicturePath() + ":", 0);
        this.picPathTextField = new JTextField();
        this.downloadBth = new JButton(Res.string().getDownLoadPicture());
        this.picPathTextField.setPreferredSize(new Dimension(180, 20));
        this.downloadBth.setPreferredSize(new Dimension(80, 20));
        this.paintPanel = new PaintPanel();
        this.paintPanel.setPreferredSize(new Dimension(360, 450));
        this.setLayout(new FlowLayout());
        this.add(picPathLabel);
        this.add(this.picPathTextField);
        this.add(this.downloadBth);
        this.add(this.paintPanel);
        this.downloadBth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DownloadPictureDialog.this.paintPanel.setOpaque(true);
                        DownloadPictureDialog.this.paintPanel.repaint();
                        DownloadPictureDialog.this.downloadBth.setEnabled(false);
                    }
                });
                DownloadPictureDialog.this.downloadPicture();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DownloadPictureDialog.this.dispose();
            }
        });
    }

    private void downloadPicture() {
        new SwingWorker<Boolean, Integer>(){
            String szFileName = "";
            String pszFileDst = "";

            @Override
            protected Boolean doInBackground() {
                if (DownloadPictureDialog.this.picPathTextField.getText().isEmpty()) {
                    JOptionPane.showMessageDialog(null, Res.string().getEnterPicturePath(), Res.string().getErrorMessage(), 0);
                    return false;
                }
                this.szFileName = DownloadPictureDialog.this.picPathTextField.getText();
                this.pszFileDst = "./person.jpg";
                File file = new File(this.pszFileDst);
                if (file.exists()) {
                    file.delete();
                }
                if (!FaceRecognitionModule.downloadPersonPic(this.szFileName, this.pszFileDst)) {
                    return false;
                }
                return true;
            }

            @Override
            protected void done() {
                if (DownloadPictureDialog.this.picPathTextField.getText().isEmpty()) {
                    return;
                }
                try {
                    if (((Boolean)this.get()).booleanValue()) {
                        ToolKits.openPictureFile(this.pszFileDst, DownloadPictureDialog.this.paintPanel);
                    } else {
                        JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                    }
                }
                catch (HeadlessException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                DownloadPictureDialog.this.downloadBth.setEnabled(true);
            }
        }.execute();
    }
}

