/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.Gate;

import com.netsdk.common.BorderEx;
import com.netsdk.common.DateChooserJButton;
import com.netsdk.common.PaintPanel;
import com.netsdk.common.Res;
import com.netsdk.demo.module.GateModule;
import com.netsdk.lib.ToolKits;
import com.sun.jna.Memory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class AddCardDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Memory memory = null;
    private String picPath = "";
    private PaintPanel addImagePanel;
    private JButton selectImageBtn;
    private JTextField cardNoTextField;
    private JTextField userIdTextField;
    private JTextField cardNameTextField;
    private JPasswordField cardPasswdField;
    private JComboBox cardStatusComboBox;
    private JComboBox cardTypeComboBox;
    private JTextField useTimesTextField;
    private JCheckBox firstEnterCheckBox;
    private JCheckBox enableCheckBox;
    private DateChooserJButton startTimeBtn;
    private DateChooserJButton endTimeBtn;
    private JButton addBtn;
    private JButton cancelBtn;

    public AddCardDialog() {
        this.setTitle(Res.string().getAdd() + Res.string().getCardInfo());
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.pack();
        this.setSize(520, 390);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        CardInfoPanel cardInfoPanel = new CardInfoPanel();
        ImagePanel imagePanel = new ImagePanel();
        this.add((Component)cardInfoPanel, "Center");
        this.add((Component)imagePanel, "East");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AddCardDialog.this.clear();
                AddCardDialog.this.dispose();
            }
        });
    }

    private void clear() {
        this.memory = null;
        this.picPath = "";
    }

    private class ImagePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public ImagePanel() {
            BorderEx.set(this, Res.string().getPersonPicture(), 4);
            Dimension dimension = new Dimension();
            dimension.width = 250;
            this.setPreferredSize(dimension);
            this.setLayout(new BorderLayout());
            AddCardDialog.this.addImagePanel = new PaintPanel();
            AddCardDialog.this.selectImageBtn = new JButton(Res.string().getSelectPicture());
            this.add((Component)AddCardDialog.this.addImagePanel, "Center");
            this.add((Component)AddCardDialog.this.selectImageBtn, "South");
            AddCardDialog.this.selectImageBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    AddCardDialog.this.picPath = ToolKits.openPictureFile(AddCardDialog.this.addImagePanel);
                    if (!AddCardDialog.this.picPath.isEmpty()) {
                        try {
                            AddCardDialog.this.memory = ToolKits.readPictureFile(AddCardDialog.this.picPath);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    private class CardInfoPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public CardInfoPanel() {
            BorderEx.set(this, Res.string().getCardInfo(), 4);
            this.setLayout(new FlowLayout());
            JLabel cardNoLabel = new JLabel(Res.string().getCardNo() + ":", 0);
            JLabel userIdLabel = new JLabel(Res.string().getUserId() + ":", 0);
            JLabel cardNameLabel = new JLabel(Res.string().getCardName() + ":", 0);
            JLabel cardPasswdLabel = new JLabel(Res.string().getCardPassword() + ":", 0);
            JLabel cardStatusLabel = new JLabel(Res.string().getCardStatus() + ":", 0);
            JLabel cardTypeLabel = new JLabel(Res.string().getCardType() + ":", 0);
            JLabel useTimesLabel = new JLabel(Res.string().getUseTimes() + ":", 0);
            JLabel validPeriodLabel = new JLabel(Res.string().getValidPeriod() + ":", 0);
            Dimension dimension = new Dimension();
            dimension.width = 85;
            dimension.height = 20;
            cardNoLabel.setPreferredSize(dimension);
            userIdLabel.setPreferredSize(dimension);
            cardNameLabel.setPreferredSize(dimension);
            cardPasswdLabel.setPreferredSize(dimension);
            cardStatusLabel.setPreferredSize(dimension);
            cardTypeLabel.setPreferredSize(dimension);
            useTimesLabel.setPreferredSize(dimension);
            validPeriodLabel.setPreferredSize(dimension);
            AddCardDialog.this.cardNoTextField = new JTextField();
            AddCardDialog.this.userIdTextField = new JTextField();
            AddCardDialog.this.cardNameTextField = new JTextField();
            AddCardDialog.this.cardPasswdField = new JPasswordField();
            AddCardDialog.this.cardStatusComboBox = new JComboBox<String>(Res.string().getCardStatusList());
            AddCardDialog.this.cardTypeComboBox = new JComboBox<String>(Res.string().getCardTypeList());
            AddCardDialog.this.useTimesTextField = new JTextField("0");
            AddCardDialog.this.firstEnterCheckBox = new JCheckBox(Res.string().getIsFirstEnter());
            AddCardDialog.this.enableCheckBox = new JCheckBox(Res.string().getEnable());
            AddCardDialog.this.enableCheckBox.setSelected(true);
            AddCardDialog.this.enableCheckBox.setVisible(false);
            AddCardDialog.this.startTimeBtn = new DateChooserJButton();
            AddCardDialog.this.endTimeBtn = new DateChooserJButton();
            AddCardDialog.this.cardNoTextField.setPreferredSize(new Dimension(145, 20));
            AddCardDialog.this.userIdTextField.setPreferredSize(new Dimension(145, 20));
            AddCardDialog.this.cardNameTextField.setPreferredSize(new Dimension(145, 20));
            AddCardDialog.this.cardPasswdField.setPreferredSize(new Dimension(145, 20));
            AddCardDialog.this.useTimesTextField.setPreferredSize(new Dimension(145, 20));
            AddCardDialog.this.cardStatusComboBox.setPreferredSize(new Dimension(145, 20));
            AddCardDialog.this.cardTypeComboBox.setPreferredSize(new Dimension(145, 20));
            AddCardDialog.this.startTimeBtn.setPreferredSize(new Dimension(145, 20));
            AddCardDialog.this.endTimeBtn.setPreferredSize(new Dimension(145, 20));
            AddCardDialog.this.firstEnterCheckBox.setPreferredSize(new Dimension(170, 20));
            AddCardDialog.this.enableCheckBox.setPreferredSize(new Dimension(70, 20));
            JLabel nullLabel1 = new JLabel();
            JLabel nullLabel2 = new JLabel();
            JLabel nullLabel3 = new JLabel();
            nullLabel1.setPreferredSize(new Dimension(5, 20));
            nullLabel2.setPreferredSize(new Dimension(30, 20));
            nullLabel3.setPreferredSize(new Dimension(85, 20));
            AddCardDialog.this.addBtn = new JButton(Res.string().getAdd());
            AddCardDialog.this.cancelBtn = new JButton(Res.string().getCancel());
            JLabel nullLabel4 = new JLabel();
            nullLabel4.setPreferredSize(new Dimension(250, 20));
            AddCardDialog.this.addBtn.setPreferredSize(new Dimension(110, 20));
            AddCardDialog.this.cancelBtn.setPreferredSize(new Dimension(110, 20));
            this.add(cardNoLabel);
            this.add(AddCardDialog.this.cardNoTextField);
            this.add(userIdLabel);
            this.add(AddCardDialog.this.userIdTextField);
            this.add(cardNameLabel);
            this.add(AddCardDialog.this.cardNameTextField);
            this.add(cardPasswdLabel);
            this.add(AddCardDialog.this.cardPasswdField);
            this.add(cardStatusLabel);
            this.add(AddCardDialog.this.cardStatusComboBox);
            this.add(cardTypeLabel);
            this.add(AddCardDialog.this.cardTypeComboBox);
            this.add(useTimesLabel);
            this.add(AddCardDialog.this.useTimesTextField);
            this.add(nullLabel1);
            this.add(AddCardDialog.this.firstEnterCheckBox);
            this.add(nullLabel2);
            this.add(AddCardDialog.this.enableCheckBox);
            this.add(validPeriodLabel);
            this.add(AddCardDialog.this.startTimeBtn);
            this.add(nullLabel3);
            this.add(AddCardDialog.this.endTimeBtn);
            this.add(nullLabel4);
            this.add(AddCardDialog.this.addBtn);
            this.add(AddCardDialog.this.cancelBtn);
            AddCardDialog.this.addBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (AddCardDialog.this.cardNoTextField.getText().isEmpty()) {
                        JOptionPane.showMessageDialog(null, Res.string().getInputCardNo(), Res.string().getErrorMessage(), 0);
                        return;
                    }
                    if (AddCardDialog.this.userIdTextField.getText().isEmpty()) {
                        JOptionPane.showMessageDialog(null, Res.string().getInputUserId(), Res.string().getErrorMessage(), 0);
                        return;
                    }
                    if (AddCardDialog.this.memory == null) {
                        JOptionPane.showMessageDialog(null, Res.string().getSelectPicture(), Res.string().getErrorMessage(), 0);
                        return;
                    }
                    try {
                        if (AddCardDialog.this.cardNoTextField.getText().getBytes("UTF-8").length > 31) {
                            JOptionPane.showMessageDialog(null, Res.string().getCardNoExceedLength() + "(31)", Res.string().getErrorMessage(), 0);
                            return;
                        }
                        if (AddCardDialog.this.userIdTextField.getText().getBytes("UTF-8").length > 31) {
                            JOptionPane.showMessageDialog(null, Res.string().getUserIdExceedLength() + "(31)", Res.string().getErrorMessage(), 0);
                            return;
                        }
                        if (AddCardDialog.this.cardNameTextField.getText().getBytes("UTF-8").length > 63) {
                            JOptionPane.showMessageDialog(null, Res.string().getCardNameExceedLength() + "(63)", Res.string().getErrorMessage(), 0);
                            return;
                        }
                        if (new String(AddCardDialog.this.cardPasswdField.getPassword()).getBytes("UTF-8").length > 63) {
                            JOptionPane.showMessageDialog(null, Res.string().getCardPasswdExceedLength() + "(63)", Res.string().getErrorMessage(), 0);
                            return;
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    int useTimes = 0;
                    useTimes = AddCardDialog.this.useTimesTextField.getText().isEmpty() ? 0 : Integer.parseInt(AddCardDialog.this.useTimesTextField.getText());
                    boolean bCardFlags = GateModule.insertCard(AddCardDialog.this.cardNoTextField.getText(), AddCardDialog.this.userIdTextField.getText(), AddCardDialog.this.cardNameTextField.getText(), new String(AddCardDialog.this.cardPasswdField.getPassword()), Res.string().getCardStatusInt(AddCardDialog.this.cardStatusComboBox.getSelectedIndex()), Res.string().getCardTypeInt(AddCardDialog.this.cardTypeComboBox.getSelectedIndex()), useTimes, AddCardDialog.this.firstEnterCheckBox.isSelected() ? 1 : 0, AddCardDialog.this.enableCheckBox.isSelected() ? 1 : 0, AddCardDialog.this.startTimeBtn.getText(), AddCardDialog.this.endTimeBtn.getText());
                    String cardError = "";
                    if (!bCardFlags) {
                        cardError = ToolKits.getErrorCodeShow();
                    }
                    boolean bFaceFalgs = GateModule.addFaceInfo(AddCardDialog.this.userIdTextField.getText(), AddCardDialog.this.memory);
                    String faceError = "";
                    if (!bFaceFalgs) {
                        faceError = ToolKits.getErrorCodeShow();
                    }
                    if (bCardFlags && bFaceFalgs) {
                        JOptionPane.showMessageDialog(null, Res.string().getSucceedAddCardAndPerson(), Res.string().getPromptMessage(), 1);
                        AddCardDialog.this.dispose();
                    }
                    if (!bCardFlags && !bFaceFalgs) {
                        JOptionPane.showMessageDialog(null, Res.string().getFailedAddCard() + " : " + cardError, Res.string().getErrorMessage(), 0);
                    }
                    if (bCardFlags && !bFaceFalgs) {
                        JOptionPane.showMessageDialog(null, Res.string().getSucceedAddCardButFailedAddPerson() + " : " + faceError, Res.string().getErrorMessage(), 0);
                    }
                    if (!bCardFlags && bFaceFalgs) {
                        JOptionPane.showMessageDialog(null, Res.string().getCardExistedSucceedAddPerson(), Res.string().getPromptMessage(), 1);
                    }
                }
            });
            AddCardDialog.this.cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    AddCardDialog.this.clear();
                    AddCardDialog.this.dispose();
                }
            });
        }
    }
}

