/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.Gate;

import com.netsdk.common.BorderEx;
import com.netsdk.common.Res;
import com.netsdk.demo.frame.Gate.AddCardDialog;
import com.netsdk.demo.frame.Gate.ModifyCardDialog;
import com.netsdk.demo.module.GateModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class CardManegerDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private int count = 0;
    private int index = 0;
    private int nFindCount = 10;
    private DefaultTableModel defaultModel;
    private JTable table;
    private JTextField cardNoTextField;
    private JButton searchBtn;
    private JButton addBtn;
    private JButton modifyBtn;
    private JButton deleteBtn;
    private JButton clearBtn;

    public CardManegerDialog() {
        this.setTitle(Res.string().getCardManager());
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.pack();
        this.setSize(700, 390);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        CardListPanel cardListPanel = new CardListPanel();
        CardOperatePanel cardOperatePanel = new CardOperatePanel();
        this.add((Component)cardListPanel, "Center");
        this.add((Component)cardOperatePanel, "East");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CardManegerDialog.this.dispose();
            }
        });
        this.setOnClickListener();
    }

    private void setOnClickListener() {
        this.searchBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (CardManegerDialog.this.cardNoTextField.getText().getBytes("UTF-8").length > 31) {
                                JOptionPane.showMessageDialog(null, Res.string().getCardNoExceedLength() + "(31)", Res.string().getErrorMessage(), 0);
                                return;
                            }
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        CardManegerDialog.this.searchBtn.setEnabled(false);
                        CardManegerDialog.this.defaultModel.setRowCount(0);
                        CardManegerDialog.this.defaultModel.setRowCount(18);
                    }
                });
                CardManegerDialog.this.findCardInfo();
            }
        });
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AddCardDialog dialog = new AddCardDialog();
                dialog.setVisible(true);
            }
        });
        this.modifyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int row = -1;
                row = CardManegerDialog.this.table.getSelectedRow();
                if (row < 0) {
                    JOptionPane.showMessageDialog(null, Res.string().getSelectCard(), Res.string().getErrorMessage(), 0);
                    return;
                }
                if (CardManegerDialog.this.defaultModel.getValueAt(row, 3) == null || String.valueOf(CardManegerDialog.this.defaultModel.getValueAt(row, 3)).trim().isEmpty()) {
                    JOptionPane.showMessageDialog(null, Res.string().getSelectCard(), Res.string().getErrorMessage(), 0);
                    return;
                }
                Vector vector = CardManegerDialog.this.defaultModel.getDataVector().get(row);
                ModifyCardDialog dialog = new ModifyCardDialog(vector);
                dialog.setVisible(true);
            }
        });
        this.deleteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int row = -1;
                row = CardManegerDialog.this.table.getSelectedRow();
                if (row < 0) {
                    JOptionPane.showMessageDialog(null, Res.string().getSelectCard(), Res.string().getErrorMessage(), 0);
                    return;
                }
                if (CardManegerDialog.this.defaultModel.getValueAt(row, 3) == null || String.valueOf(CardManegerDialog.this.defaultModel.getValueAt(row, 3)).trim().isEmpty()) {
                    JOptionPane.showMessageDialog(null, Res.string().getSelectCard(), Res.string().getErrorMessage(), 0);
                    return;
                }
                Vector v = CardManegerDialog.this.defaultModel.getDataVector().get(row);
                String recordNo = ((String)v.get(3)).toString();
                String userId = ((String)v.get(4)).toString();
                if (!GateModule.deleteFaceInfo(userId) || !GateModule.deleteCard(Integer.parseInt(recordNo))) {
                    JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                } else {
                    JOptionPane.showMessageDialog(null, Res.string().getSucceed(), Res.string().getPromptMessage(), 1);
                    CardManegerDialog.this.defaultModel.removeRow(row);
                    CardManegerDialog.this.table.updateUI();
                }
            }
        });
        this.clearBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int result = JOptionPane.showConfirmDialog(null, Res.string().getWantClearAllInfo(), Res.string().getPromptMessage(), 0);
                if (result == 0) {
                    if (!GateModule.clearFaceInfo() || !GateModule.clearCard()) {
                        JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                    } else {
                        JOptionPane.showMessageDialog(null, Res.string().getSucceed(), Res.string().getPromptMessage(), 1);
                        CardManegerDialog.this.defaultModel.setRowCount(0);
                        CardManegerDialog.this.defaultModel.setRowCount(18);
                    }
                }
            }
        });
    }

    public void findCardInfo() {
        new SwingWorker<Boolean, CardData>(){

            @Override
            protected Boolean doInBackground() {
                NetSDKLib.NET_RECORDSET_ACCESS_CTL_CARD[] pstRecord;
                CardManegerDialog.this.count = 0;
                CardManegerDialog.this.index = 0;
                CardManegerDialog.this.nFindCount = 10;
                if (!GateModule.findCard(CardManegerDialog.this.cardNoTextField.getText())) {
                    return false;
                }
                while ((pstRecord = GateModule.findNextCard(CardManegerDialog.this.nFindCount)) != null) {
                    for (int i = 0; i < pstRecord.length; ++i) {
                        CardManegerDialog.this.index = i + CardManegerDialog.this.count * CardManegerDialog.this.nFindCount;
                        try {
                            Vector<String> vector = new Vector<String>();
                            vector.add(String.valueOf(CardManegerDialog.this.index + 1));
                            vector.add(new String(pstRecord[i].szCardNo).trim());
                            vector.add(new String(pstRecord[i].szCardName, "GBK").trim());
                            vector.add(String.valueOf(pstRecord[i].nRecNo));
                            vector.add(new String(pstRecord[i].szUserID).trim());
                            vector.add(new String(pstRecord[i].szPsw).trim());
                            vector.add(Res.string().getCardStatus(pstRecord[i].emStatus));
                            vector.add(Res.string().getCardType(pstRecord[i].emType));
                            vector.add(String.valueOf(pstRecord[i].nUserTime));
                            vector.add(pstRecord[i].bFirstEnter == 1 ? Res.string().getFirstEnter() : Res.string().getNoFirstEnter());
                            vector.add(pstRecord[i].bIsValid == 1 ? Res.string().getValid() : Res.string().getInValid());
                            vector.add(pstRecord[i].stuValidStartTime.toStringTimeEx());
                            vector.add(pstRecord[i].stuValidEndTime.toStringTimeEx());
                            CardData data = new CardData();
                            data.setIndex(CardManegerDialog.this.index);
                            data.setVector(vector);
                            this.publish(data);
                            continue;
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                    }
                    if (pstRecord.length < CardManegerDialog.this.nFindCount) break;
                    CardManegerDialog.this.count++;
                }
                GateModule.findCardClose();
                return true;
            }

            @Override
            protected void process(List<CardData> chunks) {
                for (CardData data : chunks) {
                    CardManegerDialog.this.defaultModel.insertRow(data.getIndex(), data.getVector());
                    if (data.getIndex() < 18) {
                        CardManegerDialog.this.defaultModel.setRowCount(18);
                    } else {
                        CardManegerDialog.this.defaultModel.setRowCount(data.getIndex() + 1);
                    }
                    CardManegerDialog.this.table.updateUI();
                }
                super.process(chunks);
            }

            @Override
            protected void done() {
                CardManegerDialog.this.searchBtn.setEnabled(true);
            }
        }.execute();
    }

    class CardData {
        private int nIndex = 0;
        private Vector<String> vector = null;

        CardData() {
        }

        public int getIndex() {
            return this.nIndex;
        }

        public void setIndex(int index) {
            this.nIndex = index;
        }

        public Vector<String> getVector() {
            return this.vector;
        }

        public void setVector(Vector<String> vector) {
            this.vector = vector;
        }
    }

    private class CardOperatePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public CardOperatePanel() {
            BorderEx.set(this, Res.string().getCardOperate(), 2);
            this.setLayout(new BorderLayout());
            Dimension dimension = new Dimension();
            dimension.width = 210;
            this.setPreferredSize(dimension);
            Panel panel1 = new Panel();
            Panel panel2 = new Panel();
            this.add((Component)panel1, "North");
            this.add((Component)panel2, "Center");
            JLabel cardNoLabel = new JLabel(Res.string().getCardNo() + ":", 0);
            CardManegerDialog.this.cardNoTextField = new JTextField("");
            cardNoLabel.setPreferredSize(new Dimension(50, 20));
            CardManegerDialog.this.cardNoTextField.setPreferredSize(new Dimension(120, 20));
            CardManegerDialog.this.cardNoTextField.setHorizontalAlignment(0);
            panel1.setLayout(new FlowLayout());
            panel1.add(cardNoLabel);
            panel1.add(CardManegerDialog.this.cardNoTextField);
            CardManegerDialog.this.searchBtn = new JButton(Res.string().getSearch());
            CardManegerDialog.this.addBtn = new JButton(Res.string().getAdd());
            CardManegerDialog.this.modifyBtn = new JButton(Res.string().getModify());
            CardManegerDialog.this.deleteBtn = new JButton(Res.string().getDelete());
            CardManegerDialog.this.clearBtn = new JButton(Res.string().getClear());
            CardManegerDialog.this.searchBtn.setPreferredSize(new Dimension(180, 21));
            CardManegerDialog.this.addBtn.setPreferredSize(new Dimension(180, 21));
            CardManegerDialog.this.modifyBtn.setPreferredSize(new Dimension(180, 21));
            CardManegerDialog.this.deleteBtn.setPreferredSize(new Dimension(180, 21));
            CardManegerDialog.this.clearBtn.setPreferredSize(new Dimension(180, 21));
            JLabel nullLabel = new JLabel();
            nullLabel.setPreferredSize(new Dimension(180, 30));
            panel2.setLayout(new FlowLayout());
            panel2.add(nullLabel);
            panel2.add(CardManegerDialog.this.searchBtn);
            panel2.add(CardManegerDialog.this.addBtn);
            panel2.add(CardManegerDialog.this.modifyBtn);
            panel2.add(CardManegerDialog.this.deleteBtn);
            panel2.add(CardManegerDialog.this.clearBtn);
        }
    }

    private class CardListPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public CardListPanel() {
            BorderEx.set(this, Res.string().getCardInfo(), 2);
            this.setLayout(new BorderLayout());
            CardManegerDialog.this.defaultModel = new DefaultTableModel((Object[][])null, Res.string().getCardTable());
            CardManegerDialog.this.table = new JTable(CardManegerDialog.this.defaultModel){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            CardManegerDialog.this.defaultModel.setRowCount(18);
            CardManegerDialog.this.table.getColumnModel().getColumn(0).setPreferredWidth(80);
            CardManegerDialog.this.table.getColumnModel().getColumn(1).setPreferredWidth(120);
            CardManegerDialog.this.table.getColumnModel().getColumn(2).setPreferredWidth(100);
            CardManegerDialog.this.table.getColumnModel().getColumn(3).setPreferredWidth(100);
            CardManegerDialog.this.table.getColumnModel().getColumn(4).setPreferredWidth(100);
            CardManegerDialog.this.table.getColumnModel().getColumn(5).setPreferredWidth(100);
            CardManegerDialog.this.table.getColumnModel().getColumn(6).setPreferredWidth(100);
            CardManegerDialog.this.table.getColumnModel().getColumn(7).setPreferredWidth(100);
            CardManegerDialog.this.table.getColumnModel().getColumn(8).setPreferredWidth(100);
            CardManegerDialog.this.table.getColumnModel().getColumn(9).setPreferredWidth(100);
            CardManegerDialog.this.table.getColumnModel().getColumn(10).setPreferredWidth(100);
            CardManegerDialog.this.table.getColumnModel().getColumn(11).setPreferredWidth(150);
            CardManegerDialog.this.table.getColumnModel().getColumn(12).setPreferredWidth(150);
            DefaultTableCellRenderer dCellRenderer = new DefaultTableCellRenderer();
            dCellRenderer.setHorizontalAlignment(0);
            CardManegerDialog.this.table.setDefaultRenderer(Object.class, dCellRenderer);
            ((DefaultTableCellRenderer)CardManegerDialog.this.table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
            CardManegerDialog.this.table.setAutoResizeMode(0);
            JScrollPane scrollPane = new JScrollPane(CardManegerDialog.this.table);
            this.add((Component)scrollPane, "Center");
        }
    }
}

