/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.Gate;

import com.netsdk.common.BorderEx;
import com.netsdk.common.FunctionList;
import com.netsdk.common.LoginPanel;
import com.netsdk.common.PaintPanel;
import com.netsdk.common.Res;
import com.netsdk.demo.frame.Gate.CardManegerDialog;
import com.netsdk.demo.module.GateModule;
import com.netsdk.demo.module.LoginModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.Pointer;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class GateFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static JFrame frame = new JFrame();
    private static DisConnect disConnect = new DisConnect();
    private static HaveReConnect haveReConnect = new HaveReConnect();
    public static NetSDKLib.LLong m_hAttachHandle = new NetSDKLib.LLong(0L);
    private Vector<String> chnList = new Vector();
    private AnalyzerDataCB analyzerCallback = new AnalyzerDataCB();
    private Component target = this;
    private boolean isAttach = false;
    private LoginPanel loginPanel;
    private JComboBox chnComboBox;
    private JButton attachBtn;
    private JButton detachBtn;
    private JButton cardOperateBtn;
    private PaintPanel personPaintPanel;
    private JTextField timeTextField;
    private JTextField openStatusTextField;
    private JTextField openMethodTextField;
    private JTextField cardNameTextField;
    private JTextField cardNoTextField;
    private JTextField userIdTextField;
    private JTextField tempTextField;
    private JTextField maskStatusTextField;

    public GateFrame() {
        this.setTitle(Res.string().getGate());
        this.setLayout(new BorderLayout());
        this.pack();
        this.setSize(800, 400);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        LoginModule.init(disConnect, haveReConnect);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loginPanel = new LoginPanel();
        GatePanel gatePanel = new GatePanel();
        this.add((Component)this.loginPanel, "North");
        this.add((Component)gatePanel, "Center");
        this.loginPanel.addLoginBtnActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GateFrame.this.loginPanel.checkLoginText() && GateFrame.this.login()) {
                    frame = ToolKits.getFrame(e);
                    frame.setTitle(Res.string().getGate() + " : " + Res.string().getOnline());
                }
            }
        });
        this.loginPanel.addLogoutBtnActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setTitle(Res.string().getGate());
                GateFrame.this.logout();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GateModule.stopRealLoadPic(m_hAttachHandle);
                LoginModule.logout();
                LoginModule.cleanup();
                GateFrame.this.dispose();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FunctionList demo = new FunctionList();
                        demo.setVisible(true);
                    }
                });
            }
        });
    }

    public boolean login() {
        if (LoginModule.login(this.loginPanel.ipTextArea.getText(), Integer.parseInt(this.loginPanel.portTextArea.getText()), this.loginPanel.nameTextArea.getText(), new String(this.loginPanel.passwordTextArea.getPassword()))) {
            for (int i = 1; i < LoginModule.m_stDeviceInfo.byChanNum + 1; ++i) {
                this.chnList.add(Res.string().getChannel() + " " + String.valueOf(i));
            }
        } else {
            JOptionPane.showMessageDialog(null, Res.string().getLoginFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return false;
        }
        this.chnComboBox.setModel(new DefaultComboBoxModel<String>(this.chnList));
        this.loginPanel.setButtonEnable(true);
        this.setEnable(true);
        return true;
    }

    public void logout() {
        GateModule.stopRealLoadPic(m_hAttachHandle);
        LoginModule.logout();
        this.loginPanel.setButtonEnable(false);
        for (int i = 0; i < LoginModule.m_stDeviceInfo.byChanNum; ++i) {
            this.chnList.clear();
        }
        this.chnComboBox.setModel(new DefaultComboBoxModel());
        this.setEnable(false);
        this.detachBtn.setEnabled(false);
        this.isAttach = false;
        this.clearPanel();
    }

    private void setOnClickListener() {
        this.attachBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                m_hAttachHandle = GateModule.realLoadPic(GateFrame.this.chnComboBox.getSelectedIndex(), GateFrame.this.analyzerCallback);
                if (m_hAttachHandle.longValue() != 0L) {
                    GateFrame.this.isAttach = true;
                    GateFrame.this.attachBtn.setEnabled(false);
                    GateFrame.this.detachBtn.setEnabled(true);
                } else {
                    JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                }
            }
        });
        this.detachBtn.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent arg0) {
                GateModule.stopRealLoadPic(m_hAttachHandle);
                5 var2_2 = this;
                synchronized (var2_2) {
                    GateFrame.this.isAttach = false;
                }
                GateFrame.this.attachBtn.setEnabled(true);
                GateFrame.this.detachBtn.setEnabled(false);
                GateFrame.this.clearPanel();
            }
        });
        this.cardOperateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CardManegerDialog dialog = new CardManegerDialog();
                dialog.setVisible(true);
            }
        });
    }

    private void setEnable(boolean bln) {
        this.chnComboBox.setEnabled(bln);
        this.attachBtn.setEnabled(bln);
        this.cardOperateBtn.setEnabled(bln);
    }

    private void clearPanel() {
        this.personPaintPanel.setOpaque(true);
        this.personPaintPanel.repaint();
        this.timeTextField.setText("");
        this.openStatusTextField.setText("");
        this.openMethodTextField.setText("");
        this.cardNameTextField.setText("");
        this.cardNoTextField.setText("");
        this.userIdTextField.setText("");
        this.tempTextField.setText("");
        this.maskStatusTextField.setText("");
    }

    @Override
    protected void processEvent(AWTEvent event) {
        if (event instanceof AccessEvent) {
            AccessEvent ev = (AccessEvent)event;
            BufferedImage gateBufferedImage = ev.getGateBufferedImage();
            NetSDKLib.DEV_EVENT_ACCESS_CTL_INFO msg = ev.getAccessInfo();
            if (!this.isAttach) {
                return;
            }
            if (gateBufferedImage != null) {
                this.personPaintPanel.setImage(gateBufferedImage);
                this.personPaintPanel.setOpaque(false);
                this.personPaintPanel.repaint();
            } else {
                this.personPaintPanel.setOpaque(true);
                this.personPaintPanel.repaint();
            }
            if (msg.UTC == null || msg.UTC.toString().isEmpty()) {
                this.timeTextField.setText("");
            } else {
                msg.UTC.setTime(msg.UTC.dwYear, msg.UTC.dwMonth, msg.UTC.dwDay, msg.UTC.dwHour + 8, msg.UTC.dwMinute, msg.UTC.dwSecond);
                this.timeTextField.setText(msg.UTC.toString());
            }
            if (msg.bStatus == 1) {
                this.openStatusTextField.setText(Res.string().getSucceed());
            } else {
                this.openStatusTextField.setText(Res.string().getFailed());
            }
            this.openMethodTextField.setText(Res.string().getOpenMethods(msg.emOpenMethod));
            try {
                this.cardNameTextField.setText(new String(msg.szCardName, "GBK").trim());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            this.cardNoTextField.setText(new String(msg.szCardNo).trim());
            this.userIdTextField.setText(new String(msg.szUserID).trim());
            this.maskStatusTextField.setText(Res.string().getMaskStatus(msg.emMask));
            if (msg.stuManTemperatureInfo.emTemperatureUnit == 0) {
                this.tempTextField.setText(String.valueOf(msg.stuManTemperatureInfo.fCurrentTemperature + "\u2103"));
            } else if (msg.stuManTemperatureInfo.emTemperatureUnit == 1) {
                this.tempTextField.setText(String.valueOf(msg.stuManTemperatureInfo.fCurrentTemperature + "\u2109"));
            } else if (msg.stuManTemperatureInfo.emTemperatureUnit == 2) {
                this.tempTextField.setText(String.valueOf(msg.stuManTemperatureInfo.fCurrentTemperature + "K"));
            }
        } else {
            super.processEvent(event);
        }
    }

    class AccessEvent
    extends AWTEvent {
        private static final long serialVersionUID = 1L;
        public static final int EVENT_ID = 2000;
        private BufferedImage gateBufferedImage;
        private NetSDKLib.DEV_EVENT_ACCESS_CTL_INFO msg;

        public AccessEvent(Object target, BufferedImage gateBufferedImage, NetSDKLib.DEV_EVENT_ACCESS_CTL_INFO msg) {
            super(target, 2000);
            this.gateBufferedImage = null;
            this.msg = null;
            this.gateBufferedImage = gateBufferedImage;
            this.msg = msg;
        }

        public BufferedImage getGateBufferedImage() {
            return this.gateBufferedImage;
        }

        public NetSDKLib.DEV_EVENT_ACCESS_CTL_INFO getAccessInfo() {
            return this.msg;
        }
    }

    private class AnalyzerDataCB
    implements NetSDKLib.fAnalyzerDataCallBack {
        private BufferedImage gateBufferedImage = null;

        private AnalyzerDataCB() {
        }

        @Override
        public int invoke(NetSDKLib.LLong lAnalyzerHandle, int dwAlarmType, Pointer pAlarmInfo, Pointer pBuffer, int dwBufSize, Pointer dwUser, int nSequence, Pointer reserved) {
            if (lAnalyzerHandle.longValue() == 0L || pAlarmInfo == null) {
                return -1;
            }
            File path = new File("./GateSnapPicture/");
            if (!path.exists()) {
                path.mkdir();
            }
            if (dwAlarmType == 516) {
                NetSDKLib.DEV_EVENT_ACCESS_CTL_INFO msg = new NetSDKLib.DEV_EVENT_ACCESS_CTL_INFO();
                ToolKits.GetPointerData(pAlarmInfo, msg);
                String snapPicPath = path + "\\" + System.currentTimeMillis() + "GateSnapPicture.jpg";
                byte[] buffer = pBuffer.getByteArray(0L, dwBufSize);
                ByteArrayInputStream byteArrInputGlobal = new ByteArrayInputStream(buffer);
                try {
                    this.gateBufferedImage = ImageIO.read(byteArrInputGlobal);
                    if (this.gateBufferedImage != null) {
                        ImageIO.write((RenderedImage)this.gateBufferedImage, "jpg", new File(snapPicPath));
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                if (eventQueue != null) {
                    eventQueue.postEvent(new AccessEvent(GateFrame.this.target, this.gateBufferedImage, msg));
                }
            }
            return 0;
        }
    }

    private class GatePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public GatePanel() {
            BorderEx.set(this, "", 4);
            this.setLayout(new BorderLayout());
            JPanel gateOperatePanel = new JPanel();
            JPanel gateShowPanel = new JPanel();
            this.add((Component)gateOperatePanel, "West");
            this.add((Component)gateShowPanel, "Center");
            gateOperatePanel.setLayout(new BorderLayout());
            gateOperatePanel.setPreferredSize(new Dimension(250, 70));
            JPanel channelPanel = new JPanel();
            JPanel operatePanel = new JPanel();
            gateOperatePanel.add((Component)channelPanel, "North");
            gateOperatePanel.add((Component)operatePanel, "Center");
            channelPanel.setBorder(BorderFactory.createTitledBorder(""));
            channelPanel.setPreferredSize(new Dimension(220, 70));
            channelPanel.setLayout(new FlowLayout());
            JLabel channelLabel = new JLabel(Res.string().getChannel());
            GateFrame.this.chnComboBox = new JComboBox();
            GateFrame.this.chnComboBox.setPreferredSize(new Dimension(100, 20));
            channelPanel.add(channelLabel);
            channelPanel.add(GateFrame.this.chnComboBox);
            operatePanel.setBorder(BorderFactory.createTitledBorder(Res.string().getOperate()));
            operatePanel.setLayout(new FlowLayout());
            GateFrame.this.attachBtn = new JButton(Res.string().getAttach());
            GateFrame.this.detachBtn = new JButton(Res.string().getDetach());
            GateFrame.this.cardOperateBtn = new JButton(Res.string().getCardOperate());
            JLabel nullJLabel = new JLabel("");
            nullJLabel.setPreferredSize(new Dimension(205, 40));
            GateFrame.this.attachBtn.setPreferredSize(new Dimension(100, 20));
            GateFrame.this.detachBtn.setPreferredSize(new Dimension(100, 20));
            GateFrame.this.cardOperateBtn.setPreferredSize(new Dimension(205, 20));
            operatePanel.add(GateFrame.this.attachBtn);
            operatePanel.add(GateFrame.this.detachBtn);
            operatePanel.add(nullJLabel);
            operatePanel.add(GateFrame.this.cardOperateBtn);
            GateFrame.this.setEnable(false);
            GateFrame.this.detachBtn.setEnabled(false);
            gateShowPanel.setBorder(BorderFactory.createTitledBorder(""));
            gateShowPanel.setLayout(new BorderLayout());
            GateFrame.this.personPaintPanel = new PaintPanel();
            JPanel cardInfoPanel = new JPanel();
            GateFrame.this.personPaintPanel.setPreferredSize(new Dimension(250, 70));
            gateShowPanel.add((Component)GateFrame.this.personPaintPanel, "West");
            gateShowPanel.add((Component)cardInfoPanel, "Center");
            cardInfoPanel.setLayout(new FlowLayout());
            JLabel timeLable = new JLabel(Res.string().getTime() + ":", 0);
            JLabel openStatusLable = new JLabel(Res.string().getOpenStatus() + ":", 0);
            JLabel openMethodLable = new JLabel(Res.string().getOpenMethod() + ":", 0);
            JLabel cardNameLable = new JLabel(Res.string().getCardName() + ":", 0);
            JLabel cardNoLable = new JLabel(Res.string().getCardNo() + ":", 0);
            JLabel userIdLable = new JLabel(Res.string().getUserId() + ":", 0);
            JLabel tempLable = new JLabel(Res.string().getTemp() + ":", 0);
            JLabel maskstutasLable = new JLabel(Res.string().getMaskstutas() + ":", 0);
            timeLable.setPreferredSize(new Dimension(80, 20));
            openStatusLable.setPreferredSize(new Dimension(80, 20));
            openMethodLable.setPreferredSize(new Dimension(80, 20));
            cardNameLable.setPreferredSize(new Dimension(80, 20));
            cardNoLable.setPreferredSize(new Dimension(80, 20));
            userIdLable.setPreferredSize(new Dimension(80, 20));
            tempLable.setPreferredSize(new Dimension(80, 20));
            maskstutasLable.setPreferredSize(new Dimension(80, 20));
            GateFrame.this.timeTextField = new JTextField("");
            GateFrame.this.openStatusTextField = new JTextField("");
            GateFrame.this.openMethodTextField = new JTextField("");
            GateFrame.this.cardNameTextField = new JTextField("");
            GateFrame.this.cardNoTextField = new JTextField("");
            GateFrame.this.userIdTextField = new JTextField("");
            GateFrame.this.tempTextField = new JTextField("");
            GateFrame.this.maskStatusTextField = new JTextField("");
            Dimension dimension = new Dimension();
            dimension.width = 150;
            dimension.height = 20;
            GateFrame.this.timeTextField.setPreferredSize(dimension);
            GateFrame.this.openStatusTextField.setPreferredSize(dimension);
            GateFrame.this.openMethodTextField.setPreferredSize(dimension);
            GateFrame.this.cardNameTextField.setPreferredSize(dimension);
            GateFrame.this.cardNoTextField.setPreferredSize(dimension);
            GateFrame.this.userIdTextField.setPreferredSize(dimension);
            GateFrame.this.tempTextField.setPreferredSize(dimension);
            GateFrame.this.maskStatusTextField.setPreferredSize(dimension);
            GateFrame.this.timeTextField.setHorizontalAlignment(0);
            GateFrame.this.openStatusTextField.setHorizontalAlignment(0);
            GateFrame.this.openMethodTextField.setHorizontalAlignment(0);
            GateFrame.this.cardNameTextField.setHorizontalAlignment(0);
            GateFrame.this.cardNoTextField.setHorizontalAlignment(0);
            GateFrame.this.userIdTextField.setHorizontalAlignment(0);
            GateFrame.this.tempTextField.setHorizontalAlignment(0);
            GateFrame.this.maskStatusTextField.setHorizontalAlignment(0);
            GateFrame.this.timeTextField.setEditable(false);
            GateFrame.this.openStatusTextField.setEditable(false);
            GateFrame.this.openMethodTextField.setEditable(false);
            GateFrame.this.cardNameTextField.setEditable(false);
            GateFrame.this.cardNoTextField.setEditable(false);
            GateFrame.this.userIdTextField.setEditable(false);
            GateFrame.this.tempTextField.setEditable(false);
            GateFrame.this.maskStatusTextField.setEditable(false);
            cardInfoPanel.add(timeLable);
            cardInfoPanel.add(GateFrame.this.timeTextField);
            cardInfoPanel.add(openStatusLable);
            cardInfoPanel.add(GateFrame.this.openStatusTextField);
            cardInfoPanel.add(openMethodLable);
            cardInfoPanel.add(GateFrame.this.openMethodTextField);
            cardInfoPanel.add(cardNameLable);
            cardInfoPanel.add(GateFrame.this.cardNameTextField);
            cardInfoPanel.add(cardNoLable);
            cardInfoPanel.add(GateFrame.this.cardNoTextField);
            cardInfoPanel.add(userIdLable);
            cardInfoPanel.add(GateFrame.this.userIdTextField);
            cardInfoPanel.add(tempLable);
            cardInfoPanel.add(GateFrame.this.tempTextField);
            cardInfoPanel.add(maskstutasLable);
            cardInfoPanel.add(GateFrame.this.maskStatusTextField);
            GateFrame.this.setOnClickListener();
        }
    }

    private static class HaveReConnect
    implements NetSDKLib.fHaveReConnect {
        private HaveReConnect() {
        }

        @Override
        public void invoke(NetSDKLib.LLong m_hLoginHandle, String pchDVRIP, int nDVRPort, Pointer dwUser) {
            System.out.printf("ReConnect Device[%s] Port[%d]\n", pchDVRIP, nDVRPort);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.setTitle(Res.string().getGate() + " : " + Res.string().getOnline());
                }
            });
        }
    }

    private static class DisConnect
    implements NetSDKLib.fDisConnect {
        private DisConnect() {
        }

        @Override
        public void invoke(NetSDKLib.LLong m_hLoginHandle, String pchDVRIP, int nDVRPort, Pointer dwUser) {
            System.out.printf("Device[%s] Port[%d] DisConnect!\n", pchDVRIP, nDVRPort);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.setTitle(Res.string().getGate() + " : " + Res.string().getDisConnectReconnecting());
                }
            });
        }
    }
}

