/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame;

import com.netsdk.common.BorderEx;
import com.netsdk.common.EventTaskCommonQueue;
import com.netsdk.common.EventTaskHandler;
import com.netsdk.common.FunctionList;
import com.netsdk.common.LoginPanel;
import com.netsdk.common.Res;
import com.netsdk.demo.module.FaceRecognitionModule;
import com.netsdk.demo.module.LoginModule;
import com.netsdk.demo.module.RealPlayModule;
import com.netsdk.demo.module.VideoStateSummaryModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.Pointer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

class HumanNumberStatisticFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static DisConnectCallBack disConnectCB = new DisConnectCallBack();
    private static HaveReConnectCallBack haveReConnectCB = new HaveReConnectCallBack();
    private Vector<String> chnList = new Vector();
    public static NetSDKLib.LLong m_hPlayHandle = new NetSDKLib.LLong(0L);
    private static boolean b_RealPlay = false;
    private static boolean b_Attachment = false;
    public static fHumanNumberStatisticCallBack humanNumberStatisticCB = fHumanNumberStatisticCallBack.getInstance();
    private static JFrame mainFrame = new JFrame();
    private LoginPanel loginPanel;
    private HumanStatisticPanel humanStatisticPanel;
    private HumanStatisticControlPanel humanStatisticAttachPanel;
    private Panel controlPanel;
    private JLabel chnLabel;
    private static JComboBox chnComboBox;
    private JLabel streamLabel;
    private static JComboBox streamComboBox;
    private static JButton realPlayBtn;
    private static JButton attachBtn;
    private static JButton clearBtn;
    private RealPanel realPanel;
    private JPanel realPlayPanel;
    private static Panel realPlayWindow;
    private static JTable groupInfoTable;
    private GroupListPanel groupListPanel;
    private JScrollPane scrollPane;

    public HumanNumberStatisticFrame() {
        this.setTitle(Res.string().getHumanNumberStatistic());
        this.setLayout(new BorderLayout());
        this.pack();
        this.setSize(1080, 560);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        LoginModule.init(disConnectCB, haveReConnectCB);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loginPanel = new LoginPanel();
        this.humanStatisticPanel = new HumanStatisticPanel();
        this.add((Component)this.loginPanel, "North");
        this.add((Component)this.humanStatisticPanel, "Center");
        this.loginPanel.addLoginBtnActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HumanNumberStatisticFrame.this.loginPanel.checkLoginText() && HumanNumberStatisticFrame.this.login()) {
                    mainFrame = ToolKits.getFrame(e);
                    mainFrame.setTitle(Res.string().getHumanNumberStatistic() + " : " + Res.string().getOnline());
                }
            }
        });
        this.loginPanel.addLogoutBtnActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mainFrame.setTitle(Res.string().getHumanNumberStatistic());
                HumanNumberStatisticFrame.this.logout();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RealPlayModule.stopRealPlay(m_hPlayHandle);
                FaceRecognitionModule.renderPrivateData(m_hPlayHandle, 0);
                VideoStateSummaryModule.detachAllVideoStatSummary();
                LoginModule.logout();
                LoginModule.cleanup();
                HumanNumberStatisticFrame.this.dispose();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FunctionList demo = new FunctionList();
                        demo.setVisible(true);
                    }
                });
            }
        });
    }

    public boolean login() {
        if (!LoginModule.login(this.loginPanel.ipTextArea.getText(), Integer.parseInt(this.loginPanel.portTextArea.getText()), this.loginPanel.nameTextArea.getText(), new String(this.loginPanel.passwordTextArea.getPassword()))) {
            JOptionPane.showMessageDialog(null, Res.string().getLoginFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return false;
        }
        this.loginPanel.setButtonEnable(true);
        HumanNumberStatisticFrame.setButtonEnable(true);
        final int chanNum = LoginModule.m_stDeviceInfo.byChanNum;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int listSize = Math.max(chanNum, 32);
                HumanNumberStatisticFrame.this.groupListPanel.remove(HumanNumberStatisticFrame.this.scrollPane);
                HumanNumberStatisticFrame.this.groupListPanel.creatGroupInfoPanel(listSize);
                int i = 0;
                while (i < chanNum) {
                    HumanNumberStatisticFrame.this.chnList.add(Res.string().getChannel() + " " + String.valueOf(i + 1));
                    SummaryInfo summaryInfo = new SummaryInfo();
                    summaryInfo.nChannelID = i++;
                    EventDisplay.dataList.add(summaryInfo);
                }
                chnComboBox.setModel(new DefaultComboBoxModel(HumanNumberStatisticFrame.this.chnList));
                HumanNumberStatisticFrame.setEnableAllInnerComponent(HumanNumberStatisticFrame.this.controlPanel, true);
                EventDisplay.setEventInfo(groupInfoTable, EventDisplay.dataList);
            }
        });
        return true;
    }

    public void logout() {
        VideoStateSummaryModule.detachAllVideoStatSummary();
        HumanNumberStatisticFrame.stopRealPlay();
        LoginModule.logout();
        this.chnList.clear();
        EventDisplay.clearEventInfoList();
        chnComboBox.setModel(new DefaultComboBoxModel());
        this.loginPanel.setButtonEnable(false);
        HumanNumberStatisticFrame.setAttachBtnTextDisable();
        HumanNumberStatisticFrame.setEnableAllInnerComponent(this.controlPanel, false);
    }

    private static void setRealPlayBtnTextEnable() {
        b_RealPlay = true;
        realPlayBtn.setText(Res.string().getStopRealPlay());
    }

    private static void setRealPlayBtnTextDisable() {
        b_RealPlay = false;
        realPlayBtn.setText(Res.string().getStartRealPlay());
    }

    private static void setAttachBtnTextEnable() {
        b_Attachment = VideoStateSummaryModule.getM_hAttachMap().size() > 0;
        attachBtn.setText(Res.string().getDetach());
    }

    private static void setAttachBtnTextDisable() {
        b_Attachment = VideoStateSummaryModule.getM_hAttachMap().size() > 0;
        attachBtn.setText(Res.string().getAttach());
    }

    private static void setButtonEnable(boolean bln) {
        realPlayWindow.setEnabled(bln);
        chnComboBox.setEnabled(bln);
        streamComboBox.setEnabled(bln);
        realPlayBtn.setEnabled(bln);
        attachBtn.setEnabled(bln);
        clearBtn.setEnabled(bln);
    }

    public static void setEnableAllInnerComponent(Component container, boolean enable) {
        for (Component component : HumanNumberStatisticFrame.getComponents(container)) {
            component.setEnabled(enable);
        }
    }

    public static Component[] getComponents(Component container) {
        ArrayList<Object> list = null;
        try {
            list = new ArrayList<Component>(Arrays.asList(((Container)container).getComponents()));
            for (int index = 0; index < list.size(); ++index) {
                list.addAll(Arrays.asList(HumanNumberStatisticFrame.getComponents((Component)list.get(index))));
            }
        }
        catch (ClassCastException e) {
            list = new ArrayList();
        }
        return list.toArray(new Component[0]);
    }

    private void clearSummaryInfo() {
        VideoStateSummaryModule.clearVideoStateSummary(chnComboBox.getSelectedIndex());
    }

    public static void realPlay() {
        if (!b_RealPlay) {
            m_hPlayHandle = RealPlayModule.startRealPlay(chnComboBox.getSelectedIndex(), streamComboBox.getSelectedIndex() == 0 ? 0 : 3, realPlayWindow);
            if (m_hPlayHandle.longValue() != 0L) {
                FaceRecognitionModule.renderPrivateData(m_hPlayHandle, 1);
                realPlayWindow.repaint();
                chnComboBox.setEnabled(false);
                streamComboBox.setEnabled(false);
                HumanNumberStatisticFrame.setRealPlayBtnTextEnable();
            }
        } else {
            HumanNumberStatisticFrame.stopRealPlay();
        }
    }

    public static void stopRealPlay() {
        RealPlayModule.stopRealPlay(m_hPlayHandle);
        FaceRecognitionModule.renderPrivateData(m_hPlayHandle, 0);
        realPlayWindow.repaint();
        chnComboBox.setEnabled(true);
        streamComboBox.setEnabled(true);
        HumanNumberStatisticFrame.setRealPlayBtnTextDisable();
    }

    private static class EventDisplay
    implements EventTaskHandler {
        private static List<SummaryInfo> dataList = new LinkedList<SummaryInfo>();
        private static final Object lockObj = new Object();
        private final SummaryInfo summaryInfo;

        private int getMaxSize() {
            int channelNum = LoginModule.m_stDeviceInfo.byChanNum;
            return Math.max(channelNum, 32);
        }

        public EventDisplay(SummaryInfo Info) {
            this.summaryInfo = Info;
        }

        @Override
        public void eventTaskProcess() {
            this.InsertOrUpdateEventInfo(this.summaryInfo);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void InsertOrUpdateEventInfo(SummaryInfo summaryInfo) {
            Object object = lockObj;
            synchronized (object) {
                dataList.add(summaryInfo.nChannelID, summaryInfo);
                dataList.remove(summaryInfo.nChannelID + 1);
                if (dataList.size() > this.getMaxSize()) {
                    dataList.remove(this.getMaxSize());
                }
                EventDisplay.setEventInfo(groupInfoTable, dataList);
            }
        }

        private static void setEventInfo(JTable groupInfoTable, List<SummaryInfo> dataList) {
            EventDisplay.clearTableModel(groupInfoTable);
            for (int i = 0; i < dataList.size(); ++i) {
                groupInfoTable.setValueAt(dataList.get((int)i).nChannelID + 1, i, 0);
                groupInfoTable.setValueAt(dataList.get((int)i).eventTime, i, 1);
                groupInfoTable.setValueAt(dataList.get((int)i).enteredHour, i, 2);
                groupInfoTable.setValueAt(dataList.get((int)i).enteredToday, i, 3);
                groupInfoTable.setValueAt(dataList.get((int)i).enteredTotal, i, 4);
                groupInfoTable.setValueAt(dataList.get((int)i).exitedHour, i, 5);
                groupInfoTable.setValueAt(dataList.get((int)i).exitedToday, i, 6);
                groupInfoTable.setValueAt(dataList.get((int)i).exitedTotal, i, 7);
            }
        }

        public static void clearTableModel(JTable jTableModel) {
            int rowCount = jTableModel.getRowCount();
            int columnCount = jTableModel.getColumnCount();
            for (int i = 0; i < rowCount; ++i) {
                for (int j = 0; j < columnCount; ++j) {
                    jTableModel.setValueAt(" ", i, j);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void clearEventInfoList() {
            Object object = lockObj;
            synchronized (object) {
                dataList.clear();
                EventDisplay.setEventInfo(groupInfoTable, dataList);
            }
        }
    }

    private static class SummaryInfo {
        public int nChannelID;
        public String eventTime;
        public int enteredToday;
        public int enteredHour;
        public int enteredTotal;
        public int exitedToday;
        public int exitedHour;
        public int exitedTotal;

        public SummaryInfo() {
        }

        public SummaryInfo(int nChannelID, String eventTime, int enteredToday, int enteredHour, int enteredTotal, int exitedToday, int exitedHour, int exitedTotal) {
            this.nChannelID = nChannelID;
            this.eventTime = eventTime;
            this.enteredToday = enteredToday;
            this.enteredHour = enteredHour;
            this.enteredTotal = enteredTotal;
            this.exitedToday = exitedToday;
            this.exitedHour = exitedHour;
            this.exitedTotal = exitedTotal;
        }
    }

    public static class fHumanNumberStatisticCallBack
    implements NetSDKLib.fVideoStatSumCallBack {
        private static fHumanNumberStatisticCallBack instance = new fHumanNumberStatisticCallBack();
        private EventTaskCommonQueue eventTaskQueue = new EventTaskCommonQueue();

        public static fHumanNumberStatisticCallBack getInstance() {
            return instance;
        }

        public fHumanNumberStatisticCallBack() {
            this.eventTaskQueue.init();
        }

        @Override
        public void invoke(NetSDKLib.LLong lAttachHandle, NetSDKLib.NET_VIDEOSTAT_SUMMARY stVideoState, int dwBufLen, Pointer dwUser) {
            SummaryInfo summaryInfo = new SummaryInfo(stVideoState.nChannelID, stVideoState.stuTime.toStringTime(), stVideoState.stuEnteredSubtotal.nToday, stVideoState.stuEnteredSubtotal.nHour, stVideoState.stuEnteredSubtotal.nTotal, stVideoState.stuExitedSubtotal.nToday, stVideoState.stuExitedSubtotal.nHour, stVideoState.stuExitedSubtotal.nTotal);
            System.out.printf("Channel[%d] GetTime[%s]\nPeople In  Information[Total[%d] Hour[%d] Today[%d]]\nPeople Out Information[Total[%d] Hour[%d] Today[%d]]\n", summaryInfo.nChannelID, summaryInfo.eventTime, summaryInfo.enteredTotal, summaryInfo.enteredHour, summaryInfo.enteredToday, summaryInfo.exitedTotal, summaryInfo.exitedHour, summaryInfo.exitedToday);
            this.eventTaskQueue.addEvent(new EventDisplay(summaryInfo));
        }
    }

    public class GroupListPanel
    extends JPanel {
        private Object[][] statisticData = null;
        private final String[] groupName = new String[]{Res.string().getHumanNumberStatisticEventChannel(), Res.string().getHumanNumberStatisticEventTime(), Res.string().getHumanNumberStatisticEventHourIn(), Res.string().getHumanNumberStatisticEventTodayIn(), Res.string().getHumanNumberStatisticEventTotalIn(), Res.string().getHumanNumberStatisticEventHourOut(), Res.string().getHumanNumberStatisticEventTodayOut(), Res.string().getHumanNumberStatisticEventTotalOut()};
        private DefaultTableModel groupInfoModel;

        public GroupListPanel() {
            BorderEx.set(this, Res.string().getHumanNumberStatisticEventTitle(), 2);
            this.setLayout(new BorderLayout());
            this.statisticData = new Object[32][9];
            this.creatGroupInfoPanel(32);
        }

        private void creatGroupInfoPanel(int listSize) {
            this.statisticData = new Object[listSize][9];
            this.groupInfoModel = new DefaultTableModel(this.statisticData, this.groupName);
            groupInfoTable = new JTable(this.groupInfoModel){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            groupInfoTable.getColumnModel().getColumn(0).setPreferredWidth(10);
            groupInfoTable.getColumnModel().getColumn(1).setPreferredWidth(80);
            groupInfoTable.getColumnModel().getColumn(2).setPreferredWidth(10);
            groupInfoTable.getColumnModel().getColumn(3).setPreferredWidth(10);
            groupInfoTable.getColumnModel().getColumn(4).setPreferredWidth(10);
            groupInfoTable.getColumnModel().getColumn(5).setPreferredWidth(10);
            groupInfoTable.getColumnModel().getColumn(6).setPreferredWidth(10);
            groupInfoTable.getColumnModel().getColumn(7).setPreferredWidth(10);
            groupInfoTable.setSelectionMode(0);
            DefaultTableCellRenderer dCellRenderer = new DefaultTableCellRenderer();
            dCellRenderer.setHorizontalAlignment(0);
            groupInfoTable.setDefaultRenderer(Object.class, dCellRenderer);
            HumanNumberStatisticFrame.this.scrollPane = new JScrollPane(groupInfoTable);
            this.add((Component)HumanNumberStatisticFrame.this.scrollPane, "Center");
        }
    }

    private class RealPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public RealPanel() {
            BorderEx.set(this, Res.string().getRealplay(), 2);
            Dimension dim = this.getPreferredSize();
            dim.width = 420;
            this.setPreferredSize(dim);
            this.setLayout(new BorderLayout());
            HumanNumberStatisticFrame.this.realPlayPanel = new JPanel();
            this.add((Component)HumanNumberStatisticFrame.this.realPlayPanel, "Center");
            HumanNumberStatisticFrame.this.realPlayPanel.setLayout(new BorderLayout());
            HumanNumberStatisticFrame.this.realPlayPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            realPlayWindow = new Panel();
            realPlayWindow.setBackground(Color.GRAY);
            realPlayWindow.setSize(480, 480);
            HumanNumberStatisticFrame.this.realPlayPanel.add((Component)realPlayWindow, "Center");
        }
    }

    private class HumanStatisticControlPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public HumanStatisticControlPanel() {
            BorderEx.set(this, Res.string().getHumanNumberStatisticAttach(), 2);
            this.setLayout(new FlowLayout());
            HumanNumberStatisticFrame.this.controlPanel = new Panel();
            this.add(HumanNumberStatisticFrame.this.controlPanel);
            HumanNumberStatisticFrame.this.chnLabel = new JLabel(Res.string().getChannel());
            chnComboBox = new JComboBox();
            HumanNumberStatisticFrame.this.streamLabel = new JLabel(Res.string().getStreamType());
            String[] stream = new String[]{Res.string().getMasterStream(), Res.string().getSubStream()};
            streamComboBox = new JComboBox<String>(stream);
            realPlayBtn = new JButton(Res.string().getStartRealPlay());
            attachBtn = new JButton(Res.string().getAttach());
            clearBtn = new JButton(Res.string().getHumanNumberStatisticEventClearOSD());
            HumanNumberStatisticFrame.this.controlPanel.setLayout(new FlowLayout());
            HumanNumberStatisticFrame.this.controlPanel.add(HumanNumberStatisticFrame.this.chnLabel);
            HumanNumberStatisticFrame.this.controlPanel.add(chnComboBox);
            HumanNumberStatisticFrame.this.controlPanel.add(HumanNumberStatisticFrame.this.streamLabel);
            HumanNumberStatisticFrame.this.controlPanel.add(streamComboBox);
            HumanNumberStatisticFrame.this.controlPanel.add(realPlayBtn);
            HumanNumberStatisticFrame.this.controlPanel.add(attachBtn);
            HumanNumberStatisticFrame.this.controlPanel.add(clearBtn);
            chnComboBox.setPreferredSize(new Dimension(90, 20));
            streamComboBox.setPreferredSize(new Dimension(120, 20));
            realPlayBtn.setPreferredSize(new Dimension(120, 20));
            attachBtn.setPreferredSize(new Dimension(120, 20));
            clearBtn.setPreferredSize(new Dimension(120, 20));
            chnComboBox.setEnabled(false);
            streamComboBox.setEnabled(false);
            realPlayBtn.setEnabled(false);
            attachBtn.setEnabled(false);
            clearBtn.setEnabled(false);
            realPlayBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HumanNumberStatisticFrame.realPlay();
                }
            });
            attachBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int channel = chnComboBox.getSelectedIndex();
                    if (!VideoStateSummaryModule.channelAttached(channel)) {
                        if (VideoStateSummaryModule.attachVideoStatSummary(channel, humanNumberStatisticCB)) {
                            HumanNumberStatisticFrame.setAttachBtnTextEnable();
                        } else {
                            JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                        }
                    } else if (VideoStateSummaryModule.detachVideoStatSummary(channel)) {
                        HumanNumberStatisticFrame.setAttachBtnTextDisable();
                        SummaryInfo info = new SummaryInfo();
                        info.nChannelID = channel;
                        EventDisplay.dataList.add(channel, info);
                        EventDisplay.dataList.remove(channel + 1);
                        EventDisplay.setEventInfo(groupInfoTable, EventDisplay.dataList);
                    } else {
                        JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                    }
                }
            });
            chnComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        int channel = chnComboBox.getSelectedIndex();
                        if (VideoStateSummaryModule.channelAttached(channel)) {
                            HumanNumberStatisticFrame.setAttachBtnTextEnable();
                        } else {
                            HumanNumberStatisticFrame.setAttachBtnTextDisable();
                        }
                    }
                }
            });
            clearBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HumanNumberStatisticFrame.this.clearSummaryInfo();
                }
            });
        }
    }

    private class HumanStatisticPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public HumanStatisticPanel() {
            this.setLayout(new BorderLayout());
            Dimension dim = this.getPreferredSize();
            dim.width = 320;
            this.setPreferredSize(dim);
            HumanNumberStatisticFrame.this.humanStatisticAttachPanel = new HumanStatisticControlPanel();
            HumanNumberStatisticFrame.this.realPanel = new RealPanel();
            HumanNumberStatisticFrame.this.groupListPanel = new GroupListPanel();
            this.add((Component)HumanNumberStatisticFrame.this.humanStatisticAttachPanel, "North");
            this.add((Component)HumanNumberStatisticFrame.this.realPanel, "East");
            this.add((Component)HumanNumberStatisticFrame.this.groupListPanel, "Center");
        }
    }

    private static class HaveReConnectCallBack
    implements NetSDKLib.fHaveReConnect {
        private HaveReConnectCallBack() {
        }

        @Override
        public void invoke(NetSDKLib.LLong m_hLoginHandle, String pchDVRIP, int nDVRPort, Pointer dwUser) {
            System.out.printf("ReConnect Device[%s] Port[%d]\n", pchDVRIP, nDVRPort);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    mainFrame.setTitle(Res.string().getHumanNumberStatistic() + " : " + Res.string().getOnline());
                }
            });
            ExecutorService service = Executors.newSingleThreadExecutor();
            service.execute(new Runnable(){

                @Override
                public void run() {
                    if (b_RealPlay) {
                        HumanNumberStatisticFrame.stopRealPlay();
                        HumanNumberStatisticFrame.realPlay();
                    }
                    if (b_Attachment) {
                        VideoStateSummaryModule.reAttachAllVideoStatSummary(humanNumberStatisticCB);
                        HumanNumberStatisticFrame.setAttachBtnTextEnable();
                    }
                }
            });
            service.shutdown();
        }
    }

    private static class DisConnectCallBack
    implements NetSDKLib.fDisConnect {
        private DisConnectCallBack() {
        }

        @Override
        public void invoke(NetSDKLib.LLong m_hLoginHandle, String pchDVRIP, int nDVRPort, Pointer dwUser) {
            System.out.printf("Device[%s] Port[%d] DisConnectCallBack!\n", pchDVRIP, nDVRPort);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    mainFrame.setTitle(Res.string().getHumanNumberStatistic() + " : " + Res.string().getDisConnectReconnecting());
                }
            });
        }
    }
}

