/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame;

import com.netsdk.common.BorderEx;
import com.netsdk.common.FunctionList;
import com.netsdk.common.LoginPanel;
import com.netsdk.common.PaintPanel;
import com.netsdk.common.Res;
import com.netsdk.common.SavePath;
import com.netsdk.demo.module.CapturePictureModule;
import com.netsdk.demo.module.LoginModule;
import com.netsdk.demo.module.PtzControlModule;
import com.netsdk.demo.module.RealPlayModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

class PTZControlFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Vector<String> chnlist = new Vector();
    private boolean b_realplay = false;
    private static DisConnect disConnect = new DisConnect();
    private static HaveReConnect haveReConnect = new HaveReConnect();
    public static NetSDKLib.LLong m_hPlayHandle = new NetSDKLib.LLong(0L);
    private static JFrame frame = new JFrame();
    public fSnapReceiveCB m_SnapReceiveCB = new fSnapReceiveCB();
    private LoginPanel loginPanel;
    private RealPanel realPanel;
    private JPanel realplayPanel;
    private Panel realPlayWindow;
    private Panel channelPanel;
    private JLabel chnlabel;
    private JComboBox chnComboBox;
    private JLabel streamLabel;
    private JComboBox streamComboBox;
    private JButton realplayBtn;
    private JButton snapBtn;
    private PTZ_PICPanel ptz_picPanel;
    private PICPanel picPanel;
    private JPanel pictureShowPanel;
    private JPanel snapPanel;
    private PaintPanel pictureShowWindow;
    private PTZPanel ptzPanel;
    private JPanel directionPanel;
    private JPanel ptzCtrlPanel;
    private JButton leftUpBtn;
    private JButton upBtn;
    private JButton rightUpBtn;
    private JButton leftBtn;
    private JButton rightBtn;
    private JButton leftDownBtn;
    private JButton downBtn;
    private JButton rightDownBtn;
    private JComboBox speedComboBox;
    private JLabel operateJLabel;
    private JButton zoomAddBtn;
    private JButton zoomDecBtn;
    private JButton focusAddBtn;
    private JButton focusDecBtn;
    private JButton irisAddBtn;
    private JButton irisDecBtn;

    public PTZControlFrame() {
        this.setTitle(Res.string().getPTZ());
        this.setLayout(new BorderLayout());
        this.pack();
        this.setSize(800, 560);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        LoginModule.init(disConnect, haveReConnect);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loginPanel = new LoginPanel();
        this.realPanel = new RealPanel();
        this.ptz_picPanel = new PTZ_PICPanel();
        this.add((Component)this.loginPanel, "North");
        this.add((Component)this.realPanel, "Center");
        this.add((Component)this.ptz_picPanel, "East");
        this.loginPanel.addLoginBtnActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PTZControlFrame.this.loginPanel.checkLoginText() && PTZControlFrame.this.login()) {
                    frame = ToolKits.getFrame(e);
                    frame.setTitle(Res.string().getPTZ() + " : " + Res.string().getOnline());
                }
            }
        });
        this.loginPanel.addLogoutBtnActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setTitle(Res.string().getPTZ());
                PTZControlFrame.this.logout();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RealPlayModule.stopRealPlay(m_hPlayHandle);
                LoginModule.logout();
                LoginModule.cleanup();
                PTZControlFrame.this.dispose();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FunctionList demo = new FunctionList();
                        demo.setVisible(true);
                    }
                });
            }
        });
    }

    public boolean login() {
        Native.setCallbackThreadInitializer(this.m_SnapReceiveCB, new CallbackThreadInitializer(false, false, "snapPicture callback thread"));
        if (LoginModule.login(this.loginPanel.ipTextArea.getText(), Integer.parseInt(this.loginPanel.portTextArea.getText()), this.loginPanel.nameTextArea.getText(), new String(this.loginPanel.passwordTextArea.getPassword()))) {
            this.loginPanel.setButtonEnable(true);
            this.setButtonEnable(true);
            for (int i = 1; i < LoginModule.m_stDeviceInfo.byChanNum + 1; ++i) {
                this.chnlist.add(Res.string().getChannel() + " " + String.valueOf(i));
            }
        } else {
            JOptionPane.showMessageDialog(null, Res.string().getLoginFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return false;
        }
        this.chnComboBox.setModel(new DefaultComboBoxModel<String>(this.chnlist));
        CapturePictureModule.setSnapRevCallBack(this.m_SnapReceiveCB);
        return true;
    }

    public void logout() {
        RealPlayModule.stopRealPlay(m_hPlayHandle);
        LoginModule.logout();
        this.loginPanel.setButtonEnable(false);
        this.setButtonEnable(false);
        this.realPlayWindow.repaint();
        this.pictureShowWindow.setOpaque(true);
        this.pictureShowWindow.repaint();
        this.b_realplay = false;
        this.realplayBtn.setText(Res.string().getStartRealPlay());
        for (int i = 0; i < LoginModule.m_stDeviceInfo.byChanNum; ++i) {
            this.chnlist.clear();
        }
        this.chnComboBox.setModel(new DefaultComboBoxModel());
    }

    public void realplay() {
        if (!this.b_realplay) {
            m_hPlayHandle = RealPlayModule.startRealPlay(this.chnComboBox.getSelectedIndex(), this.streamComboBox.getSelectedIndex() == 0 ? 0 : 3, this.realPlayWindow);
            if (m_hPlayHandle.longValue() != 0L) {
                this.realPlayWindow.repaint();
                this.b_realplay = true;
                this.chnComboBox.setEnabled(false);
                this.streamComboBox.setEnabled(false);
                this.realplayBtn.setText(Res.string().getStopRealPlay());
            }
        } else {
            RealPlayModule.stopRealPlay(m_hPlayHandle);
            this.realPlayWindow.repaint();
            this.b_realplay = false;
            this.chnComboBox.setEnabled(true);
            this.streamComboBox.setEnabled(true);
            this.realplayBtn.setText(Res.string().getStartRealPlay());
        }
    }

    private void setButtonEnable(boolean bln) {
        this.snapBtn.setEnabled(bln);
        this.leftUpBtn.setEnabled(bln);
        this.upBtn.setEnabled(bln);
        this.rightUpBtn.setEnabled(bln);
        this.leftBtn.setEnabled(bln);
        this.rightBtn.setEnabled(bln);
        this.leftDownBtn.setEnabled(bln);
        this.downBtn.setEnabled(bln);
        this.rightDownBtn.setEnabled(bln);
        this.zoomAddBtn.setEnabled(bln);
        this.zoomDecBtn.setEnabled(bln);
        this.focusAddBtn.setEnabled(bln);
        this.focusDecBtn.setEnabled(bln);
        this.irisAddBtn.setEnabled(bln);
        this.irisDecBtn.setEnabled(bln);
        this.speedComboBox.setEnabled(bln);
        this.realPlayWindow.setEnabled(bln);
        this.chnComboBox.setEnabled(bln);
        this.streamComboBox.setEnabled(bln);
        this.realplayBtn.setEnabled(bln);
    }

    public class fSnapReceiveCB
    implements NetSDKLib.fSnapRev {
        BufferedImage bufferedImage = null;

        @Override
        public void invoke(NetSDKLib.LLong lLoginID, Pointer pBuf, int RevLen, int EncodeType, int CmdSerial, Pointer dwUser) {
            if (pBuf != null && RevLen > 0) {
                String strFileName = SavePath.getSavePath().getSaveCapturePath();
                System.out.println("strFileName = " + strFileName);
                byte[] buf = pBuf.getByteArray(0L, RevLen);
                ByteArrayInputStream byteArrInput = new ByteArrayInputStream(buf);
                try {
                    this.bufferedImage = ImageIO.read(byteArrInput);
                    if (this.bufferedImage == null) {
                        return;
                    }
                    ImageIO.write((RenderedImage)this.bufferedImage, "jpg", new File(strFileName));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PTZControlFrame.this.pictureShowWindow.setOpaque(false);
                        PTZControlFrame.this.pictureShowWindow.setImage(fSnapReceiveCB.this.bufferedImage);
                        PTZControlFrame.this.pictureShowWindow.repaint();
                    }
                });
            }
        }
    }

    private class PTZPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public PTZPanel() {
            BorderEx.set(this, Res.string().getPTZControl(), 2);
            this.setPreferredSize(new Dimension(40, 205));
            this.setLayout(new GridLayout(2, 1));
            PTZControlFrame.this.directionPanel = new JPanel();
            JPanel panel1 = new JPanel();
            JPanel panel2 = new JPanel();
            PTZControlFrame.this.ptzCtrlPanel = new JPanel();
            this.add(PTZControlFrame.this.directionPanel);
            this.add(PTZControlFrame.this.ptzCtrlPanel);
            PTZControlFrame.this.directionPanel.setLayout(new BorderLayout());
            PTZControlFrame.this.directionPanel.add((Component)panel1, "North");
            PTZControlFrame.this.directionPanel.add((Component)panel2, "Center");
            panel1.setLayout(new BorderLayout());
            panel1.setBorder(new EmptyBorder(0, 5, 0, 5));
            panel2.setLayout(new GridLayout(3, 3));
            panel2.setBorder(new EmptyBorder(0, 5, 0, 5));
            PTZControlFrame.this.leftUpBtn = new JButton(Res.string().getLeftUp());
            PTZControlFrame.this.upBtn = new JButton(Res.string().getUp());
            PTZControlFrame.this.rightUpBtn = new JButton(Res.string().getRightUp());
            PTZControlFrame.this.leftBtn = new JButton(Res.string().getLeft());
            PTZControlFrame.this.rightBtn = new JButton(Res.string().getRight());
            PTZControlFrame.this.leftDownBtn = new JButton(Res.string().getLeftDown());
            PTZControlFrame.this.downBtn = new JButton(Res.string().getDown());
            PTZControlFrame.this.rightDownBtn = new JButton(Res.string().getRightDown());
            PTZControlFrame.this.operateJLabel = new JLabel("", 0);
            String[] speed = new String[]{Res.string().getSpeed() + " 1", Res.string().getSpeed() + " 2", Res.string().getSpeed() + " 3", Res.string().getSpeed() + " 4", Res.string().getSpeed() + " 5", Res.string().getSpeed() + " 6", Res.string().getSpeed() + " 7", Res.string().getSpeed() + " 8"};
            PTZControlFrame.this.speedComboBox = new JComboBox<String>(speed);
            PTZControlFrame.this.speedComboBox.setSelectedIndex(4);
            PTZControlFrame.this.speedComboBox.setPreferredSize(new Dimension(40, 21));
            panel1.add((Component)PTZControlFrame.this.speedComboBox, "Center");
            panel2.add(PTZControlFrame.this.leftUpBtn);
            panel2.add(PTZControlFrame.this.upBtn);
            panel2.add(PTZControlFrame.this.rightUpBtn);
            panel2.add(PTZControlFrame.this.leftBtn);
            panel2.add(PTZControlFrame.this.operateJLabel);
            panel2.add(PTZControlFrame.this.rightBtn);
            panel2.add(PTZControlFrame.this.leftDownBtn);
            panel2.add(PTZControlFrame.this.downBtn);
            panel2.add(PTZControlFrame.this.rightDownBtn);
            PTZControlFrame.this.leftUpBtn.setEnabled(false);
            PTZControlFrame.this.upBtn.setEnabled(false);
            PTZControlFrame.this.rightUpBtn.setEnabled(false);
            PTZControlFrame.this.leftBtn.setEnabled(false);
            PTZControlFrame.this.rightBtn.setEnabled(false);
            PTZControlFrame.this.leftDownBtn.setEnabled(false);
            PTZControlFrame.this.downBtn.setEnabled(false);
            PTZControlFrame.this.rightDownBtn.setEnabled(false);
            PTZControlFrame.this.speedComboBox.setEnabled(false);
            PTZControlFrame.this.ptzCtrlPanel.setLayout(new GridLayout(3, 2));
            PTZControlFrame.this.ptzCtrlPanel.setBorder(new EmptyBorder(15, 5, 5, 5));
            PTZControlFrame.this.zoomAddBtn = new JButton(Res.string().getZoomAdd());
            PTZControlFrame.this.zoomDecBtn = new JButton(Res.string().getZoomDec());
            PTZControlFrame.this.focusAddBtn = new JButton(Res.string().getFocusAdd());
            PTZControlFrame.this.focusDecBtn = new JButton(Res.string().getFocusDec());
            PTZControlFrame.this.irisAddBtn = new JButton(Res.string().getIrisAdd());
            PTZControlFrame.this.irisDecBtn = new JButton(Res.string().getIrisDec());
            PTZControlFrame.this.ptzCtrlPanel.add(PTZControlFrame.this.zoomAddBtn);
            PTZControlFrame.this.ptzCtrlPanel.add(PTZControlFrame.this.zoomDecBtn);
            PTZControlFrame.this.ptzCtrlPanel.add(PTZControlFrame.this.focusAddBtn);
            PTZControlFrame.this.ptzCtrlPanel.add(PTZControlFrame.this.focusDecBtn);
            PTZControlFrame.this.ptzCtrlPanel.add(PTZControlFrame.this.irisAddBtn);
            PTZControlFrame.this.ptzCtrlPanel.add(PTZControlFrame.this.irisDecBtn);
            PTZControlFrame.this.zoomAddBtn.setEnabled(false);
            PTZControlFrame.this.zoomDecBtn.setEnabled(false);
            PTZControlFrame.this.focusAddBtn.setEnabled(false);
            PTZControlFrame.this.focusDecBtn.setEnabled(false);
            PTZControlFrame.this.irisAddBtn.setEnabled(false);
            PTZControlFrame.this.irisDecBtn.setEnabled(false);
            PTZControlFrame.this.upBtn.addMouseListener(new MouseListener(){

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (PtzControlModule.ptzControlUpStart(PTZControlFrame.this.chnComboBox.getSelectedIndex(), 0, PTZControlFrame.this.speedComboBox.getSelectedIndex())) {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getSucceed());
                    } else {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getFailed());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PtzControlModule.ptzControlUpEnd(PTZControlFrame.this.chnComboBox.getSelectedIndex());
                    PTZControlFrame.this.operateJLabel.setText("");
                }
            });
            PTZControlFrame.this.downBtn.addMouseListener(new MouseListener(){

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (PtzControlModule.ptzControlDownStart(PTZControlFrame.this.chnComboBox.getSelectedIndex(), 0, PTZControlFrame.this.speedComboBox.getSelectedIndex())) {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getSucceed());
                    } else {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getFailed());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PtzControlModule.ptzControlDownEnd(PTZControlFrame.this.chnComboBox.getSelectedIndex());
                    PTZControlFrame.this.operateJLabel.setText("");
                }
            });
            PTZControlFrame.this.leftBtn.addMouseListener(new MouseListener(){

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (PtzControlModule.ptzControlLeftStart(PTZControlFrame.this.chnComboBox.getSelectedIndex(), 0, PTZControlFrame.this.speedComboBox.getSelectedIndex())) {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getSucceed());
                    } else {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getFailed());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PtzControlModule.ptzControlLeftEnd(PTZControlFrame.this.chnComboBox.getSelectedIndex());
                    PTZControlFrame.this.operateJLabel.setText("");
                }
            });
            PTZControlFrame.this.rightBtn.addMouseListener(new MouseListener(){

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (PtzControlModule.ptzControlRightStart(PTZControlFrame.this.chnComboBox.getSelectedIndex(), 0, PTZControlFrame.this.speedComboBox.getSelectedIndex())) {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getSucceed());
                    } else {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getFailed());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PtzControlModule.ptzControlRightEnd(PTZControlFrame.this.chnComboBox.getSelectedIndex());
                    PTZControlFrame.this.operateJLabel.setText("");
                }
            });
            PTZControlFrame.this.leftUpBtn.addMouseListener(new MouseListener(){

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (PtzControlModule.ptzControlLeftUpStart(PTZControlFrame.this.chnComboBox.getSelectedIndex(), PTZControlFrame.this.speedComboBox.getSelectedIndex(), PTZControlFrame.this.speedComboBox.getSelectedIndex())) {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getSucceed());
                    } else {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getFailed());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PtzControlModule.ptzControlLeftUpEnd(PTZControlFrame.this.chnComboBox.getSelectedIndex());
                    PTZControlFrame.this.operateJLabel.setText("");
                }
            });
            PTZControlFrame.this.rightUpBtn.addMouseListener(new MouseListener(){

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (PtzControlModule.ptzControlRightUpStart(PTZControlFrame.this.chnComboBox.getSelectedIndex(), PTZControlFrame.this.speedComboBox.getSelectedIndex(), PTZControlFrame.this.speedComboBox.getSelectedIndex())) {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getSucceed());
                    } else {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getFailed());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PtzControlModule.ptzControlRightUpEnd(PTZControlFrame.this.chnComboBox.getSelectedIndex());
                    PTZControlFrame.this.operateJLabel.setText("");
                }
            });
            PTZControlFrame.this.leftDownBtn.addMouseListener(new MouseListener(){

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (PtzControlModule.ptzControlLeftDownStart(PTZControlFrame.this.chnComboBox.getSelectedIndex(), PTZControlFrame.this.speedComboBox.getSelectedIndex(), PTZControlFrame.this.speedComboBox.getSelectedIndex())) {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getSucceed());
                    } else {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getFailed());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PtzControlModule.ptzControlLeftDownEnd(PTZControlFrame.this.chnComboBox.getSelectedIndex());
                    PTZControlFrame.this.operateJLabel.setText("");
                }
            });
            PTZControlFrame.this.rightDownBtn.addMouseListener(new MouseListener(){

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (PtzControlModule.ptzControlRightDownStart(PTZControlFrame.this.chnComboBox.getSelectedIndex(), PTZControlFrame.this.speedComboBox.getSelectedIndex(), PTZControlFrame.this.speedComboBox.getSelectedIndex())) {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getSucceed());
                    } else {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getFailed());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PtzControlModule.ptzControlRightDownEnd(PTZControlFrame.this.chnComboBox.getSelectedIndex());
                    PTZControlFrame.this.operateJLabel.setText("");
                }
            });
            PTZControlFrame.this.zoomAddBtn.addMouseListener(new MouseListener(){

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (PtzControlModule.ptzControlZoomAddStart(PTZControlFrame.this.chnComboBox.getSelectedIndex(), PTZControlFrame.this.speedComboBox.getSelectedIndex())) {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getSucceed());
                    } else {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getFailed());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PtzControlModule.ptzControlZoomAddEnd(PTZControlFrame.this.chnComboBox.getSelectedIndex());
                    PTZControlFrame.this.operateJLabel.setText("");
                }
            });
            PTZControlFrame.this.zoomDecBtn.addMouseListener(new MouseListener(){

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (PtzControlModule.ptzControlZoomDecStart(PTZControlFrame.this.chnComboBox.getSelectedIndex(), PTZControlFrame.this.speedComboBox.getSelectedIndex())) {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getSucceed());
                    } else {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getFailed());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PtzControlModule.ptzControlZoomDecEnd(PTZControlFrame.this.chnComboBox.getSelectedIndex());
                    PTZControlFrame.this.operateJLabel.setText("");
                }
            });
            PTZControlFrame.this.focusAddBtn.addMouseListener(new MouseListener(){

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (PtzControlModule.ptzControlFocusAddStart(PTZControlFrame.this.chnComboBox.getSelectedIndex(), PTZControlFrame.this.speedComboBox.getSelectedIndex())) {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getSucceed());
                    } else {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getFailed());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PtzControlModule.ptzControlFocusAddEnd(PTZControlFrame.this.chnComboBox.getSelectedIndex());
                    PTZControlFrame.this.operateJLabel.setText("");
                }
            });
            PTZControlFrame.this.focusDecBtn.addMouseListener(new MouseListener(){

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (PtzControlModule.ptzControlFocusDecStart(PTZControlFrame.this.chnComboBox.getSelectedIndex(), PTZControlFrame.this.speedComboBox.getSelectedIndex())) {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getSucceed());
                    } else {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getFailed());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PtzControlModule.ptzControlFocusDecEnd(PTZControlFrame.this.chnComboBox.getSelectedIndex());
                    PTZControlFrame.this.operateJLabel.setText("");
                }
            });
            PTZControlFrame.this.irisAddBtn.addMouseListener(new MouseListener(){

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (PtzControlModule.ptzControlIrisAddStart(PTZControlFrame.this.chnComboBox.getSelectedIndex(), PTZControlFrame.this.speedComboBox.getSelectedIndex())) {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getSucceed());
                    } else {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getFailed());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PtzControlModule.ptzControlIrisAddEnd(PTZControlFrame.this.chnComboBox.getSelectedIndex());
                    PTZControlFrame.this.operateJLabel.setText("");
                }
            });
            PTZControlFrame.this.irisDecBtn.addMouseListener(new MouseListener(){

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (PtzControlModule.ptzControlIrisDecStart(PTZControlFrame.this.chnComboBox.getSelectedIndex(), PTZControlFrame.this.speedComboBox.getSelectedIndex())) {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getSucceed());
                    } else {
                        PTZControlFrame.this.operateJLabel.setText(Res.string().getFailed());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PtzControlModule.ptzControlIrisDecEnd(PTZControlFrame.this.chnComboBox.getSelectedIndex());
                    PTZControlFrame.this.operateJLabel.setText("");
                }
            });
        }
    }

    private class PICPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public PICPanel() {
            BorderEx.set(this, Res.string().getCapturePicture(), 2);
            this.setLayout(new BorderLayout());
            PTZControlFrame.this.pictureShowPanel = new JPanel();
            PTZControlFrame.this.snapPanel = new JPanel();
            this.add((Component)PTZControlFrame.this.pictureShowPanel, "Center");
            this.add((Component)PTZControlFrame.this.snapPanel, "South");
            PTZControlFrame.this.snapPanel.setLayout(new BorderLayout());
            PTZControlFrame.this.snapPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            PTZControlFrame.this.snapBtn = new JButton(Res.string().getRemoteCapture());
            PTZControlFrame.this.snapBtn.setPreferredSize(new Dimension(40, 23));
            PTZControlFrame.this.snapPanel.add((Component)PTZControlFrame.this.snapBtn, "Center");
            PTZControlFrame.this.snapBtn.setEnabled(false);
            PTZControlFrame.this.pictureShowPanel.setLayout(new BorderLayout());
            PTZControlFrame.this.pictureShowPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            PTZControlFrame.this.pictureShowWindow = new PaintPanel();
            PTZControlFrame.this.pictureShowPanel.add((Component)PTZControlFrame.this.pictureShowWindow, "Center");
            PTZControlFrame.this.snapBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (!CapturePictureModule.remoteCapturePicture(PTZControlFrame.this.chnComboBox.getSelectedIndex())) {
                        JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                    }
                }
            });
        }
    }

    private class PTZ_PICPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public PTZ_PICPanel() {
            this.setLayout(new BorderLayout());
            Dimension dim = this.getPreferredSize();
            dim.width = 320;
            this.setPreferredSize(dim);
            PTZControlFrame.this.picPanel = new PICPanel();
            PTZControlFrame.this.ptzPanel = new PTZPanel();
            this.add((Component)PTZControlFrame.this.picPanel, "Center");
            this.add((Component)PTZControlFrame.this.ptzPanel, "South");
        }
    }

    private class RealPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public RealPanel() {
            BorderEx.set(this, Res.string().getRealplay(), 2);
            this.setLayout(new BorderLayout());
            PTZControlFrame.this.channelPanel = new Panel();
            PTZControlFrame.this.realplayPanel = new JPanel();
            this.add((Component)PTZControlFrame.this.channelPanel, "South");
            this.add((Component)PTZControlFrame.this.realplayPanel, "Center");
            PTZControlFrame.this.realplayPanel.setLayout(new BorderLayout());
            PTZControlFrame.this.realplayPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            PTZControlFrame.this.realPlayWindow = new Panel();
            PTZControlFrame.this.realPlayWindow.setBackground(Color.GRAY);
            PTZControlFrame.this.realplayPanel.add((Component)PTZControlFrame.this.realPlayWindow, "Center");
            PTZControlFrame.this.chnlabel = new JLabel(Res.string().getChannel());
            PTZControlFrame.this.chnComboBox = new JComboBox();
            PTZControlFrame.this.streamLabel = new JLabel(Res.string().getStreamType());
            String[] stream = new String[]{Res.string().getMasterStream(), Res.string().getSubStream()};
            PTZControlFrame.this.streamComboBox = new JComboBox<String>(stream);
            PTZControlFrame.this.realplayBtn = new JButton(Res.string().getStartRealPlay());
            PTZControlFrame.this.channelPanel.setLayout(new FlowLayout());
            PTZControlFrame.this.channelPanel.add(PTZControlFrame.this.chnlabel);
            PTZControlFrame.this.channelPanel.add(PTZControlFrame.this.chnComboBox);
            PTZControlFrame.this.channelPanel.add(PTZControlFrame.this.streamLabel);
            PTZControlFrame.this.channelPanel.add(PTZControlFrame.this.streamComboBox);
            PTZControlFrame.this.channelPanel.add(PTZControlFrame.this.realplayBtn);
            PTZControlFrame.this.chnComboBox.setPreferredSize(new Dimension(90, 20));
            PTZControlFrame.this.streamComboBox.setPreferredSize(new Dimension(90, 20));
            PTZControlFrame.this.realplayBtn.setPreferredSize(new Dimension(120, 20));
            PTZControlFrame.this.realPlayWindow.setEnabled(false);
            PTZControlFrame.this.chnComboBox.setEnabled(false);
            PTZControlFrame.this.streamComboBox.setEnabled(false);
            PTZControlFrame.this.realplayBtn.setEnabled(false);
            PTZControlFrame.this.realplayBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PTZControlFrame.this.realplay();
                }
            });
        }
    }

    private static class HaveReConnect
    implements NetSDKLib.fHaveReConnect {
        private HaveReConnect() {
        }

        @Override
        public void invoke(NetSDKLib.LLong m_hLoginHandle, String pchDVRIP, int nDVRPort, Pointer dwUser) {
            System.out.printf("ReConnect Device[%s] Port[%d]\n", pchDVRIP, nDVRPort);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.setTitle(Res.string().getPTZ() + " : " + Res.string().getOnline());
                }
            });
        }
    }

    private static class DisConnect
    implements NetSDKLib.fDisConnect {
        private DisConnect() {
        }

        @Override
        public void invoke(NetSDKLib.LLong m_hLoginHandle, String pchDVRIP, int nDVRPort, Pointer dwUser) {
            System.out.printf("Device[%s] Port[%d] DisConnect!\n", pchDVRIP, nDVRPort);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.setTitle(Res.string().getPTZ() + " : " + Res.string().getDisConnectReconnecting());
                }
            });
        }
    }
}

