/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame;

import com.netsdk.common.BorderEx;
import com.netsdk.common.FunctionList;
import com.netsdk.common.LoginPanel;
import com.netsdk.common.Res;
import com.netsdk.demo.module.LoginModule;
import com.netsdk.demo.module.TalkModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.Pointer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class TalkFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Vector<String> chnlist = new Vector();
    private static DisConnect disConnect = new DisConnect();
    private static JFrame frame = new JFrame();
    private TalkLoginPanel loginPanel;
    private TalkPanel talkPanel;

    public TalkFrame() {
        this.setTitle(Res.string().getTalk());
        this.setLayout(new BorderLayout());
        this.pack();
        this.setSize(400, 450);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        LoginModule.init(disConnect, null);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loginPanel = new TalkLoginPanel();
        this.talkPanel = new TalkPanel();
        this.add((Component)this.loginPanel, "Center");
        this.add((Component)this.talkPanel, "South");
        this.loginPanel.addLoginBtnActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TalkFrame.this.loginPanel.checkLoginText() && TalkFrame.this.login()) {
                    frame = ToolKits.getFrame(e);
                    frame.setTitle(Res.string().getTalk() + " : " + Res.string().getOnline());
                }
            }
        });
        this.loginPanel.addLogoutBtnActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setTitle(Res.string().getTalk());
                TalkFrame.this.logout();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TalkModule.stopTalk();
                LoginModule.logout();
                LoginModule.cleanup();
                TalkFrame.this.dispose();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FunctionList demo = new FunctionList();
                        demo.setVisible(true);
                    }
                });
            }
        });
    }

    public boolean login() {
        if (LoginModule.login(this.loginPanel.ipTextArea.getText(), Integer.parseInt(this.loginPanel.portTextArea.getText()), this.loginPanel.nameTextArea.getText(), new String(this.loginPanel.passwordTextArea.getPassword()))) {
            this.loginPanel.setButtonEnable(true);
            for (int i = 1; i < LoginModule.m_stDeviceInfo.byChanNum + 1; ++i) {
                this.chnlist.add(Res.string().getChannel() + " " + String.valueOf(i));
            }
        } else {
            JOptionPane.showMessageDialog(null, Res.string().getLoginFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return false;
        }
        this.talkPanel.talkEnable();
        return true;
    }

    public void logout() {
        TalkModule.stopTalk();
        LoginModule.logout();
        this.loginPanel.setButtonEnable(false);
        this.chnlist.clear();
        this.talkPanel.initTalkEnable();
    }

    private class TalkLoginPanel
    extends LoginPanel {
        private static final long serialVersionUID = 1L;

        public TalkLoginPanel() {
            this.setLayout(new GridLayout(3, 1));
            this.removeAll();
            JPanel ipPanel = new JPanel();
            JPanel userPanel = new JPanel();
            JPanel btnPanel = new JPanel();
            JLabel nullLabel = new JLabel("          ");
            JLabel nullLabel1 = new JLabel("          ");
            this.resetSize();
            ipPanel.add(this.ipLabel);
            ipPanel.add(this.ipTextArea);
            ipPanel.add(this.portLabel);
            ipPanel.add(this.portTextArea);
            userPanel.add(this.nameLabel);
            userPanel.add(this.nameTextArea);
            userPanel.add(this.passwordLabel);
            userPanel.add(this.passwordTextArea);
            btnPanel.add(nullLabel);
            btnPanel.add(this.loginBtn);
            btnPanel.add(nullLabel1);
            btnPanel.add(this.logoutBtn);
            this.add(ipPanel);
            this.add(userPanel);
            this.add(btnPanel);
        }

        private void resetSize() {
            this.ipLabel.setPreferredSize(new Dimension(70, 20));
            this.portLabel.setPreferredSize(new Dimension(70, 20));
            this.nameLabel.setText(Res.string().getUserName());
            this.nameLabel.setPreferredSize(new Dimension(70, 20));
            this.passwordLabel.setPreferredSize(new Dimension(70, 20));
            this.ipTextArea.setPreferredSize(new Dimension(90, 20));
            this.portTextArea.setPreferredSize(new Dimension(90, 20));
            this.nameTextArea.setPreferredSize(new Dimension(90, 20));
            this.passwordTextArea.setPreferredSize(new Dimension(90, 20));
        }
    }

    private class TalkPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JPanel transmitPanel;
        private JPanel chnPanel;
        private JPanel talkBtnPanel;
        private JLabel transmitLabel;
        private JComboBox transmitComboBox;
        private JLabel chnlabel;
        private JComboBox chnComboBox;
        private JButton startTalkBtn;
        private JButton stopTalkBtn;

        public TalkPanel() {
            BorderEx.set(this, Res.string().getTalk(), 2);
            this.setLayout(new GridLayout(3, 1));
            this.setPreferredSize(new Dimension(350, 220));
            this.transmitPanel = new JPanel();
            this.chnPanel = new JPanel();
            this.talkBtnPanel = new JPanel();
            this.transmitLabel = new JLabel(Res.string().getTransmitType());
            this.transmitLabel.setPreferredSize(new Dimension(100, 25));
            this.transmitComboBox = new JComboBox();
            this.transmitComboBox.setPreferredSize(new Dimension(150, 25));
            this.transmitPanel.add(this.transmitLabel);
            this.transmitPanel.add(this.transmitComboBox);
            this.chnlabel = new JLabel(Res.string().getTransmitChannel());
            this.chnlabel.setPreferredSize(new Dimension(100, 25));
            this.chnComboBox = new JComboBox();
            this.chnComboBox.setPreferredSize(new Dimension(150, 25));
            this.chnPanel.add(this.chnlabel);
            this.chnPanel.add(this.chnComboBox);
            this.startTalkBtn = new JButton(Res.string().getStartTalk());
            this.startTalkBtn.setPreferredSize(new Dimension(100, 20));
            JLabel nullLabel = new JLabel("      ");
            this.stopTalkBtn = new JButton(Res.string().getStopTalk());
            this.stopTalkBtn.setPreferredSize(new Dimension(100, 20));
            this.talkBtnPanel.add(this.startTalkBtn);
            this.talkBtnPanel.add(nullLabel);
            this.talkBtnPanel.add(this.stopTalkBtn);
            this.add(this.transmitPanel);
            this.add(this.chnPanel);
            this.add(this.talkBtnPanel);
            this.initTalkEnable();
            this.startTalkBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TalkModule.startTalk(TalkPanel.this.transmitComboBox.getSelectedIndex(), TalkPanel.this.chnComboBox.getSelectedIndex())) {
                        TalkPanel.this.setButtonEnable(false);
                    } else {
                        JOptionPane.showMessageDialog(null, Res.string().getTalkFailed() + "," + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                    }
                }
            });
            this.stopTalkBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TalkModule.stopTalk();
                    TalkPanel.this.setButtonEnable(true);
                }
            });
            this.transmitComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        if (TalkPanel.this.transmitComboBox.getSelectedIndex() == 1) {
                            TalkPanel.this.chnComboBox.setModel(new DefaultComboBoxModel(TalkFrame.this.chnlist));
                            TalkPanel.this.chnComboBox.setEnabled(true);
                        } else {
                            TalkPanel.this.chnComboBox.setModel(new DefaultComboBoxModel());
                            TalkPanel.this.chnComboBox.setEnabled(false);
                        }
                    }
                }
            });
        }

        public void talkEnable() {
            String[] transmit = new String[]{Res.string().getLocalTransmitType(), Res.string().getRemoteTransmitType()};
            this.transmitComboBox.setModel(new DefaultComboBoxModel<String>(transmit));
            this.setButtonEnable(true);
        }

        public void initTalkEnable() {
            this.chnComboBox.setModel(new DefaultComboBoxModel());
            this.transmitComboBox.setModel(new DefaultComboBoxModel());
            this.chnComboBox.setEnabled(false);
            this.transmitComboBox.setEnabled(false);
            this.startTalkBtn.setEnabled(false);
            this.stopTalkBtn.setEnabled(false);
        }

        private void setButtonEnable(boolean bln) {
            this.transmitComboBox.setEnabled(bln);
            if (bln && this.transmitComboBox.getSelectedIndex() == 1) {
                this.chnComboBox.setEnabled(true);
            } else {
                this.chnComboBox.setEnabled(false);
            }
            this.startTalkBtn.setEnabled(bln);
            this.stopTalkBtn.setEnabled(!bln);
        }
    }

    private static class DisConnect
    implements NetSDKLib.fDisConnect {
        private DisConnect() {
        }

        @Override
        public void invoke(NetSDKLib.LLong m_hLoginHandle, String pchDVRIP, int nDVRPort, Pointer dwUser) {
            System.out.printf("Device[%s] Port[%d] DisConnect!\n", pchDVRIP, nDVRPort);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.setTitle(Res.string().getTalk() + " : " + Res.string().getDisConnectReconnecting());
                }
            });
        }
    }
}

