/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.ThermalCamera;

import com.netsdk.common.BorderEx;
import com.netsdk.common.Res;
import com.netsdk.demo.frame.ThermalCamera.ThermalCameraFrame;
import com.netsdk.demo.module.ThermalCameraModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class HeatMapDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JDialog target = this;
    private ReentrantLock lock = new ReentrantLock();
    private NetSDKLib.NET_RADIOMETRY_DATA gData = new NetSDKLib.NET_RADIOMETRY_DATA();
    private RadiometryAttachCB cbNotify = new RadiometryAttachCB();
    private OperatePanel operatePanel;
    private HeatMapShowPanel showPanel;

    public HeatMapDialog() {
        this.setTitle(Res.string().getShowInfo("HEATMAP"));
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.pack();
        this.setSize(400, 440);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.operatePanel = new OperatePanel();
        this.showPanel = new HeatMapShowPanel();
        this.add((Component)this.showPanel, "Center");
        this.add((Component)this.operatePanel, "North");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    ThermalCameraModule.radiometryDetach();
                }
                finally {
                    HeatMapDialog.this.dispose();
                }
            }
        });
    }

    private void copyRadiometryData(NetSDKLib.NET_RADIOMETRY_DATA data) {
        this.lock.lock();
        this.gData.stMetaData = data.stMetaData;
        this.gData.dwBufSize = data.dwBufSize;
        this.gData.pbDataBuf = new Memory(data.dwBufSize);
        this.gData.pbDataBuf.write(0L, data.pbDataBuf.getByteArray(0L, data.dwBufSize), 0, data.dwBufSize);
        this.lock.unlock();
    }

    public class HeatMapShowPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JTextField heightTextField;
        private JTextField widthTextField;
        private JTextField channelTextField;
        private JTextField timeTextField;
        private JTextField lengthTextField;
        private JTextField sensorTypeTextField;

        public HeatMapShowPanel() {
            BorderEx.set(this, Res.string().getShowInfo("HEATMAP_METADATA_INFO"), 1);
            this.setLayout(new FlowLayout(1, 15, 25));
            JLabel heightLabel = new JLabel(Res.string().getShowInfo("HEIGHT"), 2);
            this.heightTextField = new JTextField();
            JLabel widthLabel = new JLabel(Res.string().getShowInfo("WIDTH"), 2);
            this.widthTextField = new JTextField();
            JLabel channelLabel = new JLabel(Res.string().getShowInfo("CHANNEL"), 2);
            this.channelTextField = new JTextField();
            JLabel timeLabel = new JLabel(Res.string().getShowInfo("TIME"), 2);
            this.timeTextField = new JTextField();
            JLabel lengthLabel = new JLabel(Res.string().getShowInfo("LENGTH"), 2);
            this.lengthTextField = new JTextField();
            JLabel sensorTypeLabel = new JLabel(Res.string().getShowInfo("SENSOR_TYPE"), 2);
            this.sensorTypeTextField = new JTextField();
            Dimension lableDimension = new Dimension(100, 20);
            Dimension textFieldDimension = new Dimension(140, 20);
            heightLabel.setPreferredSize(lableDimension);
            widthLabel.setPreferredSize(lableDimension);
            channelLabel.setPreferredSize(lableDimension);
            timeLabel.setPreferredSize(lableDimension);
            lengthLabel.setPreferredSize(lableDimension);
            sensorTypeLabel.setPreferredSize(lableDimension);
            this.heightTextField.setPreferredSize(textFieldDimension);
            this.widthTextField.setPreferredSize(textFieldDimension);
            this.channelTextField.setPreferredSize(textFieldDimension);
            this.timeTextField.setPreferredSize(textFieldDimension);
            this.lengthTextField.setPreferredSize(textFieldDimension);
            this.sensorTypeTextField.setPreferredSize(textFieldDimension);
            this.heightTextField.setEditable(false);
            this.widthTextField.setEditable(false);
            this.channelTextField.setEditable(false);
            this.timeTextField.setEditable(false);
            this.lengthTextField.setEditable(false);
            this.sensorTypeTextField.setEditable(false);
            this.add(heightLabel);
            this.add(this.heightTextField);
            this.add(widthLabel);
            this.add(this.widthTextField);
            this.add(channelLabel);
            this.add(this.channelTextField);
            this.add(timeLabel);
            this.add(this.timeTextField);
            this.add(lengthLabel);
            this.add(this.lengthTextField);
            this.add(sensorTypeLabel);
            this.add(this.sensorTypeTextField);
        }

        public void updateData() {
            String[] data = new String[6];
            HeatMapDialog.this.lock.lock();
            data[0] = String.valueOf(((HeatMapDialog)HeatMapDialog.this).gData.stMetaData.nHeight);
            data[1] = String.valueOf(((HeatMapDialog)HeatMapDialog.this).gData.stMetaData.nWidth);
            data[2] = String.valueOf(((HeatMapDialog)HeatMapDialog.this).gData.stMetaData.nChannel + 1);
            data[3] = ((HeatMapDialog)HeatMapDialog.this).gData.stMetaData.stTime.toStringTimeEx();
            data[4] = String.valueOf(((HeatMapDialog)HeatMapDialog.this).gData.stMetaData.nLength);
            try {
                data[5] = new String(((HeatMapDialog)HeatMapDialog.this).gData.stMetaData.szSensorType, "GBK").trim();
            }
            catch (UnsupportedEncodingException e) {
                data[5] = new String(((HeatMapDialog)HeatMapDialog.this).gData.stMetaData.szSensorType).trim();
            }
            HeatMapDialog.this.lock.unlock();
            this.setData(data);
        }

        public void clearData() {
            this.setData(new String[6]);
        }

        private void setData(String[] data) {
            if (data.length != 6) {
                System.err.printf("data length  %d != 6", data.length);
                return;
            }
            this.heightTextField.setText(data[0]);
            this.widthTextField.setText(data[1]);
            this.channelTextField.setText(data[2]);
            this.timeTextField.setText(data[3]);
            this.lengthTextField.setText(data[4]);
            this.sensorTypeTextField.setText(data[5]);
        }
    }

    public class OperatePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JButton attachBtn;
        private JButton fetchBtn;
        private JButton saveBtn;

        public OperatePanel() {
            BorderEx.set(this, Res.string().getShowInfo("HEATMAP_OPERATE"), 1);
            this.setLayout(new FlowLayout(0, 5, 10));
            this.attachBtn = new JButton(Res.string().getShowInfo("RADIOMETRY_ATTACH"));
            this.fetchBtn = new JButton(Res.string().getShowInfo("RADIOMETRY_FETCH"));
            this.saveBtn = new JButton(Res.string().getShowInfo("SAVE_HEATMAP"));
            Dimension btnDimension = new Dimension(120, 20);
            this.attachBtn.setPreferredSize(btnDimension);
            this.fetchBtn.setPreferredSize(btnDimension);
            this.saveBtn.setPreferredSize(btnDimension);
            this.fetchBtn.setEnabled(false);
            this.saveBtn.setEnabled(false);
            this.add(this.attachBtn);
            this.add(this.fetchBtn);
            this.add(this.saveBtn);
            this.attachBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OperatePanel.this.attach();
                        }
                    });
                }
            });
            this.fetchBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OperatePanel.this.fetch();
                        }
                    });
                }
            });
            this.saveBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                OperatePanel.this.save();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            });
        }

        public void attach() {
            this.freeMemory();
            HeatMapDialog.this.target.setTitle(Res.string().getShowInfo("HEATMAP"));
            if (ThermalCameraModule.isAttaching()) {
                ThermalCameraModule.radiometryDetach();
                this.fetchBtn.setEnabled(false);
                this.saveBtn.setEnabled(false);
                this.attachBtn.setText(Res.string().getShowInfo("RADIOMETRY_ATTACH"));
            } else if (ThermalCameraModule.radiometryAttach(ThermalCameraFrame.THERMAL_CHANNEL, HeatMapDialog.this.cbNotify)) {
                this.attachBtn.setText(Res.string().getShowInfo("RADIOMETRY_DETACH"));
                HeatMapDialog.this.showPanel.clearData();
                this.fetchBtn.setEnabled(true);
            } else {
                JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            }
        }

        public void fetch() {
            this.freeMemory();
            this.saveBtn.setEnabled(false);
            int nStatus = ThermalCameraModule.radiometryFetch(ThermalCameraFrame.THERMAL_CHANNEL);
            if (nStatus != -1) {
                HeatMapDialog.this.showPanel.clearData();
                String[] arrStatus = Res.string().getTemperStatusList();
                if (nStatus >= 1 && nStatus <= arrStatus.length) {
                    HeatMapDialog.this.target.setTitle(Res.string().getShowInfo("HEATMAP") + " : " + arrStatus[nStatus - 1]);
                }
            } else {
                JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            }
        }

        public void save() throws IOException {
            HeatMapDialog.this.lock.lock();
            boolean bSaved = ThermalCameraModule.saveData(HeatMapDialog.this.gData);
            HeatMapDialog.this.lock.unlock();
            if (bSaved) {
                JOptionPane.showMessageDialog(null, Res.string().getShowInfo("HEATMAP_SAVE_SUCCESS"), Res.string().getPromptMessage(), -1);
            } else {
                JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            }
        }

        public void freeMemory() {
            HeatMapDialog.this.lock.lock();
            if (((HeatMapDialog)HeatMapDialog.this).gData.pbDataBuf != null) {
                Native.free(Pointer.nativeValue(((HeatMapDialog)HeatMapDialog.this).gData.pbDataBuf));
                Pointer.nativeValue(((HeatMapDialog)HeatMapDialog.this).gData.pbDataBuf, 0L);
            }
            HeatMapDialog.this.lock.unlock();
        }
    }

    private class RadiometryAttachCB
    implements NetSDKLib.fRadiometryAttachCB {
        private RadiometryAttachCB() {
        }

        @Override
        public void invoke(NetSDKLib.LLong lAttachHandle, NetSDKLib.NET_RADIOMETRY_DATA pBuf, int nBufLen, Pointer dwUser) {
            HeatMapDialog.this.copyRadiometryData(pBuf);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HeatMapDialog.this.target.setTitle(Res.string().getShowInfo("HEATMAP"));
                    HeatMapDialog.this.operatePanel.saveBtn.setEnabled(true);
                    HeatMapDialog.this.showPanel.updateData();
                }
            });
        }
    }
}

