/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.ThermalCamera;

import com.netsdk.common.BorderEx;
import com.netsdk.common.Res;
import com.netsdk.demo.frame.ThermalCamera.ThermalCameraFrame;
import com.netsdk.demo.module.ThermalCameraModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class ItemQueryDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private QueryPanel queryPanel;
    private QueryShowPanel showPanel;

    public ItemQueryDialog() {
        this.setTitle(Res.string().getShowInfo("ITEM_TEMPER"));
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.pack();
        this.setSize(365, 460);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.queryPanel = new QueryPanel();
        this.showPanel = new QueryShowPanel();
        this.add((Component)this.queryPanel, "North");
        this.add((Component)this.showPanel, "Center");
    }

    class NumberKeyListener
    implements KeyListener {
        NumberKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char key = e.getKeyChar();
            if (key < '0' || key > '9') {
                e.consume();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    public class QueryShowPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JTextField meterTypeTextField;
        private JTextField temperUnitTextField;
        private JTextField temperAverTextField;
        private JTextField temperMaxTextField;
        private JTextField temperMinTextField;
        private JTextField temperMidTextField;
        private JTextField temperStdTextField;

        public QueryShowPanel() {
            BorderEx.set(this, Res.string().getShowInfo("QUERY_RESULT"), 1);
            this.setLayout(new FlowLayout(1, 5, 25));
            JLabel meterTypeLabel = new JLabel(Res.string().getShowInfo("METER_TYPE"), 2);
            this.meterTypeTextField = new JTextField();
            JLabel temperUnitLabel = new JLabel(Res.string().getShowInfo("TEMPER_UNIT"), 2);
            this.temperUnitTextField = new JTextField();
            JLabel temperAverLabel = new JLabel(Res.string().getShowInfo("TEMPER_AVER"), 2);
            this.temperAverTextField = new JTextField();
            JLabel temperMaxLabel = new JLabel(Res.string().getShowInfo("TEMPER_MAX"), 2);
            this.temperMaxTextField = new JTextField();
            JLabel temperMinLabel = new JLabel(Res.string().getShowInfo("TEMPER_MIN"), 2);
            this.temperMinTextField = new JTextField();
            JLabel temperMidLabel = new JLabel(Res.string().getShowInfo("TEMPER_MID"), 2);
            this.temperMidTextField = new JTextField();
            JLabel temperStdLabel = new JLabel(Res.string().getShowInfo("TEMPER_STD"), 2);
            this.temperStdTextField = new JTextField();
            Dimension lableDimension = new Dimension(120, 20);
            Dimension textFieldDimension = new Dimension(130, 20);
            meterTypeLabel.setPreferredSize(lableDimension);
            temperUnitLabel.setPreferredSize(lableDimension);
            temperAverLabel.setPreferredSize(lableDimension);
            temperMaxLabel.setPreferredSize(lableDimension);
            temperMinLabel.setPreferredSize(lableDimension);
            temperMidLabel.setPreferredSize(lableDimension);
            temperStdLabel.setPreferredSize(lableDimension);
            this.meterTypeTextField.setPreferredSize(textFieldDimension);
            this.temperUnitTextField.setPreferredSize(textFieldDimension);
            this.temperAverTextField.setPreferredSize(textFieldDimension);
            this.temperMaxTextField.setPreferredSize(textFieldDimension);
            this.temperMinTextField.setPreferredSize(textFieldDimension);
            this.temperMidTextField.setPreferredSize(textFieldDimension);
            this.temperStdTextField.setPreferredSize(textFieldDimension);
            this.meterTypeTextField.setEditable(false);
            this.temperUnitTextField.setEditable(false);
            this.temperAverTextField.setEditable(false);
            this.temperMaxTextField.setEditable(false);
            this.temperMinTextField.setEditable(false);
            this.temperMidTextField.setEditable(false);
            this.temperStdTextField.setEditable(false);
            this.add(meterTypeLabel);
            this.add(this.meterTypeTextField);
            this.add(temperUnitLabel);
            this.add(this.temperUnitTextField);
            this.add(temperMaxLabel);
            this.add(this.temperMaxTextField);
            this.add(temperMinLabel);
            this.add(this.temperMinTextField);
            this.add(temperMidLabel);
            this.add(this.temperMidTextField);
            this.add(temperStdLabel);
            this.add(this.temperStdTextField);
        }

        public void updateData(NetSDKLib.NET_RADIOMETRYINFO stItemInfo) {
            String[] data = new String[7];
            String[] arrMeterType = Res.string().getMeterTypeList();
            data[0] = stItemInfo.nMeterType >= 1 && stItemInfo.nMeterType <= arrMeterType.length ? arrMeterType[stItemInfo.nMeterType - 1] : Res.string().getShowInfo("UNKNOWN");
            String[] arrTemperUnit = Res.string().getTemperUnitList();
            data[1] = stItemInfo.nTemperUnit >= 1 && stItemInfo.nTemperUnit <= arrTemperUnit.length ? arrTemperUnit[stItemInfo.nTemperUnit - 1] : Res.string().getShowInfo("UNKNOWN");
            data[2] = String.valueOf(stItemInfo.fTemperAver);
            data[3] = String.valueOf(stItemInfo.fTemperMax);
            data[4] = String.valueOf(stItemInfo.fTemperMin);
            data[5] = String.valueOf(stItemInfo.fTemperMid);
            data[6] = String.valueOf(stItemInfo.fTemperStd);
            this.setData(data);
        }

        public void clearData() {
            this.setData(new String[7]);
        }

        private void setData(String[] data) {
            if (data.length != 7) {
                System.err.printf("data length  %d != 7", data.length);
                return;
            }
            this.meterTypeTextField.setText(data[0]);
            this.temperUnitTextField.setText(data[1]);
            this.temperAverTextField.setText(data[2]);
            this.temperMaxTextField.setText(data[3]);
            this.temperMinTextField.setText(data[4]);
            this.temperMidTextField.setText(data[5]);
            this.temperStdTextField.setText(data[6]);
        }
    }

    public class QueryPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private NumberKeyListener listener;
        private JTextField presetIdTextField;
        private JTextField ruleIdTextField;
        private JComboBox meterTypeComboBox;
        private JButton queryBtn;

        public QueryPanel() {
            BorderEx.set(this, Res.string().getShowInfo("QUERY_CONDITION"), 1);
            this.setLayout(new BorderLayout());
            JLabel presetIdLabel = new JLabel(Res.string().getShowInfo("PRESET_ID"), 0);
            this.presetIdTextField = new JTextField("1");
            JLabel ruleIdLabel = new JLabel(Res.string().getShowInfo("RULE_ID"), 0);
            this.ruleIdTextField = new JTextField("1");
            JLabel meterTypeLabel = new JLabel(Res.string().getShowInfo("METER_TYPE"), 0);
            this.meterTypeComboBox = new JComboBox();
            this.meterTypeComboBox.setModel(new DefaultComboBoxModel<String>(Res.string().getMeterTypeList()));
            this.queryBtn = new JButton(Res.string().getShowInfo("QUERY"));
            Dimension lableDimension = new Dimension(85, 20);
            Dimension textFieldDimension = new Dimension(80, 20);
            Dimension btnDimension = new Dimension(100, 20);
            presetIdLabel.setPreferredSize(lableDimension);
            this.presetIdTextField.setPreferredSize(textFieldDimension);
            ruleIdLabel.setPreferredSize(lableDimension);
            this.ruleIdTextField.setPreferredSize(textFieldDimension);
            meterTypeLabel.setPreferredSize(lableDimension);
            this.meterTypeComboBox.setPreferredSize(textFieldDimension);
            JLabel label = new JLabel();
            label.setPreferredSize(new Dimension(40, 20));
            this.queryBtn.setPreferredSize(btnDimension);
            JPanel topPanel = new JPanel();
            topPanel.setLayout(new FlowLayout(0, 1, 10));
            topPanel.add(presetIdLabel);
            topPanel.add(this.presetIdTextField);
            topPanel.add(ruleIdLabel);
            topPanel.add(this.ruleIdTextField);
            JPanel bottomPanel = new JPanel();
            bottomPanel.setLayout(new FlowLayout(0, 1, 10));
            bottomPanel.add(meterTypeLabel);
            bottomPanel.add(this.meterTypeComboBox);
            bottomPanel.add(label);
            bottomPanel.add(this.queryBtn);
            JSplitPane splitPane = new JSplitPane(0);
            splitPane.setDividerSize(0);
            splitPane.setBorder(null);
            splitPane.add((Component)topPanel, "top");
            splitPane.add((Component)bottomPanel, "bottom");
            this.add((Component)splitPane, "Center");
            this.listener = new NumberKeyListener();
            this.presetIdTextField.addKeyListener(this.listener);
            this.ruleIdTextField.addKeyListener(this.listener);
            this.queryBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryPanel.this.queryItemInfo();
                }
            });
        }

        public void queryItemInfo() {
            try {
                ItemQueryDialog.this.showPanel.clearData();
                int nPresetId = Integer.parseInt(this.presetIdTextField.getText());
                int nRuleId = Integer.parseInt(this.ruleIdTextField.getText());
                int nMeterType = this.meterTypeComboBox.getSelectedIndex() + 1;
                NetSDKLib.NET_RADIOMETRYINFO stItemInfo = ThermalCameraModule.queryItemTemper(ThermalCameraFrame.THERMAL_CHANNEL, nPresetId, nRuleId, nMeterType);
                if (stItemInfo == null) {
                    JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                    return;
                }
                ItemQueryDialog.this.showPanel.updateData(stItemInfo);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(null, Res.string().getShowInfo("INPUT_ILLEGAL"), Res.string().getErrorMessage(), 0);
            }
        }
    }
}

