/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.ThermalCamera;

import com.netsdk.common.BorderEx;
import com.netsdk.common.Res;
import com.netsdk.demo.frame.ThermalCamera.ThermalCameraFrame;
import com.netsdk.demo.module.ThermalCameraModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PointQueryDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private QueryPanel queryPanel;
    private QueryShowPanel showPanel;

    public PointQueryDialog() {
        this.setTitle(Res.string().getShowInfo("POINT_TEMPER"));
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.pack();
        this.setSize(350, 300);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.queryPanel = new QueryPanel();
        this.showPanel = new QueryShowPanel();
        this.add((Component)this.queryPanel, "North");
        this.add((Component)this.showPanel, "Center");
    }

    class NumberKeyListener
    implements KeyListener {
        NumberKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char key = e.getKeyChar();
            if (key < '0' || key > '9') {
                e.consume();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    public class QueryShowPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JTextField meterTypeTextField;
        private JTextField temperUnitTextField;
        private JTextField temperTextField;

        public QueryShowPanel() {
            BorderEx.set(this, Res.string().getShowInfo("QUERY_RESULT"), 1);
            this.setLayout(new FlowLayout(1, 5, 30));
            JLabel meterTypeLabel = new JLabel(Res.string().getShowInfo("METER_TYPE"), 2);
            this.meterTypeTextField = new JTextField();
            JLabel temperUnitLabel = new JLabel(Res.string().getShowInfo("TEMPER_UNIT"), 2);
            this.temperUnitTextField = new JTextField();
            JLabel temperLabel = new JLabel(Res.string().getShowInfo("TEMPER"), 2);
            this.temperTextField = new JTextField();
            Dimension lableDimension = new Dimension(100, 20);
            Dimension textFieldDimension = new Dimension(130, 20);
            meterTypeLabel.setPreferredSize(lableDimension);
            temperUnitLabel.setPreferredSize(lableDimension);
            temperLabel.setPreferredSize(lableDimension);
            this.meterTypeTextField.setPreferredSize(textFieldDimension);
            this.temperUnitTextField.setPreferredSize(textFieldDimension);
            this.temperTextField.setPreferredSize(textFieldDimension);
            this.meterTypeTextField.setEditable(false);
            this.temperUnitTextField.setEditable(false);
            this.temperTextField.setEditable(false);
            this.add(meterTypeLabel);
            this.add(this.meterTypeTextField);
            this.add(temperUnitLabel);
            this.add(this.temperUnitTextField);
            this.add(temperLabel);
            this.add(this.temperTextField);
        }

        public void updateData(NetSDKLib.NET_RADIOMETRYINFO stPointInfo) {
            String[] data = new String[3];
            String[] arrMeterType = Res.string().getMeterTypeList();
            data[0] = stPointInfo.nMeterType >= 1 && stPointInfo.nMeterType <= arrMeterType.length ? arrMeterType[stPointInfo.nMeterType - 1] : Res.string().getShowInfo("UNKNOWN");
            String[] arrTemperUnit = Res.string().getTemperUnitList();
            data[1] = stPointInfo.nTemperUnit >= 1 && stPointInfo.nTemperUnit <= arrTemperUnit.length ? arrTemperUnit[stPointInfo.nTemperUnit - 1] : Res.string().getShowInfo("UNKNOWN");
            data[2] = String.valueOf(stPointInfo.fTemperAver);
            this.setData(data);
        }

        public void clearData() {
            this.setData(new String[3]);
        }

        private void setData(String[] data) {
            if (data.length != 3) {
                System.err.printf("data length  %d != 3", data.length);
                return;
            }
            this.meterTypeTextField.setText(data[0]);
            this.temperUnitTextField.setText(data[1]);
            this.temperTextField.setText(data[2]);
        }
    }

    public class QueryPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private NumberKeyListener listener;
        private JTextField XTextField;
        private JTextField YTextField;
        private JButton queryBtn;

        public QueryPanel() {
            BorderEx.set(this, Res.string().getShowInfo("QUERY_CONDITION"), 1);
            this.setLayout(new FlowLayout(1, 10, 10));
            JLabel XLabel = new JLabel(Res.string().getShowInfo("X"), 0);
            this.XTextField = new JTextField("0");
            JLabel YLabel = new JLabel(Res.string().getShowInfo("Y"), 0);
            this.YTextField = new JTextField("0");
            this.queryBtn = new JButton(Res.string().getShowInfo("QUERY"));
            Dimension lableDimension = new Dimension(10, 20);
            Dimension textFieldDimension = new Dimension(70, 20);
            Dimension btnDimension = new Dimension(100, 20);
            XLabel.setPreferredSize(lableDimension);
            this.XTextField.setPreferredSize(textFieldDimension);
            YLabel.setPreferredSize(lableDimension);
            this.YTextField.setPreferredSize(textFieldDimension);
            this.queryBtn.setPreferredSize(btnDimension);
            this.add(XLabel);
            this.add(this.XTextField);
            this.add(YLabel);
            this.add(this.YTextField);
            this.add(this.queryBtn);
            this.listener = new NumberKeyListener();
            this.XTextField.addKeyListener(this.listener);
            this.YTextField.addKeyListener(this.listener);
            this.queryBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryPanel.this.queryPointInfo();
                }
            });
        }

        private void queryPointInfo() {
            try {
                PointQueryDialog.this.showPanel.clearData();
                short x = Short.parseShort(this.XTextField.getText());
                short y = Short.parseShort(this.YTextField.getText());
                NetSDKLib.NET_RADIOMETRYINFO pointInfo = ThermalCameraModule.queryPointTemper(ThermalCameraFrame.THERMAL_CHANNEL, x, y);
                if (pointInfo == null) {
                    JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                    return;
                }
                PointQueryDialog.this.showPanel.updateData(pointInfo);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(null, Res.string().getShowInfo("COORDINATE_ILLEGAL"), Res.string().getErrorMessage(), 0);
            }
        }
    }
}

