/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.scada;

import com.netsdk.common.FunctionList;
import com.netsdk.common.Res;
import com.netsdk.demo.frame.scada.SCADAAlarmAttachInfoCallBack;
import com.netsdk.demo.frame.vto.DefaultDisConnect;
import com.netsdk.demo.frame.vto.DefaultHaveReconnect;
import com.netsdk.demo.frame.vto.OperateManager;
import com.netsdk.demo.module.LoginModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.netsdk.lib.Utils;
import com.netsdk.lib.structure.NET_ATTRIBUTE_INFO;
import com.netsdk.lib.structure.NET_GET_CONDITION_INFO;
import com.netsdk.lib.structure.NET_IN_SCADA_GET_ATTRIBUTE_INFO;
import com.netsdk.lib.structure.NET_OUT_SCADA_GET_ATTRIBUTE_INFO;
import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class SCADADemo
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private JTextField ipTextField;
    private JTextField portTextField;
    private JTextField userNameTextField;
    private JPasswordField passwordField;
    private JButton btnLogin;
    private JButton btnLogout;
    private JButton btnGetDeviceList;
    private JButton btnAlarmAttachInfo;
    private JButton btnAttachInfo;
    private JButton btnAlarmAttachInfoStop;
    private JButton btnAttachInfoStop;
    private JButton btnStartListen;
    private JButton btnStopListen;
    private JTable devicesTable;
    private JTable pointListTable;
    private JTable alarmAttachInfoTable;
    private JScrollPane deviceScrollPane;
    private JButton btnGetSCADAAttribute;
    private boolean isListen = false;
    private static JFrame mainFrame = new JFrame();
    private OperateManager manager = new OperateManager();
    private boolean isAlarmAttachInfo = false;
    private boolean isAttachInfo = false;
    Vector<String> deviceIds = new Vector();
    private static final Charset encode = Charset.forName(Utils.getPlatformEncode());
    private NetSDKLib.LLong attachInfoHandle = new NetSDKLib.LLong(0L);
    private NetSDKLib.LLong alarmAttachInfoHandle = new NetSDKLib.LLong(0L);
    private static JFrame frame = new JFrame();
    private boolean isBtnGetDeviceList = false;
    private boolean isBtnStartListen = false;
    private boolean isBtnAlarmAttachInfo = false;
    private boolean isBtnAttachInfo = false;
    private boolean isBtnPointList = false;
    private Object[][] alarmData;
    private JTable alarmTable;
    private final String[] alarmTableTitle = new String[]{Res.string().getDeviceID(), Res.string().getDeviceName(), Res.string().getChannel(), Res.string().getAlarmDescribe()};
    private DefaultTableModel alarmModel;
    private Object[][] devicesData;
    private JTable devicesDataTable;
    private final String[] devicesDataTitle = new String[]{Res.string().getDeviceID(), Res.string().getDeviceName()};
    private DefaultTableModel devicesDataModel;
    private Object[][] alarmAttachInfoData;
    private JTable alarmAttachInfoDataTable;
    private final String[] alarmAttachInfoDataTitle = new String[]{Res.string().getDeviceID(), Res.string().getPointID(), Res.string().getAlarmDescribe(), Res.string().getCollectTime(), Res.string().getAlarmLevel()};
    private DefaultTableModel alarmAttachInfoDataModel;
    private Object[][] attachInfoData;
    private JTable attachInfoDataTable;
    private final String[] attachInfoDataTitle = new String[]{Res.string().getDeviceName(), Res.string().getCollectTime(), Res.string().getPointID()};
    private DefaultTableModel attachInfoDataModel;
    private Object[][] attributeData;
    private JTable attributeDataTable;
    private final String[] attributeDataTitle = new String[]{Res.string().getDeviceID(), Res.string().getPointName(), Res.string().getAlarmDelay(), Res.string().getIfValidSignalPoint(), Res.string().getAlarmType()};
    private DefaultTableModel attributeDataModel;
    private DisConnect disConnectCallback = new DisConnect();

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SCADADemo frame = new SCADADemo();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void setButtonEnable(boolean enable) {
        this.btnLogin.setEnabled(enable);
        this.btnLogout.setEnabled(enable);
        this.btnGetDeviceList.setEnabled(enable);
        this.btnAlarmAttachInfo.setEnabled(enable);
        this.btnAttachInfo.setEnabled(enable);
        this.btnGetSCADAAttribute.setEnabled(enable);
        this.btnStartListen.setEnabled(enable);
    }

    public boolean login() {
        if (!LoginModule.login(this.ipTextField.getText(), Integer.parseInt(this.portTextField.getText()), this.userNameTextField.getText(), new String(this.passwordField.getPassword()))) {
            JOptionPane.showMessageDialog(null, Res.string().getLoginFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return false;
        }
        this.setButtonEnable(true);
        this.btnLogin.setEnabled(false);
        return true;
    }

    public void logout() {
        if (LoginModule.logout()) {
            this.setButtonEnable(false);
            this.btnLogin.setEnabled(true);
            if (this.isListen) {
                this.stopListen();
                this.isListen = false;
            }
            if (this.isAlarmAttachInfo) {
                this.scadaDetachInfo();
                this.isAlarmAttachInfo = false;
            }
            if (this.isAttachInfo) {
                this.scadaAlarmDetachInfo();
                this.isAttachInfo = false;
            }
            ((DefaultTableModel)this.alarmTable.getModel()).setRowCount(0);
            ((DefaultTableModel)this.devicesDataTable.getModel()).setRowCount(0);
            ((DefaultTableModel)this.attachInfoDataTable.getModel()).setRowCount(0);
            ((DefaultTableModel)this.alarmAttachInfoDataTable.getModel()).setRowCount(0);
            ((DefaultTableModel)this.attributeDataTable.getModel()).setRowCount(0);
        }
    }

    public boolean getDeviceIdList() {
        this.deviceIds.clear();
        int nCount = 64;
        Structure[] stuDeviceIDList = new NetSDKLib.NET_SCADA_DEVICE_ID_INFO[nCount];
        for (int i = 0; i < stuDeviceIDList.length; ++i) {
            stuDeviceIDList[i] = new NetSDKLib.NET_SCADA_DEVICE_ID_INFO();
        }
        NetSDKLib.NET_SCADA_DEVICE_LIST stuSCADADeviceInfo = new NetSDKLib.NET_SCADA_DEVICE_LIST();
        stuSCADADeviceInfo.nMax = nCount;
        int nSize = stuDeviceIDList[0].size() * nCount;
        stuSCADADeviceInfo.pstuDeviceIDInfo = new Memory(nSize);
        stuSCADADeviceInfo.pstuDeviceIDInfo.clear(nSize);
        ToolKits.SetStructArrToPointerData(stuDeviceIDList, stuSCADADeviceInfo.pstuDeviceIDInfo);
        if (this.queryDevState(5489, stuSCADADeviceInfo)) {
            JOptionPane.showMessageDialog(null, Res.string().getLoginFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return false;
        }
        if (stuSCADADeviceInfo.nRet == 0) {
            System.out.println("\u5f53\u524d\u4e3b\u673a\u63a5\u5165\u7684\u5916\u90e8\u8bbe\u5907ID\u6709\u6548\u4e2a\u6570\u4e3a0.");
            return false;
        }
        ToolKits.GetPointerDataToStructArr(stuSCADADeviceInfo.pstuDeviceIDInfo, stuDeviceIDList);
        System.out.println("\u83b7\u53d6\u5f53\u524d\u4e3b\u673a\u63a5\u5165\u7684\u5916\u90e8\u8bbe\u5907ID\u7684\u6709\u6548\u4e2a\u6570\uff1a" + stuSCADADeviceInfo.nRet);
        if (null != this.devicesDataTable) {
            DefaultTableModel model = (DefaultTableModel)this.devicesDataTable.getModel();
            model.getDataVector().clear();
            for (int i = 0; i < stuSCADADeviceInfo.nRet; ++i) {
                String deviceID = "";
                String deviceName = "";
                deviceName = new String(((NetSDKLib.NET_SCADA_DEVICE_ID_INFO)stuDeviceIDList[i]).szDevName, encode).trim();
                deviceID = new String(((NetSDKLib.NET_SCADA_DEVICE_ID_INFO)stuDeviceIDList[i]).szDeviceID, encode).trim();
                System.out.printf("\u5916\u90e8\u8bbe\u5907[%d] \u8bbe\u5907id[%s] \u8bbe\u5907\u540d\u79f0[%s]\n", i, new String(((NetSDKLib.NET_SCADA_DEVICE_ID_INFO)stuDeviceIDList[i]).szDeviceID, encode).trim(), deviceName);
                this.deviceIds.add(deviceID);
                model.addRow(new Object[]{deviceID, deviceName});
            }
        }
        return true;
    }

    public boolean queryDevState(int nType, NetSDKLib.SdkStructure stuInfo) {
        IntByReference intRetLen = new IntByReference();
        stuInfo.write();
        if (!LoginModule.netsdk.CLIENT_QueryDevState(LoginModule.m_hLoginHandle, nType, stuInfo.getPointer(), stuInfo.size(), intRetLen, 3000)) {
            return true;
        }
        stuInfo.read();
        return false;
    }

    public void scadaAlarmAttachInfo() {
        if (!this.isAlarmAttachInfo) {
            NetSDKLib.NET_IN_SCADA_ALARM_ATTACH_INFO stIn = new NetSDKLib.NET_IN_SCADA_ALARM_ATTACH_INFO();
            stIn.cbCallBack = SCADAAlarmAttachInfoCallBack.getINSTANCE(this.alarmAttachInfoDataTable);
            NetSDKLib.NET_OUT_SCADA_ALARM_ATTACH_INFO stOut = new NetSDKLib.NET_OUT_SCADA_ALARM_ATTACH_INFO();
            this.alarmAttachInfoHandle = LoginModule.netsdk.CLIENT_SCADAAlarmAttachInfo(LoginModule.m_hLoginHandle, stIn, stOut, 3000);
            if (this.alarmAttachInfoHandle.longValue() != 0L) {
                this.contentPane.repaint();
                this.isAlarmAttachInfo = true;
                this.btnAlarmAttachInfo.setText(Res.string().getCancel());
            }
        } else {
            this.scadaAlarmDetachInfo();
        }
    }

    public void scadaAlarmDetachInfo() {
        if (this.alarmAttachInfoHandle.longValue() != 0L) {
            LoginModule.netsdk.CLIENT_SCADAAlarmDetachInfo(this.alarmAttachInfoHandle);
            this.contentPane.repaint();
            this.isAlarmAttachInfo = false;
            this.alarmAttachInfoHandle.setValue(0L);
            this.alarmAttachInfoDataModel.getDataVector().clear();
            this.btnAlarmAttachInfo.setText(Res.string().getSCADAAttach());
        }
    }

    public void scadaAttachInfo() {
        if (!this.isBtnAttachInfo) {
            NetSDKLib.NET_IN_SCADA_ATTACH_INFO stIn = new NetSDKLib.NET_IN_SCADA_ATTACH_INFO();
            stIn.cbCallBack = SCADAAttachInfoCallBack.getInstance(this.attachInfoDataTable);
            System.err.println("\u767b\u5f55\u53e5\u67c4\uff1a " + LoginModule.m_hLoginHandle);
            NetSDKLib.NET_OUT_SCADA_ATTACH_INFO stOut = new NetSDKLib.NET_OUT_SCADA_ATTACH_INFO();
            this.attachInfoHandle = LoginModule.netsdk.CLIENT_SCADAAttachInfo(LoginModule.m_hLoginHandle, stIn, stOut, 3000);
            if (this.attachInfoHandle.longValue() != 0L) {
                this.contentPane.repaint();
                this.isBtnAttachInfo = true;
                this.btnAttachInfo.setText(Res.string().getCancel());
                System.out.println("CLIENT_SCADAAttachInfo: \u8ba2\u9605\u76d1\u6d4b\u70b9\u4f4d\u5b9e\u65f6\u4fe1\u606f\u6210\u529f\uff01");
            } else {
                JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            }
        } else {
            this.scadaDetachInfo();
        }
    }

    public void getDeviceAttribute() throws UnsupportedEncodingException {
        HashMap<Integer, String> num2PointType = new HashMap<Integer, String>(6);
        num2PointType.put(0, "UNKNOWN");
        num2PointType.put(1, "ALL");
        num2PointType.put(2, "YC");
        num2PointType.put(3, "YX");
        num2PointType.put(4, "YT");
        num2PointType.put(5, "YK");
        DefaultTableModel model = (DefaultTableModel)this.attributeDataTable.getModel();
        model.getDataVector().clear();
        for (int i = 0; i < this.deviceIds.size(); ++i) {
            String deviceId = this.deviceIds.get(i);
            int nMaxAttributeInfoNum = 20;
            NET_IN_SCADA_GET_ATTRIBUTE_INFO inParam = new NET_IN_SCADA_GET_ATTRIBUTE_INFO();
            NET_OUT_SCADA_GET_ATTRIBUTE_INFO outParam = new NET_OUT_SCADA_GET_ATTRIBUTE_INFO();
            NET_GET_CONDITION_INFO conditionInfo = new NET_GET_CONDITION_INFO();
            conditionInfo.szDeviceID = this.deviceIds.get(i).getBytes();
            conditionInfo.bIsSendID = 1;
            outParam.nMaxAttributeInfoNum = nMaxAttributeInfoNum;
            NET_ATTRIBUTE_INFO attributeInfo = new NET_ATTRIBUTE_INFO();
            outParam.pstuAttributeInfo = new Memory(nMaxAttributeInfoNum * attributeInfo.size());
            inParam.stuCondition = conditionInfo;
            inParam.write();
            outParam.write();
            boolean ret = LoginModule.netsdk.CLIENT_SCADAGetAttributeInfo(LoginModule.m_hLoginHandle, inParam.getPointer(), outParam.getPointer(), 3000);
            inParam.read();
            outParam.read();
            if (ret) {
                System.out.println("SCADAGetAttributeInfo succeed!");
                outParam.read();
                int retAttributeInfoNum = outParam.nRetAttributeInfoNum;
                System.out.println(outParam);
                Structure[] infos = new NET_ATTRIBUTE_INFO[retAttributeInfoNum];
                for (int j = 0; j < retAttributeInfoNum; ++j) {
                    infos[j] = new NET_ATTRIBUTE_INFO();
                }
                System.err.println("infos \u5927\u5c0f\uff1a " + infos.length);
                ToolKits.GetPointerDataToStructArr(outParam.pstuAttributeInfo, infos);
                for (int n = 0; n < retAttributeInfoNum; ++n) {
                    Structure out = new NET_ATTRIBUTE_INFO();
                    out = infos[n];
                    model.addRow(new Object[]{deviceId, new String(out.szSignalName, encode).trim(), out.nDelay, out.bIsValid, num2PointType.get(out.emPointType)});
                    System.out.println("\u8bbe\u5907ID\uff1a" + deviceId + "\n\u70b9\u4f4d\u7c7b\u578b: " + (String)num2PointType.get(out.emPointType) + "\n\u70b9\u4f4d\u540d\u79f0: " + new String(out.szSignalName, encode).trim() + "\n\u65f6\u5ef6: " + out.nDelay);
                }
                continue;
            }
            JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
        }
    }

    public void scadaDetachInfo() {
        if (this.attachInfoHandle.longValue() != 0L) {
            LoginModule.netsdk.CLIENT_SCADADetachInfo(this.attachInfoHandle);
            this.contentPane.repaint();
            this.isBtnAttachInfo = false;
            this.attachInfoDataModel.getDataVector().clear();
            this.btnAttachInfo.setText(Res.string().getSCADAAttach());
            System.out.println("CLIENT_SCADADetachInfo: \u53d6\u6d88\u8ba2\u9605\u76d1\u6d4b\u70b9\u4f4d\u5b9e\u65f6\u4fe1\u606f\u6210\u529f\uff01");
        }
    }

    public void startListenEx() {
        if (!this.isListen) {
            LoginModule.netsdk.CLIENT_SetDVRMessCallBack(MessCallback.getInstance(this.alarmTable), null);
            boolean b = LoginModule.netsdk.CLIENT_StartListenEx(LoginModule.m_hLoginHandle);
            if (b) {
                this.isListen = true;
                this.contentPane.repaint();
                this.btnStartListen.setText(Res.string().getCancel());
                System.out.println("CLIENT_StartListenEx success.");
            }
        } else {
            this.stopListen();
        }
    }

    public JTable tableInit(Object[][] data, String[] columnName) {
        DefaultTableModel model = new DefaultTableModel(data, columnName);
        JTable table = new JTable(model){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        table.setSelectionMode(0);
        DefaultTableCellRenderer dCellRenderer = new DefaultTableCellRenderer();
        dCellRenderer.setHorizontalAlignment(0);
        table.setDefaultRenderer(Object.class, dCellRenderer);
        return table;
    }

    public void stopListen() {
        if (this.isListen && LoginModule.netsdk.CLIENT_StopListen(LoginModule.m_hLoginHandle)) {
            this.isListen = false;
            this.contentPane.repaint();
            this.alarmModel.getDataVector().clear();
            this.btnStartListen.setText(Res.string().getStart());
        }
    }

    public SCADADemo() {
        this.setTitle(Res.string().getSCADA());
        this.setBounds(100, 100, 920, 750);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        this.setResizable(true);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LoginModule.init(DefaultDisConnect.GetInstance(), DefaultHaveReconnect.getINSTANCE());
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), Res.string().getLogin(), 1, 2, null, new Color(0, 0, 0)));
        panel.setBounds(0, 0, 905, 46);
        this.contentPane.add(panel);
        panel.setLayout(null);
        JLabel ipLabel = new JLabel(Res.string().getIp());
        ipLabel.setBounds(10, 15, 44, 21);
        panel.add(ipLabel);
        this.ipTextField = new JTextField();
        this.ipTextField.setText("172.3.0.223");
        this.ipTextField.setBounds(64, 15, 89, 21);
        panel.add(this.ipTextField);
        this.ipTextField.setColumns(10);
        JLabel portLabel = new JLabel(Res.string().getPort());
        portLabel.setBounds(174, 15, 44, 21);
        panel.add(portLabel);
        this.portTextField = new JTextField();
        this.portTextField.setText("37777");
        this.portTextField.setColumns(10);
        this.portTextField.setBounds(228, 15, 66, 21);
        panel.add(this.portTextField);
        JLabel lblName = new JLabel(Res.string().getUserName());
        lblName.setBounds(316, 15, 66, 21);
        panel.add(lblName);
        this.userNameTextField = new JTextField();
        this.userNameTextField.setText("admin");
        this.userNameTextField.setColumns(10);
        this.userNameTextField.setBounds(383, 15, 87, 21);
        panel.add(this.userNameTextField);
        JLabel lblPassword = new JLabel(Res.string().getPassword());
        lblPassword.setBounds(492, 15, 66, 21);
        panel.add(lblPassword);
        this.passwordField = new JPasswordField();
        this.passwordField.setBounds(568, 15, 112, 21);
        this.passwordField.setText("admin123");
        panel.add(this.passwordField);
        this.btnLogin = new JButton(Res.string().getLogin());
        this.btnLogin.setBounds(684, 14, 99, 23);
        panel.add(this.btnLogin);
        this.btnLogin.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                SCADADemo.this.login();
            }
        });
        this.btnLogout = new JButton(Res.string().getLogout());
        this.btnLogout.setBounds(785, 14, 110, 23);
        panel.add(this.btnLogout);
        this.btnLogout.setEnabled(false);
        this.btnLogout.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                SCADADemo.this.logout();
                LoginModule.cleanup();
                SCADADemo.this.dispose();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FunctionList demo = new FunctionList();
                        demo.setVisible(true);
                    }
                });
            }
        });
        JPanel devicesPanel = new JPanel();
        devicesPanel.setBorder(new TitledBorder(null, Res.string().getSCADADeviceList(), 1, 2, null, new Color(0, 0, 0)));
        devicesPanel.setBounds(0, 50, 450, 260);
        this.contentPane.add(devicesPanel);
        devicesPanel.setLayout(new BorderLayout(0, 0));
        this.btnGetDeviceList = new JButton(Res.string().getListBtn());
        this.btnGetDeviceList.setBounds(260, 315, 100, 29);
        this.contentPane.add(this.btnGetDeviceList);
        this.btnGetDeviceList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                SCADADemo.this.getDeviceIdList();
            }
        });
        this.devicesData = new Object[0][3];
        this.devicesDataTable = this.tableInit(this.devicesData, this.devicesDataTitle);
        this.devicesDataModel = (DefaultTableModel)this.devicesDataTable.getModel();
        JScrollPane deviceScrollPane = new JScrollPane(this.devicesDataTable);
        deviceScrollPane.setHorizontalScrollBarPolicy(30);
        devicesPanel.add((Component)deviceScrollPane, "Center");
        JPanel pointListPanel = new JPanel();
        pointListPanel.setBorder(new TitledBorder(null, Res.string().getSCADAPointList(), 1, 2, null, new Color(0, 0, 0)));
        pointListPanel.setBounds(0, 350, 450, 260);
        this.contentPane.add(pointListPanel);
        pointListPanel.setLayout(new BorderLayout(0, 0));
        this.btnGetSCADAAttribute = new JButton(Res.string().getListBtn());
        this.btnGetSCADAAttribute.setBounds(260, 615, 100, 29);
        this.contentPane.add(this.btnGetSCADAAttribute);
        this.btnGetSCADAAttribute.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    SCADADemo.this.getDeviceAttribute();
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
            }
        });
        this.attributeData = new Object[0][3];
        this.attributeDataTable = this.tableInit(this.attributeData, this.attributeDataTitle);
        this.attributeDataModel = (DefaultTableModel)this.attributeDataTable.getModel();
        JScrollPane attributeDataScrollPane = new JScrollPane(this.attributeDataTable);
        attributeDataScrollPane.setHorizontalScrollBarPolicy(30);
        pointListPanel.add((Component)attributeDataScrollPane, "Center");
        JPanel attachAlarmPanel = new JPanel();
        attachAlarmPanel.setBorder(new TitledBorder(null, Res.string().getSCADAAlarmAttachInfo(), 1, 2, null, new Color(0, 0, 0)));
        attachAlarmPanel.setBounds(450, 50, 450, 170);
        this.contentPane.add(attachAlarmPanel);
        attachAlarmPanel.setLayout(new BorderLayout(0, 0));
        this.btnAlarmAttachInfo = new JButton(Res.string().getSCADAAttach());
        this.btnAlarmAttachInfo.setBounds(450, 225, 100, 29);
        this.contentPane.add(this.btnAlarmAttachInfo);
        this.btnAlarmAttachInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SCADADemo.this.scadaAlarmAttachInfo();
            }
        });
        this.alarmAttachInfoData = new Object[0][3];
        this.alarmAttachInfoDataTable = this.tableInit(this.alarmAttachInfoData, this.alarmAttachInfoDataTitle);
        this.alarmAttachInfoDataModel = (DefaultTableModel)this.alarmAttachInfoDataTable.getModel();
        JScrollPane alarmAttachInfoDataScrollPane = new JScrollPane(this.alarmAttachInfoDataTable);
        alarmAttachInfoDataScrollPane.setHorizontalScrollBarPolicy(30);
        attachAlarmPanel.add((Component)alarmAttachInfoDataScrollPane, "Center");
        JPanel attachPanel = new JPanel();
        attachPanel.setBorder(new TitledBorder(null, Res.string().getSCADAAttach(), 1, 2, null, new Color(0, 0, 0)));
        attachPanel.setBounds(450, 270, 450, 170);
        this.contentPane.add(attachPanel);
        attachPanel.setLayout(new BorderLayout(0, 0));
        this.btnStartListen = new JButton(Res.string().getSCADAAttach());
        this.btnStartListen.setBounds(450, 445, 100, 29);
        this.contentPane.add(this.btnStartListen);
        this.btnStartListen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SCADADemo.this.startListenEx();
            }
        });
        this.alarmData = new Object[0][3];
        this.alarmTable = this.tableInit(this.alarmData, this.alarmTableTitle);
        this.alarmModel = (DefaultTableModel)this.alarmTable.getModel();
        JScrollPane scrollPane = new JScrollPane(this.alarmTable);
        scrollPane.setHorizontalScrollBarPolicy(30);
        attachPanel.add((Component)scrollPane, "Center");
        boolean isBtnGetDeviceList = false;
        JPanel attachInfoPanel = new JPanel();
        attachInfoPanel.setBorder(new TitledBorder(null, Res.string().getSCADAAttachInfo(), 1, 2, null, new Color(0, 0, 0)));
        attachInfoPanel.setBounds(450, 480, 450, 170);
        this.contentPane.add(attachInfoPanel);
        attachInfoPanel.setLayout(new BorderLayout(0, 0));
        this.btnAttachInfo = new JButton(Res.string().getSCADAAttach());
        this.btnAttachInfo.setBounds(450, 655, 100, 29);
        this.contentPane.add(this.btnAttachInfo);
        this.btnAttachInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SCADADemo.this.scadaAttachInfo();
            }
        });
        this.attachInfoData = new Object[0][3];
        this.attachInfoDataTable = this.tableInit(this.attachInfoData, this.attachInfoDataTitle);
        this.attachInfoDataModel = (DefaultTableModel)this.attachInfoDataTable.getModel();
        JScrollPane attachInfoDataScrollPane = new JScrollPane(this.attachInfoDataTable);
        attachInfoDataScrollPane.setHorizontalScrollBarPolicy(30);
        attachInfoPanel.add((Component)attachInfoDataScrollPane, "Center");
        this.setButtonEnable(false);
        this.btnLogin.setEnabled(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (LoginModule.m_hLoginHandle.longValue() != 0L) {
                    SCADADemo.this.logout();
                }
                LoginModule.cleanup();
                SCADADemo.this.dispose();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FunctionList demo = new FunctionList();
                        demo.setVisible(true);
                    }
                });
            }
        });
    }

    private static class SCADAAttachInfoCallBack
    implements NetSDKLib.fSCADAAttachInfoCallBack {
        private JTable attachInfoTable;
        private static SCADAAttachInfoCallBack INSTANCE;

        private SCADAAttachInfoCallBack(JTable attachInfoTable) {
            this.attachInfoTable = attachInfoTable;
        }

        public static final SCADAAttachInfoCallBack getInstance(JTable table) {
            if (INSTANCE == null) {
                INSTANCE = new SCADAAttachInfoCallBack(table);
            }
            if (table != null) {
                SCADAAttachInfoCallBack.INSTANCE.attachInfoTable = table;
            }
            return INSTANCE;
        }

        @Override
        public void invoke(NetSDKLib.LLong lLoginID, NetSDKLib.LLong lAttachHandle, NetSDKLib.NET_SCADA_NOTIFY_POINT_INFO_LIST pInfo, int nBufLen, Pointer dwUser) {
            System.out.println("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u3010\u8ba2\u9605\u76d1\u6d4b\u70b9\u4f4d\u4fe1\u606f\u56de\u8c03\u3011\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014");
            if (this.attachInfoTable != null) {
                DefaultTableModel model = (DefaultTableModel)this.attachInfoTable.getModel();
                for (int i = 0; i < pInfo.nList; ++i) {
                    String deviceName = new String(pInfo.stuList[i].szDevName, encode).trim();
                    String time = pInfo.stuList[i].stuCollectTime.toStringTime();
                    System.out.println(" \u8bbe\u5907\u540d\u79f0:" + deviceName);
                    System.out.println(" \u91c7\u96c6\u65f6\u95f4:" + time);
                    System.out.println(" \u70b9\u4f4dID:" + new String(pInfo.stuList[i].szID).trim());
                    model.addRow(new Object[]{deviceName, time, new String(pInfo.stuList[i].szID).trim()});
                }
            }
            System.out.println("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u3010\u8ba2\u9605\u76d1\u6d4b\u70b9\u4f4d\u4fe1\u606f\u56de\u8c03\u3011\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014");
        }
    }

    private static class DisConnect
    implements NetSDKLib.fDisConnect {
        private DisConnect() {
        }

        @Override
        public void invoke(NetSDKLib.LLong m_hLoginHandle, String pchDVRIP, int nDVRPort, Pointer dwUser) {
            System.out.printf("Device[%s] Port[%d] DisConnect!\n", pchDVRIP, nDVRPort);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.setTitle(Res.string().getSCADA() + " : " + Res.string().getDisConnectReconnecting());
                }
            });
        }
    }

    private static class MessCallback
    implements NetSDKLib.fMessCallBack {
        private static MessCallback INSTANCE;
        private JTable table;

        private MessCallback(JTable table) {
            this.table = table;
        }

        public static MessCallback getInstance(JTable table) {
            if (INSTANCE == null) {
                INSTANCE = new MessCallback(table);
            }
            if (table != null) {
                MessCallback.INSTANCE.table = table;
            }
            return INSTANCE;
        }

        @Override
        public boolean invoke(int lCommand, NetSDKLib.LLong lLoginID, Pointer pStuEvent, int dwBufLen, String strDeviceIP, NativeLong nDevicePort, Pointer dwUser) {
            switch (lCommand) {
                case 12706: {
                    NetSDKLib.ALARM_SCADA_DEV_INFO msg = new NetSDKLib.ALARM_SCADA_DEV_INFO();
                    ToolKits.GetPointerData(pStuEvent, msg);
                    String deviceId = new String(msg.szDevID, encode).trim();
                    System.out.println("[\u68c0\u6d4b\u91c7\u96c6\u8bbe\u5907\u62a5\u8b66\u4e8b\u4ef6] nChannel :" + msg.nChannel);
                    System.out.println("\u8bbe\u5907ID :" + deviceId);
                    String description = new String(msg.szDesc, encode).trim();
                    String deviceName = new String(msg.szDevName, encode).trim();
                    System.out.println(" nAction :" + msg.nAction + " nAlarmFlag :" + msg.nAlarmFlag + "\n\u6545\u969c\u8bbe\u5907\u540d\u79f0" + deviceName + "\n\u63cf\u8ff0" + description + "\u65f6\u95f4" + msg.stuTime);
                    if (this.table == null) break;
                    DefaultTableModel model = (DefaultTableModel)this.table.getModel();
                    model.addRow(new Object[]{deviceId, deviceName, msg.nChannel, description});
                    break;
                }
                default: {
                    System.out.println("What's lCommand: " + lCommand);
                }
            }
            return true;
        }
    }
}

