/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.vto;

import com.netsdk.common.Base64;
import com.netsdk.common.PaintPanel;
import com.netsdk.common.Res;
import com.netsdk.demo.frame.vto.CollectionFingerPrint;
import com.netsdk.demo.module.LoginModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.Memory;
import com.sun.jna.Structure;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OperateInfo
extends JDialog {
    private final JPanel contentPanel = new JPanel();
    private JTextField cardNoTextField;
    private JTextField roomNoTextField;
    private CollectionFingerPrint fingerPrint = new CollectionFingerPrint();
    private PaintPanel paintPanel;
    private Memory memory;
    private JCheckBox needFingerCheckBox;
    private boolean bListen = false;
    private int infoType;
    private String userId;
    private String cardNo;
    private String fingerPrintData;

    public void setCardNoTextFieldEditEnable(boolean enable) {
        this.cardNoTextField.setEditable(enable);
    }

    public void setRoomNoTextFieldEditEnable(boolean enable) {
        this.roomNoTextField.setEditable(enable);
    }

    public void syncData(String userId, String cardNo, String fingerPrintData) {
        this.userId = userId;
        this.cardNo = cardNo;
        this.fingerPrintData = fingerPrintData;
        if (fingerPrintData == null || fingerPrintData.trim().equals("")) {
            this.needFingerCheckBox.setSelected(false);
        } else {
            this.needFingerCheckBox.setSelected(true);
        }
        this.cardNoTextField.setText(cardNo);
        this.roomNoTextField.setText(userId);
    }

    public int getInfoType() {
        return this.infoType;
    }

    public void setInfoType(int infoType) {
        this.infoType = infoType;
    }

    public void receiveData(int infoType, String userId, String cardNo, String fingerPrintData) {
        this.infoType = infoType;
        if (infoType == 0) {
            this.userId = "";
            this.cardNo = "";
            this.fingerPrintData = "";
        } else if (infoType == 1) {
            this.userId = userId;
            this.cardNo = cardNo;
            this.fingerPrintData = fingerPrintData;
        }
        this.cardNoTextField.setText(this.cardNo);
        this.roomNoTextField.setText(this.userId);
        if (!this.fingerPrintData.trim().equals("")) {
            this.needFingerCheckBox.setSelected(true);
        } else {
            this.needFingerCheckBox.setSelected(false);
        }
    }

    public static void main(String[] args) {
        try {
            OperateInfo dialog = new OperateInfo();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OperateInfo() {
        this.setTitle(Res.string().getVTOOperateInfoTitle());
        this.setDefaultCloseOperation(2);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        this.setBounds(100, 100, 476, 294);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(null);
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(null, Res.string().getCardInfo(), 1, 2, null, null));
        panel.setBounds(0, 0, 285, 87);
        this.contentPanel.add(panel);
        panel.setLayout(null);
        JLabel lblNewLabel = new JLabel(Res.string().getCardNo());
        lblNewLabel.setBounds(10, 22, 89, 15);
        panel.add(lblNewLabel);
        this.cardNoTextField = new JTextField();
        this.cardNoTextField.setBounds(111, 19, 164, 21);
        panel.add(this.cardNoTextField);
        this.cardNoTextField.setColumns(10);
        JLabel lblNewLabel_1 = new JLabel(Res.string().getVTOOperateManagerRoomNo());
        lblNewLabel_1.setBounds(10, 62, 96, 15);
        panel.add(lblNewLabel_1);
        this.roomNoTextField = new JTextField();
        this.roomNoTextField.setColumns(10);
        this.roomNoTextField.setBounds(111, 59, 164, 21);
        panel.add(this.roomNoTextField);
        this.needFingerCheckBox = new JCheckBox(Res.string().getNeedFingerPrint());
        this.needFingerCheckBox.setSelected(true);
        this.needFingerCheckBox.setBounds(6, 106, 190, 23);
        this.contentPanel.add(this.needFingerCheckBox);
        panel = new JPanel();
        panel.setBorder(new TitledBorder(null, Res.string().getFingerPrint(), 1, 2, null, null));
        panel.setBounds(0, 135, 285, 84);
        this.contentPanel.add(panel);
        panel.setLayout(null);
        JLabel lblNewLabel_2 = new JLabel(Res.string().getFingerPrint());
        lblNewLabel_2.setBounds(10, 35, 109, 28);
        panel.add(lblNewLabel_2);
        final JButton btnGetFinger = new JButton(Res.string().getGet());
        btnGetFinger.setBounds(129, 38, 93, 23);
        panel.add(btnGetFinger);
        btnGetFinger.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (OperateInfo.this.fingerPrint == null) {
                    OperateInfo.this.fingerPrint = new CollectionFingerPrint();
                    OperateInfo.this.fingerPrint.setVisible(true);
                    OperateInfo.this.fingerPrint.setFocusable(true);
                } else {
                    OperateInfo.this.fingerPrint.dispose();
                    OperateInfo.this.fingerPrint.setVisible(true);
                }
            }
        });
        this.needFingerCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                if (checkBox.isSelected()) {
                    btnGetFinger.setEnabled(true);
                } else {
                    btnGetFinger.setEnabled(false);
                }
            }
        });
        this.paintPanel = new PaintPanel();
        this.paintPanel.setBackground(Color.GRAY);
        this.paintPanel.setBorder(new TitledBorder(null, Res.string().getFaceInfo(), 4, 2, null, null));
        this.paintPanel.setBounds(295, 10, 155, 209);
        this.contentPanel.add(this.paintPanel);
        this.paintPanel.setLayout(null);
        JButton open = new JButton(Res.string().getOpen());
        open.setBounds(26, 90, 93, 23);
        this.paintPanel.add(open);
        open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String picPath = "";
                picPath = ToolKits.openPictureFile(OperateInfo.this.paintPanel);
                if (!picPath.equals("")) {
                    try {
                        OperateInfo.this.memory = ToolKits.readPictureFile(picPath);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("OK");
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        okButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (OperateInfo.this.fingerPrint.isCollectionResult()) {
                    OperateInfo.this.fingerPrintData = Base64.getEncoder().encodeToString(OperateInfo.this.fingerPrint.getPackageData()).trim();
                }
                if (OperateInfo.this.infoType == 0) {
                    if (!OperateInfo.this.checkCardNo(OperateInfo.this.cardNoTextField.getText().trim().getBytes(), true)) {
                        return;
                    }
                    if (!OperateInfo.this.addCard(OperateInfo.this.cardNoTextField.getText().trim().getBytes(), OperateInfo.this.roomNoTextField.getText().getBytes(), OperateInfo.this.needFingerCheckBox.isSelected() ? 1 : 0, OperateInfo.this.fingerPrintData)) {
                        return;
                    }
                } else if (OperateInfo.this.infoType == 1) {
                    if (!OperateInfo.this.checkCardNo(OperateInfo.this.cardNoTextField.getText().trim().getBytes(), false)) {
                        return;
                    }
                    if (!OperateInfo.this.modifyCard(OperateInfo.this.cardNoTextField.getText().trim().getBytes(), OperateInfo.this.roomNoTextField.getText().trim().getBytes(), OperateInfo.this.needFingerCheckBox.isSelected() ? 1 : 0, OperateInfo.this.fingerPrintData)) {
                        return;
                    }
                }
                OperateInfo.this.dispose();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        cancelButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                OperateInfo.this.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                if (OperateInfo.this.fingerPrint.isCollectionResult()) {
                    OperateInfo.this.fingerPrint.clearStatus();
                }
            }
        });
    }

    public boolean checkCardNo(byte[] cardNo, boolean type) {
        if (cardNo.length == 0) {
            JOptionPane.showMessageDialog(null, Res.string().getInputCardNo(), Res.string().getErrorMessage(), 0);
            return false;
        }
        NetSDKLib.NET_IN_FIND_RECORD_PARAM inParam = new NetSDKLib.NET_IN_FIND_RECORD_PARAM();
        inParam.emType = 4;
        NetSDKLib.FIND_RECORD_ACCESSCTLCARD_CONDITION condition = new NetSDKLib.FIND_RECORD_ACCESSCTLCARD_CONDITION();
        condition.abCardNo = 1;
        if (cardNo.length > condition.szCardNo.length - 1) {
            JOptionPane.showMessageDialog(null, Res.string().getCardNoExceedLength(), Res.string().getErrorMessage(), 0);
            return false;
        }
        System.arraycopy(cardNo, 0, condition.szCardNo, 0, cardNo.length);
        inParam.pQueryCondition = new Memory(condition.size());
        ToolKits.SetStructDataToPointer(condition, inParam.pQueryCondition, 0L);
        NetSDKLib.NET_OUT_FIND_RECORD_PARAM outParam = new NetSDKLib.NET_OUT_FIND_RECORD_PARAM();
        boolean startFind = LoginModule.netsdk.CLIENT_FindRecord(LoginModule.m_hLoginHandle, inParam, outParam, 5000);
        if (!startFind) {
            JOptionPane.showMessageDialog(null, Res.string().getQueryCardExistFailed(), Res.string().getErrorMessage(), 0);
            return false;
        }
        int max = 1;
        NetSDKLib.NET_IN_FIND_NEXT_RECORD_PARAM inNextParam = new NetSDKLib.NET_IN_FIND_NEXT_RECORD_PARAM();
        inNextParam.lFindeHandle = outParam.lFindeHandle;
        inNextParam.nFileCount = max;
        NetSDKLib.NET_OUT_FIND_NEXT_RECORD_PARAM outNextParam = new NetSDKLib.NET_OUT_FIND_NEXT_RECORD_PARAM();
        outNextParam.nMaxRecordNum = max;
        Structure[] card = new NetSDKLib.NET_RECORDSET_ACCESS_CTL_CARD[]{new NetSDKLib.NET_RECORDSET_ACCESS_CTL_CARD()};
        outNextParam.pRecordList = new Memory(card[0].size() * max);
        ToolKits.SetStructArrToPointerData(card, outNextParam.pRecordList);
        LoginModule.netsdk.CLIENT_FindNextRecord(inNextParam, outNextParam, 5000);
        if (outNextParam.nRetRecordNum != 0 && type) {
            JOptionPane.showMessageDialog(null, Res.string().getFindCardExist(), Res.string().getErrorMessage(), 0);
            LoginModule.netsdk.CLIENT_FindRecordClose(outParam.lFindeHandle);
            return false;
        }
        LoginModule.netsdk.CLIENT_FindRecordClose(outParam.lFindeHandle);
        return true;
    }

    public boolean addCard(byte[] cardNo, byte[] userID, int enableFinger, String fingerPrintData) {
        if (cardNo.length == 0) {
            JOptionPane.showMessageDialog(null, Res.string().getInputCardNo(), Res.string().getErrorMessage(), 0);
            return false;
        }
        if (userID.length == 0) {
            JOptionPane.showMessageDialog(null, Res.string().getInputRoomNo(), Res.string().getErrorMessage(), 0);
            return false;
        }
        if (this.memory == null) {
            JOptionPane.showMessageDialog(null, Res.string().getChooseFacePic(), Res.string().getErrorMessage(), 0);
            return false;
        }
        NetSDKLib.NET_RECORDSET_ACCESS_CTL_CARD card = new NetSDKLib.NET_RECORDSET_ACCESS_CTL_CARD();
        if (cardNo.length > card.szCardNo.length - 1) {
            JOptionPane.showMessageDialog(null, Res.string().getCardNoExceedLength(), Res.string().getErrorMessage(), 0);
            return false;
        }
        if (userID.length > card.szUserID.length - 1) {
            JOptionPane.showMessageDialog(null, Res.string().getRoomNoExceedLength(), Res.string().getErrorMessage(), 0);
            return false;
        }
        System.arraycopy(cardNo, 0, card.szCardNo, 0, cardNo.length);
        System.arraycopy(userID, 0, card.szUserID, 0, userID.length);
        card.nDoorNum = 1;
        card.sznDoors[0] = 0;
        if (enableFinger == 1) {
            if (fingerPrintData == null || fingerPrintData.trim().equals("")) {
                JOptionPane.showMessageDialog(null, Res.string().getFingerPrintIdNotExist(), Res.string().getErrorMessage(), 0);
                return false;
            }
            byte[] bytes = Base64.getDecoder().decode(fingerPrintData);
            card.bEnableExtended = 1;
            card.stuFingerPrintInfoEx.nCount = 1;
            card.stuFingerPrintInfoEx.nLength = bytes.length;
            card.stuFingerPrintInfoEx.nPacketLen = bytes.length;
            card.stuFingerPrintInfoEx.pPacketData = new Memory(bytes.length);
            card.stuFingerPrintInfoEx.pPacketData.clear(bytes.length);
            card.stuFingerPrintInfoEx.pPacketData.write(0L, bytes, 0, bytes.length);
        } else {
            card.bEnableExtended = 0;
        }
        NetSDKLib.NET_CTRL_RECORDSET_INSERT_PARAM inParam = new NetSDKLib.NET_CTRL_RECORDSET_INSERT_PARAM();
        inParam.stuCtrlRecordSetInfo.emType = 4;
        inParam.stuCtrlRecordSetInfo.nBufLen = card.size();
        inParam.stuCtrlRecordSetInfo.pBuf = new Memory(card.size());
        ToolKits.SetStructDataToPointer(card, inParam.stuCtrlRecordSetInfo.pBuf, 0L);
        Memory pointer = new Memory(inParam.size());
        ToolKits.SetStructDataToPointer(inParam, pointer, 0L);
        boolean res = LoginModule.netsdk.CLIENT_ControlDevice(LoginModule.m_hLoginHandle, 414, pointer, 5000);
        if (!res) {
            JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return res;
        }
        ToolKits.GetPointerData(pointer, inParam);
        if (this.memory != null) {
            NetSDKLib.NET_IN_ADD_FACE_INFO inAddFaceInfo = new NetSDKLib.NET_IN_ADD_FACE_INFO();
            System.arraycopy(userID, 0, inAddFaceInfo.szUserID, 0, userID.length);
            inAddFaceInfo.stuFaceInfo.nFacePhoto = 1;
            inAddFaceInfo.stuFaceInfo.nFacePhotoLen[0] = (int)this.memory.size();
            inAddFaceInfo.stuFaceInfo.pszFacePhotoArr[0].pszFacePhoto = new Memory(this.memory.size());
            inAddFaceInfo.stuFaceInfo.pszFacePhotoArr[0].pszFacePhoto.write(0L, this.memory.getByteArray(0L, (int)this.memory.size()), 0, (int)this.memory.size());
            inAddFaceInfo.stuFaceInfo.nRoom = 1;
            System.arraycopy(userID, 0, inAddFaceInfo.stuFaceInfo.szRoomNoArr[0].szRoomNo, 0, userID.length);
            NetSDKLib.NET_OUT_ADD_FACE_INFO outAddFaceInfo = new NetSDKLib.NET_OUT_ADD_FACE_INFO();
            Memory outFaceParam = new Memory(outAddFaceInfo.size());
            ToolKits.SetStructDataToPointer(outAddFaceInfo, outFaceParam, 0L);
            Memory inFace = new Memory(inAddFaceInfo.size());
            ToolKits.SetStructDataToPointer(inAddFaceInfo, inFace, 0L);
            boolean result = LoginModule.netsdk.CLIENT_FaceInfoOpreate(LoginModule.m_hLoginHandle, 0, inFace, outFaceParam, 10000);
            if (!result) {
                JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                return false;
            }
        }
        return true;
    }

    public boolean modifyCard(byte[] cardNo, byte[] userID, int enableFinger, String fingerPrintData) {
        NetSDKLib.NET_RECORDSET_ACCESS_CTL_CARD card = new NetSDKLib.NET_RECORDSET_ACCESS_CTL_CARD();
        NetSDKLib.NET_CTRL_RECORDSET_PARAM inParam = new NetSDKLib.NET_CTRL_RECORDSET_PARAM();
        inParam.emType = 4;
        card.nDoorNum = 1;
        card.sznDoors[0] = 0;
        System.arraycopy(cardNo, 0, card.szCardNo, 0, cardNo.length);
        System.arraycopy(userID, 0, card.szUserID, 0, userID.length);
        if (enableFinger == 1) {
            if (fingerPrintData == null || fingerPrintData.trim().equals("")) {
                JOptionPane.showMessageDialog(null, Res.string().getFingerPrintIdNotExist(), Res.string().getErrorMessage(), 0);
                return false;
            }
            byte[] data = Base64.getDecoder().decode(fingerPrintData);
            card.bEnableExtended = 1;
            card.stuFingerPrintInfoEx.nCount = 1;
            card.stuFingerPrintInfoEx.nLength = data.length;
            card.stuFingerPrintInfoEx.nPacketLen = data.length;
            card.stuFingerPrintInfoEx.pPacketData = new Memory(data.length);
            card.stuFingerPrintInfoEx.pPacketData.clear(data.length);
            card.stuFingerPrintInfoEx.pPacketData.write(0L, data, 0, data.length);
        } else {
            card.bEnableExtended = 0;
        }
        inParam.pBuf = new Memory(card.size());
        ToolKits.SetStructDataToPointer(card, inParam.pBuf, 0L);
        Memory pointer = new Memory(inParam.size());
        ToolKits.SetStructDataToPointer(inParam, pointer, 0L);
        boolean res = LoginModule.netsdk.CLIENT_ControlDevice(LoginModule.m_hLoginHandle, 415, pointer, 10000);
        if (!res) {
            JOptionPane.showMessageDialog(null, Res.string().getFailedModifyCard() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return res;
        }
        if (this.memory != null) {
            NetSDKLib.NET_IN_UPDATE_FACE_INFO inUpdateFaceInfo = new NetSDKLib.NET_IN_UPDATE_FACE_INFO();
            System.arraycopy(userID, 0, inUpdateFaceInfo.szUserID, 0, userID.length);
            inUpdateFaceInfo.stuFaceInfo.nFacePhoto = 1;
            inUpdateFaceInfo.stuFaceInfo.nFacePhotoLen[0] = (int)this.memory.size();
            inUpdateFaceInfo.stuFaceInfo.pszFacePhotoArr[0].pszFacePhoto = new Memory(this.memory.size());
            inUpdateFaceInfo.stuFaceInfo.pszFacePhotoArr[0].pszFacePhoto.write(0L, this.memory.getByteArray(0L, (int)this.memory.size()), 0, (int)this.memory.size());
            inUpdateFaceInfo.stuFaceInfo.nRoom = 1;
            System.arraycopy(userID, 0, inUpdateFaceInfo.stuFaceInfo.szRoomNoArr[0].szRoomNo, 0, userID.length);
            NetSDKLib.NET_OUT_UPDATE_FACE_INFO outUpdateFaceInfo = new NetSDKLib.NET_OUT_UPDATE_FACE_INFO();
            Memory inUpdateParam = new Memory(inUpdateFaceInfo.size());
            ToolKits.SetStructDataToPointer(inUpdateFaceInfo, inUpdateParam, 0L);
            Memory outUpdateParam = new Memory(outUpdateFaceInfo.size());
            ToolKits.SetStructDataToPointer(outUpdateFaceInfo, outUpdateParam, 0L);
            boolean result = LoginModule.netsdk.CLIENT_FaceInfoOpreate(LoginModule.m_hLoginHandle, 2, inUpdateParam, outUpdateParam, 5000);
            if (!result) {
                JOptionPane.showMessageDialog(null, Res.string().getFailedModifyCard() + "," + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                return result;
            }
        }
        return true;
    }

    public void clearImage() {
        this.paintPanel.setOpaque(false);
        this.paintPanel.setImage(null);
        this.paintPanel.repaint();
        this.memory = null;
    }
}

