/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.vto;

import com.netsdk.common.Base64;
import com.netsdk.common.Res;
import com.netsdk.demo.frame.vto.OperateInfo;
import com.netsdk.demo.module.LoginModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.Memory;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class OperateManager
extends JDialog {
    private NetSDKLib.LLong lFindHandle;
    private JPanel contentPane;
    private OperateInfo info;
    private JTextField textField;
    private JTable table;
    private Object[][] data;
    private String[] tableTitle = new String[]{Res.string().getVTOOperateManagerRecNo(), Res.string().getVTOOperateManagerRoomNo(), Res.string().getVTOOperateManagerCardNo(), Res.string().getVTOOperateManagerFingerPrintData()};

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    OperateManager dialogManager = new OperateManager();
                    dialogManager.setDefaultCloseOperation(2);
                    dialogManager.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public OperateManager() {
        this.setDefaultCloseOperation(2);
        this.setTitle(Res.string().getVTOOperateManagerTitle());
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        this.setBounds(100, 100, 547, 414);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(null, Res.string().getCardInfo(), 1, 2, null, null));
        panel.setBounds(0, 10, 328, 356);
        this.contentPane.add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        panel.add((Component)scrollPane, "Center");
        this.data = new Object[0][5];
        this.table = this.tableInit(this.data, this.tableTitle);
        scrollPane.setViewportView(this.table);
        JLabel lblNewLabel = new JLabel(Res.string().getVTORealLoadCardNo());
        lblNewLabel.setBounds(338, 24, 95, 20);
        this.contentPane.add(lblNewLabel);
        this.textField = new JTextField();
        this.textField.setBounds(338, 54, 136, 21);
        this.contentPane.add(this.textField);
        this.textField.setColumns(10);
        JButton btnSearch = new JButton(Res.string().getSearch());
        btnSearch.setBounds(338, 85, 136, 23);
        this.contentPane.add(btnSearch);
        btnSearch.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                OperateManager.this.search();
            }
        });
        JButton btnAdd = new JButton(Res.string().getAdd());
        btnAdd.setBounds(338, 138, 136, 23);
        this.contentPane.add(btnAdd);
        btnAdd.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (OperateManager.this.info == null) {
                    OperateManager.this.info = new OperateInfo();
                    OperateManager.this.info.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosed(WindowEvent e) {
                            super.windowClosed(e);
                            OperateManager.this.search();
                        }
                    });
                }
                OperateManager.this.info.setVisible(true);
                OperateManager.this.info.setCardNoTextFieldEditEnable(true);
                OperateManager.this.info.setRoomNoTextFieldEditEnable(true);
                OperateManager.this.info.setFocusable(true);
                OperateManager.this.info.receiveData(0, "", "", "");
                OperateManager.this.info.clearImage();
            }
        });
        JButton btnModify = new JButton(Res.string().getModify());
        btnModify.setBounds(338, 193, 136, 23);
        this.contentPane.add(btnModify);
        btnModify.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (OperateManager.this.table.getSelectedRowCount() != 1) {
                    JOptionPane.showMessageDialog(null, Res.string().getSelectCard(), Res.string().getErrorMessage(), 0);
                    return;
                }
                if (OperateManager.this.table.getSelectedRowCount() == 1) {
                    if (OperateManager.this.info == null) {
                        OperateManager.this.info = new OperateInfo();
                        OperateManager.this.info.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosed(WindowEvent e) {
                                super.windowClosed(e);
                                OperateManager.this.search();
                            }
                        });
                    }
                    OperateManager.this.info.setVisible(true);
                    OperateManager.this.info.setCardNoTextFieldEditEnable(false);
                    OperateManager.this.info.setRoomNoTextFieldEditEnable(false);
                    OperateManager.this.info.setFocusable(true);
                    OperateManager.this.info.receiveData(1, ((String)OperateManager.this.table.getModel().getValueAt(OperateManager.this.table.getSelectedRow(), 1)).trim(), ((String)OperateManager.this.table.getModel().getValueAt(OperateManager.this.table.getSelectedRow(), 2)).trim(), ((String)OperateManager.this.table.getModel().getValueAt(OperateManager.this.table.getSelectedRow(), 3)).trim());
                    OperateManager.this.info.clearImage();
                    OperateManager.this.info.setVisible(true);
                    OperateManager.this.info.setFocusable(true);
                }
            }
        });
        JButton btnDelete = new JButton(Res.string().getDelete());
        btnDelete.setBounds(338, 245, 136, 23);
        this.contentPane.add(btnDelete);
        btnDelete.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                OperateManager.this.delete();
                OperateManager.this.search();
            }
        });
        JButton btnClear = new JButton(Res.string().getClear());
        btnClear.setBounds(338, 303, 136, 23);
        this.contentPane.add(btnClear);
        btnClear.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                OperateManager.this.clear();
                OperateManager.this.search();
            }
        });
    }

    public JTable tableInit(Object[][] data, String[] columnName) {
        DefaultTableModel model = new DefaultTableModel(data, columnName);
        JTable table = new JTable(model){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        model = (DefaultTableModel)table.getModel();
        table.setSelectionMode(0);
        DefaultTableCellRenderer dCellRenderer = new DefaultTableCellRenderer();
        dCellRenderer.setHorizontalAlignment(0);
        table.setDefaultRenderer(Object.class, dCellRenderer);
        return table;
    }

    public void search() {
        boolean bRet;
        if (this.lFindHandle != null && this.lFindHandle.longValue() != 0L) {
            LoginModule.netsdk.CLIENT_FindRecordClose(this.lFindHandle);
            this.lFindHandle = null;
        }
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        model.setRowCount(0);
        NetSDKLib.NET_IN_FIND_RECORD_PARAM inParam = new NetSDKLib.NET_IN_FIND_RECORD_PARAM();
        NetSDKLib.NET_OUT_FIND_RECORD_PARAM outParam = new NetSDKLib.NET_OUT_FIND_RECORD_PARAM();
        inParam.emType = 4;
        NetSDKLib.FIND_RECORD_ACCESSCTLCARD_CONDITION condition = new NetSDKLib.FIND_RECORD_ACCESSCTLCARD_CONDITION();
        if (this.textField.getText() != null && !this.textField.getText().equals("")) {
            condition.abCardNo = 1;
            String cardNo = this.textField.getText();
            System.arraycopy(cardNo.getBytes(), 0, condition.szCardNo, 0, cardNo.getBytes().length);
            inParam.pQueryCondition = new Memory(condition.size());
            ToolKits.SetStructDataToPointer(condition, inParam.pQueryCondition, 0L);
        }
        if (!(bRet = LoginModule.netsdk.CLIENT_FindRecord(LoginModule.m_hLoginHandle, inParam, outParam, 10000))) {
            JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return;
        }
        this.lFindHandle = outParam.lFindeHandle;
        this.queryData();
        boolean success = LoginModule.netsdk.CLIENT_FindRecordClose(this.lFindHandle);
        if (!success) {
            JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
        }
    }

    public void queryData() {
        NetSDKLib.NET_OUT_FIND_NEXT_RECORD_PARAM outParam;
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        do {
            int max = 20;
            NetSDKLib.NET_IN_FIND_NEXT_RECORD_PARAM inParam = new NetSDKLib.NET_IN_FIND_NEXT_RECORD_PARAM();
            outParam = new NetSDKLib.NET_OUT_FIND_NEXT_RECORD_PARAM();
            Structure[] cards = new NetSDKLib.NET_RECORDSET_ACCESS_CTL_CARD[max];
            for (int i = 0; i < max; ++i) {
                cards[i] = new NetSDKLib.NET_RECORDSET_ACCESS_CTL_CARD();
            }
            outParam.pRecordList = new Memory(cards[0].size() * max);
            outParam.nMaxRecordNum = max;
            inParam.lFindeHandle = this.lFindHandle;
            inParam.nFileCount = max;
            ToolKits.SetStructArrToPointerData(cards, outParam.pRecordList);
            boolean result = LoginModule.netsdk.CLIENT_FindNextRecord(inParam, outParam, 10000);
            ToolKits.GetPointerDataToStructArr(outParam.pRecordList, cards);
            for (int i = 0; i < outParam.nRetRecordNum; ++i) {
                Structure card = cards[i];
                String fingerPrint = "";
                ((NetSDKLib.NET_RECORDSET_ACCESS_CTL_CARD)card).bEnableExtended = 1;
                ((NetSDKLib.NET_RECORDSET_ACCESS_CTL_CARD)card).stuFingerPrintInfoEx.nPacketLen = 2048;
                ((NetSDKLib.NET_RECORDSET_ACCESS_CTL_CARD)card).stuFingerPrintInfoEx.pPacketData = new Memory(2048L);
                fingerPrint = this.getFingerPrint((NetSDKLib.NET_RECORDSET_ACCESS_CTL_CARD)card);
                model.addRow(new Object[]{((NetSDKLib.NET_RECORDSET_ACCESS_CTL_CARD)card).nRecNo, new String(((NetSDKLib.NET_RECORDSET_ACCESS_CTL_CARD)card).szUserID).trim(), new String(((NetSDKLib.NET_RECORDSET_ACCESS_CTL_CARD)card).szCardNo).trim(), fingerPrint.trim()});
            }
        } while (outParam.nRetRecordNum == outParam.nMaxRecordNum && (outParam.nRetRecordNum != 0 || outParam.nMaxRecordNum != 0));
    }

    public String getFingerPrint(NetSDKLib.NET_RECORDSET_ACCESS_CTL_CARD card) {
        NetSDKLib.NET_CTRL_RECORDSET_PARAM inp = new NetSDKLib.NET_CTRL_RECORDSET_PARAM();
        inp.emType = 4;
        inp.pBuf = new Memory(card.size());
        ToolKits.SetStructDataToPointer(card, inp.pBuf, 0L);
        inp.nBufLen = card.size();
        Memory pointer = new Memory(inp.size());
        ToolKits.SetStructDataToPointer(inp, pointer, 0L);
        boolean re = LoginModule.netsdk.CLIENT_QueryDevState(LoginModule.m_hLoginHandle, 5490, pointer, inp.size(), new IntByReference(0), 5000);
        if (re) {
            ToolKits.GetPointerDataToStruct(pointer, 0L, inp);
            ToolKits.GetPointerData(inp.pBuf, card);
            byte[] fpData = new byte[card.stuFingerPrintInfoEx.nRealPacketLen];
            card.stuFingerPrintInfoEx.pPacketData.read(0L, fpData, 0, fpData.length);
            return Base64.getEncoder().encodeToString(fpData);
        }
        System.out.println("Get Finger print data error.there is no data");
        return "";
    }

    public void delete() {
        if (this.table.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(null, "please select a card", Res.string().getErrorMessage(), 0);
            return;
        }
        int nRecNo = (Integer)this.table.getModel().getValueAt(this.table.getSelectedRow(), 0);
        if (!this.deleteCard(nRecNo)) {
            return;
        }
        if (!this.deleteFaceInfo((String)this.table.getModel().getValueAt(this.table.getSelectedRow(), 1))) {
            return;
        }
    }

    public boolean deleteCard(int recNo) {
        NetSDKLib.NET_CTRL_RECORDSET_PARAM remove = new NetSDKLib.NET_CTRL_RECORDSET_PARAM();
        remove.emType = 4;
        remove.pBuf = new IntByReference(recNo).getPointer();
        remove.write();
        boolean result = LoginModule.netsdk.CLIENT_ControlDevice(LoginModule.m_hLoginHandle, 258, remove.getPointer(), 5000);
        remove.read();
        if (!result) {
            JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
        }
        return result;
    }

    public boolean deleteFaceInfo(String userId) {
        int emType = 3;
        NetSDKLib.NET_IN_REMOVE_FACE_INFO inRemove = new NetSDKLib.NET_IN_REMOVE_FACE_INFO();
        System.arraycopy(userId.getBytes(), 0, inRemove.szUserID, 0, userId.getBytes().length);
        NetSDKLib.NET_OUT_REMOVE_FACE_INFO outRemove = new NetSDKLib.NET_OUT_REMOVE_FACE_INFO();
        inRemove.write();
        outRemove.write();
        boolean bRet = LoginModule.netsdk.CLIENT_FaceInfoOpreate(LoginModule.m_hLoginHandle, emType, inRemove.getPointer(), outRemove.getPointer(), 5000);
        inRemove.read();
        outRemove.read();
        if (!bRet) {
            JOptionPane.showMessageDialog(null, Res.string().getRemoveCardFaceFailed() + "," + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
        }
        return bRet;
    }

    public void clear() {
        if (!this.clearFace()) {
            return;
        }
        if (this.clearCard()) {
            return;
        }
        this.search();
    }

    private boolean clearFace() {
        int emType = 4;
        NetSDKLib.NET_IN_CLEAR_FACE_INFO inClear = new NetSDKLib.NET_IN_CLEAR_FACE_INFO();
        NetSDKLib.NET_OUT_REMOVE_FACE_INFO outClear = new NetSDKLib.NET_OUT_REMOVE_FACE_INFO();
        inClear.write();
        outClear.write();
        boolean bRet = LoginModule.netsdk.CLIENT_FaceInfoOpreate(LoginModule.m_hLoginHandle, emType, inClear.getPointer(), outClear.getPointer(), 5000);
        inClear.read();
        outClear.read();
        if (!bRet) {
            JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
        }
        return bRet;
    }

    private boolean clearCard() {
        NetSDKLib.NET_CTRL_RECORDSET_PARAM clear = new NetSDKLib.NET_CTRL_RECORDSET_PARAM();
        clear.emType = 4;
        clear.write();
        boolean result = LoginModule.netsdk.CLIENT_ControlDevice(LoginModule.m_hLoginHandle, 259, clear.getPointer(), 5000);
        clear.read();
        if (!result) {
            JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
        }
        return result;
    }
}

