/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.vto;

import com.netsdk.common.PaintPanel;
import com.netsdk.common.Res;
import com.netsdk.common.SavePath;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.Pointer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public class VTOAnalyzerCallBack
implements NetSDKLib.fAnalyzerDataCallBack {
    private static VTOAnalyzerCallBack INSTANCE;
    private JTable table;
    private PaintPanel paintPanel;
    private BufferedImage bufferedImage;

    private VTOAnalyzerCallBack(JTable table, PaintPanel panel) {
        this.table = table;
        this.paintPanel = panel;
    }

    public static VTOAnalyzerCallBack getINSTANCE(JTable table, PaintPanel paintPanel) {
        if (INSTANCE == null) {
            INSTANCE = new VTOAnalyzerCallBack(table, paintPanel);
        }
        return INSTANCE;
    }

    @Override
    public int invoke(NetSDKLib.LLong lAnalyzerHandle, int dwAlarmType, Pointer pAlarmInfo, Pointer pBuffer, int dwBufSize, Pointer dwUser, int nSequence, Pointer reserved) {
        if (dwAlarmType == 516) {
            NetSDKLib.DEV_EVENT_ACCESS_CTL_INFO info = new NetSDKLib.DEV_EVENT_ACCESS_CTL_INFO();
            ToolKits.GetPointerDataToStruct(pAlarmInfo, 0L, info);
            if (this.table != null) {
                DefaultTableModel model = (DefaultTableModel)this.table.getModel();
                NetSDKLib.NET_TIME_EX time = info.UTC;
                if (info.UTC.dwYear == 0 && info.UTC.dwMonth == 0 && info.UTC.dwDay == 0) {
                    time = info.stuFileInfo.stuFileTime;
                }
                model.addRow(new Object[]{new String(info.szUserID).trim(), new String(info.szCardNo).trim(), time.toString().trim(), this.getEventInfo(info).trim()});
            }
            if (pBuffer != null && dwBufSize > 0) {
                String strFileName = SavePath.getSavePath().getSaveCapturePath();
                byte[] buf = pBuffer.getByteArray(0L, dwBufSize);
                ByteArrayInputStream byteArrInput = new ByteArrayInputStream(buf);
                try {
                    this.bufferedImage = ImageIO.read(byteArrInput);
                    if (this.bufferedImage == null) {
                        return 0;
                    }
                    ImageIO.write((RenderedImage)this.bufferedImage, "jpg", new File(strFileName));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VTOAnalyzerCallBack.this.paintPanel.setOpaque(false);
                        VTOAnalyzerCallBack.this.paintPanel.setImage(VTOAnalyzerCallBack.this.bufferedImage);
                        VTOAnalyzerCallBack.this.paintPanel.repaint();
                    }
                });
            }
        }
        return 1;
    }

    private String getEventInfo(NetSDKLib.DEV_EVENT_ACCESS_CTL_INFO info) {
        StringBuilder builder = new StringBuilder();
        builder.append(Res.string().getChannel()).append(info.nChannelID).append(",").append(Res.string().getOpenMethod()).append(this.openDoorMethod(info.emOpenMethod)).append(",").append(Res.string().getOpenStatus()).append(info.bStatus == 1 ? Res.string().getSucceed() : Res.string().getFailed());
        return builder.toString();
    }

    private String openDoorMethod(int emOpenMethod) {
        String method;
        switch (emOpenMethod) {
            case 2: {
                method = Res.string().getCard();
                break;
            }
            case 16: {
                method = Res.string().getFaceRecognition();
                break;
            }
            case 7: {
                method = Res.string().getFingerPrint();
                break;
            }
            case 5: {
                method = Res.string().getRemoteCapture();
                break;
            }
            default: {
                method = Res.string().getUnKnow();
            }
        }
        return method;
    }
}

