/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.module;

import com.netsdk.demo.module.LoginModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.Memory;
import com.sun.jna.Structure;
import java.io.UnsupportedEncodingException;

public class AttendanceModule {
    public static final int TIME_OUT = 3000;
    public static final int nMaxFingerPrintSize = 2048;
    public static NetSDKLib.LLong m_hAttachHandle = new NetSDKLib.LLong(0L);

    public static boolean realLoadPicture(NetSDKLib.fAnalyzerDataCallBack callback) {
        int bNeedPicture = 0;
        m_hAttachHandle = LoginModule.netsdk.CLIENT_RealLoadPictureEx(LoginModule.m_hLoginHandle, -1, 1, bNeedPicture, callback, null, null);
        if (m_hAttachHandle.longValue() == 0L) {
            System.err.printf("CLIENT_RealLoadPictureEx Failed!" + ToolKits.getErrorCodePrint(), new Object[0]);
        }
        return m_hAttachHandle.longValue() != 0L;
    }

    public static void stopRealLoadPicture() {
        if (m_hAttachHandle.longValue() == 0L) {
            return;
        }
        LoginModule.netsdk.CLIENT_StopLoadPic(m_hAttachHandle);
        m_hAttachHandle.setValue(0L);
    }

    public static boolean addUser(String userId, String userName, String cardNo) {
        NetSDKLib.NET_IN_ATTENDANCE_ADDUSER stuIn = new NetSDKLib.NET_IN_ATTENDANCE_ADDUSER();
        AttendanceModule.stringToByteArray(userId, stuIn.stuUserInfo.szUserID);
        AttendanceModule.stringToByteArray(userName, stuIn.stuUserInfo.szUserName);
        AttendanceModule.stringToByteArray(cardNo, stuIn.stuUserInfo.szCardNo);
        NetSDKLib.NET_OUT_ATTENDANCE_ADDUSER stuOut = new NetSDKLib.NET_OUT_ATTENDANCE_ADDUSER();
        boolean bRet = LoginModule.netsdk.CLIENT_Attendance_AddUser(LoginModule.m_hLoginHandle, stuIn, stuOut, 3000);
        if (!bRet) {
            System.err.printf("CLIENT_Attendance_AddUser Failed!" + ToolKits.getErrorCodePrint(), new Object[0]);
        }
        return bRet;
    }

    public static boolean deleteUser(String userId) {
        AttendanceModule.removeFingerByUserId(userId);
        NetSDKLib.NET_IN_ATTENDANCE_DELUSER stuIn = new NetSDKLib.NET_IN_ATTENDANCE_DELUSER();
        AttendanceModule.stringToByteArray(userId, stuIn.szUserID);
        NetSDKLib.NET_OUT_ATTENDANCE_DELUSER stuOut = new NetSDKLib.NET_OUT_ATTENDANCE_DELUSER();
        boolean bRet = LoginModule.netsdk.CLIENT_Attendance_DelUser(LoginModule.m_hLoginHandle, stuIn, stuOut, 3000);
        if (!bRet) {
            System.err.printf("CLIENT_Attendance_DelUser Failed!" + ToolKits.getErrorCodePrint(), new Object[0]);
        }
        return bRet;
    }

    public static boolean modifyUser(String userId, String userName, String cardNo) {
        NetSDKLib.NET_IN_ATTENDANCE_ModifyUSER stuIn = new NetSDKLib.NET_IN_ATTENDANCE_ModifyUSER();
        AttendanceModule.stringToByteArray(userId, stuIn.stuUserInfo.szUserID);
        AttendanceModule.stringToByteArray(userName, stuIn.stuUserInfo.szUserName);
        AttendanceModule.stringToByteArray(cardNo, stuIn.stuUserInfo.szCardNo);
        NetSDKLib.NET_OUT_ATTENDANCE_ModifyUSER stuOut = new NetSDKLib.NET_OUT_ATTENDANCE_ModifyUSER();
        boolean bRet = LoginModule.netsdk.CLIENT_Attendance_ModifyUser(LoginModule.m_hLoginHandle, stuIn, stuOut, 3000);
        if (!bRet) {
            System.err.printf("CLIENT_Attendance_ModifyUser Failed!" + ToolKits.getErrorCodePrint(), new Object[0]);
        }
        return bRet;
    }

    public static UserData[] findUser(int nOffset, int nPagedQueryCount) {
        NetSDKLib.NET_IN_ATTENDANCE_FINDUSER stuIn = new NetSDKLib.NET_IN_ATTENDANCE_FINDUSER();
        stuIn.nOffset = nOffset;
        stuIn.nPagedQueryCount = nPagedQueryCount;
        NetSDKLib.NET_OUT_ATTENDANCE_FINDUSER stuOut = new NetSDKLib.NET_OUT_ATTENDANCE_FINDUSER();
        Structure[] userInfo = new NetSDKLib.NET_ATTENDANCE_USERINFO[nPagedQueryCount];
        for (int i = 0; i < nPagedQueryCount; ++i) {
            userInfo[i] = new NetSDKLib.NET_ATTENDANCE_USERINFO();
        }
        stuOut.nMaxUserCount = nPagedQueryCount;
        stuOut.stuUserInfo = new Memory(userInfo[0].size() * stuOut.nMaxUserCount);
        stuOut.stuUserInfo.clear(userInfo[0].size() * stuOut.nMaxUserCount);
        ToolKits.SetStructArrToPointerData(userInfo, stuOut.stuUserInfo);
        stuOut.nMaxPhotoDataLength = 128;
        stuOut.pbyPhotoData = new Memory(stuOut.nMaxPhotoDataLength);
        boolean bRet = LoginModule.netsdk.CLIENT_Attendance_FindUser(LoginModule.m_hLoginHandle, stuIn, stuOut, 3000);
        if (!bRet) {
            System.err.printf("CLIENT_Attendance_FindUser Failed!" + ToolKits.getErrorCodePrint(), new Object[0]);
            return null;
        }
        ToolKits.GetPointerDataToStructArr(stuOut.stuUserInfo, userInfo);
        UserData[] userData = new UserData[stuOut.nRetUserCount];
        for (int i = 0; i < stuOut.nRetUserCount; ++i) {
            userData[i] = new UserData();
            try {
                userData[i].userId = new String(((NetSDKLib.NET_ATTENDANCE_USERINFO)userInfo[i]).szUserID, "GBK").trim();
                userData[i].userName = new String(((NetSDKLib.NET_ATTENDANCE_USERINFO)userInfo[i]).szUserName, "GBK").trim();
                userData[i].cardNo = new String(((NetSDKLib.NET_ATTENDANCE_USERINFO)userInfo[i]).szCardNo, "GBK").trim();
                continue;
            }
            catch (Exception e) {
                userData[i].userId = new String(((NetSDKLib.NET_ATTENDANCE_USERINFO)userInfo[i]).szUserID).trim();
                userData[i].userName = new String(((NetSDKLib.NET_ATTENDANCE_USERINFO)userInfo[i]).szUserName).trim();
                userData[i].cardNo = new String(((NetSDKLib.NET_ATTENDANCE_USERINFO)userInfo[i]).szCardNo).trim();
            }
        }
        UserData.nTotalUser = stuOut.nTotalUser;
        return userData;
    }

    public static UserData getUser(String userId) {
        NetSDKLib.NET_IN_ATTENDANCE_GetUSER stuIn = new NetSDKLib.NET_IN_ATTENDANCE_GetUSER();
        AttendanceModule.stringToByteArray(userId, stuIn.szUserID);
        NetSDKLib.NET_OUT_ATTENDANCE_GetUSER stuOut = new NetSDKLib.NET_OUT_ATTENDANCE_GetUSER();
        stuOut.nMaxLength = 128;
        stuOut.pbyPhotoData = new Memory(stuOut.nMaxLength);
        stuOut.pbyPhotoData.clear(stuOut.nMaxLength);
        boolean bRet = LoginModule.netsdk.CLIENT_Attendance_GetUser(LoginModule.m_hLoginHandle, stuIn, stuOut, 3000);
        if (!bRet) {
            System.err.printf("CLIENT_Attendance_GetUser Failed!" + ToolKits.getErrorCodePrint(), new Object[0]);
            return null;
        }
        UserData userData = new UserData();
        try {
            userData.userId = new String(stuOut.stuUserInfo.szUserID, "GBK").trim();
            userData.userName = new String(stuOut.stuUserInfo.szUserName, "GBK").trim();
            userData.cardNo = new String(stuOut.stuUserInfo.szCardNo, "GBK").trim();
        }
        catch (Exception e) {
            userData.userId = new String(stuOut.stuUserInfo.szUserID).trim();
            userData.userName = new String(stuOut.stuUserInfo.szUserName).trim();
            userData.cardNo = new String(stuOut.stuUserInfo.szCardNo).trim();
        }
        return userData;
    }

    public static boolean insertFingerByUserId(String userId, byte[] szFingerPrintInfo) {
        NetSDKLib.NET_IN_FINGERPRINT_INSERT_BY_USERID stuIn = new NetSDKLib.NET_IN_FINGERPRINT_INSERT_BY_USERID();
        AttendanceModule.stringToByteArray(userId, stuIn.szUserID);
        stuIn.nPacketCount = 1;
        stuIn.nSinglePacketLen = szFingerPrintInfo.length;
        stuIn.szFingerPrintInfo = new Memory(stuIn.nPacketCount * stuIn.nSinglePacketLen);
        stuIn.szFingerPrintInfo.clear(stuIn.nPacketCount * stuIn.nSinglePacketLen);
        stuIn.szFingerPrintInfo.write(0L, szFingerPrintInfo, 0, szFingerPrintInfo.length);
        NetSDKLib.NET_OUT_FINGERPRINT_INSERT_BY_USERID stuOut = new NetSDKLib.NET_OUT_FINGERPRINT_INSERT_BY_USERID();
        boolean bRet = LoginModule.netsdk.CLIENT_Attendance_InsertFingerByUserID(LoginModule.m_hLoginHandle, stuIn, stuOut, 3000);
        if (!bRet) {
            System.err.printf("CLIENT_Attendance_InsertFingerByUserID Failed!" + ToolKits.getErrorCodePrint(), new Object[0]);
        }
        return bRet;
    }

    public static boolean removeFingerByUserId(String userId) {
        NetSDKLib.NET_CTRL_IN_FINGERPRINT_REMOVE_BY_USERID stuIn = new NetSDKLib.NET_CTRL_IN_FINGERPRINT_REMOVE_BY_USERID();
        AttendanceModule.stringToByteArray(userId, stuIn.szUserID);
        NetSDKLib.NET_CTRL_OUT_FINGERPRINT_REMOVE_BY_USERID stuOut = new NetSDKLib.NET_CTRL_OUT_FINGERPRINT_REMOVE_BY_USERID();
        boolean bRet = LoginModule.netsdk.CLIENT_Attendance_RemoveFingerByUserID(LoginModule.m_hLoginHandle, stuIn, stuOut, 3000);
        if (!bRet) {
            System.err.printf("CLIENT_Attendance_RemoveFingerByUserID Failed!" + ToolKits.getErrorCodePrint(), new Object[0]);
        }
        return bRet;
    }

    public static boolean removeFingerRecord(int nFingerPrintID) {
        NetSDKLib.NET_CTRL_IN_FINGERPRINT_REMOVE stuIn = new NetSDKLib.NET_CTRL_IN_FINGERPRINT_REMOVE();
        stuIn.nFingerPrintID = nFingerPrintID;
        NetSDKLib.NET_CTRL_OUT_FINGERPRINT_REMOVE stuOut = new NetSDKLib.NET_CTRL_OUT_FINGERPRINT_REMOVE();
        boolean bRet = LoginModule.netsdk.CLIENT_Attendance_RemoveFingerRecord(LoginModule.m_hLoginHandle, stuIn, stuOut, 3000);
        if (!bRet) {
            System.err.printf("CLIENT_Attendance_RemoveFingerRecord Failed!" + ToolKits.getErrorCodePrint(), new Object[0]);
        }
        return bRet;
    }

    public static UserData getFingerRecord(int nFingerPrintID) {
        NetSDKLib.NET_CTRL_IN_FINGERPRINT_GET stuIn = new NetSDKLib.NET_CTRL_IN_FINGERPRINT_GET();
        stuIn.nFingerPrintID = nFingerPrintID;
        NetSDKLib.NET_CTRL_OUT_FINGERPRINT_GET stuOut = new NetSDKLib.NET_CTRL_OUT_FINGERPRINT_GET();
        stuOut.nMaxFingerDataLength = 2048;
        stuOut.szFingerPrintInfo = new Memory(stuOut.nMaxFingerDataLength);
        stuOut.szFingerPrintInfo.clear(stuOut.nMaxFingerDataLength);
        boolean bRet = LoginModule.netsdk.CLIENT_Attendance_GetFingerRecord(LoginModule.m_hLoginHandle, stuIn, stuOut, 3000);
        if (!bRet) {
            System.err.printf("CLIENT_Attendance_GetFingerRecord Failed!" + ToolKits.getErrorCodePrint(), new Object[0]);
            return null;
        }
        if (stuOut.nRetLength == 0) {
            System.err.println("GetFingerRecord Failed nRetLength == 0!");
        }
        UserData userData = new UserData();
        userData.userId = new String(stuOut.szUserID).trim();
        userData.nFingerPrintIDs = new int[1];
        userData.nFingerPrintIDs[0] = nFingerPrintID;
        userData.szFingerPrintInfo = new byte[1][stuOut.nRetLength];
        stuOut.szFingerPrintInfo.read(0L, userData.szFingerPrintInfo[0], 0, stuOut.nRetLength);
        return userData;
    }

    public static boolean getFingerByUserId(String userId, UserData userData) {
        NetSDKLib.NET_IN_FINGERPRINT_GETBYUSER stuIn = new NetSDKLib.NET_IN_FINGERPRINT_GETBYUSER();
        AttendanceModule.stringToByteArray(userId, stuIn.szUserID);
        NetSDKLib.NET_OUT_FINGERPRINT_GETBYUSER stuOut = new NetSDKLib.NET_OUT_FINGERPRINT_GETBYUSER();
        stuOut.nMaxFingerDataLength = 20480;
        stuOut.pbyFingerData = new Memory(stuOut.nMaxFingerDataLength);
        stuOut.pbyFingerData.clear(stuOut.nMaxFingerDataLength);
        boolean bRet = LoginModule.netsdk.CLIENT_Attendance_GetFingerByUserID(LoginModule.m_hLoginHandle, stuIn, stuOut, 3000);
        if (!bRet) {
            System.err.printf("CLIENT_Attendance_GetFingerByUserID Failed!" + ToolKits.getErrorCodePrint(), new Object[0]);
        } else {
            userData.nFingerPrintIDs = new int[stuOut.nRetFingerPrintCount];
            userData.szFingerPrintInfo = new byte[stuOut.nRetFingerPrintCount][stuOut.nSinglePacketLength];
            int offset = 0;
            for (int i = 0; i < stuOut.nRetFingerPrintCount; ++i) {
                userData.nFingerPrintIDs[i] = stuOut.nFingerPrintIDs[i];
                stuOut.pbyFingerData.read((long)offset, userData.szFingerPrintInfo[i], 0, stuOut.nSinglePacketLength);
                offset += stuOut.nSinglePacketLength;
            }
        }
        return bRet;
    }

    public static boolean collectionFinger(int nChannelID, String szReaderID) {
        NetSDKLib.NET_CTRL_CAPTURE_FINGER_PRINT stuCollection = new NetSDKLib.NET_CTRL_CAPTURE_FINGER_PRINT();
        stuCollection.nChannelID = nChannelID;
        AttendanceModule.stringToByteArray(szReaderID, stuCollection.szReaderID);
        stuCollection.write();
        boolean bRet = LoginModule.netsdk.CLIENT_ControlDeviceEx(LoginModule.m_hLoginHandle, 416, stuCollection.getPointer(), null, 5000);
        if (!bRet) {
            System.err.printf("CLIENT_ControlDeviceEx CAPTURE_FINGER_PRINT Failed!" + ToolKits.getErrorCodePrint(), new Object[0]);
        }
        return bRet;
    }

    public static void stringToByteArray(String src, byte[] dst) {
        byte[] szSrc;
        if (src == null || src.isEmpty()) {
            return;
        }
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = 0;
        }
        try {
            szSrc = src.getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            szSrc = src.getBytes();
        }
        if (szSrc != null) {
            int len = szSrc.length >= dst.length ? dst.length - 1 : szSrc.length;
            System.arraycopy(szSrc, 0, dst, 0, len);
        }
    }

    public static enum OPERATE_TYPE {
        UNKNOWN,
        SEARCH_USER,
        PRE_SEARCH_USER,
        NEXT_SEARCH_USER,
        SEARCH_USER_BY_USERID,
        ADD_USER,
        DELETE_USER,
        MODIFIY_USER,
        FINGERPRINT_OPEARTE_BY_USERID,
        FINGERPRINT_OPEARTE_BY_ID,
        SEARCH_FINGERPRINT_BY_USERID,
        SEARCH_FINGERPRINT_BY_ID,
        ADD_FINGERPRINT,
        DELETE_FINGERPRINT_BY_USERID,
        DELETE_FINGERPRINT_BY_ID;

    }

    public static class AccessEventInfo {
        public String userId;
        public String cardNo;
        public String eventTime;
        public int openDoorMethod;
    }

    public static class UserData {
        public static int nTotalUser;
        public String userId;
        public String userName;
        public String cardNo;
        public int[] nFingerPrintIDs;
        public byte[][] szFingerPrintInfo;
    }
}

