/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.module;

import com.netsdk.demo.module.LoginModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.awt.Panel;

public class AutoRegisterModule {
    public static NetSDKLib.LLong mServerHandler = new NetSDKLib.LLong(0L);
    public static NetSDKLib.NET_DEVICEINFO_Ex m_stDeviceInfo = new NetSDKLib.NET_DEVICEINFO_Ex();
    public static NetSDKLib.LLong m_hTalkHandle = new NetSDKLib.LLong(0L);
    private static boolean m_bRecordStatus = false;

    public static boolean startServer(String address, int port, NetSDKLib.fServiceCallBack callback) {
        mServerHandler = LoginModule.netsdk.CLIENT_ListenServer(address, port, 1000, callback, null);
        if (0L == mServerHandler.longValue()) {
            System.err.println("Failed to start server." + ToolKits.getErrorCodePrint());
        } else {
            System.out.printf("Start server, [Server address %s][Server port %d]\n", address, port);
        }
        return mServerHandler.longValue() != 0L;
    }

    public static boolean stopServer() {
        boolean bRet = false;
        if (mServerHandler.longValue() != 0L) {
            bRet = LoginModule.netsdk.CLIENT_StopListenServer(mServerHandler);
            mServerHandler.setValue(0L);
            System.out.println("Stop server!");
        }
        return bRet;
    }

    public static NetSDKLib.LLong login(String m_strIp, int m_nPort, String m_strUser, String m_strPassword, String deviceIds) {
        Pointer deviceId = ToolKits.GetGBKStringToPointer(deviceIds);
        NetSDKLib.NET_IN_LOGIN_WITH_HIGHLEVEL_SECURITY pstInParam = new NetSDKLib.NET_IN_LOGIN_WITH_HIGHLEVEL_SECURITY();
        pstInParam.nPort = m_nPort;
        pstInParam.szIP = m_strIp.getBytes();
        pstInParam.szPassword = m_strPassword.getBytes();
        pstInParam.szUserName = m_strUser.getBytes();
        pstInParam.emSpecCap = 2;
        pstInParam.pCapParam = deviceId;
        NetSDKLib.NET_OUT_LOGIN_WITH_HIGHLEVEL_SECURITY pstOutParam = new NetSDKLib.NET_OUT_LOGIN_WITH_HIGHLEVEL_SECURITY();
        pstOutParam.stuDeviceInfo = m_stDeviceInfo;
        NetSDKLib.LLong m_hLoginHandle = LoginModule.netsdk.CLIENT_LoginWithHighLevelSecurity(pstInParam, pstOutParam);
        return m_hLoginHandle;
    }

    public static boolean logout(NetSDKLib.LLong m_hLoginHandle) {
        boolean bRet = false;
        if (m_hLoginHandle.longValue() != 0L) {
            bRet = LoginModule.netsdk.CLIENT_Logout(m_hLoginHandle);
            m_hLoginHandle.setValue(0L);
        }
        return bRet;
    }

    public static NetSDKLib.LLong startRealPlay(NetSDKLib.LLong m_hLoginHandle, int channel, int stream, Panel realPlayWindow) {
        NetSDKLib.LLong m_hPlayHandle = LoginModule.netsdk.CLIENT_RealPlayEx(m_hLoginHandle, channel, Native.getComponentPointer(realPlayWindow), stream);
        if (m_hPlayHandle.longValue() == 0L) {
            System.err.println("Failed to start realplay." + ToolKits.getErrorCodePrint());
        } else {
            System.out.println("Success to start realplay");
        }
        return m_hPlayHandle;
    }

    public static boolean stopRealPlay(NetSDKLib.LLong m_hPlayHandle) {
        boolean bRet = false;
        if (m_hPlayHandle.longValue() != 0L) {
            bRet = LoginModule.netsdk.CLIENT_StopRealPlayEx(m_hPlayHandle);
            m_hPlayHandle.setValue(0L);
        }
        return bRet;
    }

    public static boolean snapPicture(NetSDKLib.LLong m_hLoginHandle, int chn) {
        NetSDKLib.SNAP_PARAMS msg = new NetSDKLib.SNAP_PARAMS();
        msg.Channel = chn;
        msg.mode = 0;
        msg.Quality = 3;
        msg.InterSnap = 0;
        msg.CmdSerial = 0;
        IntByReference reserved = new IntByReference(0);
        if (!LoginModule.netsdk.CLIENT_SnapPictureEx(m_hLoginHandle, msg, reserved)) {
            System.err.printf("SnapPictureEx Failed!" + ToolKits.getErrorCodePrint(), new Object[0]);
            return false;
        }
        System.out.println("SnapPictureEx success");
        return true;
    }

    public static void setSnapRevCallBack(NetSDKLib.fSnapRev m_SnapReceiveCB) {
        LoginModule.netsdk.CLIENT_SetSnapRevCallBack(m_SnapReceiveCB, null);
    }

    public static NetSDKLib.CFG_DVRIP_INFO getDVRIPConfig(NetSDKLib.LLong m_hLoginHandle) {
        NetSDKLib.CFG_DVRIP_INFO msg = new NetSDKLib.CFG_DVRIP_INFO();
        if (!ToolKits.GetDevConfig(m_hLoginHandle, -1, "DVRIP", msg)) {
            return null;
        }
        return msg;
    }

    public static boolean setDVRIPConfig(NetSDKLib.LLong m_hLoginHandle, boolean enable, String address, int nPort, byte[] deviceId, NetSDKLib.CFG_DVRIP_INFO info) {
        NetSDKLib.CFG_DVRIP_INFO msg = info;
        msg.nRegistersNum = 1;
        msg.stuRegisters[0].bEnable = enable ? 1 : 0;
        msg.stuRegisters[0].nServersNum = 1;
        ToolKits.StringToByteArray(address, msg.stuRegisters[0].stuServers[0].szAddress);
        msg.stuRegisters[0].stuServers[0].nPort = nPort;
        ToolKits.ByteArrayToByteArray(deviceId, msg.stuRegisters[0].szDeviceID);
        return ToolKits.SetDevConfig(m_hLoginHandle, -1, "DVRIP", msg);
    }

    public static boolean startTalk(NetSDKLib.LLong m_hLoginHandle) {
        NetSDKLib.NETDEV_TALKDECODE_INFO talkEncode = new NetSDKLib.NETDEV_TALKDECODE_INFO();
        talkEncode.encodeType = 1;
        talkEncode.dwSampleRate = 8000;
        talkEncode.nAudioBit = 16;
        talkEncode.nPacketPeriod = 25;
        talkEncode.write();
        if (!LoginModule.netsdk.CLIENT_SetDeviceMode(m_hLoginHandle, 2, talkEncode.getPointer())) {
            System.err.println("Set Talk Encode Type Failed!" + ToolKits.getErrorCodePrint());
            return false;
        }
        System.out.println("Set Talk Encode Type Succeed!");
        NetSDKLib.NET_SPEAK_PARAM speak = new NetSDKLib.NET_SPEAK_PARAM();
        speak.nMode = 0;
        speak.bEnableWait = false;
        speak.nSpeakerChannel = 0;
        speak.write();
        if (!LoginModule.netsdk.CLIENT_SetDeviceMode(m_hLoginHandle, 7, speak.getPointer())) {
            System.err.println("Set Talk Speak Mode Failed!" + ToolKits.getErrorCodePrint());
            return false;
        }
        System.out.println("Set Talk Speak Mode Succeed!");
        NetSDKLib.NET_TALK_TRANSFER_PARAM talkTransfer = new NetSDKLib.NET_TALK_TRANSFER_PARAM();
        talkTransfer.bTransfer = 0;
        talkTransfer.write();
        if (!LoginModule.netsdk.CLIENT_SetDeviceMode(m_hLoginHandle, 11, talkTransfer.getPointer())) {
            System.err.println("Set Talk Transfer Mode Failed!" + ToolKits.getErrorCodePrint());
            return false;
        }
        System.out.println("Set Talk Transfer Mode Succeed!");
        m_hTalkHandle = LoginModule.netsdk.CLIENT_StartTalkEx(m_hLoginHandle, AudioDataCB.getInstance(), null);
        if (m_hTalkHandle.longValue() == 0L) {
            System.err.println("Start Talk Failed!" + ToolKits.getErrorCodePrint());
            return false;
        }
        System.out.println("Start Talk Success");
        if (!LoginModule.netsdk.CLIENT_RecordStart()) {
            System.err.println("Start Local Record Failed!" + ToolKits.getErrorCodePrint());
            AutoRegisterModule.stopTalk(m_hTalkHandle);
            return false;
        }
        System.out.println("Start Record Success");
        m_bRecordStatus = true;
        return true;
    }

    public static void stopTalk(NetSDKLib.LLong m_hTalkHandle) {
        if (m_hTalkHandle.longValue() == 0L) {
            return;
        }
        if (m_bRecordStatus) {
            LoginModule.netsdk.CLIENT_RecordStop();
            m_bRecordStatus = false;
        }
        if (!LoginModule.netsdk.CLIENT_StopTalkEx(m_hTalkHandle)) {
            System.err.println("Stop Talk Failed!" + ToolKits.getErrorCodePrint());
        } else {
            m_hTalkHandle.setValue(0L);
        }
    }

    private static class AudioDataCB
    implements NetSDKLib.pfAudioDataCallBack {
        private static AudioDataCB audioCallBack = new AudioDataCB();

        private AudioDataCB() {
        }

        public static AudioDataCB getInstance() {
            return audioCallBack;
        }

        @Override
        public void invoke(NetSDKLib.LLong lTalkHandle, Pointer pDataBuf, int dwBufSize, byte byAudioFlag, Pointer dwUser) {
            if (lTalkHandle.longValue() != m_hTalkHandle.longValue()) {
                return;
            }
            if (byAudioFlag == 0) {
                NetSDKLib.LLong lSendSize = LoginModule.netsdk.CLIENT_TalkSendData(m_hTalkHandle, pDataBuf, dwBufSize);
                if (lSendSize.longValue() != (long)dwBufSize) {
                    System.err.println("send incomplete" + lSendSize.longValue() + ":" + dwBufSize);
                }
            } else if (byAudioFlag == 1) {
                LoginModule.netsdk.CLIENT_AudioDecEx(m_hTalkHandle, pDataBuf, dwBufSize);
            }
        }
    }
}

