/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.lib;

import com.netsdk.common.ErrorCode;
import com.netsdk.common.PaintPanel;
import com.netsdk.demo.module.LoginModule;
import com.netsdk.lib.NetSDKLib;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

public class ToolKits {
    static NetSDKLib netsdkapi = NetSDKLib.NETSDK_INSTANCE;
    static NetSDKLib configapi = NetSDKLib.CONFIG_INSTANCE;

    public static void GetPointerData(Pointer pNativeData, Structure pJavaStu) {
        ToolKits.GetPointerDataToStruct(pNativeData, 0L, pJavaStu);
    }

    public static void GetPointerDataToStruct(Pointer pNativeData, long OffsetOfpNativeData, Structure pJavaStu) {
        pJavaStu.write();
        Pointer pJavaMem = pJavaStu.getPointer();
        pJavaMem.write(0L, pNativeData.getByteArray(OffsetOfpNativeData, pJavaStu.size()), 0, pJavaStu.size());
        pJavaStu.read();
    }

    public static void GetPointerDataToStructArr(Pointer pNativeData, Structure[] pJavaStuArr) {
        long offset = 0L;
        for (int i = 0; i < pJavaStuArr.length; ++i) {
            ToolKits.GetPointerDataToStruct(pNativeData, offset, pJavaStuArr[i]);
            offset += (long)pJavaStuArr[i].size();
        }
    }

    public static void SetStructArrToPointerData(Structure[] pJavaStuArr, Pointer pNativeData) {
        long offset = 0L;
        for (int i = 0; i < pJavaStuArr.length; ++i) {
            ToolKits.SetStructDataToPointer(pJavaStuArr[i], pNativeData, offset);
            offset += (long)pJavaStuArr[i].size();
        }
    }

    public static void SetStructDataToPointer(Structure pJavaStu, Pointer pNativeData, long OffsetOfpNativeData) {
        pJavaStu.write();
        Pointer pJavaMem = pJavaStu.getPointer();
        pNativeData.write(OffsetOfpNativeData, pJavaMem.getByteArray(0L, pJavaStu.size()), 0, pJavaStu.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePicture(byte[] pBuf, String sDstFile) throws IOException {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(sDstFile);
            fos.write(pBuf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePicture(byte[] pBuf, int dwBufOffset, int dwBufSize, String sDstFile) throws IOException {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(sDstFile);
            fos.write(pBuf, dwBufOffset, dwBufSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePicture(Pointer pBuf, int dwBufSize, String sDstFile) throws IOException {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(sDstFile);
            fos.write(pBuf.getByteArray(0L, dwBufSize), 0, dwBufSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePicture(Pointer pBuf, int dwBufOffset, int dwBufSize, String sDstFile) throws IOException {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(sDstFile);
            fos.write(pBuf.getByteArray(dwBufOffset, dwBufSize), 0, dwBufSize);
        }
    }

    public static String GetPointerDataToByteArr(Pointer pointer) {
        String str = "";
        if (pointer == null) {
            return str;
        }
        int length = 0;
        byte[] bufferPlace = new byte[1];
        for (int i = 0; i < 2048; ++i) {
            pointer.read((long)i, bufferPlace, 0, 1);
            if (bufferPlace[0] != 0) continue;
            length = i;
            break;
        }
        if (length > 0) {
            byte[] buffer = new byte[length];
            pointer.read(0L, buffer, 0, length);
            try {
                str = new String(buffer, "GBK").trim();
            }
            catch (UnsupportedEncodingException e) {
                return str;
            }
        }
        return str;
    }

    public static String getDate() {
        SimpleDateFormat simpleDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = simpleDate.format(new Date()).replace(" ", "_").replace(":", "-");
        return date;
    }

    public static String getDay() {
        SimpleDateFormat simpleDate = new SimpleDateFormat("yyyy-MM-dd");
        String date = simpleDate.format(new Date());
        return date;
    }

    public static void limitTextFieldLength(final JTextField jTextField, final int size) {
        jTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                String number = "0123456789\b";
                if (number.indexOf(e.getKeyChar()) < 0 || jTextField.getText().trim().length() >= size) {
                    e.consume();
                    return;
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
    }

    public static JFrame getFrame(ActionEvent e) {
        JButton btn = (JButton)e.getSource();
        JFrame frame = (JFrame)btn.getRootPane().getParent();
        return frame;
    }

    public static String getLoadLibrary(String library) {
        String path = "";
        String os = System.getProperty("os.name");
        if (os.toLowerCase().startsWith("win")) {
            path = "./libs/";
        } else if (os.toLowerCase().startsWith("linux")) {
            path = "";
        }
        return path + library;
    }

    public static String getOsName() {
        String osName = "";
        String os = System.getProperty("os.name");
        if (os.toLowerCase().startsWith("win")) {
            osName = "win";
        } else if (os.toLowerCase().startsWith("linux")) {
            osName = "linux";
        }
        return osName;
    }

    public static long GetFileSize(String filePath) {
        File f = new File(filePath);
        if (f.exists() && f.isFile()) {
            return f.length();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ReadAllFileToMemory(String file, Memory memory) throws IOException {
        if (memory != Memory.NULL) {
            long fileLen = ToolKits.GetFileSize(file);
            if (fileLen <= 0L) {
                return false;
            }
            try (FileInputStream in = null;){
                File infile = new File(file);
                if (infile.canRead()) {
                    in = new FileInputStream(infile);
                    int buffLen = 1024;
                    byte[] buffer = new byte[buffLen];
                    int readLen = 0;
                    for (long currFileLen = 0L; currFileLen < fileLen; currFileLen += (long)readLen) {
                        readLen = in.read(buffer);
                        memory.write(currFileLen, buffer, 0, readLen);
                    }
                    boolean bl = true;
                    return bl;
                }
                System.err.println("Failed to open file %s for read!!!\n");
                boolean bl = false;
                return bl;
            }
        }
        return false;
    }

    public static String openPictureFile(PaintPanel paintPanel) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String picPath = "";
        JFileChooser jfc = new JFileChooser("d:/");
        jfc.setMultiSelectionEnabled(false);
        jfc.setAcceptAllFileFilterUsed(false);
        JPGFilter filter = new JPGFilter();
        jfc.addChoosableFileFilter(filter);
        jfc.setFileFilter(filter);
        if (jfc.showOpenDialog(null) == 0) {
            picPath = jfc.getSelectedFile().getAbsolutePath();
            BufferedImage bufferedImage = null;
            if (picPath == null || picPath.equals("")) {
                return "";
            }
            File file = new File(picPath);
            if (!file.exists()) {
                return "";
            }
            try {
                bufferedImage = ImageIO.read(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (bufferedImage == null) {
                paintPanel.setOpaque(true);
                paintPanel.repaint();
                System.err.println("\u6253\u5f00\u56fe\u7247\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
                return "";
            }
            paintPanel.setOpaque(false);
            paintPanel.setImage(bufferedImage);
            paintPanel.repaint();
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return picPath;
    }

    public static File openPictureFile(String picPath, PaintPanel paintPanel) {
        BufferedImage bufferedImage = null;
        if (picPath == null || picPath.equals("")) {
            return null;
        }
        File file = new File(picPath);
        if (!file.exists()) {
            return null;
        }
        try {
            bufferedImage = ImageIO.read(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (bufferedImage == null) {
            paintPanel.setOpaque(true);
            paintPanel.repaint();
            System.err.println("\u6253\u5f00\u56fe\u7247\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
            return null;
        }
        paintPanel.setOpaque(false);
        paintPanel.setImage(bufferedImage);
        paintPanel.repaint();
        return file;
    }

    public static Memory readPictureFile(String picPath) throws IOException {
        int nPicBufLen = 0;
        Memory memory = null;
        nPicBufLen = (int)ToolKits.GetFileSize(picPath);
        if (nPicBufLen <= 0) {
            System.err.println("\u8bfb\u53d6\u56fe\u7247\u5927\u5c0f\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
            return null;
        }
        memory = new Memory(nPicBufLen);
        memory.clear();
        if (!ToolKits.ReadAllFileToMemory(picPath, memory)) {
            System.err.println("\u8bfb\u53d6\u56fe\u7247\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
            return null;
        }
        return memory;
    }

    public static String getErrorCodeShow() {
        return ErrorCode.getErrorCode(LoginModule.netsdk.CLIENT_GetLastError());
    }

    public static String getErrorCodePrint() {
        return "\n{error code: (0x80000000|" + (LoginModule.netsdk.CLIENT_GetLastError() & Integer.MAX_VALUE) + ").\u53c2\u8003  NetSDKLib.java } - {error info:" + ErrorCode.getErrorCode(LoginModule.netsdk.CLIENT_GetLastError()) + "}\n";
    }

    public static boolean GetDevConfig(NetSDKLib.LLong hLoginHandle, int nChn, String strCmd, Structure cmdObject) {
        boolean result = false;
        int nBufferLen = 0x200000;
        byte[] strBuffer = new byte[nBufferLen];
        IntByReference error = new IntByReference(0);
        if (netsdkapi.CLIENT_GetNewDevConfig(hLoginHandle, strCmd, nChn, strBuffer, nBufferLen, error, 3000)) {
            cmdObject.write();
            if (configapi.CLIENT_ParseData(strCmd, strBuffer, cmdObject.getPointer(), cmdObject.size(), null)) {
                cmdObject.read();
                result = true;
            } else {
                System.err.println("Parse " + strCmd + " Config Failed!" + ToolKits.getErrorCodePrint());
                result = false;
            }
        } else {
            System.err.printf("Get %s Config Failed!Last Error = %s\n", strCmd, ToolKits.getErrorCodePrint());
            result = false;
        }
        return result;
    }

    public static boolean SetDevConfig(NetSDKLib.LLong hLoginHandle, int nChn, String strCmd, Structure cmdObject) {
        boolean result = false;
        int nBufferLen = 0x200000;
        byte[] szBuffer = new byte[nBufferLen];
        for (int i = 0; i < nBufferLen; ++i) {
            szBuffer[i] = 0;
        }
        IntByReference error = new IntByReference(0);
        IntByReference restart = new IntByReference(0);
        cmdObject.write();
        if (configapi.CLIENT_PacketData(strCmd, cmdObject.getPointer(), cmdObject.size(), szBuffer, nBufferLen)) {
            cmdObject.read();
            if (netsdkapi.CLIENT_SetNewDevConfig(hLoginHandle, strCmd, nChn, szBuffer, nBufferLen, error, restart, 3000)) {
                result = true;
            } else {
                System.err.printf("Set %s Config Failed! Last Error = %s\n", strCmd, ToolKits.getErrorCodePrint());
                result = false;
            }
        } else {
            System.err.println("Packet " + strCmd + " Config Failed!" + ToolKits.getErrorCodePrint());
            result = false;
        }
        return result;
    }

    public static Pointer GetGBKStringToPointer(String src) {
        Memory pointer = null;
        try {
            byte[] b = src.getBytes("GBK");
            pointer = new Memory(b.length + 1);
            pointer.clear(b.length + 1);
            ((Pointer)pointer).write(0L, b, 0, b.length);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return pointer;
    }

    public static void StringToByteArray(String src, byte[] dst) {
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = 0;
        }
        System.arraycopy(src.getBytes(), 0, dst, 0, src.getBytes().length);
    }

    public static void ByteArrayToByteArray(byte[] src, byte[] dst) {
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = 0;
        }
        System.arraycopy(src, 0, dst, 0, src.length);
    }

    static class JPGFilter
    extends FileFilter {
        JPGFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.getName().toLowerCase().endsWith(".JPG") || f.getName().toLowerCase().endsWith(".jpg") || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return "*.jpg; *.JPG";
        }
    }
}

