/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.common;

import java.lang.reflect.Method;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Vector;

public class CaseMenu {
    private Vector<Item> items = new Vector();

    public void addItem(Item item) {
        this.items.add(item);
    }

    private void showItem() {
        String format = "%2d\t%-20s\n";
        int index = 0;
        System.out.printf("%2d\t%-20s\n", index++, "exit App");
        for (Item item : this.items) {
            System.out.printf("%2d\t%-20s\n", index++, item.getItemName());
        }
        System.out.println("Please input a item index to invoke the method:");
    }

    public void run() {
        Scanner scanner = new Scanner(System.in);
        while (true) {
            this.showItem();
            try {
                int input = Integer.parseInt(scanner.nextLine());
                if (input <= 0) {
                    System.err.println("input <= 0 || scanner.nextLine() == null");
                    break;
                }
                if (input < 0 || input > this.items.size()) {
                    System.err.println("Input Error Item Index.");
                    continue;
                }
                Item item = this.items.get(input - 1);
                Class<?> itemClass = item.getObject().getClass();
                Method method = itemClass.getMethod(item.getMethodName(), new Class[0]);
                method.invoke(item.getObject(), new Object[0]);
                continue;
            }
            catch (NoSuchElementException e) {
            }
            catch (NumberFormatException e) {
                System.err.println("Input Error NumberFormat.");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        scanner.close();
    }

    public static class Item {
        private Object object;
        private String itemName;
        private String methodName;

        public Item(Object object, String itemName, String methodName) {
            this.object = object;
            this.itemName = itemName;
            this.methodName = methodName;
        }

        public Object getObject() {
            return this.object;
        }

        public String getItemName() {
            return this.itemName;
        }

        public String getMethodName() {
            return this.methodName;
        }
    }
}

