/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.common;

import com.netsdk.common.EventTaskHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;

public class EventTaskCommonQueue {
    private final int MAX_TASK_COUNT = 10000;
    private final LinkedBlockingDeque<EventTaskHandler> eventTasks = new LinkedBlockingDeque(10000);
    private final int MAX_THREAD_COUNT = 10;
    private ExecutorService eventQueueService = Executors.newFixedThreadPool(10);
    private volatile boolean running = true;
    private Future<?> eventQueueThreadStatus;

    public void init() {
        this.eventQueueThreadStatus = this.eventQueueService.submit(new Thread(new Runnable(){

            @Override
            public void run() {
                while (EventTaskCommonQueue.this.running) {
                    try {
                        EventTaskHandler task = (EventTaskHandler)EventTaskCommonQueue.this.eventTasks.take();
                        try {
                            task.eventTaskProcess();
                        }
                        catch (Exception e) {
                            System.err.println("\u4efb\u52a1\u5904\u7406\u53d1\u751f\u9519\u8bef");
                        }
                    }
                    catch (InterruptedException e) {
                        System.err.println("\u4efb\u52a1\u5df2\u610f\u5916\u505c\u6b62");
                        EventTaskCommonQueue.this.running = false;
                    }
                }
            }
        }, "Event call back thread init"));
    }

    public boolean addEvent(EventTaskHandler eventHandler) {
        if (!this.running) {
            System.out.println("\u4efb\u52a1\u5df2\u505c\u6b62");
            return false;
        }
        boolean success = this.eventTasks.offer(eventHandler);
        if (!success) {
            System.out.println("\u6dfb\u52a0\u5230\u4e8b\u4ef6\u961f\u5217\u5931\u8d25");
        }
        return success;
    }

    public void activeService() {
        this.running = true;
        if (this.eventQueueService.isShutdown()) {
            this.eventQueueService = Executors.newFixedThreadPool(10);
            this.init();
            System.out.println("\u7ebf\u7a0b\u6c60\u5df2\u5173\u95ed\uff0c\u91cd\u65b0\u521d\u59cb\u5316\u7ebf\u7a0b\u6c60\u53ca\u4efb\u52a1");
        }
        if (this.eventQueueThreadStatus.isDone()) {
            this.init();
            System.out.println("\u7ebf\u7a0b\u6c60\u4efb\u52a1\u7ed3\u675f\uff0c\u91cd\u65b0\u521d\u59cb\u5316\u4efb\u52a1");
        }
    }

    public void destroy() {
        this.running = false;
        this.eventQueueService.shutdownNow();
    }
}

