/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.Attendance;

import com.netsdk.common.BorderEx;
import com.netsdk.common.Res;
import com.netsdk.demo.module.AlarmListenModule;
import com.netsdk.demo.module.AttendanceModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class AddFingerPrintDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final int CHANNEL_ID = 0;
    private static final String READER_ID = "1";
    private static final long TIMER_DELAY = 30000L;
    private String userID = null;
    private byte[] collectionData = null;
    private Timer timer = new Timer();
    private ReentrantLock lock = new ReentrantLock();
    private NetSDKLib.fMessCallBack cbMessage;
    private JLabel promptLabel;
    private JButton collectionBtn;
    private JButton addBtn;
    private JButton cancelBtn;

    public AddFingerPrintDialog(String userId) {
        this.setTitle(Res.string().getAddFingerPrint());
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.pack();
        this.setSize(300, 180);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        JPanel collectionPanel = new JPanel();
        BorderEx.set(collectionPanel, Res.string().getcFingerPrintCollection(), 4);
        collectionPanel.setLayout(new FlowLayout(1, 35, 25));
        this.collectionBtn = new JButton(Res.string().getStartCollection());
        this.collectionBtn.setPreferredSize(new Dimension(150, 20));
        this.promptLabel = new JLabel();
        this.promptLabel.setPreferredSize(new Dimension(150, 20));
        this.promptLabel.setHorizontalAlignment(0);
        collectionPanel.add(this.collectionBtn);
        collectionPanel.add(this.promptLabel);
        JPanel functionPanel = new JPanel();
        this.addBtn = new JButton(Res.string().getAdd());
        this.cancelBtn = new JButton(Res.string().getCancel());
        this.addBtn.setPreferredSize(new Dimension(100, 20));
        this.cancelBtn.setPreferredSize(new Dimension(100, 20));
        functionPanel.add(this.addBtn);
        functionPanel.add(this.cancelBtn);
        this.add((Component)collectionPanel, "Center");
        this.add((Component)functionPanel, "South");
        this.addBtn.setEnabled(false);
        this.userID = userId;
        this.cbMessage = new fCollectionDataCB();
        this.collectionBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddFingerPrintDialog.this.collectionFinger();
            }
        });
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AttendanceModule.insertFingerByUserId(AddFingerPrintDialog.this.userID, AddFingerPrintDialog.this.collectionData)) {
                    JOptionPane.showMessageDialog(null, Res.string().getSucceed(), Res.string().getPromptMessage(), 1);
                } else {
                    JOptionPane.showMessageDialog(null, Res.string().getFailed(), Res.string().getErrorMessage(), 0);
                }
                AddFingerPrintDialog.this.dispose();
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlarmListenModule.stopListen();
                AddFingerPrintDialog.this.timer.cancel();
                AddFingerPrintDialog.this.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AlarmListenModule.stopListen();
                AddFingerPrintDialog.this.timer.cancel();
                AddFingerPrintDialog.this.dispose();
            }
        });
    }

    public void collectionFinger() {
        if (!AlarmListenModule.startListen(this.cbMessage)) {
            JOptionPane.showMessageDialog(null, Res.string().getCollectionFailed() + "," + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return;
        }
        this.collectionData = null;
        if (!AttendanceModule.collectionFinger(0, READER_ID)) {
            JOptionPane.showMessageDialog(null, Res.string().getCollectionFailed() + "," + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AddFingerPrintDialog.this.promptLabel.setText(Res.string().getInCollection());
                AddFingerPrintDialog.this.collectionBtn.setEnabled(false);
            }
        });
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                AddFingerPrintDialog.this.lock.lock();
                if (AddFingerPrintDialog.this.collectionData == null) {
                    AlarmListenModule.stopListen();
                    AddFingerPrintDialog.this.promptLabel.setText(Res.string().getCollectionFailed());
                    AddFingerPrintDialog.this.collectionBtn.setEnabled(true);
                }
                AddFingerPrintDialog.this.lock.unlock();
            }
        }, 30000L);
    }

    static /* synthetic */ byte[] access$202(AddFingerPrintDialog x0, byte[] x1) {
        x0.collectionData = x1;
        return x1;
    }

    private class fCollectionDataCB
    implements NetSDKLib.fMessCallBack {
        private fCollectionDataCB() {
        }

        @Override
        public boolean invoke(int lCommand, NetSDKLib.LLong lLoginID, Pointer pStuEvent, int dwBufLen, String strDeviceIP, NativeLong nDevicePort, Pointer dwUser) {
            if (lCommand == 12685) {
                AddFingerPrintDialog.this.lock.lock();
                if (AddFingerPrintDialog.this.collectionData == null) {
                    AddFingerPrintDialog.this.timer.cancel();
                    NetSDKLib.ALARM_CAPTURE_FINGER_PRINT_INFO msg = new NetSDKLib.ALARM_CAPTURE_FINGER_PRINT_INFO();
                    ToolKits.GetPointerData(pStuEvent, msg);
                    AddFingerPrintDialog.access$202(AddFingerPrintDialog.this, new byte[msg.nPacketLen * msg.nPacketNum]);
                    msg.szFingerPrintInfo.read(0L, AddFingerPrintDialog.this.collectionData, 0, msg.nPacketLen * msg.nPacketNum);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AlarmListenModule.stopListen();
                            AddFingerPrintDialog.this.promptLabel.setText(Res.string().getcCompleteCollection());
                            AddFingerPrintDialog.this.addBtn.setEnabled(true);
                        }
                    });
                }
                AddFingerPrintDialog.this.lock.unlock();
            }
            return true;
        }
    }
}

