/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.Attendance;

import com.netsdk.common.FunctionList;
import com.netsdk.common.LoginPanel;
import com.netsdk.common.Res;
import com.netsdk.demo.frame.Attendance.AttendanceFunctionOperatePanel;
import com.netsdk.demo.frame.Attendance.AttendanceShowPanel;
import com.netsdk.demo.module.AttendanceModule;
import com.netsdk.demo.module.LoginModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.Pointer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class AttendanceFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private DisConnect disConnect = new DisConnect();
    private static JFrame frame = new JFrame();
    private LoginPanel loginPanel;
    private AttendanceFunctionOperatePanel operatePanel;
    private AttendanceShowPanel showPanel;

    public AttendanceFrame() {
        this.setTitle(Res.string().getAttendance());
        this.setLayout(new BorderLayout());
        this.pack();
        this.setSize(800, 555);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        LoginModule.init(this.disConnect, null);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loginPanel = new LoginPanel();
        this.showPanel = new AttendanceShowPanel();
        this.operatePanel = new AttendanceFunctionOperatePanel(this.showPanel);
        JSplitPane splitPane = new JSplitPane(0, this.loginPanel, this.operatePanel);
        splitPane.setDividerSize(0);
        splitPane.setBorder(null);
        this.add((Component)splitPane, "North");
        this.add((Component)this.showPanel, "Center");
        this.loginPanel.addLoginBtnActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AttendanceFrame.this.loginPanel.checkLoginText() && AttendanceFrame.this.login()) {
                    frame = ToolKits.getFrame(e);
                    frame.setTitle(Res.string().getAttendance() + " : " + Res.string().getOnline());
                }
            }
        });
        this.loginPanel.addLogoutBtnActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AttendanceFrame.this.logout();
                    }
                });
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AttendanceModule.stopRealLoadPicture();
                LoginModule.logout();
                LoginModule.cleanup();
                AttendanceFrame.this.dispose();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FunctionList demo = new FunctionList();
                        demo.setVisible(true);
                    }
                });
            }
        });
    }

    public boolean login() {
        if (!LoginModule.login(this.loginPanel.ipTextArea.getText(), Integer.parseInt(this.loginPanel.portTextArea.getText()), this.loginPanel.nameTextArea.getText(), new String(this.loginPanel.passwordTextArea.getPassword()))) {
            JOptionPane.showMessageDialog(null, Res.string().getLoginFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return false;
        }
        this.loginPanel.setButtonEnable(true);
        this.operatePanel.setButtonEnable(true);
        return true;
    }

    public void logout() {
        AttendanceModule.stopRealLoadPicture();
        LoginModule.logout();
        frame.setTitle(Res.string().getAttendance());
        this.loginPanel.setButtonEnable(false);
        this.operatePanel.setButtonEnable(false);
        this.showPanel.clearup();
    }

    private class DisConnect
    implements NetSDKLib.fDisConnect {
        @Override
        public void invoke(NetSDKLib.LLong m_hLoginHandle, String pchDVRIP, int nDVRPort, Pointer dwUser) {
            System.out.printf("Device[%s] Port[%d] DisConnect!\n", pchDVRIP, nDVRPort);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, Res.string().getDisConnect(), Res.string().getErrorMessage(), 0);
                    AttendanceFrame.this.logout();
                }
            });
        }
    }
}

