/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.Attendance;

import com.netsdk.common.BorderEx;
import com.netsdk.common.Res;
import com.netsdk.demo.frame.Attendance.AttendanceOperateShareDialog;
import com.netsdk.demo.frame.Attendance.AttendanceShowPanel;
import com.netsdk.demo.frame.Attendance.OperateByFingerPrintIdDialog;
import com.netsdk.demo.frame.Attendance.OperateByUserIdDialog;
import com.netsdk.demo.frame.Attendance.SubscribePanel;
import com.netsdk.demo.module.AttendanceModule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class AttendanceFunctionOperatePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static boolean bLogout = false;
    public AttendanceShowPanel showPanel;
    private AttendanceFunctionOperatePanel target = this;
    private UserOperateActionListener listener;
    public FunctionOperatePanel userPanel;
    public SubscribePanel subscribePanel;

    public AttendanceFunctionOperatePanel(AttendanceShowPanel showPanel) {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(800, 120));
        this.listener = new UserOperateActionListener();
        this.userPanel = new FunctionOperatePanel();
        this.subscribePanel = new SubscribePanel(showPanel.eventShowPanel);
        JSplitPane splitPane = new JSplitPane();
        splitPane.setDividerSize(0);
        splitPane.setBorder(null);
        splitPane.add((Component)this.userPanel, "left");
        splitPane.add((Component)this.subscribePanel, "right");
        this.add((Component)splitPane, "Center");
        this.showPanel = showPanel;
        this.showPanel.userShowPanel.prePageBtn.addActionListener(this.listener);
        this.showPanel.userShowPanel.nextPageBtn.addActionListener(this.listener);
    }

    public void setButtonEnable(boolean b) {
        bLogout = !b;
        this.userPanel.setButtonEnable(b);
        this.subscribePanel.setButtonEnable(b);
    }

    public void setSearchEnable(boolean b) {
        this.showPanel.userShowPanel.setButtonEnable(b);
        this.userPanel.searchPersonBtn.setEnabled(b);
    }

    public void insertData(AttendanceModule.UserData[] arrUserData) {
        this.showPanel.userShowPanel.insertData(arrUserData);
    }

    public void insertData(AttendanceModule.UserData userData) {
        this.showPanel.userShowPanel.insertData(userData);
    }

    public class SearchPersonSwingWorker
    extends SwingWorker<AttendanceModule.UserData[], Object> {
        private AttendanceFunctionOperatePanel operatePanel;
        private int offset = 0;
        private AttendanceModule.OPERATE_TYPE type;

        public SearchPersonSwingWorker(AttendanceModule.OPERATE_TYPE type, AttendanceFunctionOperatePanel operatePanel) {
            this.operatePanel = operatePanel;
            this.type = type;
        }

        @Override
        protected AttendanceModule.UserData[] doInBackground() throws Exception {
            switch (this.type) {
                case SEARCH_USER: {
                    this.offset = 0;
                    break;
                }
                case PRE_SEARCH_USER: {
                    this.offset = 15 * ((AttendanceShowPanel.userIndex - 1) / 15 - 1);
                    break;
                }
                case NEXT_SEARCH_USER: {
                    this.offset = AttendanceShowPanel.userIndex;
                    break;
                }
            }
            AttendanceModule.UserData[] arrUserData = AttendanceModule.findUser(this.offset, 15);
            return arrUserData;
        }

        @Override
        protected void done() {
            if (bLogout) {
                return;
            }
            try {
                AttendanceModule.UserData[] arrUserData = (AttendanceModule.UserData[])this.get();
                if (arrUserData == null) {
                    JOptionPane.showMessageDialog(null, Res.string().getFailed(), Res.string().getErrorMessage(), 0);
                    return;
                }
                if (this.type == AttendanceModule.OPERATE_TYPE.SEARCH_USER || this.type == AttendanceModule.OPERATE_TYPE.PRE_SEARCH_USER) {
                    AttendanceShowPanel.userIndex = this.offset;
                }
                this.operatePanel.insertData(arrUserData);
            }
            catch (Exception exception) {
            }
            finally {
                this.operatePanel.setSearchEnable(true);
            }
        }
    }

    public class SearchRunnable
    implements Runnable {
        private AttendanceModule.OPERATE_TYPE searchType;

        public SearchRunnable(AttendanceModule.OPERATE_TYPE searchType) {
            this.searchType = searchType;
        }

        @Override
        public void run() {
            AttendanceFunctionOperatePanel.this.userPanel.searchPerson(this.searchType);
        }
    }

    private class UserOperateActionListener
    implements ActionListener {
        private UserOperateActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            AttendanceModule.OPERATE_TYPE emType = this.getOperateType(arg0.getSource());
            switch (emType) {
                case SEARCH_USER: 
                case PRE_SEARCH_USER: 
                case NEXT_SEARCH_USER: {
                    SwingUtilities.invokeLater(new SearchRunnable(emType));
                    break;
                }
                case ADD_USER: {
                    new AttendanceOperateShareDialog(emType, null, "").setVisible(true);
                    break;
                }
                case MODIFIY_USER: 
                case DELETE_USER: 
                case FINGERPRINT_OPEARTE_BY_USERID: {
                    AttendanceModule.UserData userData = AttendanceFunctionOperatePanel.this.showPanel.userShowPanel.GetSelectedItem();
                    if (userData == null) {
                        JOptionPane.showMessageDialog(null, Res.string().getSelectPerson(), Res.string().getErrorMessage(), 0);
                        return;
                    }
                    if (emType == AttendanceModule.OPERATE_TYPE.FINGERPRINT_OPEARTE_BY_USERID) {
                        new OperateByUserIdDialog(userData).setVisible(true);
                        break;
                    }
                    new AttendanceOperateShareDialog(emType, userData).setVisible(true);
                    break;
                }
                case FINGERPRINT_OPEARTE_BY_ID: {
                    new OperateByFingerPrintIdDialog().setVisible(true);
                }
            }
        }

        private AttendanceModule.OPERATE_TYPE getOperateType(Object btn) {
            AttendanceModule.OPERATE_TYPE type = AttendanceModule.OPERATE_TYPE.UNKNOWN;
            if (btn == AttendanceFunctionOperatePanel.this.userPanel.searchPersonBtn) {
                type = AttendanceModule.OPERATE_TYPE.SEARCH_USER;
            } else if (btn == AttendanceFunctionOperatePanel.this.showPanel.userShowPanel.prePageBtn) {
                type = AttendanceModule.OPERATE_TYPE.PRE_SEARCH_USER;
            } else if (btn == AttendanceFunctionOperatePanel.this.showPanel.userShowPanel.nextPageBtn) {
                type = AttendanceModule.OPERATE_TYPE.NEXT_SEARCH_USER;
            } else if (btn == AttendanceFunctionOperatePanel.this.userPanel.addPersonBtn) {
                type = AttendanceModule.OPERATE_TYPE.ADD_USER;
            } else if (btn == AttendanceFunctionOperatePanel.this.userPanel.modifyPersonBtn) {
                type = AttendanceModule.OPERATE_TYPE.MODIFIY_USER;
            } else if (btn == AttendanceFunctionOperatePanel.this.userPanel.deletePersonBtn) {
                type = AttendanceModule.OPERATE_TYPE.DELETE_USER;
            } else if (btn == AttendanceFunctionOperatePanel.this.userPanel.operateByUserIdBtn) {
                type = AttendanceModule.OPERATE_TYPE.FINGERPRINT_OPEARTE_BY_USERID;
            } else if (btn == AttendanceFunctionOperatePanel.this.userPanel.operateByFingerPrintIdBtn) {
                type = AttendanceModule.OPERATE_TYPE.FINGERPRINT_OPEARTE_BY_ID;
            } else {
                System.err.println("Unknown Event: " + btn);
            }
            return type;
        }
    }

    public class FunctionOperatePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JTextField userIdTextField;
        public JButton searchPersonBtn;
        private JButton addPersonBtn;
        private JButton modifyPersonBtn;
        private JButton deletePersonBtn;
        private JButton operateByUserIdBtn;
        private JButton operateByFingerPrintIdBtn;

        public FunctionOperatePanel() {
            this.setLayout(new BorderLayout());
            this.setPreferredSize(new Dimension(600, 60));
            JLabel userIdLabel = new JLabel(Res.string().getUserId(), 0);
            this.userIdTextField = new JTextField();
            userIdLabel.setPreferredSize(new Dimension(80, 20));
            this.userIdTextField.setPreferredSize(new Dimension(110, 20));
            JPanel userFunctionPanel = new JPanel();
            userFunctionPanel.setLayout(new FlowLayout(0));
            BorderEx.set(userFunctionPanel, Res.string().getUserOperate(), 1);
            this.searchPersonBtn = new JButton(Res.string().getSearch());
            this.addPersonBtn = new JButton(Res.string().getAdd());
            this.modifyPersonBtn = new JButton(Res.string().getModify());
            this.deletePersonBtn = new JButton(Res.string().getDelete());
            this.searchPersonBtn.setPreferredSize(new Dimension(90, 20));
            this.addPersonBtn.setPreferredSize(new Dimension(90, 20));
            this.modifyPersonBtn.setPreferredSize(new Dimension(90, 20));
            this.deletePersonBtn.setPreferredSize(new Dimension(90, 20));
            userFunctionPanel.add(userIdLabel);
            userFunctionPanel.add(this.userIdTextField);
            userFunctionPanel.add(this.searchPersonBtn);
            userFunctionPanel.add(this.addPersonBtn);
            userFunctionPanel.add(this.modifyPersonBtn);
            userFunctionPanel.add(this.deletePersonBtn);
            JPanel fingerPrintFunctionPanel = new JPanel(new FlowLayout(1));
            BorderEx.set(fingerPrintFunctionPanel, Res.string().getFingerPrintOperate(), 1);
            this.operateByUserIdBtn = new JButton(Res.string().getOperateByUserId());
            this.operateByFingerPrintIdBtn = new JButton(Res.string().getOperateByFingerPrintId());
            this.operateByUserIdBtn.setPreferredSize(new Dimension(260, 20));
            this.operateByFingerPrintIdBtn.setPreferredSize(new Dimension(260, 20));
            fingerPrintFunctionPanel.add(this.operateByUserIdBtn);
            fingerPrintFunctionPanel.add(this.operateByFingerPrintIdBtn);
            JSplitPane splitPane = new JSplitPane(0);
            splitPane.setDividerSize(0);
            splitPane.setBorder(null);
            splitPane.add((Component)userFunctionPanel, "top");
            splitPane.add((Component)fingerPrintFunctionPanel, "bottom");
            this.add((Component)splitPane, "Center");
            this.searchPersonBtn.addActionListener(AttendanceFunctionOperatePanel.this.listener);
            this.addPersonBtn.addActionListener(AttendanceFunctionOperatePanel.this.listener);
            this.modifyPersonBtn.addActionListener(AttendanceFunctionOperatePanel.this.listener);
            this.deletePersonBtn.addActionListener(AttendanceFunctionOperatePanel.this.listener);
            this.operateByUserIdBtn.addActionListener(AttendanceFunctionOperatePanel.this.listener);
            this.operateByFingerPrintIdBtn.addActionListener(AttendanceFunctionOperatePanel.this.listener);
            this.setButtonEnable(false);
        }

        public void setButtonEnable(boolean b) {
            this.searchPersonBtn.setEnabled(b);
            this.addPersonBtn.setEnabled(b);
            this.modifyPersonBtn.setEnabled(b);
            this.deletePersonBtn.setEnabled(b);
            this.operateByUserIdBtn.setEnabled(b);
            this.operateByFingerPrintIdBtn.setEnabled(b);
        }

        public void searchPerson(AttendanceModule.OPERATE_TYPE type) {
            if (type == AttendanceModule.OPERATE_TYPE.SEARCH_USER && !this.userIdTextField.getText().isEmpty()) {
                AttendanceModule.UserData userData = AttendanceModule.getUser(this.userIdTextField.getText());
                if (userData == null) {
                    JOptionPane.showMessageDialog(null, Res.string().getFailed(), Res.string().getErrorMessage(), 0);
                    return;
                }
                AttendanceFunctionOperatePanel.this.showPanel.userShowPanel.insertData(userData);
            } else {
                AttendanceFunctionOperatePanel.this.setSearchEnable(false);
                new SearchPersonSwingWorker(type, AttendanceFunctionOperatePanel.this.target).execute();
            }
        }
    }
}

