/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.Attendance;

import com.netsdk.common.Base64;
import com.netsdk.common.BorderEx;
import com.netsdk.common.Res;
import com.netsdk.demo.frame.Attendance.AttendanceOperateShareDialog;
import com.netsdk.demo.module.AttendanceModule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class OperateByFingerPrintIdDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTextField fingerPrintIdTextField;
    public JButton searchFingerPrintBtn;
    private JButton deleteFingerPrintBtn;
    private JLabel userId;
    private JTextArea fingerPrintData;
    private FingerPrintIdOperateActionListener listener;

    public OperateByFingerPrintIdDialog() {
        this.setTitle(Res.string().getOperateByFingerPrintId());
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.pack();
        this.setSize(600, 500);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        JLabel fingerPrintIdLabel = new JLabel(Res.string().getFingerPrintId(), 0);
        this.fingerPrintIdTextField = new JTextField();
        fingerPrintIdLabel.setPreferredSize(new Dimension(85, 20));
        this.fingerPrintIdTextField.setPreferredSize(new Dimension(100, 20));
        this.searchFingerPrintBtn = new JButton(Res.string().getSearchFingerPrint());
        this.deleteFingerPrintBtn = new JButton(Res.string().getDeleteFingerPrint());
        this.searchFingerPrintBtn.setPreferredSize(new Dimension(140, 20));
        this.deleteFingerPrintBtn.setPreferredSize(new Dimension(140, 20));
        JPanel functionPanel = new JPanel();
        BorderEx.set(functionPanel, Res.string().getOperateByFingerPrintId(), 1);
        functionPanel.add(fingerPrintIdLabel);
        functionPanel.add(this.fingerPrintIdTextField);
        functionPanel.add(this.searchFingerPrintBtn);
        functionPanel.add(this.deleteFingerPrintBtn);
        JPanel fingerPrintPanel = new JPanel();
        BorderEx.set(fingerPrintPanel, Res.string().getFingerPrintInfo(), 1);
        fingerPrintPanel.setLayout(null);
        JLabel userIdLabel = new JLabel(Res.string().getUserId());
        this.userId = new JLabel();
        JLabel fingerPrintDataLabel = new JLabel(Res.string().getFingerPrintData());
        this.fingerPrintData = new JTextArea();
        this.fingerPrintData.setBackground(null);
        this.fingerPrintData.setEditable(false);
        this.fingerPrintData.setLineWrap(true);
        JScrollPane scrollPane = new JScrollPane(this.fingerPrintData);
        userIdLabel.setBounds(30, 30, 90, 20);
        this.userId.setBounds(150, 30, 300, 20);
        fingerPrintDataLabel.setBounds(30, 60, 150, 20);
        this.fingerPrintData.setBounds(30, 80, 600, 20);
        scrollPane.setBounds(30, 80, 550, 300);
        scrollPane.setBorder(null);
        fingerPrintPanel.add(userIdLabel);
        fingerPrintPanel.add(this.userId);
        fingerPrintPanel.add(fingerPrintDataLabel);
        fingerPrintPanel.add(scrollPane);
        this.add((Component)functionPanel, "North");
        this.add((Component)fingerPrintPanel, "Center");
        this.fingerPrintIdTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                char key = e.getKeyChar();
                if (key < '0' || key > '9') {
                    e.consume();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.listener = new FingerPrintIdOperateActionListener();
        this.searchFingerPrintBtn.addActionListener(this.listener);
        this.deleteFingerPrintBtn.addActionListener(this.listener);
    }

    public String getFingerPrintId() {
        if (this.fingerPrintIdTextField.getText().isEmpty()) {
            JOptionPane.showMessageDialog(null, Res.string().getInput() + Res.string().getFingerPrintId(), Res.string().getErrorMessage(), 0);
            return null;
        }
        try {
            Integer.parseInt(this.fingerPrintIdTextField.getText());
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, Res.string().getFingerPrintIdIllegal(), Res.string().getErrorMessage(), 0);
            return null;
        }
        return this.fingerPrintIdTextField.getText();
    }

    public void searchFingerPrint() {
        this.clearFingerPrintInfo();
        String fingerPrintId = this.getFingerPrintId();
        if (fingerPrintId == null) {
            return;
        }
        AttendanceModule.UserData userData = AttendanceModule.getFingerRecord(Integer.parseInt(fingerPrintId));
        if (userData == null) {
            JOptionPane.showMessageDialog(null, Res.string().getFailed(), Res.string().getErrorMessage(), 0);
            return;
        }
        if (userData.szFingerPrintInfo[0].length == 0) {
            JOptionPane.showMessageDialog(null, Res.string().getFingerPrintIdNotExist(), Res.string().getErrorMessage(), 0);
            return;
        }
        this.dealFingerPrintInfo(userData);
    }

    public void dealFingerPrintInfo(AttendanceModule.UserData userData) {
        this.userId.setText(userData.userId);
        this.fingerPrintData.setText(this.formatFingerPrintData(userData.szFingerPrintInfo[0]));
    }

    private String formatFingerPrintData(byte[] fingerPrintData) {
        String formatData = Base64.getEncoder().encodeToString(fingerPrintData);
        return formatData;
    }

    public void clearFingerPrintInfo() {
        this.userId.setText("");
        this.fingerPrintData.setText("");
    }

    private class FingerPrintIdOperateActionListener
    implements ActionListener {
        private FingerPrintIdOperateActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            AttendanceModule.OPERATE_TYPE emType = this.getOperateType(arg0.getSource());
            switch (emType) {
                case SEARCH_FINGERPRINT_BY_ID: {
                    OperateByFingerPrintIdDialog.this.searchFingerPrint();
                    break;
                }
                case DELETE_FINGERPRINT_BY_ID: {
                    String fingerPrintId = OperateByFingerPrintIdDialog.this.getFingerPrintId();
                    if (fingerPrintId == null) {
                        return;
                    }
                    new AttendanceOperateShareDialog(emType, fingerPrintId).setVisible(true);
                    break;
                }
            }
        }

        private AttendanceModule.OPERATE_TYPE getOperateType(Object btn) {
            AttendanceModule.OPERATE_TYPE type = AttendanceModule.OPERATE_TYPE.UNKNOWN;
            if (btn == OperateByFingerPrintIdDialog.this.searchFingerPrintBtn) {
                type = AttendanceModule.OPERATE_TYPE.SEARCH_FINGERPRINT_BY_ID;
            } else if (btn == OperateByFingerPrintIdDialog.this.deleteFingerPrintBtn) {
                type = AttendanceModule.OPERATE_TYPE.DELETE_FINGERPRINT_BY_ID;
            } else {
                System.err.println("Unknown Event: " + btn);
            }
            return type;
        }
    }
}

