/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.Attendance;

import com.netsdk.common.Base64;
import com.netsdk.common.BorderEx;
import com.netsdk.common.Res;
import com.netsdk.demo.frame.Attendance.AddFingerPrintDialog;
import com.netsdk.demo.frame.Attendance.AttendanceOperateShareDialog;
import com.netsdk.demo.module.AttendanceModule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class OperateByUserIdDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private AttendanceModule.UserData userData;
    public JButton searchFingerPrintBtn;
    private JButton addFingerPrintBtn;
    private JButton deleteFingerPrintBtn;
    private UserIdOperateActionListener listener;
    private FingerPrintShowPanel fingerPrintShowPanel;

    public OperateByUserIdDialog(AttendanceModule.UserData userData) {
        this.setTitle(Res.string().getOperateByUserId());
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.pack();
        this.setSize(570, 383);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        JPanel userInfoPanel = new JPanel();
        userInfoPanel.setLayout(new FlowLayout(0));
        BorderEx.set(userInfoPanel, Res.string().getUserInfo(), 2);
        JLabel userIdLabel = new JLabel(Res.string().getUserId(), 0);
        JTextField userIdTextField = new JTextField(userData.userId);
        JLabel userNameLabel = new JLabel(Res.string().getUserName(true), 0);
        JTextField userNameTextField = new JTextField(userData.userName);
        JLabel cardNoLabel = new JLabel(Res.string().getCardNo(), 0);
        JTextField cardNoTextField = new JTextField(userData.cardNo);
        userIdTextField.setEnabled(false);
        userNameTextField.setEnabled(false);
        cardNoTextField.setEnabled(false);
        Dimension dimLable = new Dimension(55, 20);
        userIdLabel.setPreferredSize(dimLable);
        userNameLabel.setPreferredSize(dimLable);
        cardNoLabel.setPreferredSize(dimLable);
        Dimension dimValue = new Dimension(100, 20);
        userIdTextField.setPreferredSize(dimValue);
        userNameTextField.setPreferredSize(dimValue);
        cardNoTextField.setPreferredSize(dimValue);
        userInfoPanel.add(userIdLabel);
        userInfoPanel.add(userIdTextField);
        userInfoPanel.add(userNameLabel);
        userInfoPanel.add(userNameTextField);
        userInfoPanel.add(cardNoLabel);
        userInfoPanel.add(cardNoTextField);
        JPanel functionPanel = new JPanel();
        BorderEx.set(functionPanel, Res.string().getOperateByUserId(), 2);
        this.searchFingerPrintBtn = new JButton(Res.string().getSearchFingerPrint());
        this.addFingerPrintBtn = new JButton(Res.string().getAddFingerPrint());
        this.deleteFingerPrintBtn = new JButton(Res.string().getDeleteFingerPrint());
        this.searchFingerPrintBtn.setPreferredSize(new Dimension(150, 20));
        this.addFingerPrintBtn.setPreferredSize(new Dimension(150, 20));
        this.deleteFingerPrintBtn.setPreferredSize(new Dimension(150, 20));
        functionPanel.add(this.searchFingerPrintBtn);
        functionPanel.add(this.addFingerPrintBtn);
        functionPanel.add(this.deleteFingerPrintBtn);
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setDividerSize(0);
        splitPane.setBorder(null);
        splitPane.add((Component)userInfoPanel, "top");
        splitPane.add((Component)functionPanel, "bottom");
        this.add((Component)splitPane, "North");
        this.fingerPrintShowPanel = new FingerPrintShowPanel();
        this.add((Component)this.fingerPrintShowPanel, "Center");
        this.listener = new UserIdOperateActionListener();
        this.searchFingerPrintBtn.addActionListener(this.listener);
        this.addFingerPrintBtn.addActionListener(this.listener);
        this.deleteFingerPrintBtn.addActionListener(this.listener);
        this.userData = userData;
    }

    public void searchFingerPrint() {
        this.clearTable();
        boolean bSuccess = AttendanceModule.getFingerByUserId(this.userData.userId, this.userData);
        if (bSuccess) {
            this.fingerPrintShowPanel.insertData(this.userData);
        } else {
            JOptionPane.showMessageDialog(null, Res.string().getFailed(), Res.string().getErrorMessage(), 0);
        }
    }

    public void clearTable() {
        this.fingerPrintShowPanel.clearData();
    }

    public void addFingerPrint(int fingerPrintId, byte[] fingerPrintData) {
        this.fingerPrintShowPanel.insertData(fingerPrintId, fingerPrintData);
    }

    public class FingerPrintShowPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        public static final int INDEX = 0;
        public static final int USER_ID = 1;
        public static final int FINGERPRINT_ID = 2;
        public static final int FINGERPRINT_DATA = 3;
        public static final int MAX_FINGERPRINT_NUM = 10;
        private int realRows = 0;
        private JTable table = null;
        private DefaultTableModel tableModel = null;

        public FingerPrintShowPanel() {
            BorderEx.set(this, Res.string().getFingerPrintInfo(), 1);
            this.setLayout(new BorderLayout());
            this.setPreferredSize(new Dimension(550, 375));
            Vector<String> columnNames = new Vector<String>();
            columnNames.add(Res.string().getIndex());
            columnNames.add(Res.string().getUserId());
            columnNames.add(Res.string().getFingerPrintId());
            columnNames.add(Res.string().getFingerPrintData());
            this.tableModel = new DefaultTableModel(null, columnNames);
            this.table = new JTable(this.tableModel){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return false;
                }
            };
            this.tableModel.setRowCount(10);
            this.table.setSelectionMode(0);
            this.table.getColumnModel().getColumn(0).setPreferredWidth(80);
            this.table.getColumnModel().getColumn(1).setPreferredWidth(100);
            this.table.getColumnModel().getColumn(2).setPreferredWidth(100);
            this.table.getColumnModel().getColumn(3).setPreferredWidth(8888);
            ((DefaultTableCellRenderer)this.table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
            this.table.setAutoResizeMode(0);
            JScrollPane scrollPane = new JScrollPane(this.table);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setHorizontalScrollBarPolicy(30);
            this.add((Component)scrollPane, "Center");
        }

        public void insertData(AttendanceModule.UserData userData) {
            if (userData.nFingerPrintIDs == null) {
                return;
            }
            this.clearData();
            this.tableModel.setRowCount(0);
            for (int i = 0; i < userData.nFingerPrintIDs.length; ++i) {
                this.insertFingerPrintData(userData.nFingerPrintIDs[i], userData.szFingerPrintInfo[i]);
            }
            this.tableModel.setRowCount(10);
            this.table.updateUI();
        }

        public void insertData(int fingerPrintId, byte[] fingerPrintData) {
            this.tableModel.setRowCount(this.realRows);
            this.insertFingerPrintData(fingerPrintId, fingerPrintData);
            this.tableModel.setRowCount(10);
            this.table.updateUI();
        }

        private void insertFingerPrintData(int fingerPrintId, byte[] fingerPrintData) {
            ++this.realRows;
            Vector<String> vector = new Vector<String>();
            vector.add(String.valueOf(this.realRows));
            vector.add(((OperateByUserIdDialog)OperateByUserIdDialog.this).userData.userId);
            vector.add(String.valueOf(fingerPrintId));
            vector.add(this.formatFingerPrintData(fingerPrintData));
            this.tableModel.addRow(vector);
        }

        private String formatFingerPrintData(byte[] fingerPrintData) {
            String formatData = Base64.getEncoder().encodeToString(fingerPrintData);
            return formatData;
        }

        public void clearData() {
            this.realRows = 0;
            this.tableModel.setRowCount(0);
            this.tableModel.setRowCount(10);
            this.table.updateUI();
        }
    }

    private class UserIdOperateActionListener
    implements ActionListener {
        private UserIdOperateActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            AttendanceModule.OPERATE_TYPE emType = this.getOperateType(arg0.getSource());
            switch (emType) {
                case SEARCH_FINGERPRINT_BY_USERID: {
                    OperateByUserIdDialog.this.searchFingerPrint();
                    break;
                }
                case ADD_FINGERPRINT: {
                    new AddFingerPrintDialog(((OperateByUserIdDialog)OperateByUserIdDialog.this).userData.userId).setVisible(true);
                    break;
                }
                case DELETE_FINGERPRINT_BY_USERID: {
                    new AttendanceOperateShareDialog(emType, OperateByUserIdDialog.this.userData).setVisible(true);
                    break;
                }
            }
        }

        private AttendanceModule.OPERATE_TYPE getOperateType(Object btn) {
            AttendanceModule.OPERATE_TYPE type = AttendanceModule.OPERATE_TYPE.UNKNOWN;
            if (btn == OperateByUserIdDialog.this.searchFingerPrintBtn) {
                type = AttendanceModule.OPERATE_TYPE.SEARCH_FINGERPRINT_BY_USERID;
            } else if (btn == OperateByUserIdDialog.this.addFingerPrintBtn) {
                type = AttendanceModule.OPERATE_TYPE.ADD_FINGERPRINT;
            } else if (btn == OperateByUserIdDialog.this.deleteFingerPrintBtn) {
                type = AttendanceModule.OPERATE_TYPE.DELETE_FINGERPRINT_BY_USERID;
            } else {
                System.err.println("Unknown Event: " + btn);
            }
            return type;
        }
    }
}

