/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.Attendance;

import com.netsdk.common.BorderEx;
import com.netsdk.common.Res;
import com.netsdk.demo.frame.Attendance.AttendanceShowPanel;
import com.netsdk.demo.module.AttendanceModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.Pointer;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SubscribePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Component target = this;
    private boolean bSubscribe = false;
    private AttendanceShowPanel.EventInfoShowPanel eventShowPanel;
    private JButton subscribeBtn;
    private NetSDKLib.fAnalyzerDataCallBack callback;

    public SubscribePanel(AttendanceShowPanel.EventInfoShowPanel eventPanel) {
        BorderEx.set(this, Res.string().getSubscribe(), 1);
        this.setLayout(new FlowLayout(1, 5, 30));
        this.setPreferredSize(new Dimension(180, 80));
        this.eventShowPanel = eventPanel;
        this.callback = new fAnalyzerDataCB();
        this.subscribeBtn = new JButton(Res.string().getSubscribe());
        this.subscribeBtn.setPreferredSize(new Dimension(150, 20));
        this.add(this.subscribeBtn);
        this.subscribeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SubscribePanel.this.bSubscribe) {
                    AttendanceModule.stopRealLoadPicture();
                    SubscribePanel.this.eventShowPanel.clearEvent();
                    SubscribePanel.this.setSubscribeStatus(false);
                } else if (AttendanceModule.realLoadPicture(SubscribePanel.this.callback)) {
                    SubscribePanel.this.setSubscribeStatus(true);
                } else {
                    JOptionPane.showMessageDialog(null, Res.string().getSubscribeFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                    return;
                }
            }
        });
        this.subscribeBtn.setEnabled(false);
    }

    public void setButtonEnable(boolean b) {
        this.setSubscribeStatus(false);
        this.subscribeBtn.setEnabled(b);
    }

    public void setSubscribeStatus(boolean b) {
        this.bSubscribe = b;
        if (this.bSubscribe) {
            this.subscribeBtn.setText(Res.string().getUnSubscribe());
        } else {
            this.subscribeBtn.setText(Res.string().getSubscribe());
        }
    }

    @Override
    protected void processEvent(AWTEvent event) {
        if (event instanceof AccessEvent) {
            AttendanceModule.AccessEventInfo accessEventInfo = ((AccessEvent)event).getAccessEventInfo();
            this.eventShowPanel.insertEvent(accessEventInfo);
        } else {
            super.processEvent(event);
        }
    }

    class AccessEvent
    extends AWTEvent {
        private static final long serialVersionUID = 1L;
        public static final int EVENT_ID = 2000;
        private AttendanceModule.AccessEventInfo accessEvent;

        public AccessEvent(Object target, AttendanceModule.AccessEventInfo accessEvent) {
            super(target, 2000);
            this.accessEvent = accessEvent;
        }

        public AttendanceModule.AccessEventInfo getAccessEventInfo() {
            return this.accessEvent;
        }
    }

    public class fAnalyzerDataCB
    implements NetSDKLib.fAnalyzerDataCallBack {
        public final EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();

        @Override
        public int invoke(NetSDKLib.LLong lAnalyzerHandle, int dwAlarmType, Pointer pAlarmInfo, Pointer pBuffer, int dwBufSize, Pointer dwUser, int nSequence, Pointer reserved) {
            if (pAlarmInfo == null) {
                return 0;
            }
            switch (dwAlarmType) {
                case 516: {
                    NetSDKLib.DEV_EVENT_ACCESS_CTL_INFO event = new NetSDKLib.DEV_EVENT_ACCESS_CTL_INFO();
                    ToolKits.GetPointerData(pAlarmInfo, event);
                    AttendanceModule.AccessEventInfo accessEvent = new AttendanceModule.AccessEventInfo();
                    accessEvent.userId = new String(event.szUserID).trim();
                    accessEvent.cardNo = new String(event.szCardNo).trim();
                    accessEvent.eventTime = event.UTC.toStringTime();
                    accessEvent.openDoorMethod = event.emOpenMethod;
                    if (this.eventQueue == null) break;
                    this.eventQueue.postEvent(new AccessEvent(SubscribePanel.this.target, accessEvent));
                    break;
                }
            }
            return 0;
        }
    }
}

