/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.AutoRegister;

import com.netsdk.common.BorderEx;
import com.netsdk.common.LoginPanel;
import com.netsdk.common.Res;
import com.netsdk.demo.module.AutoRegisterModule;
import com.netsdk.demo.module.LoginModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DeviceConfigDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private NetSDKLib.CFG_DVRIP_INFO info = null;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private LoginDevicePanel loginDevicePanel;
    private JTextField autoRegisterIpTextField;
    private JTextField autoRegisterPortTextField;
    private JTextField deviceIdTextField;
    private JCheckBox enableCheckBox;
    private JButton getBtn;
    private JButton setBtn;

    public DeviceConfigDialog() {
        this.setTitle(Res.string().getDeviceConfig());
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.pack();
        this.setSize(300, 380);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.loginDevicePanel = new LoginDevicePanel();
        ConfigDevicePanel configDevicePanel = new ConfigDevicePanel();
        this.add((Component)this.loginDevicePanel, "North");
        this.add((Component)configDevicePanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!DeviceConfigDialog.this.executorService.isShutdown()) {
                    DeviceConfigDialog.this.executorService.shutdown();
                }
                LoginModule.logout();
                DeviceConfigDialog.this.dispose();
            }
        });
    }

    private void login() {
        if (this.loginDevicePanel.checkLoginText()) {
            if (LoginModule.login(this.loginDevicePanel.ipTextArea.getText(), Integer.parseInt(this.loginDevicePanel.portTextArea.getText()), this.loginDevicePanel.nameTextArea.getText(), new String(this.loginDevicePanel.passwordTextArea.getPassword()))) {
                this.loginDevicePanel.setButtonEnable(true);
                this.enableCheckBox.setEnabled(true);
                this.getBtn.setEnabled(true);
                this.setBtn.setEnabled(true);
                this.autoRegisterIpTextField.setEnabled(true);
                this.autoRegisterPortTextField.setEnabled(true);
                this.deviceIdTextField.setEnabled(true);
            } else {
                JOptionPane.showMessageDialog(null, Res.string().getLoginFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            }
        }
    }

    private void logout() {
        LoginModule.logout();
        this.loginDevicePanel.setButtonEnable(false);
        this.enableCheckBox.setEnabled(false);
        this.getBtn.setEnabled(false);
        this.setBtn.setEnabled(false);
        this.autoRegisterIpTextField.setEnabled(false);
        this.autoRegisterPortTextField.setEnabled(false);
        this.deviceIdTextField.setEnabled(false);
        this.autoRegisterIpTextField.setText("");
        this.autoRegisterPortTextField.setText("");
        this.deviceIdTextField.setText("");
    }

    private void getConfig() {
        this.info = AutoRegisterModule.getDVRIPConfig(LoginModule.m_hLoginHandle);
        if (this.info == null) {
            this.autoRegisterIpTextField.setText("");
            this.autoRegisterPortTextField.setText("");
            this.deviceIdTextField.setText("");
            JOptionPane.showMessageDialog(null, Res.string().getGet() + Res.string().getFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
        } else {
            if (this.info.stuRegisters[0].bEnable == 1) {
                this.enableCheckBox.setSelected(true);
            } else {
                this.enableCheckBox.setSelected(false);
            }
            this.autoRegisterIpTextField.setText(new String(this.info.stuRegisters[0].stuServers[0].szAddress).trim());
            this.autoRegisterPortTextField.setText(String.valueOf(this.info.stuRegisters[0].stuServers[0].nPort));
            try {
                this.deviceIdTextField.setText(new String(this.info.stuRegisters[0].szDeviceID, "GBK").trim());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            JOptionPane.showMessageDialog(null, Res.string().getSucceed(), Res.string().getPromptMessage(), 1);
        }
        this.getBtn.setEnabled(true);
    }

    private void setConfig() {
        this.info = AutoRegisterModule.getDVRIPConfig(LoginModule.m_hLoginHandle);
        if (this.autoRegisterIpTextField.getText().equals("")) {
            this.setBtn.setEnabled(true);
            JOptionPane.showMessageDialog(null, Res.string().getInput() + Res.string().getRegisterAddress(), Res.string().getErrorMessage(), 0);
            return;
        }
        if (this.autoRegisterPortTextField.getText().equals("")) {
            this.setBtn.setEnabled(true);
            JOptionPane.showMessageDialog(null, Res.string().getInput() + Res.string().getRegisterPort(), Res.string().getErrorMessage(), 0);
            return;
        }
        if (this.deviceIdTextField.getText().equals("")) {
            this.setBtn.setEnabled(true);
            JOptionPane.showMessageDialog(null, Res.string().getInput() + Res.string().getDeviceID(), Res.string().getErrorMessage(), 0);
            return;
        }
        byte[] deviceId = null;
        try {
            deviceId = this.deviceIdTextField.getText().getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        System.out.println("\u767b\u5f55\u53e5\u67c4" + LoginModule.m_hLoginHandle + "\u662f\u5426\u542f\u7528" + this.enableCheckBox.isSelected() + "ip" + this.autoRegisterIpTextField.getText() + "\u7aef\u53e3" + this.autoRegisterPortTextField.getText() + "\u8bbe\u5907id" + new String(deviceId));
        if (AutoRegisterModule.setDVRIPConfig(LoginModule.m_hLoginHandle, this.enableCheckBox.isSelected(), this.autoRegisterIpTextField.getText(), Integer.parseInt(this.autoRegisterPortTextField.getText()), deviceId, this.info)) {
            JOptionPane.showMessageDialog(null, Res.string().getSucceed(), Res.string().getPromptMessage(), 1);
        } else {
            JOptionPane.showMessageDialog(null, Res.string().getSet() + Res.string().getFailed() + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
        }
        this.setBtn.setEnabled(true);
    }

    private class ConfigDevicePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public ConfigDevicePanel() {
            BorderEx.set(this, Res.string().getDeviceConfig(), 2);
            this.setLayout(new FlowLayout());
            DeviceConfigDialog.this.enableCheckBox = new JCheckBox(Res.string().getEnable());
            JLabel nullLabel = new JLabel();
            JLabel autoRegisterIpLabel = new JLabel(Res.string().getRegisterAddress(), 0);
            JLabel autoRegisterPortLabel = new JLabel(Res.string().getRegisterPort(), 0);
            JLabel deviceIdLabel = new JLabel(Res.string().getDeviceID(), 0);
            DeviceConfigDialog.this.enableCheckBox.setPreferredSize(new Dimension(80, 21));
            nullLabel.setPreferredSize(new Dimension(120, 21));
            autoRegisterIpLabel.setPreferredSize(new Dimension(100, 21));
            autoRegisterPortLabel.setPreferredSize(new Dimension(100, 21));
            deviceIdLabel.setPreferredSize(new Dimension(100, 21));
            DeviceConfigDialog.this.autoRegisterIpTextField = new JTextField();
            DeviceConfigDialog.this.autoRegisterPortTextField = new JTextField();
            DeviceConfigDialog.this.deviceIdTextField = new JTextField();
            DeviceConfigDialog.this.autoRegisterIpTextField.setPreferredSize(new Dimension(140, 21));
            DeviceConfigDialog.this.autoRegisterPortTextField.setPreferredSize(new Dimension(140, 21));
            DeviceConfigDialog.this.deviceIdTextField.setPreferredSize(new Dimension(140, 21));
            DeviceConfigDialog.this.getBtn = new JButton(Res.string().getGet());
            DeviceConfigDialog.this.setBtn = new JButton(Res.string().getSet());
            DeviceConfigDialog.this.getBtn.setPreferredSize(new Dimension(120, 21));
            DeviceConfigDialog.this.setBtn.setPreferredSize(new Dimension(120, 21));
            this.add(DeviceConfigDialog.this.enableCheckBox);
            this.add(nullLabel);
            this.add(autoRegisterIpLabel);
            this.add(DeviceConfigDialog.this.autoRegisterIpTextField);
            this.add(autoRegisterPortLabel);
            this.add(DeviceConfigDialog.this.autoRegisterPortTextField);
            this.add(deviceIdLabel);
            this.add(DeviceConfigDialog.this.deviceIdTextField);
            this.add(DeviceConfigDialog.this.getBtn);
            this.add(DeviceConfigDialog.this.setBtn);
            DeviceConfigDialog.this.enableCheckBox.setSelected(true);
            DeviceConfigDialog.this.enableCheckBox.setEnabled(false);
            DeviceConfigDialog.this.getBtn.setEnabled(false);
            DeviceConfigDialog.this.setBtn.setEnabled(false);
            DeviceConfigDialog.this.autoRegisterIpTextField.setEnabled(false);
            DeviceConfigDialog.this.autoRegisterPortTextField.setEnabled(false);
            DeviceConfigDialog.this.deviceIdTextField.setEnabled(false);
            DeviceConfigDialog.this.getBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    DeviceConfigDialog.this.executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            DeviceConfigDialog.this.getBtn.setEnabled(false);
                        }
                    });
                    DeviceConfigDialog.this.executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            DeviceConfigDialog.this.getConfig();
                        }
                    });
                }
            });
            DeviceConfigDialog.this.setBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    DeviceConfigDialog.this.executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            DeviceConfigDialog.this.setBtn.setEnabled(false);
                        }
                    });
                    DeviceConfigDialog.this.executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            DeviceConfigDialog.this.setConfig();
                        }
                    });
                }
            });
        }
    }

    private class LoginDevicePanel
    extends LoginPanel {
        private static final long serialVersionUID = 1L;

        public LoginDevicePanel() {
            BorderEx.set(this, Res.string().getLogin(), 2);
            this.setLayout(new FlowLayout());
            Dimension dimension = new Dimension();
            dimension.height = 180;
            this.setPreferredSize(dimension);
            this.ipLabel.setPreferredSize(new Dimension(100, 21));
            this.portLabel.setPreferredSize(new Dimension(100, 21));
            this.nameLabel.setPreferredSize(new Dimension(100, 21));
            this.passwordLabel.setPreferredSize(new Dimension(100, 21));
            this.ipLabel.setHorizontalAlignment(0);
            this.portLabel.setHorizontalAlignment(0);
            this.nameLabel.setHorizontalAlignment(0);
            this.passwordLabel.setHorizontalAlignment(0);
            this.ipTextArea.setPreferredSize(new Dimension(140, 21));
            this.portTextArea.setPreferredSize(new Dimension(140, 21));
            this.nameTextArea.setPreferredSize(new Dimension(140, 21));
            this.passwordTextArea.setPreferredSize(new Dimension(140, 21));
            this.loginBtn.setPreferredSize(new Dimension(120, 21));
            this.logoutBtn.setPreferredSize(new Dimension(120, 21));
            this.add(this.ipLabel);
            this.add(this.ipTextArea);
            this.add(this.portLabel);
            this.add(this.portTextArea);
            this.add(this.nameLabel);
            this.add(this.nameTextArea);
            this.add(this.passwordLabel);
            this.add(this.passwordTextArea);
            this.add(this.loginBtn);
            this.add(this.logoutBtn);
            this.loginBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    DeviceConfigDialog.this.login();
                }
            });
            this.logoutBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    DeviceConfigDialog.this.logout();
                }
            });
        }
    }
}

