/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame;

import com.netsdk.common.BorderEx;
import com.netsdk.common.FunctionList;
import com.netsdk.common.Res;
import com.netsdk.demo.frame.DevcieInitFrame;
import com.netsdk.demo.module.DeviceSearchModule;
import com.netsdk.demo.module.LoginModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.Pointer;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

class DeviceSearchAndInitFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Object[][] data;
    private static int index = 0;
    private int count = 0;
    private static NetSDKLib.LLong m_DeviceSearchHandle = new NetSDKLib.LLong(0L);
    private static Map<String, Byte> pwdResetHashMap = new HashMap<String, Byte>();
    private static ArrayList<String> macArrayList = new ArrayList();
    private Component target = this;
    private volatile boolean bFlag = true;
    private ExecutorService executorService = Executors.newFixedThreadPool(4);
    private Test_fSearchDevicesCbEx callbackEx = new Test_fSearchDevicesCbEx();
    private Test_fSearchDevicesCB callback = new Test_fSearchDevicesCB();
    private DeviceSearchPanel deviceSearchPanel;
    private DeviceSearchResultShowListPanel deviceSearchResultShowPanel;
    private DeviceInitPanel deviceIntPanel;
    private JButton deviceInitBtn;
    private JButton multiAndBroadcastSearchBtn;
    private JButton unicastSearchBtn;
    private JTextField startIpTextField;
    private JTextField endIpTextField;
    private static DefaultTableModel defaultModel;
    private static JTable table;
    private static List<NetSDKLib.DEVICE_NET_INFO_EX2> list;
    private static List<NetSDKLib.LLong> handles;

    public DeviceSearchAndInitFrame() {
        this.setTitle(Res.string().getDeviceSearchAndInit());
        this.setSize(700, 560);
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        LoginModule.init(null, null);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.deviceSearchPanel = new DeviceSearchPanel();
        this.deviceSearchResultShowPanel = new DeviceSearchResultShowListPanel();
        this.deviceIntPanel = new DeviceInitPanel();
        this.add((Component)this.deviceSearchPanel, "North");
        this.add((Component)this.deviceSearchResultShowPanel, "Center");
        this.add((Component)this.deviceIntPanel, "South");
        this.enableEvents(64L);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            if (!this.bFlag) {
                JOptionPane.showMessageDialog(null, Res.string().getSearchingWait(), Res.string().getPromptMessage(), 1);
                return;
            }
            for (int i = 0; i < handles.size(); ++i) {
                DeviceSearchModule.stopDeviceSearch(handles.get(i));
            }
            if (!this.executorService.isShutdown()) {
                this.executorService.shutdown();
            }
            LoginModule.cleanup();
            this.dispose();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FunctionList demo = new FunctionList();
                    demo.setVisible(true);
                }
            });
        }
        super.processWindowEvent(e);
    }

    @Override
    protected void processEvent(AWTEvent event) {
        if (event instanceof DeviceSearchListEx) {
            DeviceSearchListEx ev = (DeviceSearchListEx)event;
            NetSDKLib.DEVICE_NET_INFO_EX2 deviceInfo = ev.getDeviceInfo();
            if (!macArrayList.contains(new String(deviceInfo.stuDevInfo.szMac))) {
                list.add(deviceInfo);
                if (index < 1000) {
                    macArrayList.add(new String(deviceInfo.stuDevInfo.szMac));
                    defaultModel.setValueAt(index + 1, index, 0);
                    defaultModel.setValueAt(Res.string().getInitStateInfo(deviceInfo.stuDevInfo.byInitStatus & 3), index, 1);
                    defaultModel.setValueAt("IPV" + String.valueOf(deviceInfo.stuDevInfo.iIPVersion), index, 2);
                    if (!new String(deviceInfo.stuDevInfo.szIP).trim().isEmpty()) {
                        defaultModel.setValueAt(new String(deviceInfo.stuDevInfo.szIP).trim(), index, 3);
                    } else {
                        defaultModel.setValueAt("", index, 3);
                    }
                    defaultModel.setValueAt(String.valueOf(deviceInfo.stuDevInfo.nPort), index, 4);
                    if (!new String(deviceInfo.stuDevInfo.szSubmask).trim().isEmpty()) {
                        defaultModel.setValueAt(new String(deviceInfo.stuDevInfo.szSubmask).trim(), index, 5);
                    } else {
                        defaultModel.setValueAt("", index, 5);
                    }
                    if (!new String(deviceInfo.stuDevInfo.szGateway).trim().isEmpty()) {
                        defaultModel.setValueAt(new String(deviceInfo.stuDevInfo.szGateway).trim(), index, 6);
                    } else {
                        defaultModel.setValueAt("", index, 6);
                    }
                    if (!new String(deviceInfo.stuDevInfo.szMac).trim().isEmpty()) {
                        defaultModel.setValueAt(new String(deviceInfo.stuDevInfo.szMac).trim(), index, 7);
                    } else {
                        defaultModel.setValueAt("", index, 7);
                    }
                    if (!new String(deviceInfo.stuDevInfo.szDeviceType).trim().isEmpty()) {
                        defaultModel.setValueAt(new String(deviceInfo.stuDevInfo.szDeviceType).trim(), index, 8);
                    } else {
                        defaultModel.setValueAt("", index, 8);
                    }
                    if (!new String(deviceInfo.stuDevInfo.szNewDetailType).trim().isEmpty()) {
                        defaultModel.setValueAt(new String(deviceInfo.stuDevInfo.szNewDetailType).trim(), index, 9);
                    } else {
                        defaultModel.setValueAt("", index, 9);
                    }
                    defaultModel.setValueAt(String.valueOf(deviceInfo.stuDevInfo.nHttpPort), index, 10);
                    pwdResetHashMap.put(new String(deviceInfo.stuDevInfo.szMac).trim(), deviceInfo.stuDevInfo.byPwdResetWay);
                    for (int i = 0; i < 11; ++i) {
                        table.getColumnModel().getColumn(i).setCellRenderer(new MyTableCellRender());
                    }
                    table.updateUI();
                    ++index;
                }
            }
        } else if (event instanceof DeviceSearchList) {
            DeviceSearchList ev = (DeviceSearchList)event;
            NetSDKLib.DEVICE_NET_INFO_EX deviceInfo = ev.getDeviceInfo();
            if (!macArrayList.contains(new String(deviceInfo.szMac)) && index < 1000) {
                macArrayList.add(new String(deviceInfo.szMac));
                defaultModel.setValueAt(index + 1, index, 0);
                defaultModel.setValueAt(Res.string().getInitStateInfo(deviceInfo.byInitStatus & 3), index, 1);
                defaultModel.setValueAt("IPV" + String.valueOf(deviceInfo.iIPVersion), index, 2);
                if (!new String(deviceInfo.szIP).trim().isEmpty()) {
                    defaultModel.setValueAt(new String(deviceInfo.szIP).trim(), index, 3);
                } else {
                    defaultModel.setValueAt("", index, 3);
                }
                defaultModel.setValueAt(String.valueOf(deviceInfo.nPort), index, 4);
                if (!new String(deviceInfo.szSubmask).trim().isEmpty()) {
                    defaultModel.setValueAt(new String(deviceInfo.szSubmask).trim(), index, 5);
                } else {
                    defaultModel.setValueAt("", index, 5);
                }
                if (!new String(deviceInfo.szGateway).trim().isEmpty()) {
                    defaultModel.setValueAt(new String(deviceInfo.szGateway).trim(), index, 6);
                } else {
                    defaultModel.setValueAt("", index, 6);
                }
                if (!new String(deviceInfo.szMac).trim().isEmpty()) {
                    defaultModel.setValueAt(new String(deviceInfo.szMac).trim(), index, 7);
                } else {
                    defaultModel.setValueAt("", index, 7);
                }
                if (!new String(deviceInfo.szDeviceType).trim().isEmpty()) {
                    defaultModel.setValueAt(new String(deviceInfo.szDeviceType).trim(), index, 8);
                } else {
                    defaultModel.setValueAt("", index, 8);
                }
                if (!new String(deviceInfo.szNewDetailType).trim().isEmpty()) {
                    defaultModel.setValueAt(new String(deviceInfo.szNewDetailType).trim(), index, 9);
                } else {
                    defaultModel.setValueAt("", index, 9);
                }
                defaultModel.setValueAt(String.valueOf(deviceInfo.nHttpPort), index, 10);
                pwdResetHashMap.put(new String(deviceInfo.szMac).trim(), deviceInfo.byPwdResetWay);
                for (int i = 0; i < 11; ++i) {
                    table.getColumnModel().getColumn(i).setCellRenderer(new MyTableCellRender());
                }
                table.updateUI();
                ++index;
            }
        } else {
            super.processEvent(event);
        }
    }

    private boolean checkIP() {
        String[] startIp = this.startIpTextField.getText().split("\\.");
        String[] endIp = this.endIpTextField.getText().split("\\.");
        if (this.startIpTextField.getText().isEmpty()) {
            JOptionPane.showMessageDialog(null, Res.string().getInputDeviceIP(), Res.string().getErrorMessage(), 0);
            return false;
        }
        if (this.endIpTextField.getText().isEmpty()) {
            JOptionPane.showMessageDialog(null, Res.string().getInputDeviceIP(), Res.string().getErrorMessage(), 0);
            return false;
        }
        if (!startIp[0].equals(endIp[0])) {
            JOptionPane.showMessageDialog(null, Res.string().getCheckIp(), Res.string().getErrorMessage(), 0);
            return false;
        }
        if (!startIp[1].equals(endIp[1])) {
            JOptionPane.showMessageDialog(null, Res.string().getCheckIp(), Res.string().getErrorMessage(), 0);
            return false;
        }
        if (Integer.parseInt(startIp[2]) > Integer.parseInt(endIp[2])) {
            JOptionPane.showMessageDialog(null, Res.string().getCheckIp(), Res.string().getErrorMessage(), 0);
            return false;
        }
        if (Integer.parseInt(startIp[2]) == Integer.parseInt(endIp[2]) && Integer.parseInt(startIp[3]) > Integer.parseInt(endIp[3])) {
            JOptionPane.showMessageDialog(null, Res.string().getCheckIp(), Res.string().getErrorMessage(), 0);
            return false;
        }
        this.count = (Integer.parseInt(endIp[2]) - Integer.parseInt(startIp[2])) * 256 + Integer.parseInt(endIp[3]) - Integer.parseInt(startIp[3]) + 1;
        if (this.count > 1000) {
            JOptionPane.showMessageDialog(null, Res.string().getControlScope(), Res.string().getErrorMessage(), 0);
            return false;
        }
        return true;
    }

    static /* synthetic */ Object[][] access$302(DeviceSearchAndInitFrame x0, Object[][] x1) {
        x0.data = x1;
        return x1;
    }

    static {
        list = new ArrayList<NetSDKLib.DEVICE_NET_INFO_EX2>();
        handles = new ArrayList<NetSDKLib.LLong>();
    }

    private static class MyTableCellRender
    implements TableCellRenderer {
        DefaultTableCellRenderer dCellRenderer = new DefaultTableCellRenderer();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelect, boolean hasFocus, int row, int colum) {
            Component component = this.dCellRenderer.getTableCellRendererComponent(table, value, isSelect, hasFocus, row, colum);
            if (String.valueOf(defaultModel.getValueAt(row, 1)).trim().equals(Res.string().getNotInitialized())) {
                component.setForeground(Color.RED);
            } else {
                component.setForeground(Color.BLACK);
            }
            this.dCellRenderer.setHorizontalAlignment(0);
            table.setDefaultRenderer(Object.class, this.dCellRenderer);
            return component;
        }
    }

    class DeviceSearchListEx
    extends AWTEvent {
        private static final long serialVersionUID = 1L;
        public static final int EVENT_ID = 2000;
        private NetSDKLib.DEVICE_NET_INFO_EX2 deviceInfo;

        public DeviceSearchListEx(Object target, NetSDKLib.DEVICE_NET_INFO_EX2 deviceInfo) {
            super(target, 2000);
            this.deviceInfo = deviceInfo;
        }

        public NetSDKLib.DEVICE_NET_INFO_EX2 getDeviceInfo() {
            return this.deviceInfo;
        }
    }

    class DeviceSearchList
    extends AWTEvent {
        private static final long serialVersionUID = 1L;
        public static final int EVENT_ID = 2000;
        private NetSDKLib.DEVICE_NET_INFO_EX deviceInfo;

        public DeviceSearchList(Object target, NetSDKLib.DEVICE_NET_INFO_EX deviceInfo) {
            super(target, 2000);
            this.deviceInfo = deviceInfo;
        }

        public NetSDKLib.DEVICE_NET_INFO_EX getDeviceInfo() {
            return this.deviceInfo;
        }
    }

    private class Test_fSearchDevicesCB
    implements NetSDKLib.fSearchDevicesCB {
        private Test_fSearchDevicesCB() {
        }

        @Override
        public void invoke(Pointer pDevNetInfo, Pointer pUserData) {
            NetSDKLib.DEVICE_NET_INFO_EX deviceInfo = new NetSDKLib.DEVICE_NET_INFO_EX();
            ToolKits.GetPointerData(pDevNetInfo, deviceInfo);
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            if (eventQueue != null) {
                eventQueue.postEvent(new DeviceSearchList(DeviceSearchAndInitFrame.this.target, deviceInfo));
            }
        }
    }

    private class Test_fSearchDevicesCbEx
    implements NetSDKLib.fSearchDevicesCBEx {
        private Test_fSearchDevicesCbEx() {
        }

        @Override
        public void invoke(NetSDKLib.LLong lSearchHandle, Pointer pDevNetInfo, Pointer pUserData) {
            NetSDKLib.DEVICE_NET_INFO_EX2 deviceInfo = new NetSDKLib.DEVICE_NET_INFO_EX2();
            ToolKits.GetPointerData(pDevNetInfo, deviceInfo);
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            if (eventQueue != null) {
                eventQueue.postEvent(new DeviceSearchListEx(DeviceSearchAndInitFrame.this.target, deviceInfo));
            }
        }
    }

    private class DeviceInitPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public DeviceInitPanel() {
            BorderEx.set(this, Res.string().getDeviceInit(), 2);
            this.setLayout(new BorderLayout());
            Dimension dimension = new Dimension();
            dimension.height = 55;
            this.setPreferredSize(dimension);
            DeviceSearchAndInitFrame.this.deviceInitBtn = new JButton(Res.string().getDeviceInit());
            this.add((Component)DeviceSearchAndInitFrame.this.deviceInitBtn, "West");
            DeviceSearchAndInitFrame.this.deviceInitBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int row = -1;
                    row = table.getSelectedRow();
                    System.out.println(new String(((NetSDKLib.DEVICE_NET_INFO_EX2)list.get((int)row)).szLocalIP));
                    if (defaultModel == null) {
                        JOptionPane.showMessageDialog(null, Res.string().getPleaseSelectInitializedDevice(), Res.string().getErrorMessage(), 0);
                        return;
                    }
                    if (row < 0) {
                        JOptionPane.showMessageDialog(null, Res.string().getPleaseSelectInitializedDevice(), Res.string().getErrorMessage(), 0);
                        return;
                    }
                    if (defaultModel.getValueAt(row, 7) == null || String.valueOf(defaultModel.getValueAt(row, 7)).trim().equals("")) {
                        JOptionPane.showMessageDialog(null, Res.string().getPleaseSelectInitializedDevice(), Res.string().getErrorMessage(), 0);
                        return;
                    }
                    if (defaultModel.getValueAt(row, 1) == null || String.valueOf(defaultModel.getValueAt(row, 1)).trim().equals(Res.string().getInitialized())) {
                        JOptionPane.showMessageDialog(null, Res.string().getInitialized(), Res.string().getErrorMessage(), 0);
                        return;
                    }
                    String localIp = new String(((NetSDKLib.DEVICE_NET_INFO_EX2)list.get((int)row)).szLocalIP).trim();
                    String mac = String.valueOf(defaultModel.getValueAt(row, 7)).trim();
                    byte passwdReset = (Byte)pwdResetHashMap.get(mac);
                    DevcieInitFrame demo = new DevcieInitFrame(localIp, passwdReset, mac, row, defaultModel, table);
                    demo.setLocationRelativeTo(null);
                    demo.setVisible(true);
                }
            });
        }
    }

    private class DeviceSearchResultShowListPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public DeviceSearchResultShowListPanel() {
            BorderEx.set(this, Res.string().getDeviceSearchResult(), 2);
            this.setLayout(new BorderLayout());
            DeviceSearchAndInitFrame.access$302(DeviceSearchAndInitFrame.this, new Object[1000][11]);
            defaultModel = new DefaultTableModel(DeviceSearchAndInitFrame.this.data, Res.string().getDeviceTableName());
            table = new JTable(defaultModel){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            table.setSelectionMode(0);
            table.getColumnModel().getColumn(0).setPreferredWidth(50);
            table.getColumnModel().getColumn(1).setPreferredWidth(80);
            table.getColumnModel().getColumn(2).setPreferredWidth(80);
            table.getColumnModel().getColumn(3).setPreferredWidth(120);
            table.getColumnModel().getColumn(4).setPreferredWidth(80);
            table.getColumnModel().getColumn(5).setPreferredWidth(120);
            table.getColumnModel().getColumn(6).setPreferredWidth(120);
            table.getColumnModel().getColumn(7).setPreferredWidth(140);
            table.getColumnModel().getColumn(8).setPreferredWidth(100);
            table.getColumnModel().getColumn(9).setPreferredWidth(100);
            table.getColumnModel().getColumn(10).setPreferredWidth(100);
            table.setAutoResizeMode(0);
            JScrollPane scrollPane = new JScrollPane(table);
            scrollPane.setVerticalScrollBarPolicy(20);
            this.add((Component)scrollPane, "Center");
        }
    }

    private class UnicastDeviceSearchPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public UnicastDeviceSearchPanel() {
            BorderEx.set(this, Res.string().getDevicePointToPointSearch(), 1);
            this.setLayout(new FlowLayout());
            JLabel startIpLabel = new JLabel(Res.string().getStartIp());
            JLabel endIpLabel = new JLabel(Res.string().getEndIp());
            DeviceSearchAndInitFrame.this.startIpTextField = new JTextField("172.23.3.0");
            DeviceSearchAndInitFrame.this.endIpTextField = new JTextField("172.23.3.231");
            DeviceSearchAndInitFrame.this.unicastSearchBtn = new JButton(Res.string().getStartSearch());
            DeviceSearchAndInitFrame.this.startIpTextField.setPreferredSize(new Dimension(100, 20));
            DeviceSearchAndInitFrame.this.endIpTextField.setPreferredSize(new Dimension(100, 20));
            DeviceSearchAndInitFrame.this.unicastSearchBtn.setPreferredSize(new Dimension(120, 20));
            this.add(startIpLabel);
            this.add(DeviceSearchAndInitFrame.this.startIpTextField);
            this.add(endIpLabel);
            this.add(DeviceSearchAndInitFrame.this.endIpTextField);
            this.add(DeviceSearchAndInitFrame.this.unicastSearchBtn);
            DeviceSearchAndInitFrame.this.unicastSearchBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    DeviceSearchAndInitFrame.this.deviceInitBtn.setEnabled(false);
                    index = 0;
                    DeviceSearchAndInitFrame.this.count = 0;
                    DeviceSearchAndInitFrame.this.bFlag = false;
                    if (!DeviceSearchAndInitFrame.this.checkIP()) {
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DeviceSearchAndInitFrame.this.unicastSearchBtn.setEnabled(false);
                        }
                    });
                    DeviceSearchAndInitFrame.access$302(DeviceSearchAndInitFrame.this, new Object[1000][11]);
                    defaultModel = new DefaultTableModel(DeviceSearchAndInitFrame.this.data, Res.string().getDeviceTableName());
                    table.setModel(defaultModel);
                    table.getColumnModel().getColumn(0).setPreferredWidth(50);
                    table.getColumnModel().getColumn(1).setPreferredWidth(80);
                    table.getColumnModel().getColumn(2).setPreferredWidth(80);
                    table.getColumnModel().getColumn(3).setPreferredWidth(120);
                    table.getColumnModel().getColumn(4).setPreferredWidth(80);
                    table.getColumnModel().getColumn(5).setPreferredWidth(120);
                    table.getColumnModel().getColumn(6).setPreferredWidth(120);
                    table.getColumnModel().getColumn(7).setPreferredWidth(140);
                    table.getColumnModel().getColumn(8).setPreferredWidth(100);
                    table.getColumnModel().getColumn(9).setPreferredWidth(100);
                    table.getColumnModel().getColumn(10).setPreferredWidth(100);
                    table.setAutoResizeMode(0);
                    pwdResetHashMap.clear();
                    macArrayList.clear();
                    for (int i = 0; i < handles.size(); ++i) {
                        DeviceSearchModule.stopDeviceSearch((NetSDKLib.LLong)handles.get(i));
                    }
                    if (DeviceSearchAndInitFrame.this.count > 0 && DeviceSearchAndInitFrame.this.count <= 256) {
                        DeviceSearchAndInitFrame.this.executorService.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    for (int i = 0; i < DeviceSearchModule.getHostAddress().size(); ++i) {
                                        DeviceSearchModule.unicastDeviceSearch(DeviceSearchModule.getHostAddress().get(i), DeviceSearchAndInitFrame.this.startIpTextField.getText(), DeviceSearchAndInitFrame.this.count, DeviceSearchAndInitFrame.this.callback);
                                    }
                                }
                                catch (SocketException e) {
                                    e.printStackTrace();
                                }
                                DeviceSearchAndInitFrame.this.bFlag = true;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DeviceSearchAndInitFrame.this.unicastSearchBtn.setEnabled(true);
                                    }
                                });
                            }
                        });
                    } else if (DeviceSearchAndInitFrame.this.count > 256 && DeviceSearchAndInitFrame.this.count <= 512) {
                        DeviceSearchAndInitFrame.this.executorService.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    for (int i = 0; i < DeviceSearchModule.getHostAddress().size(); ++i) {
                                        DeviceSearchModule.unicastDeviceSearch(DeviceSearchModule.getHostAddress().get(i), DeviceSearchAndInitFrame.this.startIpTextField.getText(), 256, DeviceSearchAndInitFrame.this.callback);
                                    }
                                }
                                catch (SocketException e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                        DeviceSearchAndInitFrame.this.executorService.execute(new Runnable(){

                            @Override
                            public void run() {
                                String[] szIp = DeviceSearchAndInitFrame.this.startIpTextField.getText().split("\\.");
                                try {
                                    for (int i = 0; i < DeviceSearchModule.getHostAddress().size(); ++i) {
                                        DeviceSearchModule.unicastDeviceSearch(DeviceSearchModule.getHostAddress().get(i), DeviceSearchModule.getIp(szIp, 255), DeviceSearchAndInitFrame.this.count - 256, DeviceSearchAndInitFrame.this.callback);
                                    }
                                }
                                catch (SocketException e) {
                                    e.printStackTrace();
                                }
                                DeviceSearchAndInitFrame.this.bFlag = true;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DeviceSearchAndInitFrame.this.unicastSearchBtn.setEnabled(true);
                                    }
                                });
                            }
                        });
                    } else if (DeviceSearchAndInitFrame.this.count > 512 && DeviceSearchAndInitFrame.this.count <= 768) {
                        DeviceSearchAndInitFrame.this.executorService.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    for (int i = 0; i < DeviceSearchModule.getHostAddress().size(); ++i) {
                                        DeviceSearchModule.unicastDeviceSearch(DeviceSearchModule.getHostAddress().get(i), DeviceSearchAndInitFrame.this.startIpTextField.getText(), 256, DeviceSearchAndInitFrame.this.callback);
                                    }
                                }
                                catch (SocketException e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                        DeviceSearchAndInitFrame.this.executorService.execute(new Runnable(){

                            @Override
                            public void run() {
                                String[] szIp = DeviceSearchAndInitFrame.this.startIpTextField.getText().split("\\.");
                                try {
                                    for (int i = 0; i < DeviceSearchModule.getHostAddress().size(); ++i) {
                                        DeviceSearchModule.unicastDeviceSearch(DeviceSearchModule.getHostAddress().get(i), DeviceSearchModule.getIp(szIp, 255), 256, DeviceSearchAndInitFrame.this.callback);
                                    }
                                }
                                catch (SocketException e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                        DeviceSearchAndInitFrame.this.executorService.execute(new Runnable(){

                            @Override
                            public void run() {
                                String[] szIp = DeviceSearchAndInitFrame.this.startIpTextField.getText().split("\\.");
                                szIp = DeviceSearchModule.getIp(szIp, 255).split("\\.");
                                try {
                                    for (int i = 0; i < DeviceSearchModule.getHostAddress().size(); ++i) {
                                        DeviceSearchModule.unicastDeviceSearch(DeviceSearchModule.getHostAddress().get(i), DeviceSearchModule.getIp(szIp, 255), DeviceSearchAndInitFrame.this.count - 512, DeviceSearchAndInitFrame.this.callback);
                                    }
                                }
                                catch (SocketException e) {
                                    e.printStackTrace();
                                }
                                DeviceSearchAndInitFrame.this.bFlag = true;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DeviceSearchAndInitFrame.this.unicastSearchBtn.setEnabled(true);
                                    }
                                });
                            }
                        });
                    } else if (DeviceSearchAndInitFrame.this.count > 768 && DeviceSearchAndInitFrame.this.count <= 1000) {
                        DeviceSearchAndInitFrame.this.executorService.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    for (int i = 0; i < DeviceSearchModule.getHostAddress().size(); ++i) {
                                        DeviceSearchModule.unicastDeviceSearch(DeviceSearchModule.getHostAddress().get(i), DeviceSearchAndInitFrame.this.startIpTextField.getText(), 256, DeviceSearchAndInitFrame.this.callback);
                                    }
                                }
                                catch (SocketException e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                        DeviceSearchAndInitFrame.this.executorService.execute(new Runnable(){

                            @Override
                            public void run() {
                                String[] szIp = DeviceSearchAndInitFrame.this.startIpTextField.getText().split("\\.");
                                try {
                                    for (int i = 0; i < DeviceSearchModule.getHostAddress().size(); ++i) {
                                        DeviceSearchModule.unicastDeviceSearch(DeviceSearchModule.getHostAddress().get(i), DeviceSearchModule.getIp(szIp, 255), 256, DeviceSearchAndInitFrame.this.callback);
                                    }
                                }
                                catch (SocketException e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                        DeviceSearchAndInitFrame.this.executorService.execute(new Runnable(){

                            @Override
                            public void run() {
                                String[] szIp = DeviceSearchAndInitFrame.this.startIpTextField.getText().split("\\.");
                                szIp = DeviceSearchModule.getIp(szIp, 255).split("\\.");
                                try {
                                    for (int i = 0; i < DeviceSearchModule.getHostAddress().size(); ++i) {
                                        DeviceSearchModule.unicastDeviceSearch(DeviceSearchModule.getHostAddress().get(i), DeviceSearchModule.getIp(szIp, 255), 256, DeviceSearchAndInitFrame.this.callback);
                                    }
                                }
                                catch (SocketException e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                        DeviceSearchAndInitFrame.this.executorService.execute(new Runnable(){

                            @Override
                            public void run() {
                                String[] szIp = DeviceSearchAndInitFrame.this.startIpTextField.getText().split("\\.");
                                szIp = DeviceSearchModule.getIp(szIp, 255).split("\\.");
                                szIp = DeviceSearchModule.getIp(szIp, 255).split("\\.");
                                try {
                                    for (int i = 0; i < DeviceSearchModule.getHostAddress().size(); ++i) {
                                        DeviceSearchModule.unicastDeviceSearch(DeviceSearchModule.getHostAddress().get(i), DeviceSearchModule.getIp(szIp, 255), DeviceSearchAndInitFrame.this.count - 768, DeviceSearchAndInitFrame.this.callback);
                                    }
                                }
                                catch (SocketException e) {
                                    e.printStackTrace();
                                }
                                DeviceSearchAndInitFrame.this.bFlag = true;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DeviceSearchAndInitFrame.this.unicastSearchBtn.setEnabled(true);
                                    }
                                });
                            }
                        });
                    }
                }
            });
        }
    }

    private class MulticastAndBroadcastDeviceSearchPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public MulticastAndBroadcastDeviceSearchPanel() {
            BorderEx.set(this, Res.string().getDeviceSearch(), 1);
            this.setLayout(new FlowLayout());
            Dimension dimension = new Dimension();
            dimension.width = 220;
            this.setPreferredSize(dimension);
            DeviceSearchAndInitFrame.this.multiAndBroadcastSearchBtn = new JButton(Res.string().getStartSearch());
            DeviceSearchAndInitFrame.this.multiAndBroadcastSearchBtn.setPreferredSize(new Dimension(120, 20));
            this.add(DeviceSearchAndInitFrame.this.multiAndBroadcastSearchBtn);
            DeviceSearchAndInitFrame.this.multiAndBroadcastSearchBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int i;
                    DeviceSearchAndInitFrame.this.deviceInitBtn.setEnabled(true);
                    for (i = 0; i < handles.size(); ++i) {
                        DeviceSearchModule.stopDeviceSearch((NetSDKLib.LLong)handles.get(i));
                    }
                    DeviceSearchAndInitFrame.access$302(DeviceSearchAndInitFrame.this, new Object[1000][11]);
                    defaultModel = new DefaultTableModel(DeviceSearchAndInitFrame.this.data, Res.string().getDeviceTableName());
                    table.setModel(defaultModel);
                    table.getColumnModel().getColumn(0).setPreferredWidth(50);
                    table.getColumnModel().getColumn(1).setPreferredWidth(80);
                    table.getColumnModel().getColumn(2).setPreferredWidth(80);
                    table.getColumnModel().getColumn(3).setPreferredWidth(120);
                    table.getColumnModel().getColumn(4).setPreferredWidth(80);
                    table.getColumnModel().getColumn(5).setPreferredWidth(120);
                    table.getColumnModel().getColumn(6).setPreferredWidth(120);
                    table.getColumnModel().getColumn(7).setPreferredWidth(140);
                    table.getColumnModel().getColumn(8).setPreferredWidth(100);
                    table.getColumnModel().getColumn(9).setPreferredWidth(100);
                    table.getColumnModel().getColumn(10).setPreferredWidth(100);
                    table.setAutoResizeMode(0);
                    pwdResetHashMap.clear();
                    macArrayList.clear();
                    list.clear();
                    index = 0;
                    try {
                        for (i = 0; i < DeviceSearchModule.getHostAddress().size(); ++i) {
                            NetSDKLib.LLong handle = m_DeviceSearchHandle = DeviceSearchModule.multiBroadcastDeviceSearch(DeviceSearchAndInitFrame.this.callbackEx, DeviceSearchModule.getHostAddress().get(i));
                            handles.add(handle);
                        }
                    }
                    catch (SocketException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private class DeviceSearchPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public DeviceSearchPanel() {
            BorderEx.set(this, Res.string().getDeviceSearchOperate(), 2);
            this.setLayout(new BorderLayout());
            Dimension dimension = new Dimension();
            dimension.height = 85;
            this.setPreferredSize(dimension);
            MulticastAndBroadcastDeviceSearchPanel multiAndBroadPanel = new MulticastAndBroadcastDeviceSearchPanel();
            UnicastDeviceSearchPanel unicastPanel = new UnicastDeviceSearchPanel();
            this.add((Component)multiAndBroadPanel, "West");
            this.add((Component)unicastPanel, "Center");
        }
    }
}

