/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.FaceRecognition;

import com.netsdk.common.DateChooserJButtonEx;
import com.netsdk.common.PaintPanel;
import com.netsdk.common.Res;
import com.netsdk.demo.frame.FaceRecognition.DownloadPictureDialog;
import com.netsdk.demo.module.LoginModule;
import com.netsdk.demo.module.SearchByPictureModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class SearchByPicDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Vector<String> chnList = new Vector();
    private Memory memory = null;
    private static volatile int nProgress = 0;
    private static volatile int nCount = 0;
    private static JTextArea searchPicInfoTextArea;
    private static JProgressBar progressBar;
    private static JButton searchPicBtn;
    private PaintPanel searchPicPanel;
    private JComboBox chnComboBox;
    private JTextField similaryTextField;
    private DateChooserJButtonEx startTimeBtn;
    private DateChooserJButtonEx endTimeBtn;
    private JLabel chnLabel;
    private JLabel startTimeLabel;
    private JLabel endTimeLabel;
    private JCheckBox faceCheckBox;
    private static JCheckBox historyCheckBox;

    public SearchByPicDialog() {
        this.setTitle(Res.string().getSearchByPic());
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.pack();
        this.setSize(780, 550);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        JPanel panel = new JPanel();
        progressBar = new JProgressBar(0, 100);
        Dimension dimension = new Dimension();
        dimension.height = 18;
        progressBar.setPreferredSize(dimension);
        progressBar.setStringPainted(true);
        this.add((Component)panel, "Center");
        this.add((Component)progressBar, "South");
        panel.setLayout(new BorderLayout());
        SearchPicConditionPanel searchPicConditionPanel = new SearchPicConditionPanel();
        searchPicInfoTextArea = new JTextArea();
        Dimension dimension1 = new Dimension();
        dimension1.width = 220;
        searchPicConditionPanel.setPreferredSize(dimension1);
        panel.add((Component)searchPicConditionPanel, "West");
        panel.add((Component)new JScrollPane(searchPicInfoTextArea), "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SearchByPicDialog.this.dispose();
            }
        });
    }

    private void searchByPicture() {
        new SwingWorker<Boolean, StringBuffer>(){
            int nTotalCount = 0;

            @Override
            protected Boolean doInBackground() {
                int beginNum = 0;
                int nCount = 0;
                int index = 0;
                int nFindCount = 10;
                StringBuffer message = null;
                if (SearchByPicDialog.this.memory == null) {
                    JOptionPane.showMessageDialog(null, Res.string().getChooseFacePic(), Res.string().getErrorMessage(), 0);
                    return false;
                }
                this.nTotalCount = SearchByPictureModule.startFindPerson(SearchByPicDialog.this.memory, SearchByPicDialog.this.startTimeBtn.getText(), SearchByPicDialog.this.endTimeBtn.getText(), historyCheckBox.isSelected(), SearchByPicDialog.this.chnComboBox.getSelectedIndex(), SearchByPicDialog.this.similaryTextField.getText());
                if (this.nTotalCount == 0) {
                    SearchByPictureModule.doFindClosePerson();
                    return false;
                }
                if (this.nTotalCount == -1) {
                    nProgress = 0;
                    nCount = 0;
                    SearchByPictureModule.attachFaceFindState(fFaceFindStateCb.getInstance());
                } else {
                    NetSDKLib.CANDIDATE_INFOEX[] caInfoexs;
                    while ((caInfoexs = SearchByPictureModule.doFindNextPerson(beginNum, nFindCount)) != null) {
                        for (int i = 0; i < caInfoexs.length; ++i) {
                            index = i + nFindCount * nCount + 1;
                            message = new StringBuffer();
                            if (historyCheckBox.isSelected()) {
                                message.append("[" + index + "]" + Res.string().getTime() + ":" + caInfoexs[i].stTime.toStringTimeEx() + "\n");
                                message.append("[" + index + "]" + Res.string().getUid() + ":" + new String(caInfoexs[i].stPersonInfo.szUID).trim() + "\n");
                                message.append("[" + index + "]" + Res.string().getSex() + ":" + Res.string().getSex(caInfoexs[i].stPersonInfo.bySex) + "\n");
                                message.append("[" + index + "]" + Res.string().getAge() + ":" + caInfoexs[i].stPersonInfo.byAge + "\n");
                                message.append("[" + index + "]" + Res.string().getColor() + ":" + Res.string().getColor(0) + "\n");
                                message.append("[" + index + "]" + Res.string().getEye() + ":" + Res.string().getEyeState(caInfoexs[i].stPersonInfo.emEye) + "\n");
                                message.append("[" + index + "]" + Res.string().getMouth() + ":" + Res.string().getMouthState(caInfoexs[i].stPersonInfo.emMouth) + "\n");
                                message.append("[" + index + "]" + Res.string().getMask() + ":" + Res.string().getMaskState(caInfoexs[i].stPersonInfo.emMask) + "\n");
                                message.append("[" + index + "]" + Res.string().getBeard() + ":" + Res.string().getBeardState(caInfoexs[i].stPersonInfo.emBeard) + "\n");
                                message.append("[" + index + "]" + Res.string().getGlasses() + ":" + Res.string().getGlasses(caInfoexs[i].stPersonInfo.byGlasses) + "\n");
                                message.append("[" + index + "]" + Res.string().getSimilarity() + ":" + caInfoexs[i].bySimilarity + "\n");
                                message.append("[" + index + "]" + Res.string().getPicturePath() + ":" + caInfoexs[i].stPersonInfo.szFacePicInfo[0].pszFilePath.getString(0L) + "\n");
                            } else {
                                message.append("[" + index + "]" + Res.string().getFaceLibraryID() + ":" + new String(caInfoexs[i].stPersonInfo.szGroupID).trim() + "\n");
                                try {
                                    message.append("[" + index + "]" + Res.string().getFaceLibraryName() + ":" + new String(caInfoexs[i].stPersonInfo.szGroupName, "GBK").trim() + "\n");
                                    message.append("[" + index + "]" + Res.string().getName() + ":" + new String(caInfoexs[i].stPersonInfo.szPersonName, "GBK").trim() + "\n");
                                }
                                catch (UnsupportedEncodingException e) {
                                    e.printStackTrace();
                                }
                                message.append("[" + index + "]" + Res.string().getUid() + ":" + new String(caInfoexs[i].stPersonInfo.szUID).trim() + "\n");
                                message.append("[" + index + "]" + Res.string().getBirthday() + ":" + caInfoexs[i].stPersonInfo.wYear + "-" + (0xFF & caInfoexs[i].stPersonInfo.byMonth) + "-" + (0xFF & caInfoexs[i].stPersonInfo.byDay) + "\n");
                                message.append("[" + index + "]" + Res.string().getSex() + ":" + Res.string().getSex(caInfoexs[i].stPersonInfo.bySex) + "\n");
                                message.append("[" + index + "]" + Res.string().getCardType() + ":" + Res.string().getIdType(caInfoexs[i].stPersonInfo.byIDType) + "\n");
                                message.append("[" + index + "]" + Res.string().getCardNum() + ":" + new String(caInfoexs[i].stPersonInfo.szID).trim() + "\n");
                                message.append("[" + index + "]" + Res.string().getSimilarity() + ":" + caInfoexs[i].bySimilarity + "\n");
                                message.append("[" + index + "]" + Res.string().getPicturePath() + ":" + caInfoexs[i].stPersonInfo.szFacePicInfo[0].pszFilePath.getString(0L) + "\n");
                            }
                            message.append("\n");
                            this.publish(message);
                        }
                        if (caInfoexs.length < nFindCount) {
                            System.out.printf("No More Record, Find End!\n", new Object[0]);
                            break;
                        }
                        beginNum += nFindCount;
                        ++nCount;
                    }
                    SearchByPictureModule.doFindClosePerson();
                }
                return true;
            }

            @Override
            protected void process(List<StringBuffer> chunks) {
                for (StringBuffer data : chunks) {
                    searchPicInfoTextArea.append(data.toString());
                    searchPicInfoTextArea.updateUI();
                }
                super.process(chunks);
            }

            @Override
            protected void done() {
                if (this.nTotalCount == 0) {
                    searchPicBtn.setEnabled(true);
                    progressBar.setValue(100);
                    searchPicInfoTextArea.append("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u4fe1\u606f... \n");
                    searchPicInfoTextArea.updateUI();
                } else if (this.nTotalCount == -1) {
                    searchPicInfoTextArea.append(Res.string().getLoading() + "... \n");
                    searchPicInfoTextArea.updateUI();
                } else {
                    try {
                        if (((Boolean)this.get()).booleanValue()) {
                            searchPicBtn.setEnabled(true);
                            progressBar.setValue(100);
                            searchPicInfoTextArea.append("\u67e5\u8be2\u7ed3\u675f... \n");
                            searchPicInfoTextArea.updateUI();
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.execute();
    }

    private static class SearchPictureWoker
    extends SwingWorker<Boolean, StringBuffer> {
        private int nTotalCount;

        public SearchPictureWoker(int nTotalCount) {
            this.nTotalCount = nTotalCount;
        }

        @Override
        protected Boolean doInBackground() {
            NetSDKLib.CANDIDATE_INFOEX[] caInfoexs;
            int beginNum = 0;
            int nCount = 0;
            int index = 0;
            int nFindCount = 10;
            StringBuffer message = null;
            SearchByPictureModule.detachFaceFindState();
            System.out.println("nTotalCount = " + this.nTotalCount);
            if (this.nTotalCount == 0) {
                SearchByPictureModule.doFindClosePerson();
                return false;
            }
            while ((caInfoexs = SearchByPictureModule.doFindNextPerson(beginNum, nFindCount)) != null) {
                for (int i = 0; i < caInfoexs.length; ++i) {
                    index = i + nFindCount * nCount + 1;
                    message = new StringBuffer();
                    if (historyCheckBox.isSelected()) {
                        message.append("[" + index + "]" + Res.string().getTime() + ":" + caInfoexs[i].stTime.toStringTimeEx() + "\n");
                        message.append("[" + index + "]" + Res.string().getUid() + ":" + new String(caInfoexs[i].stPersonInfo.szUID).trim() + "\n");
                        message.append("[" + index + "]" + Res.string().getSex() + ":" + Res.string().getSex(caInfoexs[i].stPersonInfo.bySex) + "\n");
                        message.append("[" + index + "]" + Res.string().getAge() + ":" + caInfoexs[i].stPersonInfo.byAge + "\n");
                        message.append("[" + index + "]" + Res.string().getColor() + ":" + Res.string().getColor(0) + "\n");
                        message.append("[" + index + "]" + Res.string().getEye() + ":" + Res.string().getEyeState(caInfoexs[i].stPersonInfo.emEye) + "\n");
                        message.append("[" + index + "]" + Res.string().getMouth() + ":" + Res.string().getMouthState(caInfoexs[i].stPersonInfo.emMouth) + "\n");
                        message.append("[" + index + "]" + Res.string().getMask() + ":" + Res.string().getMaskState(caInfoexs[i].stPersonInfo.emMask) + "\n");
                        message.append("[" + index + "]" + Res.string().getBeard() + ":" + Res.string().getBeardState(caInfoexs[i].stPersonInfo.emBeard) + "\n");
                        message.append("[" + index + "]" + Res.string().getGlasses() + ":" + Res.string().getGlasses(caInfoexs[i].stPersonInfo.byGlasses) + "\n");
                        message.append("[" + index + "]" + Res.string().getSimilarity() + ":" + caInfoexs[i].bySimilarity + "\n");
                        message.append("[" + index + "]" + Res.string().getPicturePath() + ":" + caInfoexs[i].stPersonInfo.szFacePicInfo[0].pszFilePath.getString(0L) + "\n");
                    } else {
                        message.append("[" + index + "]" + Res.string().getFaceLibraryID() + ":" + new String(caInfoexs[i].stPersonInfo.szGroupID).trim() + "\n");
                        try {
                            message.append("[" + index + "]" + Res.string().getFaceLibraryName() + ":" + new String(caInfoexs[i].stPersonInfo.szGroupName, "GBK").trim() + "\n");
                            message.append("[" + index + "]" + Res.string().getName() + ":" + new String(caInfoexs[i].stPersonInfo.szPersonName, "GBK").trim() + "\n");
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        message.append("[" + index + "]" + Res.string().getUid() + ":" + new String(caInfoexs[i].stPersonInfo.szUID).trim() + "\n");
                        message.append("[" + index + "]" + Res.string().getBirthday() + ":" + caInfoexs[i].stPersonInfo.wYear + "-" + (0xFF & caInfoexs[i].stPersonInfo.byMonth) + "-" + (0xFF & caInfoexs[i].stPersonInfo.byDay) + "\n");
                        message.append("[" + index + "]" + Res.string().getSex() + ":" + Res.string().getSex(caInfoexs[i].stPersonInfo.bySex) + "\n");
                        message.append("[" + index + "]" + Res.string().getCardType() + ":" + Res.string().getIdType(caInfoexs[i].stPersonInfo.byIDType) + "\n");
                        message.append("[" + index + "]" + Res.string().getCardNum() + ":" + new String(caInfoexs[i].stPersonInfo.szID).trim() + "\n");
                        message.append("[" + index + "]" + Res.string().getSimilarity() + ":" + caInfoexs[i].bySimilarity + "\n");
                        message.append("[" + index + "]" + Res.string().getPicturePath() + ":" + caInfoexs[i].stPersonInfo.szFacePicInfo[0].pszFilePath.getString(0L) + "\n");
                    }
                    message.append("\n");
                    this.publish(message);
                }
                if (caInfoexs.length < nFindCount) {
                    System.out.printf("No More Record, Find End!\n", new Object[0]);
                    break;
                }
                beginNum += nFindCount;
                ++nCount;
            }
            SearchByPictureModule.doFindClosePerson();
            return true;
        }

        @Override
        protected void process(List<StringBuffer> chunks) {
            for (StringBuffer data : chunks) {
                searchPicInfoTextArea.append(data.toString());
                searchPicInfoTextArea.updateUI();
            }
            super.process(chunks);
        }

        @Override
        protected void done() {
            searchPicBtn.setEnabled(true);
            searchPicInfoTextArea.append(Res.string().getEndSearch() + "... \n");
            searchPicInfoTextArea.updateUI();
        }
    }

    private static class fFaceFindStateCb
    implements NetSDKLib.fFaceFindState {
        private fFaceFindStateCb() {
        }

        public static fFaceFindStateCb getInstance() {
            return fFaceFindStateCbHolder.instance;
        }

        @Override
        public void invoke(NetSDKLib.LLong lLoginID, NetSDKLib.LLong lAttachHandle, Pointer pstStates, int nStateNum, Pointer dwUser) {
            int i;
            if (nStateNum < 1) {
                return;
            }
            Structure[] msg = new NetSDKLib.NET_CB_FACE_FIND_STATE[nStateNum];
            for (i = 0; i < nStateNum; ++i) {
                msg[i] = new NetSDKLib.NET_CB_FACE_FIND_STATE();
            }
            ToolKits.GetPointerDataToStructArr(pstStates, msg);
            for (i = 0; i < nStateNum; ++i) {
                if (SearchByPictureModule.nToken != ((NetSDKLib.NET_CB_FACE_FIND_STATE)msg[i]).nToken) continue;
                nProgress = ((NetSDKLib.NET_CB_FACE_FIND_STATE)msg[i]).nProgress;
                nCount = ((NetSDKLib.NET_CB_FACE_FIND_STATE)msg[i]).nCurrentCount;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        progressBar.setValue(nProgress);
                        if (nProgress == 100) {
                            new SearchPictureWoker(nCount).execute();
                        }
                    }
                });
            }
        }

        private static class fFaceFindStateCbHolder {
            private static final fFaceFindStateCb instance = new fFaceFindStateCb();

            private fFaceFindStateCbHolder() {
            }
        }
    }

    private class SearchPicConditionPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public SearchPicConditionPanel() {
            this.setLayout(new BorderLayout());
            JPanel panelNorth = new JPanel();
            JPanel panelSouth = new JPanel();
            this.add((Component)panelNorth, "North");
            this.add((Component)panelSouth, "South");
            SearchByPicDialog.this.searchPicPanel = new PaintPanel();
            JButton selectPicBtn = new JButton(Res.string().getSelectPicture());
            JButton downloadBtn = new JButton(Res.string().getDownloadQueryPicture());
            SearchByPicDialog.this.searchPicPanel.setPreferredSize(new Dimension(210, 270));
            selectPicBtn.setPreferredSize(new Dimension(210, 20));
            downloadBtn.setPreferredSize(new Dimension(210, 20));
            panelNorth.setLayout(new FlowLayout());
            panelNorth.setPreferredSize(new Dimension(210, 330));
            panelNorth.add(SearchByPicDialog.this.searchPicPanel);
            panelNorth.add(selectPicBtn);
            panelNorth.add(downloadBtn);
            SearchByPicDialog.this.faceCheckBox = new JCheckBox(Res.string().getFaceLibrary());
            historyCheckBox = new JCheckBox(Res.string().getHistoryLibrary());
            SearchByPicDialog.this.faceCheckBox.setPreferredSize(new Dimension(100, 20));
            historyCheckBox.setPreferredSize(new Dimension(100, 20));
            SearchByPicDialog.this.startTimeLabel = new JLabel(Res.string().getStartTime(), 0);
            SearchByPicDialog.this.endTimeLabel = new JLabel(Res.string().getEndTime(), 0);
            SearchByPicDialog.this.chnLabel = new JLabel(Res.string().getChannel(), 0);
            JLabel similaryLabel = new JLabel(Res.string().getSimilarity(), 0);
            Dimension dimension1 = new Dimension();
            dimension1.width = 80;
            dimension1.height = 20;
            SearchByPicDialog.this.startTimeLabel.setPreferredSize(dimension1);
            SearchByPicDialog.this.endTimeLabel.setPreferredSize(dimension1);
            SearchByPicDialog.this.chnLabel.setPreferredSize(dimension1);
            similaryLabel.setPreferredSize(dimension1);
            SearchByPicDialog.this.startTimeBtn = new DateChooserJButtonEx("2018-11-07");
            SearchByPicDialog.this.endTimeBtn = new DateChooserJButtonEx();
            SearchByPicDialog.this.chnComboBox = new JComboBox();
            for (int i = 1; i < LoginModule.m_stDeviceInfo.byChanNum + 1; ++i) {
                SearchByPicDialog.this.chnList.add(Res.string().getChannel() + " " + String.valueOf(i));
            }
            SearchByPicDialog.this.chnComboBox.setModel(new DefaultComboBoxModel(SearchByPicDialog.this.chnList));
            SearchByPicDialog.this.similaryTextField = new JTextField("60", 0);
            Dimension dimension2 = new Dimension();
            dimension2.width = 120;
            dimension2.height = 20;
            SearchByPicDialog.this.startTimeBtn.setPreferredSize(dimension2);
            SearchByPicDialog.this.endTimeBtn.setPreferredSize(dimension2);
            SearchByPicDialog.this.chnComboBox.setPreferredSize(dimension2);
            SearchByPicDialog.this.similaryTextField.setPreferredSize(dimension2);
            searchPicBtn = new JButton(Res.string().getSearch());
            searchPicBtn.setPreferredSize(new Dimension(210, 20));
            panelSouth.setLayout(new FlowLayout());
            panelSouth.setPreferredSize(new Dimension(210, 160));
            panelSouth.add(SearchByPicDialog.this.faceCheckBox);
            panelSouth.add(historyCheckBox);
            panelSouth.add(SearchByPicDialog.this.startTimeLabel);
            panelSouth.add(SearchByPicDialog.this.startTimeBtn);
            panelSouth.add(SearchByPicDialog.this.endTimeLabel);
            panelSouth.add(SearchByPicDialog.this.endTimeBtn);
            panelSouth.add(SearchByPicDialog.this.chnLabel);
            panelSouth.add(SearchByPicDialog.this.chnComboBox);
            panelSouth.add(similaryLabel);
            panelSouth.add(SearchByPicDialog.this.similaryTextField);
            panelSouth.add(searchPicBtn);
            historyCheckBox.setSelected(true);
            SearchByPicDialog.this.faceCheckBox.setSelected(false);
            selectPicBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    String picPath = "";
                    picPath = ToolKits.openPictureFile(SearchByPicDialog.this.searchPicPanel);
                    if (!picPath.equals("")) {
                        try {
                            SearchByPicDialog.this.memory = ToolKits.readPictureFile(picPath);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            downloadBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    DownloadPictureDialog dialog = new DownloadPictureDialog();
                    dialog.setVisible(true);
                }
            });
            searchPicBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            searchPicBtn.setEnabled(false);
                            progressBar.setValue(0);
                            searchPicInfoTextArea.setText("");
                        }
                    });
                    SearchByPicDialog.this.searchByPicture();
                }
            });
            SearchByPicDialog.this.faceCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (SearchByPicDialog.this.faceCheckBox.isSelected()) {
                        historyCheckBox.setSelected(false);
                        SearchByPicDialog.this.chnLabel.setVisible(false);
                        SearchByPicDialog.this.chnComboBox.setVisible(false);
                        SearchByPicDialog.this.startTimeLabel.setVisible(false);
                        SearchByPicDialog.this.endTimeLabel.setVisible(false);
                        SearchByPicDialog.this.startTimeBtn.setVisible(false);
                        SearchByPicDialog.this.endTimeBtn.setVisible(false);
                    } else {
                        historyCheckBox.setSelected(true);
                        SearchByPicDialog.this.chnLabel.setVisible(true);
                        SearchByPicDialog.this.chnComboBox.setVisible(true);
                        SearchByPicDialog.this.startTimeLabel.setVisible(true);
                        SearchByPicDialog.this.endTimeLabel.setVisible(true);
                        SearchByPicDialog.this.startTimeBtn.setVisible(true);
                        SearchByPicDialog.this.endTimeBtn.setVisible(true);
                    }
                }
            });
            historyCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (historyCheckBox.isSelected()) {
                        SearchByPicDialog.this.faceCheckBox.setSelected(false);
                        SearchByPicDialog.this.chnLabel.setVisible(true);
                        SearchByPicDialog.this.chnComboBox.setVisible(true);
                        SearchByPicDialog.this.startTimeLabel.setVisible(true);
                        SearchByPicDialog.this.endTimeLabel.setVisible(true);
                        SearchByPicDialog.this.startTimeBtn.setVisible(true);
                        SearchByPicDialog.this.endTimeBtn.setVisible(true);
                    } else {
                        SearchByPicDialog.this.faceCheckBox.setSelected(true);
                        SearchByPicDialog.this.chnLabel.setVisible(false);
                        SearchByPicDialog.this.chnComboBox.setVisible(false);
                        SearchByPicDialog.this.startTimeLabel.setVisible(false);
                        SearchByPicDialog.this.endTimeLabel.setVisible(false);
                        SearchByPicDialog.this.startTimeBtn.setVisible(false);
                        SearchByPicDialog.this.endTimeBtn.setVisible(false);
                    }
                }
            });
        }
    }
}

