/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame;

import com.netsdk.common.BorderEx;
import com.netsdk.common.FunctionList;
import com.netsdk.common.LoginPanel;
import com.netsdk.common.Res;
import com.netsdk.demo.module.LoginModule;
import com.netsdk.demo.module.RealPlayModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.Pointer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

class RealPlayFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Vector<String> chnlist = new Vector();
    private boolean isrealplayOne = false;
    private boolean isrealplayTwo = false;
    private static DisConnect disConnect = new DisConnect();
    private static HaveReConnect haveReConnect = new HaveReConnect();
    public static NetSDKLib.LLong m_hPlayHandleOne = new NetSDKLib.LLong(0L);
    public static NetSDKLib.LLong m_hPlayHandleTwo = new NetSDKLib.LLong(0L);
    private static JFrame frame = new JFrame();
    private LoginPanel loginPanel;
    private JPanel realPanel;
    private RealPanelOne realPanelOne;
    private JPanel realplayPanelOne;
    private Panel realPlayWindowOne;
    private Panel channelPanelOne;
    private JLabel chnlabelOne;
    private JComboBox chnComboBoxOne;
    private JLabel streamLabelOne;
    private JComboBox streamComboBoxOne;
    private JButton realplayBtnOne;
    private RealPanelTwo realPanelTwo;
    private JPanel realplayPanelTwo;
    private Panel realPlayWindowTwo;
    private Panel channelPanelTwo;
    private JLabel chnlabelTwo;
    private JComboBox chnComboBoxTwo;
    private JLabel streamLabelTwo;
    private JComboBox streamComboBoxTwo;
    private JButton realplayBtnTwo;

    public RealPlayFrame() {
        this.setTitle(Res.string().getRealplay());
        this.setLayout(new BorderLayout());
        this.pack();
        this.setSize(800, 560);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        LoginModule.init(disConnect, haveReConnect);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loginPanel = new LoginPanel();
        this.realPanel = new JPanel();
        this.add((Component)this.loginPanel, "North");
        this.add((Component)this.realPanel, "Center");
        this.realPanelOne = new RealPanelOne();
        this.realPanelTwo = new RealPanelTwo();
        this.realPanel.setLayout(new GridLayout(1, 2));
        this.realPanel.add(this.realPanelOne);
        this.realPanel.add(this.realPanelTwo);
        this.loginPanel.addLoginBtnActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RealPlayFrame.this.loginPanel.checkLoginText() && RealPlayFrame.this.login()) {
                    frame = ToolKits.getFrame(e);
                    frame.setTitle(Res.string().getRealplay() + " : " + Res.string().getOnline());
                }
            }
        });
        this.loginPanel.addLogoutBtnActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setTitle(Res.string().getRealplay());
                RealPlayFrame.this.logout();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RealPlayModule.stopRealPlay(m_hPlayHandleOne);
                RealPlayModule.stopRealPlay(m_hPlayHandleTwo);
                LoginModule.logout();
                LoginModule.cleanup();
                RealPlayFrame.this.dispose();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FunctionList demo = new FunctionList();
                        demo.setVisible(true);
                    }
                });
            }
        });
    }

    public boolean login() {
        if (LoginModule.login(this.loginPanel.ipTextArea.getText(), Integer.parseInt(this.loginPanel.portTextArea.getText()), this.loginPanel.nameTextArea.getText(), new String(this.loginPanel.passwordTextArea.getPassword()))) {
            this.loginPanel.setButtonEnable(true);
            this.setButtonEnable(true);
            for (int i = 1; i < LoginModule.m_stDeviceInfo.byChanNum + 1; ++i) {
                this.chnlist.add(Res.string().getChannel() + " " + String.valueOf(i));
            }
        } else {
            JOptionPane.showMessageDialog(null, Res.string().getLoginFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return false;
        }
        this.chnComboBoxOne.setModel(new DefaultComboBoxModel<String>(this.chnlist));
        this.chnComboBoxTwo.setModel(new DefaultComboBoxModel<String>(this.chnlist));
        return true;
    }

    public void logout() {
        RealPlayModule.stopRealPlay(m_hPlayHandleOne);
        RealPlayModule.stopRealPlay(m_hPlayHandleTwo);
        LoginModule.logout();
        this.loginPanel.setButtonEnable(false);
        this.setButtonEnable(false);
        this.realPlayWindowOne.repaint();
        this.realPlayWindowTwo.repaint();
        this.isrealplayOne = false;
        this.realplayBtnOne.setText(Res.string().getStartRealPlay());
        this.isrealplayTwo = false;
        this.realplayBtnTwo.setText(Res.string().getStartRealPlay());
        for (int i = 0; i < LoginModule.m_stDeviceInfo.byChanNum; ++i) {
            this.chnlist.clear();
        }
        this.chnComboBoxOne.setModel(new DefaultComboBoxModel());
        this.chnComboBoxTwo.setModel(new DefaultComboBoxModel());
    }

    public void realplayOne() {
        if (!this.isrealplayOne) {
            m_hPlayHandleOne = RealPlayModule.startRealPlay(this.chnComboBoxOne.getSelectedIndex(), this.streamComboBoxOne.getSelectedIndex() == 0 ? 0 : 3, this.realPlayWindowOne);
            if (m_hPlayHandleOne.longValue() != 0L) {
                this.realPlayWindowOne.repaint();
                this.isrealplayOne = true;
                this.chnComboBoxOne.setEnabled(false);
                this.streamComboBoxOne.setEnabled(false);
                this.realplayBtnOne.setText(Res.string().getStopRealPlay());
            } else {
                JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            }
        } else {
            RealPlayModule.stopRealPlay(m_hPlayHandleOne);
            this.realPlayWindowOne.repaint();
            this.isrealplayOne = false;
            this.chnComboBoxOne.setEnabled(true);
            this.streamComboBoxOne.setEnabled(true);
            this.realplayBtnOne.setText(Res.string().getStartRealPlay());
        }
    }

    public void realplayTwo() {
        if (!this.isrealplayTwo) {
            m_hPlayHandleTwo = RealPlayModule.startRealPlay(this.chnComboBoxTwo.getSelectedIndex(), this.streamComboBoxTwo.getSelectedIndex() == 0 ? 0 : 3, this.realPlayWindowTwo);
            if (m_hPlayHandleTwo.longValue() != 0L) {
                this.realPlayWindowTwo.repaint();
                this.isrealplayTwo = true;
                this.chnComboBoxTwo.setEnabled(false);
                this.streamComboBoxTwo.setEnabled(false);
                this.realplayBtnTwo.setText(Res.string().getStopRealPlay());
            } else {
                JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            }
        } else {
            RealPlayModule.stopRealPlay(m_hPlayHandleTwo);
            this.realPlayWindowTwo.repaint();
            this.isrealplayTwo = false;
            this.chnComboBoxTwo.setEnabled(true);
            this.streamComboBoxTwo.setEnabled(true);
            this.realplayBtnTwo.setText(Res.string().getStartRealPlay());
        }
    }

    private void setButtonEnable(boolean bln) {
        this.realPlayWindowOne.setEnabled(bln);
        this.chnComboBoxOne.setEnabled(bln);
        this.streamComboBoxOne.setEnabled(bln);
        this.realplayBtnOne.setEnabled(bln);
        this.realPlayWindowTwo.setEnabled(bln);
        this.chnComboBoxTwo.setEnabled(bln);
        this.streamComboBoxTwo.setEnabled(bln);
        this.realplayBtnTwo.setEnabled(bln);
    }

    private class RealPanelTwo
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public RealPanelTwo() {
            BorderEx.set(this, Res.string().getRealplay(), 2);
            this.setLayout(new BorderLayout());
            RealPlayFrame.this.channelPanelTwo = new Panel();
            RealPlayFrame.this.realplayPanelTwo = new JPanel();
            this.add((Component)RealPlayFrame.this.channelPanelTwo, "North");
            this.add((Component)RealPlayFrame.this.realplayPanelTwo, "Center");
            RealPlayFrame.this.realplayPanelTwo.setLayout(new BorderLayout());
            RealPlayFrame.this.realplayPanelTwo.setBorder(new EmptyBorder(5, 5, 5, 5));
            RealPlayFrame.this.realPlayWindowTwo = new Panel();
            RealPlayFrame.this.realPlayWindowTwo.setBackground(Color.GRAY);
            RealPlayFrame.this.realplayPanelTwo.add((Component)RealPlayFrame.this.realPlayWindowTwo, "Center");
            RealPlayFrame.this.chnlabelTwo = new JLabel(Res.string().getChn());
            RealPlayFrame.this.chnComboBoxTwo = new JComboBox();
            RealPlayFrame.this.streamLabelTwo = new JLabel(Res.string().getStreamType());
            String[] stream = new String[]{Res.string().getMasterStream(), Res.string().getSubStream()};
            RealPlayFrame.this.streamComboBoxTwo = new JComboBox<String>(stream);
            RealPlayFrame.this.realplayBtnTwo = new JButton(Res.string().getStartRealPlay());
            RealPlayFrame.this.channelPanelTwo.setLayout(new FlowLayout());
            RealPlayFrame.this.channelPanelTwo.add(RealPlayFrame.this.chnlabelTwo);
            RealPlayFrame.this.channelPanelTwo.add(RealPlayFrame.this.chnComboBoxTwo);
            RealPlayFrame.this.channelPanelTwo.add(RealPlayFrame.this.streamLabelTwo);
            RealPlayFrame.this.channelPanelTwo.add(RealPlayFrame.this.streamComboBoxTwo);
            RealPlayFrame.this.channelPanelTwo.add(RealPlayFrame.this.realplayBtnTwo);
            RealPlayFrame.this.chnComboBoxTwo.setPreferredSize(new Dimension(80, 20));
            RealPlayFrame.this.streamComboBoxTwo.setPreferredSize(new Dimension(95, 20));
            RealPlayFrame.this.realplayBtnTwo.setPreferredSize(new Dimension(115, 20));
            RealPlayFrame.this.realPlayWindowTwo.setEnabled(false);
            RealPlayFrame.this.chnComboBoxTwo.setEnabled(false);
            RealPlayFrame.this.streamComboBoxTwo.setEnabled(false);
            RealPlayFrame.this.realplayBtnTwo.setEnabled(false);
            RealPlayFrame.this.realplayBtnTwo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RealPlayFrame.this.realplayTwo();
                }
            });
        }
    }

    private class RealPanelOne
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public RealPanelOne() {
            BorderEx.set(this, Res.string().getRealplay(), 2);
            this.setLayout(new BorderLayout());
            RealPlayFrame.this.channelPanelOne = new Panel();
            RealPlayFrame.this.realplayPanelOne = new JPanel();
            this.add((Component)RealPlayFrame.this.channelPanelOne, "North");
            this.add((Component)RealPlayFrame.this.realplayPanelOne, "Center");
            RealPlayFrame.this.realplayPanelOne.setLayout(new BorderLayout());
            RealPlayFrame.this.realplayPanelOne.setBorder(new EmptyBorder(5, 5, 5, 5));
            RealPlayFrame.this.realPlayWindowOne = new Panel();
            RealPlayFrame.this.realPlayWindowOne.setBackground(Color.GRAY);
            RealPlayFrame.this.realplayPanelOne.add((Component)RealPlayFrame.this.realPlayWindowOne, "Center");
            RealPlayFrame.this.chnlabelOne = new JLabel(Res.string().getChn());
            RealPlayFrame.this.chnComboBoxOne = new JComboBox();
            RealPlayFrame.this.streamLabelOne = new JLabel(Res.string().getStreamType());
            String[] stream = new String[]{Res.string().getMasterStream(), Res.string().getSubStream()};
            RealPlayFrame.this.streamComboBoxOne = new JComboBox<String>(stream);
            RealPlayFrame.this.realplayBtnOne = new JButton(Res.string().getStartRealPlay());
            RealPlayFrame.this.channelPanelOne.setLayout(new FlowLayout());
            RealPlayFrame.this.channelPanelOne.add(RealPlayFrame.this.chnlabelOne);
            RealPlayFrame.this.channelPanelOne.add(RealPlayFrame.this.chnComboBoxOne);
            RealPlayFrame.this.channelPanelOne.add(RealPlayFrame.this.streamLabelOne);
            RealPlayFrame.this.channelPanelOne.add(RealPlayFrame.this.streamComboBoxOne);
            RealPlayFrame.this.channelPanelOne.add(RealPlayFrame.this.realplayBtnOne);
            RealPlayFrame.this.chnComboBoxOne.setPreferredSize(new Dimension(80, 20));
            RealPlayFrame.this.streamComboBoxOne.setPreferredSize(new Dimension(95, 20));
            RealPlayFrame.this.realplayBtnOne.setPreferredSize(new Dimension(115, 20));
            RealPlayFrame.this.realPlayWindowOne.setEnabled(false);
            RealPlayFrame.this.chnComboBoxOne.setEnabled(false);
            RealPlayFrame.this.streamComboBoxOne.setEnabled(false);
            RealPlayFrame.this.realplayBtnOne.setEnabled(false);
            RealPlayFrame.this.realplayBtnOne.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RealPlayFrame.this.realplayOne();
                }
            });
        }
    }

    private static class HaveReConnect
    implements NetSDKLib.fHaveReConnect {
        private HaveReConnect() {
        }

        @Override
        public void invoke(NetSDKLib.LLong m_hLoginHandle, String pchDVRIP, int nDVRPort, Pointer dwUser) {
            System.out.printf("ReConnect Device[%s] Port[%d]\n", pchDVRIP, nDVRPort);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.setTitle(Res.string().getRealplay() + " : " + Res.string().getOnline());
                }
            });
        }
    }

    private static class DisConnect
    implements NetSDKLib.fDisConnect {
        private DisConnect() {
        }

        @Override
        public void invoke(NetSDKLib.LLong m_hLoginHandle, String pchDVRIP, int nDVRPort, Pointer dwUser) {
            System.out.printf("Device[%s] Port[%d] DisConnect!\n", pchDVRIP, nDVRPort);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.setTitle(Res.string().getRealplay() + " : " + Res.string().getDisConnectReconnecting());
                }
            });
        }
    }
}

