/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.ThermalCamera;

import com.netsdk.common.BorderEx;
import com.netsdk.common.DateChooserJButton;
import com.netsdk.common.Res;
import com.netsdk.demo.frame.ThermalCamera.ThermalCameraFrame;
import com.netsdk.demo.module.ThermalCameraModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class TemperQueryDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private NetSDKLib.NET_IN_RADIOMETRY_STARTFIND stuStartFind = new NetSDKLib.NET_IN_RADIOMETRY_STARTFIND();
    private QueryPanel queryPanel;
    private QueryShowPanel showPanel;

    public TemperQueryDialog() {
        this.setTitle(Res.string().getShowInfo("TEMPER_INFO"));
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.pack();
        this.setSize(800, 550);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.queryPanel = new QueryPanel();
        this.showPanel = new QueryShowPanel();
        this.add((Component)this.queryPanel, "North");
        this.add((Component)this.showPanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    ThermalCameraModule.stopFind();
                }
                finally {
                    TemperQueryDialog.this.dispose();
                }
            }
        });
    }

    public void setSearchEnable(boolean b) {
        this.showPanel.setButtonEnable(b);
        this.queryPanel.setButtonEnable(b);
    }

    public void queryHistoryInfo(final QUERY_TYPE type) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TemperQueryDialog.this.setSearchEnable(false);
                if (type == QUERY_TYPE.FIRST_PAGE_QUERY) {
                    TemperQueryDialog.this.showPanel.clearData();
                }
            }
        });
        new QuerySwingWorker(type).execute();
    }

    public class QuerySwingWorker
    extends SwingWorker<NetSDKLib.NET_OUT_RADIOMETRY_DOFIND, Object> {
        private QUERY_TYPE type;
        private int offset = 0;

        public QuerySwingWorker(QUERY_TYPE type) {
            this.type = type;
        }

        @Override
        protected NetSDKLib.NET_OUT_RADIOMETRY_DOFIND doInBackground() {
            int currentIndex = TemperQueryDialog.this.showPanel.getIndex();
            try {
                switch (this.type) {
                    case FIRST_PAGE_QUERY: {
                        ThermalCameraModule.stopFind();
                        if (!ThermalCameraModule.startFind(TemperQueryDialog.this.stuStartFind)) {
                            return null;
                        }
                        this.offset = 0;
                        break;
                    }
                    case PRE_PAGE_QUERY: {
                        this.offset = ((currentIndex - 1) / 20 - 1) * 20;
                        break;
                    }
                    case NEXT_PAGE_QUERY: {
                        this.offset = currentIndex;
                        break;
                    }
                }
                NetSDKLib.NET_OUT_RADIOMETRY_DOFIND stuDoFind = ThermalCameraModule.doFind(this.offset, 20);
                return stuDoFind;
            }
            catch (Exception e) {
                System.out.println(" -------- doInBackground Exception -------- ");
                return null;
            }
        }

        @Override
        protected void done() {
            try {
                NetSDKLib.NET_OUT_RADIOMETRY_DOFIND stuDoFind = (NetSDKLib.NET_OUT_RADIOMETRY_DOFIND)this.get();
                if (stuDoFind == null) {
                    JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                    return;
                }
                if (stuDoFind.nFound == 0) {
                    JOptionPane.showMessageDialog(null, Res.string().getFailed(), Res.string().getErrorMessage(), 0);
                    return;
                }
                TemperQueryDialog.this.showPanel.setIndex(this.offset);
                TemperQueryDialog.this.showPanel.insertData(stuDoFind);
            }
            catch (Exception exception) {
            }
            finally {
                TemperQueryDialog.this.setSearchEnable(true);
            }
        }
    }

    public static enum QUERY_TYPE {
        UNKNOWN,
        FIRST_PAGE_QUERY,
        PRE_PAGE_QUERY,
        NEXT_PAGE_QUERY;

    }

    public class QueryShowPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        public static final int INDEX = 0;
        public static final int RECORD_TIME = 1;
        public static final int PRESET_ID = 2;
        public static final int RULE_ID = 3;
        public static final int ITEM_NAME = 4;
        public static final int CHANNEL = 5;
        public static final int COORDINATE = 6;
        public static final int METER_TYPE = 7;
        public static final int TEMPER_UNIT = 8;
        public static final int TEMPER_AVER = 9;
        public static final int TEMPER_MAX = 10;
        public static final int TEMPER_MIN = 11;
        public static final int TEMPER_MID = 12;
        public static final int TEMPER_STD = 13;
        public static final int QUERY_SHOW_COUNT = 20;
        private int currentIndex = 0;
        private String[] arrMeterType = Res.string().getMeterTypeList();
        private String[] arrTemperUnit = Res.string().getTemperUnitList();
        private JTable table = null;
        private DefaultTableModel tableModel = null;
        public JButton prePageBtn;
        public JButton nextPageBtn;

        public QueryShowPanel() {
            BorderEx.set(this, Res.string().getShowInfo("QUERY_LIST"), 1);
            this.setLayout(new BorderLayout());
            Object[] columnNames = new String[]{Res.string().getShowInfo("INDEX"), Res.string().getShowInfo("RECORD_TIME"), Res.string().getShowInfo("PRESET_ID"), Res.string().getShowInfo("RULE_ID"), Res.string().getShowInfo("ITEM_NAME"), Res.string().getShowInfo("CHANNEL"), Res.string().getShowInfo("COORDINATE"), Res.string().getShowInfo("METER_TYPE"), Res.string().getShowInfo("TEMPER_UNIT"), Res.string().getShowInfo("TEMPER_AVER"), Res.string().getShowInfo("TEMPER_MAX"), Res.string().getShowInfo("TEMPER_MIN"), Res.string().getShowInfo("TEMPER_MID"), Res.string().getShowInfo("TEMPER_STD")};
            this.tableModel = new DefaultTableModel((Object[][])null, columnNames);
            this.table = new JTable(this.tableModel){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return false;
                }
            };
            this.tableModel.setRowCount(20);
            this.table.setSelectionMode(0);
            Enumeration<TableColumn> columns = this.table.getColumnModel().getColumns();
            while (columns.hasMoreElements()) {
                columns.nextElement().setPreferredWidth(140);
            }
            this.table.getColumnModel().getColumn(1).setPreferredWidth(140);
            this.table.getColumnModel().getColumn(4).setPreferredWidth(180);
            ((DefaultTableCellRenderer)this.table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
            DefaultTableCellRenderer tcr = new DefaultTableCellRenderer();
            tcr.setHorizontalAlignment(0);
            this.table.setDefaultRenderer(Object.class, tcr);
            this.table.setAutoResizeMode(0);
            JScrollPane scrollPane = new JScrollPane(this.table);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setHorizontalScrollBarPolicy(30);
            JPanel functionPanel = new JPanel(new FlowLayout(1, 120, 5));
            this.prePageBtn = new JButton(Res.string().getPreviousPage());
            this.nextPageBtn = new JButton(Res.string().getNextPage());
            this.prePageBtn.setPreferredSize(new Dimension(120, 20));
            this.nextPageBtn.setPreferredSize(new Dimension(120, 20));
            this.setButtonEnable(false);
            functionPanel.add(this.nextPageBtn);
            this.add((Component)scrollPane, "Center");
            this.add((Component)functionPanel, "South");
            this.prePageBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TemperQueryDialog.this.queryHistoryInfo(QUERY_TYPE.PRE_PAGE_QUERY);
                }
            });
            this.nextPageBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TemperQueryDialog.this.queryHistoryInfo(QUERY_TYPE.NEXT_PAGE_QUERY);
                }
            });
        }

        public void setButtonEnable(boolean b) {
            this.prePageBtn.setEnabled(false);
            this.nextPageBtn.setEnabled(false);
            if (b) {
                if (this.currentIndex < ThermalCameraModule.getTotalCount()) {
                    this.nextPageBtn.setEnabled(true);
                }
                if (this.currentIndex > 20) {
                    this.prePageBtn.setEnabled(true);
                }
            }
        }

        public int getIndex() {
            return this.currentIndex;
        }

        public void setIndex(int index) {
            this.currentIndex = index;
        }

        public void insertData(NetSDKLib.NET_OUT_RADIOMETRY_DOFIND stuDoFind) {
            if (stuDoFind == null) {
                return;
            }
            this.tableModel.setRowCount(0);
            for (int i = 0; i < stuDoFind.nFound; ++i) {
                this.insertData(stuDoFind.stInfo[i]);
            }
            this.tableModel.setRowCount(20);
            this.table.updateUI();
        }

        private void insertData(NetSDKLib.NET_RADIOMETRY_QUERY data) {
            ++this.currentIndex;
            Vector<String> vector = new Vector<String>();
            vector.add(String.valueOf(this.currentIndex));
            vector.add(data.stTime.toStringTimeEx());
            vector.add(String.valueOf(data.nPresetId));
            vector.add(String.valueOf(data.nRuleId));
            try {
                vector.add(new String(data.szName, "GBK").trim());
            }
            catch (UnsupportedEncodingException e) {
                vector.add(new String(data.szName).trim());
            }
            vector.add(String.valueOf(data.nChannel));
            if (data.stTemperInfo.nMeterType == 1) {
                vector.add("(" + data.stCoordinates[0].nx + "," + data.stCoordinates[0].ny + ")");
            } else if (data.stTemperInfo.nMeterType == 2) {
                vector.add("(" + data.stCoordinates[0].nx + "," + data.stCoordinates[0].ny + "),(" + data.stCoordinates[1].nx + "," + data.stCoordinates[1].ny + ")");
            } else {
                switch (data.nCoordinateNum) {
                    case 3: {
                        vector.add("(" + data.stCoordinates[0].nx + "," + data.stCoordinates[0].ny + "),(" + data.stCoordinates[1].nx + "," + data.stCoordinates[1].ny + "),(" + data.stCoordinates[2].nx + "," + data.stCoordinates[2].ny + ")");
                        break;
                    }
                    case 4: {
                        vector.add("(" + data.stCoordinates[0].nx + "," + data.stCoordinates[0].ny + "),(" + data.stCoordinates[1].nx + "," + data.stCoordinates[1].ny + "),(" + data.stCoordinates[2].nx + "," + data.stCoordinates[2].ny + "),(" + data.stCoordinates[3].nx + "," + data.stCoordinates[3].ny + ")");
                        break;
                    }
                    case 5: {
                        vector.add("(" + data.stCoordinates[0].nx + "," + data.stCoordinates[0].ny + "),(" + data.stCoordinates[1].nx + "," + data.stCoordinates[1].ny + "),(" + data.stCoordinates[2].nx + "," + data.stCoordinates[2].ny + "),(" + data.stCoordinates[3].nx + "," + data.stCoordinates[3].ny + "),(" + data.stCoordinates[4].nx + "," + data.stCoordinates[4].ny + ")");
                        break;
                    }
                    case 6: {
                        vector.add("(" + data.stCoordinates[0].nx + "," + data.stCoordinates[0].ny + "),(" + data.stCoordinates[1].nx + "," + data.stCoordinates[1].ny + "),(" + data.stCoordinates[2].nx + "," + data.stCoordinates[2].ny + "),(" + data.stCoordinates[3].nx + "," + data.stCoordinates[3].ny + "),(" + data.stCoordinates[4].nx + "," + data.stCoordinates[4].ny + "),(" + data.stCoordinates[5].nx + "," + data.stCoordinates[5].ny + "),");
                        break;
                    }
                    case 7: {
                        vector.add("(" + data.stCoordinates[0].nx + "," + data.stCoordinates[0].ny + "),(" + data.stCoordinates[1].nx + "," + data.stCoordinates[1].ny + "),(" + data.stCoordinates[2].nx + "," + data.stCoordinates[2].ny + "),(" + data.stCoordinates[3].nx + "," + data.stCoordinates[3].ny + "),(" + data.stCoordinates[4].nx + "," + data.stCoordinates[4].ny + "),(" + data.stCoordinates[5].nx + "," + data.stCoordinates[5].ny + "),(" + data.stCoordinates[6].nx + "," + data.stCoordinates[6].ny + ")");
                        break;
                    }
                    case 8: {
                        vector.add("(" + data.stCoordinates[0].nx + "," + data.stCoordinates[0].ny + "),(" + data.stCoordinates[1].nx + "," + data.stCoordinates[1].ny + "),(" + data.stCoordinates[2].nx + "," + data.stCoordinates[2].ny + "),(" + data.stCoordinates[3].nx + "," + data.stCoordinates[3].ny + "),(" + data.stCoordinates[4].nx + "," + data.stCoordinates[4].ny + "),(" + data.stCoordinates[5].nx + "," + data.stCoordinates[5].ny + "),(" + data.stCoordinates[6].nx + "," + data.stCoordinates[6].ny + "),(" + data.stCoordinates[7].nx + "," + data.stCoordinates[7].ny + ")");
                    }
                }
            }
            if (data.stTemperInfo.nMeterType >= 1 && data.stTemperInfo.nMeterType <= this.arrMeterType.length) {
                vector.add(this.arrMeterType[data.stTemperInfo.nMeterType - 1]);
            } else {
                vector.add(Res.string().getShowInfo("UNKNOWN"));
            }
            if (data.stTemperInfo.nTemperUnit >= 1 && data.stTemperInfo.nTemperUnit <= this.arrTemperUnit.length) {
                vector.add(this.arrTemperUnit[data.stTemperInfo.nTemperUnit - 1]);
            } else {
                vector.add(Res.string().getShowInfo("UNKNOWN"));
            }
            vector.add(String.valueOf(data.stTemperInfo.fTemperAver));
            vector.add(String.valueOf(data.stTemperInfo.fTemperMax));
            vector.add(String.valueOf(data.stTemperInfo.fTemperMin));
            vector.add(String.valueOf(data.stTemperInfo.fTemperMid));
            vector.add(String.valueOf(data.stTemperInfo.fTemperStd));
            this.tableModel.addRow(vector);
        }

        public void clearData() {
            this.currentIndex = 0;
            this.tableModel.setRowCount(0);
            this.tableModel.setRowCount(20);
            this.table.updateUI();
            this.setButtonEnable(false);
        }
    }

    public class QueryPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private DateChooserJButton startTimeBtn;
        private DateChooserJButton endTimeBtn;
        private JComboBox meterTypeComboBox;
        private JComboBox periodComboBox;
        private JButton queryBtn;

        public QueryPanel() {
            BorderEx.set(this, Res.string().getShowInfo("QUERY_CONDITION"), 1);
            this.setLayout(new BorderLayout());
            JLabel startTimeLabel = new JLabel(Res.string().getShowInfo("START_TIME"), 2);
            this.startTimeBtn = new DateChooserJButton();
            JLabel endTimeLabel = new JLabel(Res.string().getShowInfo("END_TIME"), 2);
            this.endTimeBtn = new DateChooserJButton();
            JLabel meterTypeLabel = new JLabel(Res.string().getShowInfo("METER_TYPE"), 2);
            this.meterTypeComboBox = new JComboBox();
            this.meterTypeComboBox.setModel(new DefaultComboBoxModel<String>(Res.string().getMeterTypeList()));
            JLabel periodLabel = new JLabel(Res.string().getShowInfo("SAVE_PERIOD"), 2);
            this.periodComboBox = new JComboBox();
            this.periodComboBox.setModel(new DefaultComboBoxModel<String>(Res.string().getPeriodList()));
            this.queryBtn = new JButton(Res.string().getShowInfo("QUERY"));
            Dimension lableDimension = new Dimension(85, 20);
            Dimension btnDimension = new Dimension(125, 20);
            startTimeLabel.setPreferredSize(lableDimension);
            this.startTimeBtn.setPreferredSize(btnDimension);
            endTimeLabel.setPreferredSize(lableDimension);
            this.endTimeBtn.setPreferredSize(btnDimension);
            meterTypeLabel.setPreferredSize(lableDimension);
            this.meterTypeComboBox.setPreferredSize(btnDimension);
            periodLabel.setPreferredSize(lableDimension);
            this.periodComboBox.setPreferredSize(btnDimension);
            this.queryBtn.setPreferredSize(btnDimension);
            JPanel startTimePanel = new JPanel();
            startTimePanel.setLayout(new FlowLayout(0));
            startTimePanel.add(startTimeLabel);
            startTimePanel.add(this.startTimeBtn);
            JPanel endTimePanel = new JPanel();
            endTimePanel.setLayout(new FlowLayout(0));
            endTimePanel.add(endTimeLabel);
            endTimePanel.add(this.endTimeBtn);
            JPanel topPanel = new JPanel();
            topPanel.setLayout(new FlowLayout(0, 30, 2));
            topPanel.add(startTimePanel);
            topPanel.add(endTimePanel);
            JPanel meterTypePanel = new JPanel();
            meterTypePanel.setLayout(new FlowLayout(0));
            meterTypePanel.add(meterTypeLabel);
            meterTypePanel.add(this.meterTypeComboBox);
            JPanel periodPanel = new JPanel();
            periodPanel.setLayout(new FlowLayout(0));
            periodPanel.add(periodLabel);
            periodPanel.add(this.periodComboBox);
            JPanel bottomPanel = new JPanel();
            bottomPanel.setLayout(new FlowLayout(0, 30, 2));
            bottomPanel.add(meterTypePanel);
            bottomPanel.add(periodPanel);
            JPanel leftPanel = new JPanel(new GridLayout(2, 1));
            BorderEx.set(leftPanel, "", 1);
            leftPanel.add(topPanel);
            leftPanel.add(bottomPanel);
            JPanel rightPanel = new JPanel();
            rightPanel.setLayout(null);
            BorderEx.set(rightPanel, "", 1);
            this.queryBtn.setBounds(50, 30, 125, 20);
            rightPanel.add(this.queryBtn);
            JSplitPane pane = new JSplitPane(1, leftPanel, rightPanel);
            pane.setDividerSize(0);
            pane.setBorder(null);
            this.add((Component)pane, "Center");
            this.queryBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryPanel.this.setStuStartFind();
                    TemperQueryDialog.this.queryHistoryInfo(QUERY_TYPE.FIRST_PAGE_QUERY);
                }
            });
        }

        private void setStuStartFind() {
            this.setTime(((TemperQueryDialog)TemperQueryDialog.this).stuStartFind.stStartTime, this.startTimeBtn.getText());
            this.setTime(((TemperQueryDialog)TemperQueryDialog.this).stuStartFind.stEndTime, this.endTimeBtn.getText());
            ((TemperQueryDialog)TemperQueryDialog.this).stuStartFind.nMeterType = this.meterTypeComboBox.getSelectedIndex() + 1;
            ((TemperQueryDialog)TemperQueryDialog.this).stuStartFind.nChannel = ThermalCameraFrame.THERMAL_CHANNEL;
            int[] arrPeriod = new int[]{5, 10, 15, 30};
            ((TemperQueryDialog)TemperQueryDialog.this).stuStartFind.emPeriod = arrPeriod[this.periodComboBox.getSelectedIndex()];
        }

        private void setTime(NetSDKLib.NET_TIME netTime, String date) {
            String[] dateTime = date.split(" ");
            String[] arrDate = dateTime[0].split("-");
            String[] arrTime = dateTime[1].split(":");
            netTime.dwYear = Integer.parseInt(arrDate[0]);
            netTime.dwMonth = Integer.parseInt(arrDate[1]);
            netTime.dwDay = Integer.parseInt(arrDate[2]);
            netTime.dwHour = Integer.parseInt(arrTime[0]);
            netTime.dwMinute = Integer.parseInt(arrTime[1]);
            netTime.dwSecond = Integer.parseInt(arrTime[2]);
        }

        public void setButtonEnable(boolean b) {
            this.queryBtn.setEnabled(b);
        }
    }
}

