/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.ThermalCamera;

import com.netsdk.common.BorderEx;
import com.netsdk.common.FunctionList;
import com.netsdk.common.LoginPanel;
import com.netsdk.common.Res;
import com.netsdk.demo.frame.ThermalCamera.HeatMapDialog;
import com.netsdk.demo.frame.ThermalCamera.ItemQueryDialog;
import com.netsdk.demo.frame.ThermalCamera.PointQueryDialog;
import com.netsdk.demo.frame.ThermalCamera.TemperQueryDialog;
import com.netsdk.demo.module.LoginModule;
import com.netsdk.demo.module.RealPlayModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.Pointer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

class ThermalCameraFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    public static int THERMAL_CHANNEL = 1;
    private Vector<String> chnlist = new Vector();
    private boolean isrealplayOne = false;
    private boolean isrealplayTwo = false;
    private static DisConnect disConnect = new DisConnect();
    private static HaveReConnect haveReConnect = new HaveReConnect();
    public static NetSDKLib.LLong m_hPlayHandleOne = new NetSDKLib.LLong(0L);
    public static NetSDKLib.LLong m_hPlayHandleTwo = new NetSDKLib.LLong(0L);
    private static JFrame frame = new JFrame();
    private LoginPanel loginPanel;
    private ThermalOperatePanel operatePanel;
    private RealPanelOne realPanelOne;
    private RealPanelTwo realPanelTwo;

    public ThermalCameraFrame() {
        this.setTitle(Res.string().getThermalCamera());
        this.setLayout(new BorderLayout());
        this.pack();
        this.setSize(800, 560);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        LoginModule.init(disConnect, haveReConnect);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loginPanel = new LoginPanel();
        this.operatePanel = new ThermalOperatePanel();
        this.realPanelOne = new RealPanelOne();
        this.realPanelTwo = new RealPanelTwo();
        JSplitPane splitPane = new JSplitPane(0, this.loginPanel, this.operatePanel);
        splitPane.setDividerSize(0);
        splitPane.setBorder(null);
        JPanel realPanel = new JPanel();
        realPanel.setLayout(new GridLayout(1, 2));
        realPanel.add(this.realPanelOne);
        realPanel.add(this.realPanelTwo);
        this.add((Component)splitPane, "North");
        this.add((Component)realPanel, "Center");
        this.loginPanel.addLoginBtnActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ThermalCameraFrame.this.loginPanel.checkLoginText() && ThermalCameraFrame.this.login()) {
                    frame = ToolKits.getFrame(e);
                    frame.setTitle(Res.string().getShowInfo("THERMAL_CAMERA") + " : " + Res.string().getOnline());
                }
            }
        });
        this.loginPanel.addLogoutBtnActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setTitle(Res.string().getShowInfo("THERMAL_CAMERA"));
                ThermalCameraFrame.this.logout();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RealPlayModule.stopRealPlay(m_hPlayHandleOne);
                RealPlayModule.stopRealPlay(m_hPlayHandleTwo);
                LoginModule.logout();
                LoginModule.cleanup();
                ThermalCameraFrame.this.dispose();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FunctionList demo = new FunctionList();
                        demo.setVisible(true);
                    }
                });
            }
        });
    }

    public boolean login() {
        if (LoginModule.login(this.loginPanel.ipTextArea.getText(), Integer.parseInt(this.loginPanel.portTextArea.getText()), this.loginPanel.nameTextArea.getText(), new String(this.loginPanel.passwordTextArea.getPassword()))) {
            for (int i = 1; i < LoginModule.m_stDeviceInfo.byChanNum + 1; ++i) {
                this.chnlist.add(Res.string().getChannel() + " " + String.valueOf(i));
            }
        } else {
            JOptionPane.showMessageDialog(null, Res.string().getLoginFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return false;
        }
        this.setEnable(true);
        return true;
    }

    public void logout() {
        RealPlayModule.stopRealPlay(m_hPlayHandleOne);
        RealPlayModule.stopRealPlay(m_hPlayHandleTwo);
        LoginModule.logout();
        this.setEnable(false);
        this.chnlist.clear();
    }

    public void setEnable(boolean b) {
        this.loginPanel.setButtonEnable(b);
        this.realPanelOne.setRealPlayEnable(b);
        this.realPanelTwo.setRealPlayEnable(b);
        this.operatePanel.setOperateEnabled(b);
        this.isrealplayOne = false;
        this.isrealplayTwo = false;
    }

    private class RealPanelTwo
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JPanel realplayPanelTwo;
        private Panel realPlayWindowTwo;
        private Panel channelPanelTwo;
        private JLabel chnlabelTwo;
        private JComboBox chnComboBoxTwo;
        private JLabel streamLabelTwo;
        private JComboBox streamComboBoxTwo;
        private JButton realplayBtnTwo;

        public RealPanelTwo() {
            BorderEx.set(this, Res.string().getRealplay(), 2);
            this.setLayout(new BorderLayout());
            this.channelPanelTwo = new Panel();
            this.realplayPanelTwo = new JPanel();
            this.add((Component)this.channelPanelTwo, "North");
            this.add((Component)this.realplayPanelTwo, "Center");
            this.realplayPanelTwo.setLayout(new BorderLayout());
            this.realplayPanelTwo.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.realPlayWindowTwo = new Panel();
            this.realPlayWindowTwo.setBackground(Color.GRAY);
            this.realplayPanelTwo.add((Component)this.realPlayWindowTwo, "Center");
            this.chnlabelTwo = new JLabel(Res.string().getChn());
            this.chnComboBoxTwo = new JComboBox();
            this.streamLabelTwo = new JLabel(Res.string().getStreamType());
            String[] stream = new String[]{Res.string().getMasterStream(), Res.string().getSubStream()};
            this.streamComboBoxTwo = new JComboBox<String>(stream);
            this.realplayBtnTwo = new JButton(Res.string().getStartRealPlay());
            this.channelPanelTwo.setLayout(new FlowLayout());
            this.channelPanelTwo.add(this.chnlabelTwo);
            this.channelPanelTwo.add(this.chnComboBoxTwo);
            this.channelPanelTwo.add(this.streamLabelTwo);
            this.channelPanelTwo.add(this.streamComboBoxTwo);
            this.channelPanelTwo.add(this.realplayBtnTwo);
            this.chnComboBoxTwo.setPreferredSize(new Dimension(80, 20));
            this.streamComboBoxTwo.setPreferredSize(new Dimension(95, 20));
            this.realplayBtnTwo.setPreferredSize(new Dimension(115, 20));
            this.realPlayWindowTwo.setEnabled(false);
            this.chnComboBoxTwo.setEnabled(false);
            this.streamComboBoxTwo.setEnabled(false);
            this.realplayBtnTwo.setEnabled(false);
            this.realplayBtnTwo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RealPanelTwo.this.realPlay();
                }
            });
        }

        public void setRealPlayEnable(boolean bln) {
            this.realPlayWindowTwo.setEnabled(bln);
            this.chnComboBoxTwo.setEnabled(bln);
            this.streamComboBoxTwo.setEnabled(bln);
            this.realplayBtnTwo.setEnabled(bln);
            if (bln) {
                this.chnComboBoxTwo.setModel(new DefaultComboBoxModel(ThermalCameraFrame.this.chnlist));
                if (ThermalCameraFrame.this.chnlist.size() > THERMAL_CHANNEL) {
                    this.chnComboBoxTwo.setSelectedIndex(THERMAL_CHANNEL);
                }
            } else {
                this.realPlayWindowTwo.repaint();
                this.realplayBtnTwo.setText(Res.string().getStartRealPlay());
                this.chnComboBoxTwo.setModel(new DefaultComboBoxModel());
            }
        }

        private void realPlay() {
            if (!ThermalCameraFrame.this.isrealplayTwo) {
                m_hPlayHandleTwo = RealPlayModule.startRealPlay(this.chnComboBoxTwo.getSelectedIndex(), this.streamComboBoxTwo.getSelectedIndex() == 0 ? 0 : 3, this.realPlayWindowTwo);
                if (m_hPlayHandleTwo.longValue() != 0L) {
                    this.changePlayStatus(true);
                } else {
                    JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                }
            } else {
                RealPlayModule.stopRealPlay(m_hPlayHandleTwo);
                this.changePlayStatus(false);
            }
        }

        private void changePlayStatus(boolean b) {
            this.realPlayWindowTwo.repaint();
            ThermalCameraFrame.this.isrealplayTwo = b;
            this.chnComboBoxTwo.setEnabled(!b);
            this.streamComboBoxTwo.setEnabled(!b);
            if (b) {
                this.realplayBtnTwo.setText(Res.string().getStopRealPlay());
            } else {
                m_hPlayHandleTwo.setValue(0L);
                this.realplayBtnTwo.setText(Res.string().getStartRealPlay());
            }
        }
    }

    private class RealPanelOne
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JPanel realplayPanelOne;
        private Panel realPlayWindowOne;
        private Panel channelPanelOne;
        private JLabel chnlabelOne;
        private JComboBox chnComboBoxOne;
        private JLabel streamLabelOne;
        private JComboBox streamComboBoxOne;
        private JButton realplayBtnOne;

        public RealPanelOne() {
            BorderEx.set(this, Res.string().getRealplay(), 2);
            this.setLayout(new BorderLayout());
            this.channelPanelOne = new Panel();
            this.realplayPanelOne = new JPanel();
            this.add((Component)this.channelPanelOne, "North");
            this.add((Component)this.realplayPanelOne, "Center");
            this.realplayPanelOne.setLayout(new BorderLayout());
            this.realplayPanelOne.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.realPlayWindowOne = new Panel();
            this.realPlayWindowOne.setBackground(Color.GRAY);
            this.realplayPanelOne.add((Component)this.realPlayWindowOne, "Center");
            this.chnlabelOne = new JLabel(Res.string().getChn());
            this.chnComboBoxOne = new JComboBox();
            this.streamLabelOne = new JLabel(Res.string().getStreamType());
            String[] stream = new String[]{Res.string().getMasterStream(), Res.string().getSubStream()};
            this.streamComboBoxOne = new JComboBox<String>(stream);
            this.realplayBtnOne = new JButton(Res.string().getStartRealPlay());
            this.channelPanelOne.setLayout(new FlowLayout());
            this.channelPanelOne.add(this.chnlabelOne);
            this.channelPanelOne.add(this.chnComboBoxOne);
            this.channelPanelOne.add(this.streamLabelOne);
            this.channelPanelOne.add(this.streamComboBoxOne);
            this.channelPanelOne.add(this.realplayBtnOne);
            this.chnComboBoxOne.setPreferredSize(new Dimension(80, 20));
            this.streamComboBoxOne.setPreferredSize(new Dimension(95, 20));
            this.realplayBtnOne.setPreferredSize(new Dimension(115, 20));
            this.realPlayWindowOne.setEnabled(false);
            this.chnComboBoxOne.setEnabled(false);
            this.streamComboBoxOne.setEnabled(false);
            this.realplayBtnOne.setEnabled(false);
            this.realplayBtnOne.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RealPanelOne.this.realPlay();
                }
            });
        }

        public void setRealPlayEnable(boolean bln) {
            this.realPlayWindowOne.setEnabled(bln);
            this.chnComboBoxOne.setEnabled(bln);
            this.streamComboBoxOne.setEnabled(bln);
            this.realplayBtnOne.setEnabled(bln);
            if (bln) {
                this.chnComboBoxOne.setModel(new DefaultComboBoxModel(ThermalCameraFrame.this.chnlist));
            } else {
                this.realPlayWindowOne.repaint();
                this.realplayBtnOne.setText(Res.string().getStartRealPlay());
                this.chnComboBoxOne.setModel(new DefaultComboBoxModel());
            }
        }

        private void realPlay() {
            if (!ThermalCameraFrame.this.isrealplayOne) {
                m_hPlayHandleOne = RealPlayModule.startRealPlay(this.chnComboBoxOne.getSelectedIndex(), this.streamComboBoxOne.getSelectedIndex() == 0 ? 0 : 3, this.realPlayWindowOne);
                if (m_hPlayHandleOne.longValue() != 0L) {
                    this.changePlayStatus(true);
                } else {
                    JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                }
            } else {
                RealPlayModule.stopRealPlay(m_hPlayHandleOne);
                this.changePlayStatus(false);
            }
        }

        private void changePlayStatus(boolean b) {
            this.realPlayWindowOne.repaint();
            ThermalCameraFrame.this.isrealplayOne = b;
            this.chnComboBoxOne.setEnabled(!b);
            this.streamComboBoxOne.setEnabled(!b);
            if (b) {
                this.realplayBtnOne.setText(Res.string().getStopRealPlay());
            } else {
                m_hPlayHandleOne.setValue(0L);
                this.realplayBtnOne.setText(Res.string().getStartRealPlay());
            }
        }
    }

    private class ThermalOperateActionListener
    implements ActionListener {
        private ThermalOperateActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            THERMAL_CHANNEL = ThermalCameraFrame.this.operatePanel.chnComboBox.getSelectedIndex();
            ThermalOperate emType = this.getOperateType(arg0.getSource());
            switch (emType) {
                case POINT_QUERY: {
                    new PointQueryDialog().setVisible(true);
                    break;
                }
                case ITEM_QUERY: {
                    new ItemQueryDialog().setVisible(true);
                    break;
                }
                case TEMPER_QUERY: {
                    new TemperQueryDialog().setVisible(true);
                    break;
                }
                case HEATMAP: {
                    new HeatMapDialog().setVisible(true);
                    break;
                }
            }
        }

        private ThermalOperate getOperateType(Object btn) {
            ThermalOperate type = ThermalOperate.UNKNOWN;
            if (btn == ThermalCameraFrame.this.operatePanel.pointQueryBtn) {
                type = ThermalOperate.POINT_QUERY;
            } else if (btn == ThermalCameraFrame.this.operatePanel.itemQueryBtn) {
                type = ThermalOperate.ITEM_QUERY;
            } else if (btn == ThermalCameraFrame.this.operatePanel.historyQueryBtn) {
                type = ThermalOperate.TEMPER_QUERY;
            } else if (btn == ThermalCameraFrame.this.operatePanel.heatMapBtn) {
                type = ThermalOperate.HEATMAP;
            } else {
                System.err.println("Unknown Event: " + btn);
            }
            return type;
        }
    }

    private static enum ThermalOperate {
        UNKNOWN,
        POINT_QUERY,
        ITEM_QUERY,
        TEMPER_QUERY,
        HEATMAP;

    }

    private class ThermalOperatePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JComboBox chnComboBox;
        private ThermalOperateActionListener listener;
        private JButton pointQueryBtn;
        private JButton itemQueryBtn;
        private JButton historyQueryBtn;
        private JButton heatMapBtn;

        public ThermalOperatePanel() {
            BorderEx.set(this, Res.string().getShowInfo("THERMAL_OPERATE"), 2);
            this.setLayout(new FlowLayout(1, 15, 5));
            JLabel chnlabel = new JLabel(Res.string().getChn());
            this.chnComboBox = new JComboBox();
            this.pointQueryBtn = new JButton(Res.string().getShowInfo("POINT_QUERY"));
            this.itemQueryBtn = new JButton(Res.string().getShowInfo("ITEM_QUERY"));
            this.historyQueryBtn = new JButton(Res.string().getShowInfo("TEMPER_QUERY"));
            this.heatMapBtn = new JButton(Res.string().getShowInfo("HEATMAP"));
            Dimension btnDimension = new Dimension(140, 20);
            this.pointQueryBtn.setPreferredSize(btnDimension);
            this.itemQueryBtn.setPreferredSize(btnDimension);
            this.historyQueryBtn.setPreferredSize(btnDimension);
            this.heatMapBtn.setPreferredSize(btnDimension);
            this.chnComboBox.setPreferredSize(new Dimension(80, 20));
            JPanel chnPanel = new JPanel();
            chnPanel.add(chnlabel);
            chnPanel.add(this.chnComboBox);
            this.add(chnPanel);
            this.add(this.pointQueryBtn);
            this.add(this.pointQueryBtn);
            this.add(this.itemQueryBtn);
            this.add(this.historyQueryBtn);
            this.add(this.heatMapBtn);
            this.setOperateEnabled(false);
            this.listener = new ThermalOperateActionListener();
            this.pointQueryBtn.addActionListener(this.listener);
            this.itemQueryBtn.addActionListener(this.listener);
            this.historyQueryBtn.addActionListener(this.listener);
            this.heatMapBtn.addActionListener(this.listener);
        }

        public void setOperateEnabled(boolean b) {
            this.pointQueryBtn.setEnabled(b);
            this.itemQueryBtn.setEnabled(b);
            this.historyQueryBtn.setEnabled(b);
            this.heatMapBtn.setEnabled(b);
            this.chnComboBox.setEnabled(b);
            if (b) {
                this.chnComboBox.setModel(new DefaultComboBoxModel(ThermalCameraFrame.this.chnlist));
                if (ThermalCameraFrame.this.chnlist.size() > THERMAL_CHANNEL) {
                    this.chnComboBox.setSelectedIndex(THERMAL_CHANNEL);
                }
            } else {
                this.chnComboBox.setModel(new DefaultComboBoxModel());
            }
        }
    }

    private static class HaveReConnect
    implements NetSDKLib.fHaveReConnect {
        private HaveReConnect() {
        }

        @Override
        public void invoke(NetSDKLib.LLong m_hLoginHandle, String pchDVRIP, int nDVRPort, Pointer dwUser) {
            System.out.printf("ReConnect Device[%s] Port[%d]\n", pchDVRIP, nDVRPort);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.setTitle(Res.string().getShowInfo("THERMAL_CAMERA") + " : " + Res.string().getOnline());
                }
            });
        }
    }

    private static class DisConnect
    implements NetSDKLib.fDisConnect {
        private DisConnect() {
        }

        @Override
        public void invoke(NetSDKLib.LLong m_hLoginHandle, String pchDVRIP, int nDVRPort, Pointer dwUser) {
            System.out.printf("Device[%s] Port[%d] DisConnect!\n", pchDVRIP, nDVRPort);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.setTitle(Res.string().getShowInfo("THERMAL_CAMERA") + " : " + Res.string().getDisConnectReconnecting());
                }
            });
        }
    }
}

