/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame;

import com.netsdk.common.BorderEx;
import com.netsdk.common.FunctionList;
import com.netsdk.common.ListPictureShowDialog;
import com.netsdk.common.LoginPanel;
import com.netsdk.common.PaintPanel;
import com.netsdk.common.Res;
import com.netsdk.common.SavePath;
import com.netsdk.demo.module.LoginModule;
import com.netsdk.demo.module.RealPlayModule;
import com.netsdk.demo.module.TrafficEventModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

class TrafficEventFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Vector<String> chnlist = new Vector();
    private DefaultTableModel model;
    private AnalyzerDataCB m_AnalyzerDataCB = new AnalyzerDataCB();
    private static DisConnect disConnect = new DisConnect();
    private static HaveReConnect haveReConnect = new HaveReConnect();
    public static NetSDKLib.LLong m_hPlayHandle = new NetSDKLib.LLong(0L);
    boolean b_openStrobe = false;
    boolean b_realplay = false;
    boolean b_attach = false;
    private int i = 1;
    private TRAFFIC_INFO trafficInfo = new TRAFFIC_INFO();
    private BufferedImage snapImage = null;
    private BufferedImage plateImage = null;
    private Component target = this;
    private static JFrame frame = new JFrame();
    private LoginPanel loginPanel;
    private ItsPanel itsPanel;
    private OperatePanel operatePanel;
    private JButton realplayBtn;
    private JButton attachBtn;
    private MessagePanel messagePanel;
    private DefaultTableModel defaultModel;
    private JTable table;
    private RealPlayPanel realPlayPanel;
    Panel realPlayWindow;
    private JLabel chnlabel;
    JComboBox chnComboBox;
    JComboBox streamComboBox;
    private EventInfoPanel eventInfoPanel;
    private PaintPanel SnapImagePanel;
    private PaintPanel plateImagePanel;
    private JLabel plateImageLabel;
    private JLabel eventnameLabel;
    private JTextField eventnameTextField;
    private JLabel eventTimeLabel;
    private JTextField eventTimeTextField;
    private JLabel licensePlateLabel;
    private JTextField licensePlateTextField;
    private JButton manualSnapBtn;
    private JButton openStrobeButton;

    public TrafficEventFrame() {
        this.setTitle(Res.string().getITSEvent());
        this.setLayout(new BorderLayout());
        this.pack();
        this.setSize(800, 565);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        LoginModule.init(disConnect, haveReConnect);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loginPanel = new LoginPanel();
        this.itsPanel = new ItsPanel();
        this.add((Component)this.loginPanel, "North");
        this.add((Component)this.itsPanel, "Center");
        this.loginPanel.addLoginBtnActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TrafficEventFrame.this.loginPanel.checkLoginText() && TrafficEventFrame.this.login()) {
                    frame = ToolKits.getFrame(e);
                    frame.setTitle(Res.string().getITSEvent() + " : " + Res.string().getOnline());
                }
            }
        });
        this.loginPanel.addLogoutBtnActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setTitle(Res.string().getITSEvent());
                TrafficEventFrame.this.logout();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RealPlayModule.stopRealPlay(m_hPlayHandle);
                TrafficEventModule.detachIVSEvent();
                LoginModule.logout();
                LoginModule.cleanup();
                TrafficEventFrame.this.dispose();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FunctionList demo = new FunctionList();
                        demo.setVisible(true);
                    }
                });
            }
        });
    }

    public boolean login() {
        Native.setCallbackThreadInitializer(this.m_AnalyzerDataCB, new CallbackThreadInitializer(false, false, "traffic callback thread"));
        if (LoginModule.login(this.loginPanel.ipTextArea.getText(), Integer.parseInt(this.loginPanel.portTextArea.getText()), this.loginPanel.nameTextArea.getText(), new String(this.loginPanel.passwordTextArea.getPassword()))) {
            this.loginPanel.setButtonEnable(true);
            this.setButtonEnable(true);
            for (int i = 1; i < LoginModule.m_stDeviceInfo.byChanNum + 1; ++i) {
                this.chnlist.add(Res.string().getChannel() + " " + String.valueOf(i));
            }
        } else {
            JOptionPane.showMessageDialog(null, Res.string().getLoginFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return false;
        }
        this.chnComboBox.setModel(new DefaultComboBoxModel<String>(this.chnlist));
        return true;
    }

    public void logout() {
        RealPlayModule.stopRealPlay(m_hPlayHandle);
        TrafficEventModule.detachIVSEvent();
        LoginModule.logout();
        this.loginPanel.setButtonEnable(false);
        this.setButtonEnable(false);
        this.realPlayWindow.repaint();
        this.eventnameTextField.setText("");
        this.licensePlateTextField.setText("");
        this.eventTimeTextField.setText("");
        this.b_realplay = false;
        this.realplayBtn.setText(Res.string().getStartRealPlay());
        this.b_attach = false;
        this.attachBtn.setText(Res.string().getAttach());
        this.b_openStrobe = false;
        this.openStrobeButton.setText(Res.string().getOpenStrobe());
        this.i = 1;
        for (int i = 0; i < LoginModule.m_stDeviceInfo.byChanNum; ++i) {
            this.chnlist.clear();
        }
        this.chnComboBox.setModel(new DefaultComboBoxModel());
        this.defaultModel.setRowCount(0);
        this.defaultModel.setRowCount(8);
        this.table.updateUI();
        this.SnapImagePanel.setOpaque(true);
        this.SnapImagePanel.repaint();
        this.plateImagePanel.setOpaque(true);
        this.plateImagePanel.repaint();
    }

    public void realplay() {
        if (!this.b_realplay) {
            m_hPlayHandle = RealPlayModule.startRealPlay(this.chnComboBox.getSelectedIndex(), 0, this.realPlayWindow);
            if (m_hPlayHandle.longValue() != 0L) {
                this.realPlayWindow.repaint();
                this.b_realplay = true;
                this.chnComboBox.setEnabled(false);
                this.realplayBtn.setText(Res.string().getStopRealPlay());
            }
        } else {
            RealPlayModule.stopRealPlay(m_hPlayHandle);
            this.realPlayWindow.repaint();
            this.b_realplay = false;
            this.chnComboBox.setEnabled(true);
            this.realplayBtn.setText(Res.string().getStartRealPlay());
        }
    }

    public void attach() {
        if (!this.b_attach) {
            if (TrafficEventModule.attachIVSEvent(this.chnComboBox.getSelectedIndex(), this.m_AnalyzerDataCB)) {
                this.b_attach = true;
                this.attachBtn.setText(Res.string().getDetach());
            }
        } else {
            TrafficEventModule.detachIVSEvent();
            this.b_attach = false;
            this.attachBtn.setText(Res.string().getAttach());
        }
    }

    public void openstrobe() {
        if (!this.b_openStrobe) {
            if (TrafficEventModule.New_OpenStrobe()) {
                this.b_openStrobe = true;
                this.openStrobeButton.setText(Res.string().getCloseStrobe());
            } else {
                JOptionPane.showMessageDialog(null, Res.string().getOpenStrobeFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            }
        } else {
            TrafficEventModule.New_CloseStrobe();
            this.b_openStrobe = false;
            this.openStrobeButton.setText(Res.string().getOpenStrobe());
        }
    }

    @Override
    protected void processEvent(AWTEvent event) {
        if (event instanceof TrafficEvent) {
            TrafficEvent ev = (TrafficEvent)event;
            TRAFFIC_INFO trafficInfo = ev.getTrafficInfo();
            BufferedImage snapImage = ev.getSnapBufferedImage();
            BufferedImage plateImage = ev.getPlaBufferedImage();
            this.showTrafficEventInfo(trafficInfo);
            this.showPicture(snapImage, plateImage);
        } else {
            super.processEvent(event);
        }
    }

    private void showTrafficEventInfo(TRAFFIC_INFO trafficInfo) {
        if (trafficInfo.m_EventName.equals("")) {
            this.eventnameTextField.setText("");
        } else {
            this.eventnameTextField.setText(trafficInfo.m_EventName);
        }
        if (trafficInfo.m_PlateNumber.equals("")) {
            this.licensePlateTextField.setText(Res.string().getNoPlate());
            this.plateImagePanel.setOpaque(true);
            this.plateImagePanel.repaint();
        } else {
            this.licensePlateTextField.setText(trafficInfo.m_PlateNumber);
        }
        if (trafficInfo.m_Utc == null || trafficInfo.m_Utc.toStringTime().equals("")) {
            this.eventTimeTextField.setText("");
        } else {
            this.eventTimeTextField.setText(trafficInfo.m_Utc.toStringTime());
        }
        Vector<String> vector = new Vector<String>();
        vector.add(String.valueOf(this.i));
        vector.add(trafficInfo.m_EventName);
        vector.add(trafficInfo.m_PlateNumber);
        if (trafficInfo.m_Utc == null || trafficInfo.m_Utc.toStringTime().equals("")) {
            vector.add("");
        } else {
            vector.add(trafficInfo.m_Utc.toStringTime());
        }
        vector.add(trafficInfo.m_PlateType);
        vector.add(trafficInfo.m_PlateColor);
        vector.add(trafficInfo.m_VehicleColor);
        vector.add(trafficInfo.m_VehicleType);
        vector.add(trafficInfo.m_VehicleSize);
        vector.add(trafficInfo.m_FileCount);
        vector.add(trafficInfo.m_FileIndex);
        vector.add(trafficInfo.m_GroupID);
        vector.add(trafficInfo.m_IllegalPlace);
        vector.add(trafficInfo.m_LaneNumber);
        this.defaultModel.insertRow(0, vector);
        this.defaultModel.setRowCount(8);
        this.table.updateUI();
        ++this.i;
    }

    private void showPicture(BufferedImage snapImage, BufferedImage plateImage) {
        if (snapImage == null) {
            this.SnapImagePanel.setOpaque(true);
            this.SnapImagePanel.repaint();
            this.plateImagePanel.setOpaque(true);
            this.plateImagePanel.repaint();
            return;
        }
        this.SnapImagePanel.setOpaque(false);
        this.SnapImagePanel.setImage(snapImage);
        this.SnapImagePanel.repaint();
        if (plateImage == null) {
            this.plateImagePanel.setOpaque(true);
            this.plateImagePanel.repaint();
            return;
        }
        this.plateImagePanel.setOpaque(false);
        this.plateImagePanel.setImage(plateImage);
        this.plateImagePanel.repaint();
    }

    private void savePlatePic(Pointer pBuffer, int dwBufferSize, TRAFFIC_INFO trafficInfo) {
        if (pBuffer == null || dwBufferSize <= 0) {
            return;
        }
        byte[] buffer = pBuffer.getByteArray(0L, dwBufferSize);
        ByteArrayInputStream byteArrInput = new ByteArrayInputStream(buffer);
        String bigPicture = SavePath.getSavePath().getSaveTrafficImagePath() + "Big_" + trafficInfo.m_Utc.toStringTitle() + "_" + trafficInfo.m_FileCount + "-" + trafficInfo.m_FileIndex + "-" + trafficInfo.m_GroupID + ".jpg";
        try {
            this.snapImage = ImageIO.read(byteArrInput);
            if (this.snapImage == null) {
                return;
            }
            ImageIO.write((RenderedImage)this.snapImage, "jpg", new File(bigPicture));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        if (bigPicture == null || bigPicture.equals("")) {
            return;
        }
        if (trafficInfo.m_bPicEnble == 1) {
            if (trafficInfo.m_FileLength > 0) {
                String platePicture = SavePath.getSavePath().getSaveTrafficImagePath() + "plate_" + trafficInfo.m_Utc.toStringTitle() + "_" + trafficInfo.m_FileCount + "-" + trafficInfo.m_FileIndex + "-" + trafficInfo.m_GroupID + ".jpg";
                int size = 0;
                if (dwBufferSize <= trafficInfo.m_OffSet) {
                    return;
                }
                size = trafficInfo.m_FileLength <= dwBufferSize - trafficInfo.m_OffSet ? trafficInfo.m_FileLength : dwBufferSize - trafficInfo.m_OffSet;
                byte[] bufPlate = pBuffer.getByteArray(trafficInfo.m_OffSet, size);
                ByteArrayInputStream byteArrInputPlate = new ByteArrayInputStream(bufPlate);
                try {
                    this.plateImage = ImageIO.read(byteArrInputPlate);
                    if (this.plateImage == null) {
                        return;
                    }
                    ImageIO.write((RenderedImage)this.plateImage, "jpg", new File(platePicture));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            if (trafficInfo.m_BoundingBox == null) {
                return;
            }
            NetSDKLib.DH_RECT dhRect = trafficInfo.m_BoundingBox;
            boolean OSD_HEIGHT = false;
            long nWidth = this.snapImage.getWidth(null);
            long nHeight = this.snapImage.getHeight(null);
            if (nWidth <= 0L || (nHeight -= 0L) <= 0L) {
                return;
            }
            NetSDKLib.DH_RECT dstRect = new NetSDKLib.DH_RECT();
            dstRect.left.setValue((long)((double)(nWidth * dhRect.left.longValue()) / 8192.0));
            dstRect.right.setValue((long)((double)(nWidth * dhRect.right.longValue()) / 8192.0));
            dstRect.bottom.setValue((long)((double)(nHeight * dhRect.bottom.longValue()) / 8192.0));
            dstRect.top.setValue((long)((double)(nHeight * dhRect.top.longValue()) / 8192.0));
            int x = dstRect.left.intValue();
            int y = dstRect.top.intValue() + 0;
            int w = dstRect.right.intValue() - dstRect.left.intValue();
            int h = dstRect.bottom.intValue() - dstRect.top.intValue();
            if (x == 0 || y == 0 || w <= 0 || h <= 0) {
                return;
            }
            try {
                this.plateImage = this.snapImage.getSubimage(x, y, w, h);
                String platePicture = SavePath.getSavePath().getSaveTrafficImagePath() + "plate_" + trafficInfo.m_Utc.toStringTitle() + "_" + trafficInfo.m_FileCount + "-" + trafficInfo.m_FileIndex + "-" + trafficInfo.m_GroupID + ".jpg";
                if (this.plateImage == null) {
                    return;
                }
                ImageIO.write((RenderedImage)this.plateImage, "jpg", new File(platePicture));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void setButtonEnable(boolean bln) {
        this.chnComboBox.setEnabled(bln);
        this.realplayBtn.setEnabled(bln);
        this.attachBtn.setEnabled(bln);
        this.manualSnapBtn.setEnabled(bln);
        this.openStrobeButton.setEnabled(bln);
    }

    private class AnalyzerDataCB
    implements NetSDKLib.fAnalyzerDataCallBack {
        private AnalyzerDataCB() {
        }

        @Override
        public int invoke(NetSDKLib.LLong lAnalyzerHandle, int dwAlarmType, Pointer pAlarmInfo, Pointer pBuffer, int dwBufSize, Pointer dwUser, int nSequence, Pointer reserved) {
            if (lAnalyzerHandle.longValue() == 0L) {
                return -1;
            }
            if (dwAlarmType == 23 || dwAlarmType == 256 || dwAlarmType == 257 || dwAlarmType == 258 || dwAlarmType == 259 || dwAlarmType == 260 || dwAlarmType == 261 || dwAlarmType == 262 || dwAlarmType == 263 || dwAlarmType == 264 || dwAlarmType == 265 || dwAlarmType == 266 || dwAlarmType == 267 || dwAlarmType == 270 || dwAlarmType == 271 || dwAlarmType == 280 || dwAlarmType == 283 || dwAlarmType == 292 || dwAlarmType == 293 || dwAlarmType == 299 || dwAlarmType == 300 || dwAlarmType == 312) {
                EventQueue eventQueue;
                this.GetStuObject(dwAlarmType, pAlarmInfo);
                boolean flag = true;
                if (dwAlarmType == 280) {
                    NetSDKLib.DEV_EVENT_TRAFFIC_MANUALSNAP_INFO msg = new NetSDKLib.DEV_EVENT_TRAFFIC_MANUALSNAP_INFO();
                    ToolKits.GetPointerData(pAlarmInfo, msg);
                    byte bPicEnble = msg.stuObject.bPicEnble;
                    if (bPicEnble == 0) {
                        flag = false;
                    }
                }
                if (flag) {
                    TrafficEventFrame.this.savePlatePic(pBuffer, dwBufSize, TrafficEventFrame.this.trafficInfo);
                    eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                    if (eventQueue != null) {
                        eventQueue.postEvent(new TrafficEvent(TrafficEventFrame.this.target, TrafficEventFrame.this.snapImage, TrafficEventFrame.this.plateImage, TrafficEventFrame.this.trafficInfo));
                    }
                } else {
                    TrafficEventFrame.this.savePlatePic(pBuffer, dwBufSize, TrafficEventFrame.this.trafficInfo);
                    eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                    if (eventQueue != null) {
                        eventQueue.postEvent(new TrafficEvent(TrafficEventFrame.this.target, TrafficEventFrame.this.snapImage, null, TrafficEventFrame.this.trafficInfo));
                    }
                }
            }
            return 0;
        }

        private void GetStuObject(int dwAlarmType, Pointer pAlarmInfo) {
            if (pAlarmInfo == null) {
                return;
            }
            switch (dwAlarmType) {
                case 23: {
                    NetSDKLib.DEV_EVENT_TRAFFICJUNCTION_INFO msg = new NetSDKLib.DEV_EVENT_TRAFFICJUNCTION_INFO();
                    ToolKits.GetPointerData(pAlarmInfo, msg);
                    TrafficEventFrame.this.trafficInfo.m_EventName = Res.string().getEventName(23);
                    try {
                        TrafficEventFrame.this.trafficInfo.m_PlateNumber = new String(msg.stuObject.szText, "GBK").trim();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    TrafficEventFrame.this.trafficInfo.m_PlateType = new String(msg.stTrafficCar.szPlateType).trim();
                    TrafficEventFrame.this.trafficInfo.m_FileCount = String.valueOf(msg.stuFileInfo.bCount);
                    TrafficEventFrame.this.trafficInfo.m_FileIndex = String.valueOf(msg.stuFileInfo.bIndex);
                    TrafficEventFrame.this.trafficInfo.m_GroupID = String.valueOf(msg.stuFileInfo.nGroupId);
                    TrafficEventFrame.this.trafficInfo.m_IllegalPlace = ToolKits.GetPointerDataToByteArr(msg.stTrafficCar.szDeviceAddress);
                    TrafficEventFrame.this.trafficInfo.m_LaneNumber = String.valueOf(msg.nLane);
                    TrafficEventFrame.this.trafficInfo.m_PlateColor = new String(msg.stTrafficCar.szPlateColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleColor = new String(msg.stTrafficCar.szVehicleColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleType = new String(msg.stuVehicle.szObjectSubType).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleSize = Res.string().getTrafficSize(msg.stTrafficCar.nVehicleSize);
                    TrafficEventFrame.this.trafficInfo.m_Utc = msg.UTC;
                    TrafficEventFrame.this.trafficInfo.m_bPicEnble = msg.stuObject.bPicEnble;
                    TrafficEventFrame.this.trafficInfo.m_OffSet = msg.stuObject.stPicInfo.dwOffSet;
                    TrafficEventFrame.this.trafficInfo.m_FileLength = msg.stuObject.stPicInfo.dwFileLenth;
                    TrafficEventFrame.this.trafficInfo.m_BoundingBox = msg.stuObject.BoundingBox;
                    break;
                }
                case 256: {
                    NetSDKLib.DEV_EVENT_TRAFFIC_RUNREDLIGHT_INFO msg = new NetSDKLib.DEV_EVENT_TRAFFIC_RUNREDLIGHT_INFO();
                    ToolKits.GetPointerData(pAlarmInfo, msg);
                    TrafficEventFrame.this.trafficInfo.m_EventName = Res.string().getEventName(256);
                    try {
                        TrafficEventFrame.this.trafficInfo.m_PlateNumber = new String(msg.stuObject.szText, "GBK").trim();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    TrafficEventFrame.this.trafficInfo.m_PlateType = new String(msg.stTrafficCar.szPlateType).trim();
                    TrafficEventFrame.this.trafficInfo.m_FileCount = String.valueOf(msg.stuFileInfo.bCount);
                    TrafficEventFrame.this.trafficInfo.m_FileIndex = String.valueOf(msg.stuFileInfo.bIndex);
                    TrafficEventFrame.this.trafficInfo.m_GroupID = String.valueOf(msg.stuFileInfo.nGroupId);
                    TrafficEventFrame.this.trafficInfo.m_IllegalPlace = ToolKits.GetPointerDataToByteArr(msg.stTrafficCar.szDeviceAddress);
                    TrafficEventFrame.this.trafficInfo.m_LaneNumber = String.valueOf(msg.nLane);
                    TrafficEventFrame.this.trafficInfo.m_PlateColor = new String(msg.stTrafficCar.szPlateColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleColor = new String(msg.stTrafficCar.szVehicleColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleType = new String(msg.stuVehicle.szObjectSubType).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleSize = Res.string().getTrafficSize(msg.stTrafficCar.nVehicleSize);
                    TrafficEventFrame.this.trafficInfo.m_Utc = msg.UTC;
                    TrafficEventFrame.this.trafficInfo.m_bPicEnble = msg.stuObject.bPicEnble;
                    TrafficEventFrame.this.trafficInfo.m_OffSet = msg.stuObject.stPicInfo.dwOffSet;
                    TrafficEventFrame.this.trafficInfo.m_FileLength = msg.stuObject.stPicInfo.dwFileLenth;
                    TrafficEventFrame.this.trafficInfo.m_BoundingBox = msg.stuObject.BoundingBox;
                    break;
                }
                case 257: {
                    NetSDKLib.DEV_EVENT_TRAFFIC_OVERLINE_INFO msg = new NetSDKLib.DEV_EVENT_TRAFFIC_OVERLINE_INFO();
                    ToolKits.GetPointerData(pAlarmInfo, msg);
                    TrafficEventFrame.this.trafficInfo.m_EventName = Res.string().getEventName(257);
                    try {
                        TrafficEventFrame.this.trafficInfo.m_PlateNumber = new String(msg.stuObject.szText, "GBK").trim();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    TrafficEventFrame.this.trafficInfo.m_PlateType = new String(msg.stTrafficCar.szPlateType).trim();
                    TrafficEventFrame.this.trafficInfo.m_FileCount = String.valueOf(msg.stuFileInfo.bCount);
                    TrafficEventFrame.this.trafficInfo.m_FileIndex = String.valueOf(msg.stuFileInfo.bIndex);
                    TrafficEventFrame.this.trafficInfo.m_GroupID = String.valueOf(msg.stuFileInfo.nGroupId);
                    TrafficEventFrame.this.trafficInfo.m_IllegalPlace = ToolKits.GetPointerDataToByteArr(msg.stTrafficCar.szDeviceAddress);
                    TrafficEventFrame.this.trafficInfo.m_LaneNumber = String.valueOf(msg.nLane);
                    TrafficEventFrame.this.trafficInfo.m_PlateColor = new String(msg.stTrafficCar.szPlateColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleColor = new String(msg.stTrafficCar.szVehicleColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleType = new String(msg.stuVehicle.szObjectSubType).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleSize = Res.string().getTrafficSize(msg.stTrafficCar.nVehicleSize);
                    TrafficEventFrame.this.trafficInfo.m_Utc = msg.UTC;
                    TrafficEventFrame.this.trafficInfo.m_bPicEnble = msg.stuObject.bPicEnble;
                    TrafficEventFrame.this.trafficInfo.m_OffSet = msg.stuObject.stPicInfo.dwOffSet;
                    TrafficEventFrame.this.trafficInfo.m_FileLength = msg.stuObject.stPicInfo.dwFileLenth;
                    TrafficEventFrame.this.trafficInfo.m_BoundingBox = msg.stuObject.BoundingBox;
                    break;
                }
                case 258: {
                    NetSDKLib.DEV_EVENT_TRAFFIC_RETROGRADE_INFO msg = new NetSDKLib.DEV_EVENT_TRAFFIC_RETROGRADE_INFO();
                    ToolKits.GetPointerData(pAlarmInfo, msg);
                    TrafficEventFrame.this.trafficInfo.m_EventName = Res.string().getEventName(258);
                    try {
                        TrafficEventFrame.this.trafficInfo.m_PlateNumber = new String(msg.stuObject.szText, "GBK").trim();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    TrafficEventFrame.this.trafficInfo.m_PlateType = new String(msg.stTrafficCar.szPlateType).trim();
                    TrafficEventFrame.this.trafficInfo.m_FileCount = String.valueOf(msg.stuFileInfo.bCount);
                    TrafficEventFrame.this.trafficInfo.m_FileIndex = String.valueOf(msg.stuFileInfo.bIndex);
                    TrafficEventFrame.this.trafficInfo.m_GroupID = String.valueOf(msg.stuFileInfo.nGroupId);
                    TrafficEventFrame.this.trafficInfo.m_IllegalPlace = ToolKits.GetPointerDataToByteArr(msg.stTrafficCar.szDeviceAddress);
                    TrafficEventFrame.this.trafficInfo.m_LaneNumber = String.valueOf(msg.nLane);
                    TrafficEventFrame.this.trafficInfo.m_PlateColor = new String(msg.stTrafficCar.szPlateColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleColor = new String(msg.stTrafficCar.szVehicleColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleType = new String(msg.stuVehicle.szObjectSubType).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleSize = Res.string().getTrafficSize(msg.stTrafficCar.nVehicleSize);
                    TrafficEventFrame.this.trafficInfo.m_Utc = msg.UTC;
                    TrafficEventFrame.this.trafficInfo.m_bPicEnble = msg.stuObject.bPicEnble;
                    TrafficEventFrame.this.trafficInfo.m_OffSet = msg.stuObject.stPicInfo.dwOffSet;
                    TrafficEventFrame.this.trafficInfo.m_FileLength = msg.stuObject.stPicInfo.dwFileLenth;
                    TrafficEventFrame.this.trafficInfo.m_BoundingBox = msg.stuObject.BoundingBox;
                    break;
                }
                case 259: {
                    NetSDKLib.DEV_EVENT_TRAFFIC_TURNLEFT_INFO msg = new NetSDKLib.DEV_EVENT_TRAFFIC_TURNLEFT_INFO();
                    ToolKits.GetPointerData(pAlarmInfo, msg);
                    TrafficEventFrame.this.trafficInfo.m_EventName = Res.string().getEventName(259);
                    try {
                        TrafficEventFrame.this.trafficInfo.m_PlateNumber = new String(msg.stuObject.szText, "GBK").trim();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    TrafficEventFrame.this.trafficInfo.m_PlateType = new String(msg.stTrafficCar.szPlateType).trim();
                    TrafficEventFrame.this.trafficInfo.m_FileCount = String.valueOf(msg.stuFileInfo.bCount);
                    TrafficEventFrame.this.trafficInfo.m_FileIndex = String.valueOf(msg.stuFileInfo.bIndex);
                    TrafficEventFrame.this.trafficInfo.m_GroupID = String.valueOf(msg.stuFileInfo.nGroupId);
                    TrafficEventFrame.this.trafficInfo.m_IllegalPlace = ToolKits.GetPointerDataToByteArr(msg.stTrafficCar.szDeviceAddress);
                    TrafficEventFrame.this.trafficInfo.m_LaneNumber = String.valueOf(msg.nLane);
                    TrafficEventFrame.this.trafficInfo.m_PlateColor = new String(msg.stTrafficCar.szPlateColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleColor = new String(msg.stTrafficCar.szVehicleColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleType = new String(msg.stuVehicle.szObjectSubType).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleSize = Res.string().getTrafficSize(msg.stTrafficCar.nVehicleSize);
                    TrafficEventFrame.this.trafficInfo.m_Utc = msg.UTC;
                    TrafficEventFrame.this.trafficInfo.m_bPicEnble = msg.stuObject.bPicEnble;
                    TrafficEventFrame.this.trafficInfo.m_OffSet = msg.stuObject.stPicInfo.dwOffSet;
                    TrafficEventFrame.this.trafficInfo.m_FileLength = msg.stuObject.stPicInfo.dwFileLenth;
                    TrafficEventFrame.this.trafficInfo.m_BoundingBox = msg.stuObject.BoundingBox;
                    break;
                }
                case 260: {
                    NetSDKLib.DEV_EVENT_TRAFFIC_TURNRIGHT_INFO msg = new NetSDKLib.DEV_EVENT_TRAFFIC_TURNRIGHT_INFO();
                    ToolKits.GetPointerData(pAlarmInfo, msg);
                    TrafficEventFrame.this.trafficInfo.m_EventName = Res.string().getEventName(260);
                    try {
                        TrafficEventFrame.this.trafficInfo.m_PlateNumber = new String(msg.stuObject.szText, "GBK").trim();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    TrafficEventFrame.this.trafficInfo.m_PlateType = new String(msg.stTrafficCar.szPlateType).trim();
                    TrafficEventFrame.this.trafficInfo.m_FileCount = String.valueOf(msg.stuFileInfo.bCount);
                    TrafficEventFrame.this.trafficInfo.m_FileIndex = String.valueOf(msg.stuFileInfo.bIndex);
                    TrafficEventFrame.this.trafficInfo.m_GroupID = String.valueOf(msg.stuFileInfo.nGroupId);
                    TrafficEventFrame.this.trafficInfo.m_IllegalPlace = ToolKits.GetPointerDataToByteArr(msg.stTrafficCar.szDeviceAddress);
                    TrafficEventFrame.this.trafficInfo.m_LaneNumber = String.valueOf(msg.nLane);
                    TrafficEventFrame.this.trafficInfo.m_PlateColor = new String(msg.stTrafficCar.szPlateColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleColor = new String(msg.stTrafficCar.szVehicleColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleType = new String(msg.stuVehicle.szObjectSubType).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleSize = Res.string().getTrafficSize(msg.stTrafficCar.nVehicleSize);
                    TrafficEventFrame.this.trafficInfo.m_Utc = msg.UTC;
                    TrafficEventFrame.this.trafficInfo.m_bPicEnble = msg.stuObject.bPicEnble;
                    TrafficEventFrame.this.trafficInfo.m_OffSet = msg.stuObject.stPicInfo.dwOffSet;
                    TrafficEventFrame.this.trafficInfo.m_FileLength = msg.stuObject.stPicInfo.dwFileLenth;
                    TrafficEventFrame.this.trafficInfo.m_BoundingBox = msg.stuObject.BoundingBox;
                    break;
                }
                case 261: {
                    NetSDKLib.DEV_EVENT_TRAFFIC_UTURN_INFO msg = new NetSDKLib.DEV_EVENT_TRAFFIC_UTURN_INFO();
                    ToolKits.GetPointerData(pAlarmInfo, msg);
                    TrafficEventFrame.this.trafficInfo.m_EventName = Res.string().getEventName(261);
                    try {
                        TrafficEventFrame.this.trafficInfo.m_PlateNumber = new String(msg.stuObject.szText, "GBK").trim();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    TrafficEventFrame.this.trafficInfo.m_PlateType = new String(msg.stTrafficCar.szPlateType).trim();
                    TrafficEventFrame.this.trafficInfo.m_FileCount = String.valueOf(msg.stuFileInfo.bCount);
                    TrafficEventFrame.this.trafficInfo.m_FileIndex = String.valueOf(msg.stuFileInfo.bIndex);
                    TrafficEventFrame.this.trafficInfo.m_GroupID = String.valueOf(msg.stuFileInfo.nGroupId);
                    TrafficEventFrame.this.trafficInfo.m_IllegalPlace = ToolKits.GetPointerDataToByteArr(msg.stTrafficCar.szDeviceAddress);
                    TrafficEventFrame.this.trafficInfo.m_LaneNumber = String.valueOf(msg.nLane);
                    TrafficEventFrame.this.trafficInfo.m_PlateColor = new String(msg.stTrafficCar.szPlateColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleColor = new String(msg.stTrafficCar.szVehicleColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleType = new String(msg.stuVehicle.szObjectSubType).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleSize = Res.string().getTrafficSize(msg.stTrafficCar.nVehicleSize);
                    TrafficEventFrame.this.trafficInfo.m_Utc = msg.UTC;
                    TrafficEventFrame.this.trafficInfo.m_bPicEnble = msg.stuObject.bPicEnble;
                    TrafficEventFrame.this.trafficInfo.m_OffSet = msg.stuObject.stPicInfo.dwOffSet;
                    TrafficEventFrame.this.trafficInfo.m_FileLength = msg.stuObject.stPicInfo.dwFileLenth;
                    TrafficEventFrame.this.trafficInfo.m_BoundingBox = msg.stuObject.BoundingBox;
                    break;
                }
                case 262: {
                    NetSDKLib.DEV_EVENT_TRAFFIC_OVERSPEED_INFO msg = new NetSDKLib.DEV_EVENT_TRAFFIC_OVERSPEED_INFO();
                    ToolKits.GetPointerData(pAlarmInfo, msg);
                    TrafficEventFrame.this.trafficInfo.m_EventName = Res.string().getEventName(262);
                    try {
                        TrafficEventFrame.this.trafficInfo.m_PlateNumber = new String(msg.stuObject.szText, "GBK").trim();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    TrafficEventFrame.this.trafficInfo.m_PlateType = new String(msg.stTrafficCar.szPlateType).trim();
                    TrafficEventFrame.this.trafficInfo.m_FileCount = String.valueOf(msg.stuFileInfo.bCount);
                    TrafficEventFrame.this.trafficInfo.m_FileIndex = String.valueOf(msg.stuFileInfo.bIndex);
                    TrafficEventFrame.this.trafficInfo.m_GroupID = String.valueOf(msg.stuFileInfo.nGroupId);
                    TrafficEventFrame.this.trafficInfo.m_IllegalPlace = ToolKits.GetPointerDataToByteArr(msg.stTrafficCar.szDeviceAddress);
                    TrafficEventFrame.this.trafficInfo.m_LaneNumber = String.valueOf(msg.nLane);
                    TrafficEventFrame.this.trafficInfo.m_PlateColor = new String(msg.stTrafficCar.szPlateColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleColor = new String(msg.stTrafficCar.szVehicleColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleType = new String(msg.stuVehicle.szObjectSubType).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleSize = Res.string().getTrafficSize(msg.stTrafficCar.nVehicleSize);
                    TrafficEventFrame.this.trafficInfo.m_Utc = msg.UTC;
                    TrafficEventFrame.this.trafficInfo.m_bPicEnble = msg.stuObject.bPicEnble;
                    TrafficEventFrame.this.trafficInfo.m_OffSet = msg.stuObject.stPicInfo.dwOffSet;
                    TrafficEventFrame.this.trafficInfo.m_FileLength = msg.stuObject.stPicInfo.dwFileLenth;
                    TrafficEventFrame.this.trafficInfo.m_BoundingBox = msg.stuObject.BoundingBox;
                    break;
                }
                case 263: {
                    NetSDKLib.DEV_EVENT_TRAFFIC_UNDERSPEED_INFO msg = new NetSDKLib.DEV_EVENT_TRAFFIC_UNDERSPEED_INFO();
                    ToolKits.GetPointerData(pAlarmInfo, msg);
                    TrafficEventFrame.this.trafficInfo.m_EventName = Res.string().getEventName(263);
                    try {
                        TrafficEventFrame.this.trafficInfo.m_PlateNumber = new String(msg.stuObject.szText, "GBK").trim();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    TrafficEventFrame.this.trafficInfo.m_PlateType = new String(msg.stTrafficCar.szPlateType).trim();
                    TrafficEventFrame.this.trafficInfo.m_FileCount = String.valueOf(msg.stuFileInfo.bCount);
                    TrafficEventFrame.this.trafficInfo.m_FileIndex = String.valueOf(msg.stuFileInfo.bIndex);
                    TrafficEventFrame.this.trafficInfo.m_GroupID = String.valueOf(msg.stuFileInfo.nGroupId);
                    TrafficEventFrame.this.trafficInfo.m_IllegalPlace = ToolKits.GetPointerDataToByteArr(msg.stTrafficCar.szDeviceAddress);
                    TrafficEventFrame.this.trafficInfo.m_LaneNumber = String.valueOf(msg.nLane);
                    TrafficEventFrame.this.trafficInfo.m_PlateColor = new String(msg.stTrafficCar.szPlateColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleColor = new String(msg.stTrafficCar.szVehicleColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleType = new String(msg.stuVehicle.szObjectSubType).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleSize = Res.string().getTrafficSize(msg.stTrafficCar.nVehicleSize);
                    TrafficEventFrame.this.trafficInfo.m_Utc = msg.UTC;
                    TrafficEventFrame.this.trafficInfo.m_bPicEnble = msg.stuObject.bPicEnble;
                    TrafficEventFrame.this.trafficInfo.m_OffSet = msg.stuObject.stPicInfo.dwOffSet;
                    TrafficEventFrame.this.trafficInfo.m_FileLength = msg.stuObject.stPicInfo.dwFileLenth;
                    TrafficEventFrame.this.trafficInfo.m_BoundingBox = msg.stuObject.BoundingBox;
                    break;
                }
                case 264: {
                    NetSDKLib.DEV_EVENT_TRAFFIC_PARKING_INFO msg = new NetSDKLib.DEV_EVENT_TRAFFIC_PARKING_INFO();
                    ToolKits.GetPointerData(pAlarmInfo, msg);
                    TrafficEventFrame.this.trafficInfo.m_EventName = Res.string().getEventName(264);
                    try {
                        TrafficEventFrame.this.trafficInfo.m_PlateNumber = new String(msg.stuObject.szText, "GBK").trim();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    TrafficEventFrame.this.trafficInfo.m_PlateType = new String(msg.stTrafficCar.szPlateType).trim();
                    TrafficEventFrame.this.trafficInfo.m_FileCount = String.valueOf(msg.stuFileInfo.bCount);
                    TrafficEventFrame.this.trafficInfo.m_FileIndex = String.valueOf(msg.stuFileInfo.bIndex);
                    TrafficEventFrame.this.trafficInfo.m_GroupID = String.valueOf(msg.stuFileInfo.nGroupId);
                    TrafficEventFrame.this.trafficInfo.m_IllegalPlace = ToolKits.GetPointerDataToByteArr(msg.stTrafficCar.szDeviceAddress);
                    TrafficEventFrame.this.trafficInfo.m_LaneNumber = String.valueOf(msg.nLane);
                    TrafficEventFrame.this.trafficInfo.m_PlateColor = new String(msg.stTrafficCar.szPlateColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleColor = new String(msg.stTrafficCar.szVehicleColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleType = new String(msg.stuVehicle.szObjectSubType).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleSize = Res.string().getTrafficSize(msg.stTrafficCar.nVehicleSize);
                    TrafficEventFrame.this.trafficInfo.m_Utc = msg.UTC;
                    TrafficEventFrame.this.trafficInfo.m_bPicEnble = msg.stuObject.bPicEnble;
                    TrafficEventFrame.this.trafficInfo.m_OffSet = msg.stuObject.stPicInfo.dwOffSet;
                    TrafficEventFrame.this.trafficInfo.m_FileLength = msg.stuObject.stPicInfo.dwFileLenth;
                    TrafficEventFrame.this.trafficInfo.m_BoundingBox = msg.stuObject.BoundingBox;
                    break;
                }
                case 265: {
                    NetSDKLib.DEV_EVENT_TRAFFIC_WRONGROUTE_INFO msg = new NetSDKLib.DEV_EVENT_TRAFFIC_WRONGROUTE_INFO();
                    ToolKits.GetPointerData(pAlarmInfo, msg);
                    TrafficEventFrame.this.trafficInfo.m_EventName = Res.string().getEventName(265);
                    try {
                        TrafficEventFrame.this.trafficInfo.m_PlateNumber = new String(msg.stuObject.szText, "GBK").trim();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    TrafficEventFrame.this.trafficInfo.m_PlateType = new String(msg.stTrafficCar.szPlateType).trim();
                    TrafficEventFrame.this.trafficInfo.m_FileCount = String.valueOf(msg.stuFileInfo.bCount);
                    TrafficEventFrame.this.trafficInfo.m_FileIndex = String.valueOf(msg.stuFileInfo.bIndex);
                    TrafficEventFrame.this.trafficInfo.m_GroupID = String.valueOf(msg.stuFileInfo.nGroupId);
                    TrafficEventFrame.this.trafficInfo.m_IllegalPlace = ToolKits.GetPointerDataToByteArr(msg.stTrafficCar.szDeviceAddress);
                    TrafficEventFrame.this.trafficInfo.m_LaneNumber = String.valueOf(msg.nLane);
                    TrafficEventFrame.this.trafficInfo.m_PlateColor = new String(msg.stTrafficCar.szPlateColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleColor = new String(msg.stTrafficCar.szVehicleColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleType = new String(msg.stuVehicle.szObjectSubType).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleSize = Res.string().getTrafficSize(msg.stTrafficCar.nVehicleSize);
                    TrafficEventFrame.this.trafficInfo.m_Utc = msg.UTC;
                    TrafficEventFrame.this.trafficInfo.m_bPicEnble = msg.stuObject.bPicEnble;
                    TrafficEventFrame.this.trafficInfo.m_OffSet = msg.stuObject.stPicInfo.dwOffSet;
                    TrafficEventFrame.this.trafficInfo.m_FileLength = msg.stuObject.stPicInfo.dwFileLenth;
                    TrafficEventFrame.this.trafficInfo.m_BoundingBox = msg.stuObject.BoundingBox;
                    break;
                }
                case 266: {
                    NetSDKLib.DEV_EVENT_TRAFFIC_CROSSLANE_INFO msg = new NetSDKLib.DEV_EVENT_TRAFFIC_CROSSLANE_INFO();
                    ToolKits.GetPointerData(pAlarmInfo, msg);
                    TrafficEventFrame.this.trafficInfo.m_EventName = Res.string().getEventName(266);
                    try {
                        TrafficEventFrame.this.trafficInfo.m_PlateNumber = new String(msg.stuObject.szText, "GBK").trim();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    TrafficEventFrame.this.trafficInfo.m_PlateType = new String(msg.stuTrafficCar.szPlateType).trim();
                    TrafficEventFrame.this.trafficInfo.m_FileCount = String.valueOf(msg.stuFileInfo.bCount);
                    TrafficEventFrame.this.trafficInfo.m_FileIndex = String.valueOf(msg.stuFileInfo.bIndex);
                    TrafficEventFrame.this.trafficInfo.m_GroupID = String.valueOf(msg.stuFileInfo.nGroupId);
                    TrafficEventFrame.this.trafficInfo.m_IllegalPlace = ToolKits.GetPointerDataToByteArr(msg.stuTrafficCar.szDeviceAddress);
                    TrafficEventFrame.this.trafficInfo.m_LaneNumber = String.valueOf(msg.nLane);
                    TrafficEventFrame.this.trafficInfo.m_PlateColor = new String(msg.stuTrafficCar.szPlateColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleColor = new String(msg.stuTrafficCar.szVehicleColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleType = new String(msg.stuVehicle.szObjectSubType).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleSize = Res.string().getTrafficSize(msg.stuTrafficCar.nVehicleSize);
                    TrafficEventFrame.this.trafficInfo.m_Utc = msg.UTC;
                    TrafficEventFrame.this.trafficInfo.m_bPicEnble = msg.stuObject.bPicEnble;
                    TrafficEventFrame.this.trafficInfo.m_OffSet = msg.stuObject.stPicInfo.dwOffSet;
                    TrafficEventFrame.this.trafficInfo.m_FileLength = msg.stuObject.stPicInfo.dwFileLenth;
                    TrafficEventFrame.this.trafficInfo.m_BoundingBox = msg.stuObject.BoundingBox;
                    break;
                }
                case 267: {
                    NetSDKLib.DEV_EVENT_TRAFFIC_OVERYELLOWLINE_INFO msg = new NetSDKLib.DEV_EVENT_TRAFFIC_OVERYELLOWLINE_INFO();
                    ToolKits.GetPointerData(pAlarmInfo, msg);
                    TrafficEventFrame.this.trafficInfo.m_EventName = Res.string().getEventName(267);
                    try {
                        TrafficEventFrame.this.trafficInfo.m_PlateNumber = new String(msg.stuObject.szText, "GBK").trim();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    TrafficEventFrame.this.trafficInfo.m_PlateType = new String(msg.stTrafficCar.szPlateType).trim();
                    TrafficEventFrame.this.trafficInfo.m_FileCount = String.valueOf(msg.stuFileInfo.bCount);
                    TrafficEventFrame.this.trafficInfo.m_FileIndex = String.valueOf(msg.stuFileInfo.bIndex);
                    TrafficEventFrame.this.trafficInfo.m_GroupID = String.valueOf(msg.stuFileInfo.nGroupId);
                    TrafficEventFrame.this.trafficInfo.m_IllegalPlace = ToolKits.GetPointerDataToByteArr(msg.stTrafficCar.szDeviceAddress);
                    TrafficEventFrame.this.trafficInfo.m_LaneNumber = String.valueOf(msg.nLane);
                    TrafficEventFrame.this.trafficInfo.m_PlateColor = new String(msg.stTrafficCar.szPlateColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleColor = new String(msg.stTrafficCar.szVehicleColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleType = new String(msg.stuVehicle.szObjectSubType).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleSize = Res.string().getTrafficSize(msg.stTrafficCar.nVehicleSize);
                    TrafficEventFrame.this.trafficInfo.m_Utc = msg.UTC;
                    TrafficEventFrame.this.trafficInfo.m_bPicEnble = msg.stuObject.bPicEnble;
                    TrafficEventFrame.this.trafficInfo.m_OffSet = msg.stuObject.stPicInfo.dwOffSet;
                    TrafficEventFrame.this.trafficInfo.m_FileLength = msg.stuObject.stPicInfo.dwFileLenth;
                    TrafficEventFrame.this.trafficInfo.m_BoundingBox = msg.stuObject.BoundingBox;
                    break;
                }
                case 270: {
                    NetSDKLib.DEV_EVENT_TRAFFIC_YELLOWPLATEINLANE_INFO msg = new NetSDKLib.DEV_EVENT_TRAFFIC_YELLOWPLATEINLANE_INFO();
                    ToolKits.GetPointerData(pAlarmInfo, msg);
                    TrafficEventFrame.this.trafficInfo.m_EventName = Res.string().getEventName(270);
                    try {
                        TrafficEventFrame.this.trafficInfo.m_PlateNumber = new String(msg.stuObject.szText, "GBK").trim();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    TrafficEventFrame.this.trafficInfo.m_PlateType = new String(msg.stTrafficCar.szPlateType).trim();
                    TrafficEventFrame.this.trafficInfo.m_FileCount = String.valueOf(msg.stuFileInfo.bCount);
                    TrafficEventFrame.this.trafficInfo.m_FileIndex = String.valueOf(msg.stuFileInfo.bIndex);
                    TrafficEventFrame.this.trafficInfo.m_GroupID = String.valueOf(msg.stuFileInfo.nGroupId);
                    TrafficEventFrame.this.trafficInfo.m_IllegalPlace = ToolKits.GetPointerDataToByteArr(msg.stTrafficCar.szDeviceAddress);
                    TrafficEventFrame.this.trafficInfo.m_LaneNumber = String.valueOf(msg.nLane);
                    TrafficEventFrame.this.trafficInfo.m_PlateColor = new String(msg.stTrafficCar.szPlateColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleColor = new String(msg.stTrafficCar.szVehicleColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleType = new String(msg.stuVehicle.szObjectSubType).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleSize = Res.string().getTrafficSize(msg.stTrafficCar.nVehicleSize);
                    TrafficEventFrame.this.trafficInfo.m_Utc = msg.UTC;
                    TrafficEventFrame.this.trafficInfo.m_bPicEnble = msg.stuObject.bPicEnble;
                    TrafficEventFrame.this.trafficInfo.m_OffSet = msg.stuObject.stPicInfo.dwOffSet;
                    TrafficEventFrame.this.trafficInfo.m_FileLength = msg.stuObject.stPicInfo.dwFileLenth;
                    TrafficEventFrame.this.trafficInfo.m_BoundingBox = msg.stuObject.BoundingBox;
                    break;
                }
                case 271: {
                    NetSDKLib.DEV_EVENT_TRAFFIC_PEDESTRAINPRIORITY_INFO msg = new NetSDKLib.DEV_EVENT_TRAFFIC_PEDESTRAINPRIORITY_INFO();
                    ToolKits.GetPointerData(pAlarmInfo, msg);
                    TrafficEventFrame.this.trafficInfo.m_EventName = Res.string().getEventName(271);
                    try {
                        TrafficEventFrame.this.trafficInfo.m_PlateNumber = new String(msg.stuObject.szText, "GBK").trim();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    TrafficEventFrame.this.trafficInfo.m_PlateType = new String(msg.stTrafficCar.szPlateType).trim();
                    TrafficEventFrame.this.trafficInfo.m_FileCount = String.valueOf(msg.stuFileInfo.bCount);
                    TrafficEventFrame.this.trafficInfo.m_FileIndex = String.valueOf(msg.stuFileInfo.bIndex);
                    TrafficEventFrame.this.trafficInfo.m_GroupID = String.valueOf(msg.stuFileInfo.nGroupId);
                    TrafficEventFrame.this.trafficInfo.m_IllegalPlace = ToolKits.GetPointerDataToByteArr(msg.stTrafficCar.szDeviceAddress);
                    TrafficEventFrame.this.trafficInfo.m_LaneNumber = String.valueOf(msg.nLane);
                    TrafficEventFrame.this.trafficInfo.m_PlateColor = new String(msg.stTrafficCar.szPlateColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleColor = new String(msg.stTrafficCar.szVehicleColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleType = new String(msg.stuVehicle.szObjectSubType).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleSize = Res.string().getTrafficSize(msg.stTrafficCar.nVehicleSize);
                    TrafficEventFrame.this.trafficInfo.m_Utc = msg.UTC;
                    TrafficEventFrame.this.trafficInfo.m_bPicEnble = msg.stuObject.bPicEnble;
                    TrafficEventFrame.this.trafficInfo.m_OffSet = msg.stuObject.stPicInfo.dwOffSet;
                    TrafficEventFrame.this.trafficInfo.m_FileLength = msg.stuObject.stPicInfo.dwFileLenth;
                    TrafficEventFrame.this.trafficInfo.m_BoundingBox = msg.stuObject.BoundingBox;
                    break;
                }
                case 280: {
                    JOptionPane.showMessageDialog(null, Res.string().getManualCaptureSucceed(), Res.string().getPromptMessage(), 1);
                    NetSDKLib.DEV_EVENT_TRAFFIC_MANUALSNAP_INFO msg = new NetSDKLib.DEV_EVENT_TRAFFIC_MANUALSNAP_INFO();
                    ToolKits.GetPointerData(pAlarmInfo, msg);
                    TrafficEventFrame.this.trafficInfo.m_EventName = Res.string().getEventName(280);
                    try {
                        TrafficEventFrame.this.trafficInfo.m_PlateNumber = new String(msg.stuObject.szText, "GBK").trim();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    TrafficEventFrame.this.trafficInfo.m_PlateType = new String(msg.stTrafficCar.szPlateType).trim();
                    TrafficEventFrame.this.trafficInfo.m_FileCount = String.valueOf(msg.stuFileInfo.bCount);
                    TrafficEventFrame.this.trafficInfo.m_FileIndex = String.valueOf(msg.stuFileInfo.bIndex);
                    TrafficEventFrame.this.trafficInfo.m_GroupID = String.valueOf(msg.stuFileInfo.nGroupId);
                    TrafficEventFrame.this.trafficInfo.m_IllegalPlace = ToolKits.GetPointerDataToByteArr(msg.stTrafficCar.szDeviceAddress);
                    TrafficEventFrame.this.trafficInfo.m_LaneNumber = String.valueOf(msg.nLane);
                    TrafficEventFrame.this.trafficInfo.m_PlateColor = new String(msg.stTrafficCar.szPlateColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleColor = new String(msg.stTrafficCar.szVehicleColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleType = new String(msg.stuVehicle.szObjectSubType).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleSize = Res.string().getTrafficSize(msg.stTrafficCar.nVehicleSize);
                    TrafficEventFrame.this.trafficInfo.m_Utc = msg.UTC;
                    TrafficEventFrame.this.trafficInfo.m_bPicEnble = msg.stuObject.bPicEnble;
                    TrafficEventFrame.this.trafficInfo.m_OffSet = msg.stuObject.stPicInfo.dwOffSet;
                    TrafficEventFrame.this.trafficInfo.m_FileLength = msg.stuObject.stPicInfo.dwFileLenth;
                    TrafficEventFrame.this.trafficInfo.m_BoundingBox = msg.stuObject.BoundingBox;
                    break;
                }
                case 283: {
                    NetSDKLib.DEV_EVENT_TRAFFIC_VEHICLEINROUTE_INFO msg = new NetSDKLib.DEV_EVENT_TRAFFIC_VEHICLEINROUTE_INFO();
                    ToolKits.GetPointerData(pAlarmInfo, msg);
                    TrafficEventFrame.this.trafficInfo.m_EventName = Res.string().getEventName(283);
                    try {
                        TrafficEventFrame.this.trafficInfo.m_PlateNumber = new String(msg.stuObject.szText, "GBK").trim();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    TrafficEventFrame.this.trafficInfo.m_PlateType = new String(msg.stTrafficCar.szPlateType).trim();
                    TrafficEventFrame.this.trafficInfo.m_FileCount = String.valueOf(msg.stuFileInfo.bCount);
                    TrafficEventFrame.this.trafficInfo.m_FileIndex = String.valueOf(msg.stuFileInfo.bIndex);
                    TrafficEventFrame.this.trafficInfo.m_GroupID = String.valueOf(msg.stuFileInfo.nGroupId);
                    TrafficEventFrame.this.trafficInfo.m_IllegalPlace = ToolKits.GetPointerDataToByteArr(msg.stTrafficCar.szDeviceAddress);
                    TrafficEventFrame.this.trafficInfo.m_LaneNumber = String.valueOf(msg.nLane);
                    TrafficEventFrame.this.trafficInfo.m_PlateColor = new String(msg.stTrafficCar.szPlateColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleColor = new String(msg.stTrafficCar.szVehicleColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleType = new String(msg.stuVehicle.szObjectSubType).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleSize = Res.string().getTrafficSize(msg.stTrafficCar.nVehicleSize);
                    TrafficEventFrame.this.trafficInfo.m_Utc = msg.UTC;
                    TrafficEventFrame.this.trafficInfo.m_bPicEnble = msg.stuObject.bPicEnble;
                    TrafficEventFrame.this.trafficInfo.m_OffSet = msg.stuObject.stPicInfo.dwOffSet;
                    TrafficEventFrame.this.trafficInfo.m_FileLength = msg.stuObject.stPicInfo.dwFileLenth;
                    TrafficEventFrame.this.trafficInfo.m_BoundingBox = msg.stuObject.BoundingBox;
                    break;
                }
                case 292: {
                    NetSDKLib.DEV_EVENT_TRAFFIC_VEHICLEINBUSROUTE_INFO msg = new NetSDKLib.DEV_EVENT_TRAFFIC_VEHICLEINBUSROUTE_INFO();
                    ToolKits.GetPointerData(pAlarmInfo, msg);
                    TrafficEventFrame.this.trafficInfo.m_EventName = Res.string().getEventName(292);
                    try {
                        TrafficEventFrame.this.trafficInfo.m_PlateNumber = new String(msg.stuObject.szText, "GBK").trim();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    TrafficEventFrame.this.trafficInfo.m_PlateType = new String(msg.stTrafficCar.szPlateType).trim();
                    TrafficEventFrame.this.trafficInfo.m_FileCount = String.valueOf(msg.stuFileInfo.bCount);
                    TrafficEventFrame.this.trafficInfo.m_FileIndex = String.valueOf(msg.stuFileInfo.bIndex);
                    TrafficEventFrame.this.trafficInfo.m_GroupID = String.valueOf(msg.stuFileInfo.nGroupId);
                    TrafficEventFrame.this.trafficInfo.m_IllegalPlace = ToolKits.GetPointerDataToByteArr(msg.stTrafficCar.szDeviceAddress);
                    TrafficEventFrame.this.trafficInfo.m_LaneNumber = String.valueOf(msg.nLane);
                    TrafficEventFrame.this.trafficInfo.m_PlateColor = new String(msg.stTrafficCar.szPlateColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleColor = new String(msg.stTrafficCar.szVehicleColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleType = new String(msg.stuVehicle.szObjectSubType).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleSize = Res.string().getTrafficSize(msg.stTrafficCar.nVehicleSize);
                    TrafficEventFrame.this.trafficInfo.m_Utc = msg.UTC;
                    TrafficEventFrame.this.trafficInfo.m_bPicEnble = msg.stuObject.bPicEnble;
                    TrafficEventFrame.this.trafficInfo.m_OffSet = msg.stuObject.stPicInfo.dwOffSet;
                    TrafficEventFrame.this.trafficInfo.m_FileLength = msg.stuObject.stPicInfo.dwFileLenth;
                    TrafficEventFrame.this.trafficInfo.m_BoundingBox = msg.stuObject.BoundingBox;
                    break;
                }
                case 293: {
                    NetSDKLib.DEV_EVENT_IVS_TRAFFIC_BACKING_INFO msg = new NetSDKLib.DEV_EVENT_IVS_TRAFFIC_BACKING_INFO();
                    ToolKits.GetPointerData(pAlarmInfo, msg);
                    TrafficEventFrame.this.trafficInfo.m_EventName = Res.string().getEventName(293);
                    try {
                        TrafficEventFrame.this.trafficInfo.m_PlateNumber = new String(msg.stuObject.szText, "GBK").trim();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    TrafficEventFrame.this.trafficInfo.m_PlateType = new String(msg.stTrafficCar.szPlateType).trim();
                    TrafficEventFrame.this.trafficInfo.m_FileCount = String.valueOf(msg.stuFileInfo.bCount);
                    TrafficEventFrame.this.trafficInfo.m_FileIndex = String.valueOf(msg.stuFileInfo.bIndex);
                    TrafficEventFrame.this.trafficInfo.m_GroupID = String.valueOf(msg.stuFileInfo.nGroupId);
                    TrafficEventFrame.this.trafficInfo.m_IllegalPlace = ToolKits.GetPointerDataToByteArr(msg.stTrafficCar.szDeviceAddress);
                    TrafficEventFrame.this.trafficInfo.m_LaneNumber = String.valueOf(msg.nLane);
                    TrafficEventFrame.this.trafficInfo.m_PlateColor = new String(msg.stTrafficCar.szPlateColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleColor = new String(msg.stTrafficCar.szVehicleColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleType = new String(msg.stuVehicle.szObjectSubType).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleSize = Res.string().getTrafficSize(msg.stTrafficCar.nVehicleSize);
                    TrafficEventFrame.this.trafficInfo.m_Utc = msg.UTC;
                    TrafficEventFrame.this.trafficInfo.m_bPicEnble = msg.stuObject.bPicEnble;
                    TrafficEventFrame.this.trafficInfo.m_OffSet = msg.stuObject.stPicInfo.dwOffSet;
                    TrafficEventFrame.this.trafficInfo.m_FileLength = msg.stuObject.stPicInfo.dwFileLenth;
                    TrafficEventFrame.this.trafficInfo.m_BoundingBox = msg.stuObject.BoundingBox;
                    break;
                }
                case 299: {
                    NetSDKLib.DEV_EVENT_TRAFFIC_PARKINGSPACEPARKING_INFO msg = new NetSDKLib.DEV_EVENT_TRAFFIC_PARKINGSPACEPARKING_INFO();
                    ToolKits.GetPointerData(pAlarmInfo, msg);
                    TrafficEventFrame.this.trafficInfo.m_EventName = Res.string().getEventName(299);
                    try {
                        TrafficEventFrame.this.trafficInfo.m_PlateNumber = new String(msg.stuObject.szText, "GBK").trim();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    TrafficEventFrame.this.trafficInfo.m_PlateType = new String(msg.stTrafficCar.szPlateType).trim();
                    TrafficEventFrame.this.trafficInfo.m_FileCount = String.valueOf(msg.stuFileInfo.bCount);
                    TrafficEventFrame.this.trafficInfo.m_FileIndex = String.valueOf(msg.stuFileInfo.bIndex);
                    TrafficEventFrame.this.trafficInfo.m_GroupID = String.valueOf(msg.stuFileInfo.nGroupId);
                    TrafficEventFrame.this.trafficInfo.m_IllegalPlace = ToolKits.GetPointerDataToByteArr(msg.stTrafficCar.szDeviceAddress);
                    TrafficEventFrame.this.trafficInfo.m_LaneNumber = String.valueOf(msg.nLane);
                    TrafficEventFrame.this.trafficInfo.m_PlateColor = new String(msg.stTrafficCar.szPlateColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleColor = new String(msg.stTrafficCar.szVehicleColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleType = new String(msg.stuVehicle.szObjectSubType).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleSize = Res.string().getTrafficSize(msg.stTrafficCar.nVehicleSize);
                    TrafficEventFrame.this.trafficInfo.m_Utc = msg.UTC;
                    TrafficEventFrame.this.trafficInfo.m_bPicEnble = msg.stuObject.bPicEnble;
                    TrafficEventFrame.this.trafficInfo.m_OffSet = msg.stuObject.stPicInfo.dwOffSet;
                    TrafficEventFrame.this.trafficInfo.m_FileLength = msg.stuObject.stPicInfo.dwFileLenth;
                    TrafficEventFrame.this.trafficInfo.m_BoundingBox = msg.stuObject.BoundingBox;
                    break;
                }
                case 300: {
                    NetSDKLib.DEV_EVENT_TRAFFIC_PARKINGSPACENOPARKING_INFO msg = new NetSDKLib.DEV_EVENT_TRAFFIC_PARKINGSPACENOPARKING_INFO();
                    ToolKits.GetPointerData(pAlarmInfo, msg);
                    TrafficEventFrame.this.trafficInfo.m_EventName = Res.string().getEventName(300);
                    try {
                        TrafficEventFrame.this.trafficInfo.m_PlateNumber = new String(msg.stuObject.szText, "GBK").trim();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    TrafficEventFrame.this.trafficInfo.m_PlateType = new String(msg.stTrafficCar.szPlateType).trim();
                    TrafficEventFrame.this.trafficInfo.m_FileCount = String.valueOf(msg.stuFileInfo.bCount);
                    TrafficEventFrame.this.trafficInfo.m_FileIndex = String.valueOf(msg.stuFileInfo.bIndex);
                    TrafficEventFrame.this.trafficInfo.m_GroupID = String.valueOf(msg.stuFileInfo.nGroupId);
                    TrafficEventFrame.this.trafficInfo.m_IllegalPlace = ToolKits.GetPointerDataToByteArr(msg.stTrafficCar.szDeviceAddress);
                    TrafficEventFrame.this.trafficInfo.m_LaneNumber = String.valueOf(msg.nLane);
                    TrafficEventFrame.this.trafficInfo.m_PlateColor = new String(msg.stTrafficCar.szPlateColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleColor = new String(msg.stTrafficCar.szVehicleColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleType = new String(msg.stuVehicle.szObjectSubType).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleSize = Res.string().getTrafficSize(msg.stTrafficCar.nVehicleSize);
                    TrafficEventFrame.this.trafficInfo.m_Utc = msg.UTC;
                    TrafficEventFrame.this.trafficInfo.m_bPicEnble = msg.stuObject.bPicEnble;
                    TrafficEventFrame.this.trafficInfo.m_OffSet = msg.stuObject.stPicInfo.dwOffSet;
                    TrafficEventFrame.this.trafficInfo.m_FileLength = msg.stuObject.stPicInfo.dwFileLenth;
                    TrafficEventFrame.this.trafficInfo.m_BoundingBox = msg.stuObject.BoundingBox;
                    break;
                }
                case 312: {
                    NetSDKLib.DEV_EVENT_TRAFFIC_WITHOUT_SAFEBELT msg = new NetSDKLib.DEV_EVENT_TRAFFIC_WITHOUT_SAFEBELT();
                    ToolKits.GetPointerData(pAlarmInfo, msg);
                    TrafficEventFrame.this.trafficInfo.m_EventName = Res.string().getEventName(312);
                    try {
                        TrafficEventFrame.this.trafficInfo.m_PlateNumber = new String(msg.stuObject.szText, "GBK").trim();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    TrafficEventFrame.this.trafficInfo.m_PlateType = new String(msg.stuTrafficCar.szPlateType).trim();
                    TrafficEventFrame.this.trafficInfo.m_FileCount = String.valueOf(msg.stuFileInfo.bCount);
                    TrafficEventFrame.this.trafficInfo.m_FileIndex = String.valueOf(msg.stuFileInfo.bIndex);
                    TrafficEventFrame.this.trafficInfo.m_GroupID = String.valueOf(msg.stuFileInfo.nGroupId);
                    TrafficEventFrame.this.trafficInfo.m_IllegalPlace = ToolKits.GetPointerDataToByteArr(msg.stuTrafficCar.szDeviceAddress);
                    TrafficEventFrame.this.trafficInfo.m_LaneNumber = String.valueOf(msg.nLane);
                    TrafficEventFrame.this.trafficInfo.m_PlateColor = new String(msg.stuTrafficCar.szPlateColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleColor = new String(msg.stuTrafficCar.szVehicleColor).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleType = new String(msg.stuVehicle.szObjectSubType).trim();
                    TrafficEventFrame.this.trafficInfo.m_VehicleSize = Res.string().getTrafficSize(msg.stuTrafficCar.nVehicleSize);
                    TrafficEventFrame.this.trafficInfo.m_Utc = msg.UTC;
                    TrafficEventFrame.this.trafficInfo.m_bPicEnble = msg.stuObject.bPicEnble;
                    TrafficEventFrame.this.trafficInfo.m_OffSet = msg.stuObject.stPicInfo.dwOffSet;
                    TrafficEventFrame.this.trafficInfo.m_FileLength = msg.stuObject.stPicInfo.dwFileLenth;
                    TrafficEventFrame.this.trafficInfo.m_BoundingBox = msg.stuObject.BoundingBox;
                    break;
                }
            }
        }
    }

    class TrafficEvent
    extends AWTEvent {
        private static final long serialVersionUID = 1L;
        public static final int EVENT_ID = 2000;
        private TRAFFIC_INFO trafficInfo;
        private BufferedImage snapImage;
        private BufferedImage plateImage;

        public TrafficEvent(Object target, BufferedImage snapImage, BufferedImage plateImage, TRAFFIC_INFO info) {
            super(target, 2000);
            this.trafficInfo = null;
            this.snapImage = null;
            this.plateImage = null;
            this.snapImage = snapImage;
            this.plateImage = plateImage;
            this.trafficInfo = info;
        }

        public BufferedImage getSnapBufferedImage() {
            return this.snapImage;
        }

        public BufferedImage getPlaBufferedImage() {
            return this.plateImage;
        }

        public TRAFFIC_INFO getTrafficInfo() {
            return this.trafficInfo;
        }
    }

    private class MessagePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public MessagePanel() {
            BorderEx.set(this, Res.string().getEventInfo(), 2);
            Dimension dim = this.getPreferredSize();
            dim.height = 195;
            this.setPreferredSize(dim);
            this.setLayout(new BorderLayout());
            TrafficEventFrame.this.defaultModel = new DefaultTableModel((Object[][])null, Res.string().getTrafficTableName());
            TrafficEventFrame.this.table = new JTable(TrafficEventFrame.this.defaultModel){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            TrafficEventFrame.this.defaultModel.setRowCount(8);
            TrafficEventFrame.this.model = (DefaultTableModel)TrafficEventFrame.this.table.getModel();
            TrafficEventFrame.this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
            TrafficEventFrame.this.table.getColumnModel().getColumn(1).setPreferredWidth(120);
            TrafficEventFrame.this.table.getColumnModel().getColumn(2).setPreferredWidth(100);
            TrafficEventFrame.this.table.getColumnModel().getColumn(3).setPreferredWidth(140);
            TrafficEventFrame.this.table.getColumnModel().getColumn(4).setPreferredWidth(80);
            TrafficEventFrame.this.table.getColumnModel().getColumn(5).setPreferredWidth(80);
            TrafficEventFrame.this.table.getColumnModel().getColumn(6).setPreferredWidth(80);
            TrafficEventFrame.this.table.getColumnModel().getColumn(7).setPreferredWidth(80);
            TrafficEventFrame.this.table.getColumnModel().getColumn(8).setPreferredWidth(80);
            TrafficEventFrame.this.table.getColumnModel().getColumn(9).setPreferredWidth(80);
            TrafficEventFrame.this.table.getColumnModel().getColumn(10).setPreferredWidth(60);
            TrafficEventFrame.this.table.getColumnModel().getColumn(11).setPreferredWidth(100);
            TrafficEventFrame.this.table.getColumnModel().getColumn(12).setPreferredWidth(100);
            TrafficEventFrame.this.table.getColumnModel().getColumn(13).setPreferredWidth(90);
            TrafficEventFrame.this.table.setSelectionMode(0);
            DefaultTableCellRenderer dCellRenderer = new DefaultTableCellRenderer();
            dCellRenderer.setHorizontalAlignment(0);
            TrafficEventFrame.this.table.setDefaultRenderer(Object.class, dCellRenderer);
            TrafficEventFrame.this.table.setAutoResizeMode(0);
            JScrollPane scrollPane = new JScrollPane(TrafficEventFrame.this.table);
            this.add((Component)scrollPane, "Center");
            TrafficEventFrame.this.table.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() < 2) {
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int row = TrafficEventFrame.this.table.getSelectedRow();
                            if (TrafficEventFrame.this.model.getValueAt(row, 3) == null || String.valueOf(TrafficEventFrame.this.model.getValueAt(row, 3)).trim().equals("")) {
                                return;
                            }
                            if (TrafficEventFrame.this.model.getValueAt(row, 9) == null || String.valueOf(TrafficEventFrame.this.model.getValueAt(row, 9)).trim().equals("")) {
                                return;
                            }
                            if (TrafficEventFrame.this.model.getValueAt(row, 10) == null || String.valueOf(TrafficEventFrame.this.model.getValueAt(row, 10)).trim().equals("")) {
                                return;
                            }
                            if (TrafficEventFrame.this.model.getValueAt(row, 11) == null || String.valueOf(TrafficEventFrame.this.model.getValueAt(row, 11)).trim().equals("")) {
                                return;
                            }
                            String str2 = String.valueOf(TrafficEventFrame.this.model.getValueAt(row, 3)).trim().replace(" ", "_").replace("/", "").replace(":", "");
                            String str9 = "_" + String.valueOf(TrafficEventFrame.this.model.getValueAt(row, 9)).trim();
                            String str10 = "-" + String.valueOf(TrafficEventFrame.this.model.getValueAt(row, 10)).trim();
                            String str11 = "-" + String.valueOf(TrafficEventFrame.this.model.getValueAt(row, 11)).trim();
                            String selectPicture = SavePath.getSavePath().getSaveTrafficImagePath() + "Big_Time_" + str2 + str9 + str10 + str11 + ".jpg";
                            BufferedImage bufferedImage = null;
                            if (selectPicture == null || selectPicture.equals("")) {
                                return;
                            }
                            File file = new File(selectPicture);
                            if (!file.exists()) {
                                return;
                            }
                            try {
                                bufferedImage = ImageIO.read(file);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            ListPictureShowDialog demo = new ListPictureShowDialog();
                            demo.listPanel.setOpaque(false);
                            demo.listPanel.setImage(bufferedImage);
                            demo.setVisible(true);
                        }
                    });
                }
            });
        }
    }

    private class EventInfoPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public EventInfoPanel() {
            Dimension dimension = new Dimension(-1, -1);
            BorderEx.set(this, Res.string().getEventPicture(), 2);
            this.setLayout(new BorderLayout());
            JPanel paramPanel = new JPanel();
            JPanel textPanel = new JPanel();
            JPanel platePanel = new JPanel();
            TrafficEventFrame.this.plateImagePanel = new PaintPanel();
            TrafficEventFrame.this.plateImageLabel = new JLabel(Res.string().getPlatePicture());
            dimension.width = 145;
            dimension.height = 49;
            TrafficEventFrame.this.plateImagePanel.setPreferredSize(dimension);
            platePanel.setLayout(new BorderLayout());
            platePanel.add((Component)TrafficEventFrame.this.plateImagePanel, "South");
            platePanel.add((Component)TrafficEventFrame.this.plateImageLabel, "Center");
            TrafficEventFrame.this.eventnameLabel = new JLabel(Res.string().getEventName());
            TrafficEventFrame.this.eventnameTextField = new JTextField("");
            TrafficEventFrame.this.eventTimeLabel = new JLabel(Res.string().getEventTime());
            TrafficEventFrame.this.eventTimeTextField = new JTextField("");
            TrafficEventFrame.this.licensePlateLabel = new JLabel(Res.string().getLicensePlate());
            TrafficEventFrame.this.licensePlateTextField = new JTextField("");
            dimension.width = 165;
            dimension.height = 45;
            paramPanel.setPreferredSize(dimension);
            paramPanel.setLayout(new BorderLayout());
            paramPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            textPanel.setLayout(new GridLayout(6, 2));
            textPanel.add(TrafficEventFrame.this.eventnameLabel);
            textPanel.add(TrafficEventFrame.this.eventnameTextField);
            textPanel.add(TrafficEventFrame.this.eventTimeLabel);
            textPanel.add(TrafficEventFrame.this.eventTimeTextField);
            textPanel.add(TrafficEventFrame.this.licensePlateLabel);
            textPanel.add(TrafficEventFrame.this.licensePlateTextField);
            TrafficEventFrame.this.eventnameTextField.setEditable(false);
            TrafficEventFrame.this.eventTimeTextField.setEditable(false);
            TrafficEventFrame.this.licensePlateTextField.setEditable(false);
            paramPanel.add((Component)platePanel, "North");
            paramPanel.add((Component)textPanel, "Center");
            TrafficEventFrame.this.SnapImagePanel = new PaintPanel();
            TrafficEventFrame.this.SnapImagePanel.setSize(291, 200);
            JPanel snapJPanel = new JPanel();
            snapJPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            snapJPanel.setLayout(new BorderLayout());
            snapJPanel.add((Component)TrafficEventFrame.this.SnapImagePanel, "Center");
            this.add((Component)snapJPanel, "Center");
            this.add((Component)paramPanel, "West");
        }
    }

    private class RealPlayPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public RealPlayPanel() {
            BorderEx.set(this, Res.string().getRealplay(), 2);
            this.setLayout(new BorderLayout());
            Dimension dim = this.getPreferredSize();
            dim.height = 280;
            dim.width = 320;
            this.setPreferredSize(dim);
            JPanel reaJPanel = new JPanel();
            reaJPanel.setLayout(new BorderLayout());
            reaJPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.add((Component)reaJPanel, "Center");
            TrafficEventFrame.this.realPlayWindow = new Panel();
            TrafficEventFrame.this.realPlayWindow.setBackground(Color.GRAY);
            reaJPanel.add((Component)TrafficEventFrame.this.realPlayWindow, "Center");
        }
    }

    private class OperatePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public OperatePanel() {
            BorderEx.set(this, Res.string().getOperate(), 2);
            this.setLayout(new FlowLayout());
            TrafficEventFrame.this.chnlabel = new JLabel(Res.string().getChannel());
            TrafficEventFrame.this.chnComboBox = new JComboBox();
            JLabel nullLabel2 = new JLabel("   ");
            JLabel nullLabel3 = new JLabel("   ");
            JLabel nullLabel4 = new JLabel("   ");
            JLabel nullLabel5 = new JLabel("   ");
            TrafficEventFrame.this.realplayBtn = new JButton(Res.string().getStartRealPlay());
            TrafficEventFrame.this.attachBtn = new JButton(Res.string().getAttach());
            TrafficEventFrame.this.manualSnapBtn = new JButton(Res.string().getManualCapture());
            TrafficEventFrame.this.openStrobeButton = new JButton(Res.string().getOpenStrobe());
            TrafficEventFrame.this.chnComboBox.setPreferredSize(new Dimension(100, 20));
            TrafficEventFrame.this.realplayBtn.setPreferredSize(new Dimension(125, 20));
            TrafficEventFrame.this.attachBtn.setPreferredSize(new Dimension(120, 20));
            TrafficEventFrame.this.manualSnapBtn.setPreferredSize(new Dimension(125, 20));
            TrafficEventFrame.this.openStrobeButton.setPreferredSize(new Dimension(120, 20));
            this.add(TrafficEventFrame.this.chnlabel);
            this.add(TrafficEventFrame.this.chnComboBox);
            this.add(nullLabel2);
            this.add(TrafficEventFrame.this.realplayBtn);
            this.add(nullLabel3);
            this.add(TrafficEventFrame.this.attachBtn);
            this.add(nullLabel4);
            this.add(TrafficEventFrame.this.manualSnapBtn);
            this.add(nullLabel5);
            this.add(TrafficEventFrame.this.openStrobeButton);
            TrafficEventFrame.this.chnComboBox.setEnabled(false);
            TrafficEventFrame.this.realplayBtn.setEnabled(false);
            TrafficEventFrame.this.attachBtn.setEnabled(false);
            TrafficEventFrame.this.manualSnapBtn.setEnabled(false);
            TrafficEventFrame.this.openStrobeButton.setEnabled(false);
            TrafficEventFrame.this.realplayBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TrafficEventFrame.this.realplay();
                }
            });
            TrafficEventFrame.this.attachBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TrafficEventFrame.this.attach();
                }
            });
            TrafficEventFrame.this.manualSnapBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!TrafficEventModule.manualSnapPicture(TrafficEventFrame.this.chnComboBox.getSelectedIndex())) {
                        JOptionPane.showMessageDialog(null, Res.string().getManualCaptureFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
                    }
                }
            });
            TrafficEventFrame.this.openStrobeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrafficEventFrame.this.openstrobe();
                }
            });
        }
    }

    private class ItsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public ItsPanel() {
            BorderEx.set(this, null, 2);
            this.setLayout(new BorderLayout());
            TrafficEventFrame.this.operatePanel = new OperatePanel();
            TrafficEventFrame.this.realPlayPanel = new RealPlayPanel();
            TrafficEventFrame.this.eventInfoPanel = new EventInfoPanel();
            TrafficEventFrame.this.messagePanel = new MessagePanel();
            this.add((Component)TrafficEventFrame.this.operatePanel, "North");
            this.add((Component)TrafficEventFrame.this.realPlayPanel, "West");
            this.add((Component)TrafficEventFrame.this.eventInfoPanel, "Center");
            this.add((Component)TrafficEventFrame.this.messagePanel, "South");
        }
    }

    private static class HaveReConnect
    implements NetSDKLib.fHaveReConnect {
        private HaveReConnect() {
        }

        @Override
        public void invoke(NetSDKLib.LLong m_hLoginHandle, String pchDVRIP, int nDVRPort, Pointer dwUser) {
            System.out.printf("ReConnect Device[%s] Port[%d]\n", pchDVRIP, nDVRPort);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.setTitle(Res.string().getITSEvent() + " : " + Res.string().getOnline());
                }
            });
        }
    }

    private static class DisConnect
    implements NetSDKLib.fDisConnect {
        private DisConnect() {
        }

        @Override
        public void invoke(NetSDKLib.LLong m_hLoginHandle, String pchDVRIP, int nDVRPort, Pointer dwUser) {
            System.out.printf("Device[%s] Port[%d] DisConnect!\n", pchDVRIP, nDVRPort);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.setTitle(Res.string().getITSEvent() + " : " + Res.string().getDisConnectReconnecting());
                }
            });
        }
    }

    private class TRAFFIC_INFO {
        private String m_EventName;
        private String m_PlateNumber;
        private String m_PlateType;
        private String m_PlateColor;
        private String m_VehicleColor;
        private String m_VehicleType;
        private String m_VehicleSize;
        private String m_FileCount;
        private String m_FileIndex;
        private String m_GroupID;
        private String m_IllegalPlace;
        private String m_LaneNumber;
        private NetSDKLib.NET_TIME_EX m_Utc;
        private int m_bPicEnble;
        private int m_OffSet;
        private int m_FileLength;
        private NetSDKLib.DH_RECT m_BoundingBox;

        private TRAFFIC_INFO() {
        }
    }
}

