/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.vto;

import com.netsdk.common.Base64;
import com.netsdk.common.Res;
import com.netsdk.demo.frame.vto.VTOMessageCallBack;
import com.netsdk.demo.module.LoginModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.Memory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class CollectionFingerPrint
extends JDialog {
    private final JPanel contentPanel = new JPanel();
    private JTextField ipTextField;
    private JTextField portTextField;
    private JTextField usernameTextField;
    private JPasswordField passwordField;
    private JLabel collectionResult;
    private JButton btnLogin;
    private JButton btnLogout;
    private JButton btnCollection;
    private byte[] packageData;
    private int packageLen;
    private boolean bcollectionResult = false;
    private boolean isListen;
    private NetSDKLib.LLong loginHandler;
    private NetSDKLib.NET_DEVICEINFO_Ex deviceinfoEx = new NetSDKLib.NET_DEVICEINFO_Ex();

    public byte[] getPackageData() {
        return this.packageData;
    }

    public void setPackageData(byte[] packageData) {
        this.packageData = packageData;
    }

    public void setLabelResult(byte[] packageData) {
        this.collectionResult.setText(Base64.getEncoder().encodeToString(packageData));
    }

    public int getPackageLen() {
        return this.packageLen;
    }

    public void setPackageLen(int packageLen) {
        this.packageLen = packageLen;
    }

    public boolean isCollectionResult() {
        return this.bcollectionResult;
    }

    public void setCollectionResult(boolean bcollectionResult) {
        this.bcollectionResult = bcollectionResult;
        this.collectionResult.setText(this.bcollectionResult ? "success" : "failed");
    }

    public void stopListen() {
        if (this.loginHandler != null && this.loginHandler.longValue() != 0L) {
            this.stopListen(this.loginHandler);
        }
        this.btnCollection.setEnabled(true);
        this.isListen = false;
    }

    public static void main(String[] args) {
        try {
            CollectionFingerPrint dialog = new CollectionFingerPrint();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CollectionFingerPrint() {
        this.setBounds(100, 100, 304, 397);
        this.setTitle(Res.string().getVTOOperateCollectionFingerPrintTitle());
        this.setDefaultCloseOperation(2);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(null);
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(null, Res.string().getLogin(), 4, 2, null, null));
        panel.setBounds(10, 10, 268, 167);
        this.contentPanel.add(panel);
        panel.setLayout(null);
        JLabel lblNewLabel = new JLabel(Res.string().getIp());
        lblNewLabel.setBounds(10, 23, 66, 15);
        panel.add(lblNewLabel);
        this.ipTextField = new JTextField();
        this.ipTextField.setText("172.23.32.61");
        this.ipTextField.setBounds(103, 20, 155, 21);
        panel.add(this.ipTextField);
        this.ipTextField.setColumns(10);
        JLabel lblPort = new JLabel(Res.string().getPort());
        lblPort.setBounds(10, 48, 83, 15);
        panel.add(lblPort);
        this.portTextField = new JTextField();
        this.portTextField.setText("37777");
        this.portTextField.setColumns(10);
        this.portTextField.setBounds(103, 45, 155, 21);
        panel.add(this.portTextField);
        JLabel lblName = new JLabel(Res.string().getUserName());
        lblName.setBounds(10, 73, 83, 15);
        panel.add(lblName);
        this.usernameTextField = new JTextField();
        this.usernameTextField.setText("admin");
        this.usernameTextField.setColumns(10);
        this.usernameTextField.setBounds(103, 70, 155, 21);
        panel.add(this.usernameTextField);
        JLabel lblPassword = new JLabel(Res.string().getPassword());
        lblPassword.setBounds(10, 98, 90, 15);
        panel.add(lblPassword);
        this.passwordField = new JPasswordField();
        this.passwordField.setBounds(103, 95, 155, 18);
        this.passwordField.setText("admin123");
        panel.add(this.passwordField);
        this.btnLogin = new JButton(Res.string().getLogin());
        this.btnLogin.setBounds(7, 134, 111, 23);
        panel.add(this.btnLogin);
        this.btnLogin.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (CollectionFingerPrint.this.login()) {
                    CollectionFingerPrint.this.btnCollection.setEnabled(true);
                }
            }
        });
        this.btnLogout = new JButton(Res.string().getLogout());
        this.btnLogout.setBounds(153, 134, 105, 23);
        panel.add(this.btnLogout);
        this.btnLogout.setEnabled(false);
        this.btnLogout.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CollectionFingerPrint.this.logout();
            }
        });
        panel = new JPanel();
        panel.setBorder(new TitledBorder(null, Res.string().getOperate(), 4, 2, null, null));
        panel.setBounds(10, 187, 268, 129);
        this.contentPanel.add(panel);
        panel.setLayout(null);
        this.btnCollection = new JButton(Res.string().getStartCollection());
        this.btnCollection.setBounds(10, 26, 227, 41);
        panel.add(this.btnCollection);
        this.collectionResult = new JLabel(Res.string().getCollectionResult());
        this.collectionResult.setBounds(10, 77, 227, 26);
        panel.add(this.collectionResult);
        this.btnCollection.setEnabled(false);
        final CollectionFingerPrint print = this;
        this.btnCollection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionFingerPrint.this.isListen = CollectionFingerPrint.this.startListen(CollectionFingerPrint.this.loginHandler, VTOMessageCallBack.getINSTANCE(null, print));
                if (CollectionFingerPrint.this.isListen) {
                    if (!CollectionFingerPrint.this.collectionFinger()) {
                        CollectionFingerPrint.this.stopListen(CollectionFingerPrint.this.loginHandler);
                    } else {
                        CollectionFingerPrint.this.btnCollection.setEnabled(false);
                    }
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(20000L);
                                if (CollectionFingerPrint.this.isListen) {
                                    CollectionFingerPrint.this.stopListen();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                    }).start();
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                if (CollectionFingerPrint.this.loginHandler != null && CollectionFingerPrint.this.loginHandler.longValue() != 0L) {
                    if (CollectionFingerPrint.this.isListen) {
                        CollectionFingerPrint.this.stopListen(CollectionFingerPrint.this.loginHandler);
                    }
                    CollectionFingerPrint.this.logout();
                }
                CollectionFingerPrint.this.btnLogin.setEnabled(true);
                CollectionFingerPrint.this.btnLogout.setEnabled(false);
                CollectionFingerPrint.this.btnCollection.setEnabled(false);
                CollectionFingerPrint.this.bcollectionResult = false;
                CollectionFingerPrint.access$602(CollectionFingerPrint.this, null);
                CollectionFingerPrint.this.collectionResult.setText(Res.string().getCollectionResult());
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("OK");
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionFingerPrint.this.setVisible(false);
            }
        });
    }

    public boolean login() {
        if (!this.login(this.ipTextField.getText(), Integer.parseInt(this.portTextField.getText()), this.usernameTextField.getText(), new String(this.passwordField.getPassword()))) {
            JOptionPane.showMessageDialog(null, Res.string().getLoginFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return false;
        }
        this.btnLogin.setEnabled(false);
        this.btnLogout.setEnabled(true);
        this.btnCollection.setEnabled(true);
        return true;
    }

    public boolean login(String m_strIp, int m_nPort, String m_strUser, String m_strPassword) {
        NetSDKLib.NET_IN_LOGIN_WITH_HIGHLEVEL_SECURITY pstInParam = new NetSDKLib.NET_IN_LOGIN_WITH_HIGHLEVEL_SECURITY();
        pstInParam.nPort = m_nPort;
        pstInParam.szIP = m_strIp.getBytes();
        pstInParam.szPassword = m_strPassword.getBytes();
        pstInParam.szUserName = m_strUser.getBytes();
        NetSDKLib.NET_OUT_LOGIN_WITH_HIGHLEVEL_SECURITY pstOutParam = new NetSDKLib.NET_OUT_LOGIN_WITH_HIGHLEVEL_SECURITY();
        pstOutParam.stuDeviceInfo = this.deviceinfoEx;
        this.loginHandler = LoginModule.netsdk.CLIENT_LoginWithHighLevelSecurity(pstInParam, pstOutParam);
        if (this.loginHandler.longValue() == 0L) {
            JOptionPane.showMessageDialog(null, Res.string().getLoginFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
        } else {
            System.out.println("Login Success [ " + m_strIp + " ]");
        }
        return this.loginHandler.longValue() != 0L;
    }

    public long getLoginHandler() {
        if (this.loginHandler != null) {
            return this.loginHandler.longValue();
        }
        return 0L;
    }

    public boolean logout() {
        if (this.loginHandler.longValue() == 0L) {
            return false;
        }
        boolean bRet = LoginModule.netsdk.CLIENT_Logout(this.loginHandler);
        if (bRet) {
            this.loginHandler.setValue(0L);
            this.btnLogin.setEnabled(true);
            this.btnLogout.setEnabled(false);
        } else {
            JOptionPane.showMessageDialog(null, Res.string().getLoginFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
        }
        return bRet;
    }

    public boolean collectionFinger() {
        NetSDKLib.NET_CTRL_CAPTURE_FINGER_PRINT capture = new NetSDKLib.NET_CTRL_CAPTURE_FINGER_PRINT();
        capture.nChannelID = 0;
        System.arraycopy("1".getBytes(), 0, capture.szReaderID, 0, "1".getBytes().length);
        Memory pointer = new Memory(capture.size());
        ToolKits.SetStructDataToPointer(capture, pointer, 0L);
        boolean ret = LoginModule.netsdk.CLIENT_ControlDevice(this.loginHandler, 416, pointer, 100000);
        if (!ret) {
            JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return false;
        }
        return true;
    }

    public boolean startListen(NetSDKLib.LLong loginHandler, NetSDKLib.fMessCallBack cbMessage) {
        LoginModule.netsdk.CLIENT_SetDVRMessCallBack(cbMessage, null);
        if (!LoginModule.netsdk.CLIENT_StartListenEx(loginHandler)) {
            JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return false;
        }
        System.out.println("CLIENT_StartListenEx success.");
        return true;
    }

    public boolean stopListen(NetSDKLib.LLong loginHandler) {
        if (!LoginModule.netsdk.CLIENT_StopListen(loginHandler)) {
            JOptionPane.showMessageDialog(null, Res.string().getStopListenFailed() + "," + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return false;
        }
        System.out.println("CLIENT_StopListen success.");
        return true;
    }

    public void clearStatus() {
        this.setPackageData(null);
        this.setCollectionResult(false);
        this.setPackageLen(0);
    }

    static /* synthetic */ byte[] access$602(CollectionFingerPrint x0, byte[] x1) {
        x0.packageData = x1;
        return x1;
    }
}

