/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.frame.vto;

import com.netsdk.common.FunctionList;
import com.netsdk.common.PaintPanel;
import com.netsdk.common.Res;
import com.netsdk.demo.frame.vto.DefaultDisConnect;
import com.netsdk.demo.frame.vto.DefaultHaveReconnect;
import com.netsdk.demo.frame.vto.OperateManager;
import com.netsdk.demo.frame.vto.VTOAnalyzerCallBack;
import com.netsdk.demo.frame.vto.VTOMessageCallBack;
import com.netsdk.demo.module.AlarmListenModule;
import com.netsdk.demo.module.GateModule;
import com.netsdk.demo.module.LoginModule;
import com.netsdk.demo.module.RealPlayModule;
import com.netsdk.demo.module.TalkModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.Memory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class VTODemo
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private JTextField ipTextField;
    private JTextField portTextField;
    private JTextField userNameTextField;
    private JPasswordField passwordField;
    private JTable alarmTable;
    private Panel realPlay;
    private PaintPanel imagePanel;
    private JButton btnLogin;
    private JButton btnLogout;
    private JButton btnRealPlay;
    private JButton btnStopplay;
    private JButton btnTalk;
    private JButton btnStoptalk;
    private JButton btnOpendoor;
    private JButton btnClosedoor;
    private JButton btnOperate;
    private JButton btnStartlisten;
    private JButton btnStoplisten;
    private JButton btnStartrealload;
    private JButton btnStoprealload;
    JTabbedPane tabbedPane;
    private static boolean b_RealPlay = false;
    private static boolean b_Attachment = false;
    private boolean isListen = false;
    private static JFrame mainFrame = new JFrame();
    private OperateManager manager = new OperateManager();
    private Object[][] alarmData;
    private Object[][] realData;
    private DefaultTableModel alarmModel;
    private DefaultTableModel realModel;
    private final String[] alarmTableTitle = new String[]{Res.string().getVTOAlarmEventRoomNo(), Res.string().getVTOAlarmEventCardNo(), Res.string().getVTOAlarmEventTime(), Res.string().getVTOAlarmEventOpenMethod(), Res.string().getVTOAlarmEventStatus()};
    private final String[] realTableTitle = new String[]{Res.string().getVTORealLoadRoomNO(), Res.string().getVTORealLoadCardNo(), Res.string().getVTORealLoadTime(), Res.string().getVTORealLoadEventInfo()};
    private NetSDKLib.LLong m_hPlayHandle;
    private NetSDKLib.LLong m_attachHandle;
    private JTable realLoadTable;
    private JScrollPane realScrollPane;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    VTODemo frame = new VTODemo();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public VTODemo() {
        this.setTitle(Res.string().getVTO());
        this.setBounds(100, 100, 920, 651);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LoginModule.init(DefaultDisConnect.GetInstance(), DefaultHaveReconnect.getINSTANCE());
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), Res.string().getLogin(), 1, 2, null, new Color(0, 0, 0)));
        panel.setBounds(0, 0, 905, 46);
        this.contentPane.add(panel);
        panel.setLayout(null);
        JLabel ipLabel = new JLabel(Res.string().getIp());
        ipLabel.setBounds(10, 15, 44, 21);
        panel.add(ipLabel);
        this.ipTextField = new JTextField();
        this.ipTextField.setText("10.34.3.63");
        this.ipTextField.setBounds(64, 15, 89, 21);
        panel.add(this.ipTextField);
        this.ipTextField.setColumns(10);
        JLabel portLabel = new JLabel(Res.string().getPort());
        portLabel.setBounds(174, 15, 44, 21);
        panel.add(portLabel);
        this.portTextField = new JTextField();
        this.portTextField.setText("37777");
        this.portTextField.setColumns(10);
        this.portTextField.setBounds(228, 15, 66, 21);
        panel.add(this.portTextField);
        JLabel lblName = new JLabel(Res.string().getUserName());
        lblName.setBounds(316, 15, 66, 21);
        panel.add(lblName);
        this.userNameTextField = new JTextField();
        this.userNameTextField.setText("admin");
        this.userNameTextField.setColumns(10);
        this.userNameTextField.setBounds(383, 15, 87, 21);
        panel.add(this.userNameTextField);
        JLabel lblPassword = new JLabel(Res.string().getPassword());
        lblPassword.setBounds(492, 15, 66, 21);
        panel.add(lblPassword);
        this.passwordField = new JPasswordField();
        this.passwordField.setBounds(568, 15, 112, 21);
        this.passwordField.setText("admin123");
        panel.add(this.passwordField);
        this.btnLogin = new JButton(Res.string().getLogin());
        this.btnLogin.setBounds(684, 14, 99, 23);
        panel.add(this.btnLogin);
        this.btnLogin.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                VTODemo.this.login();
            }
        });
        this.btnLogout = new JButton(Res.string().getLogout());
        this.btnLogout.setBounds(785, 14, 110, 23);
        panel.add(this.btnLogout);
        this.btnLogout.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                VTODemo.this.logout();
            }
        });
        JPanel previewPanel = new JPanel();
        previewPanel.setBorder(new TitledBorder(null, Res.string().getRealplay(), 1, 2, null, null));
        previewPanel.setBounds(10, 56, 409, 313);
        this.contentPane.add(previewPanel);
        previewPanel.setLayout(new BorderLayout(0, 0));
        this.realPlay = new Panel();
        this.realPlay.setBackground(Color.GRAY);
        previewPanel.add((Component)this.realPlay, "Center");
        JPanel operatePanel = new JPanel();
        operatePanel.setBorder(new TitledBorder(null, Res.string().getOperate(), 1, 2, null, null));
        operatePanel.setBounds(429, 56, 452, 194);
        this.contentPane.add(operatePanel);
        operatePanel.setLayout(null);
        this.btnRealPlay = new JButton(Res.string().getStartRealPlay());
        this.btnRealPlay.setBounds(37, 23, 162, 29);
        operatePanel.add(this.btnRealPlay);
        this.btnRealPlay.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                VTODemo.this.realPlay();
            }
        });
        this.btnTalk = new JButton(Res.string().getStartTalk());
        this.btnTalk.setBounds(248, 23, 152, 29);
        operatePanel.add(this.btnTalk);
        this.btnTalk.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                VTODemo.this.talk();
            }
        });
        this.btnStopplay = new JButton(Res.string().getStopRealPlay());
        this.btnStopplay.setBounds(37, 62, 162, 29);
        operatePanel.add(this.btnStopplay);
        this.btnStopplay.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                VTODemo.this.stopPlay();
            }
        });
        this.btnStoptalk = new JButton(Res.string().getStopTalk());
        this.btnStoptalk.setBounds(248, 62, 152, 29);
        operatePanel.add(this.btnStoptalk);
        this.btnStoptalk.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                VTODemo.this.stopTalk();
            }
        });
        this.btnOpendoor = new JButton(Res.string().getDoorOpen());
        this.btnOpendoor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                VTODemo.this.openDoor();
            }
        });
        this.btnOpendoor.setBounds(37, 110, 162, 29);
        operatePanel.add(this.btnOpendoor);
        this.btnClosedoor = new JButton(Res.string().getDoorClose());
        this.btnClosedoor.setBounds(37, 149, 162, 29);
        operatePanel.add(this.btnClosedoor);
        this.btnClosedoor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                VTODemo.this.closeDoor();
            }
        });
        this.btnOperate = new JButton(Res.string().getCardOperate());
        this.btnOperate.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (VTODemo.this.manager == null) {
                    VTODemo.this.manager = new OperateManager();
                }
                VTODemo.this.manager.setVisible(true);
            }
        });
        this.btnOperate.setBounds(248, 125, 152, 29);
        operatePanel.add(this.btnOperate);
        JPanel eventOperate = new JPanel();
        eventOperate.setBorder(new TitledBorder(null, Res.string().getEventOperate(), 1, 2, null, null));
        eventOperate.setBounds(429, 260, 452, 104);
        this.contentPane.add(eventOperate);
        eventOperate.setLayout(null);
        this.btnStartlisten = new JButton(Res.string().getStartListen());
        this.btnStartlisten.setBounds(35, 21, 178, 29);
        eventOperate.add(this.btnStartlisten);
        this.btnStartlisten.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                VTODemo.this.isListen = VTODemo.this.startListen();
                VTODemo.this.tabbedPane.setSelectedIndex(0);
            }
        });
        this.btnStoplisten = new JButton(Res.string().getStopListen());
        this.btnStoplisten.setBounds(35, 60, 178, 29);
        eventOperate.add(this.btnStoplisten);
        this.btnStoplisten.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ((DefaultTableModel)VTODemo.this.alarmTable.getModel()).setRowCount(0);
                VTODemo.this.stopListen();
            }
        });
        this.btnStartrealload = new JButton(Res.string().getStartRealLoad());
        this.btnStartrealload.setBounds(234, 21, 195, 29);
        eventOperate.add(this.btnStartrealload);
        this.btnStartrealload.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                VTODemo.this.startRealLoad();
                VTODemo.this.tabbedPane.setSelectedIndex(1);
            }
        });
        this.btnStoprealload = new JButton(Res.string().getStopRealLoad());
        this.btnStoprealload.setBounds(234, 60, 195, 29);
        eventOperate.add(this.btnStoprealload);
        this.btnStoprealload.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ((DefaultTableModel)VTODemo.this.realLoadTable.getModel()).setRowCount(0);
                VTODemo.this.stopRealLoad();
                VTODemo.this.imagePanel.setImage(null);
                VTODemo.this.imagePanel.repaint();
            }
        });
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setBounds(10, 379, 871, 224);
        this.contentPane.add(this.tabbedPane);
        JPanel alarmPanel = new JPanel();
        alarmPanel.setBorder(new TitledBorder(null, Res.string().getEventInfo(), 1, 2, null, null));
        this.tabbedPane.addTab(Res.string().getAlarmEvent(), null, alarmPanel, null);
        alarmPanel.setLayout(new BorderLayout(0, 0));
        this.alarmData = new Object[0][5];
        this.alarmTable = this.tableInit(this.alarmData, this.alarmTableTitle);
        this.alarmModel = (DefaultTableModel)this.alarmTable.getModel();
        JScrollPane scrollPane = new JScrollPane(this.alarmTable);
        scrollPane.setHorizontalScrollBarPolicy(30);
        alarmPanel.add((Component)scrollPane, "Center");
        JPanel realLoadPanel = new JPanel();
        realLoadPanel.setBorder(new TitledBorder(null, Res.string().getVTORealLoadEventInfo(), 1, 2, null, null));
        this.tabbedPane.addTab(Res.string().getRealLoadEvent(), null, realLoadPanel, null);
        realLoadPanel.setLayout(null);
        this.imagePanel = new PaintPanel();
        this.imagePanel.setBounds(671, 20, 185, 165);
        realLoadPanel.add(this.imagePanel);
        this.realData = new Object[0][4];
        this.realLoadTable = this.tableInit(this.realData, this.realTableTitle);
        this.realModel = (DefaultTableModel)this.realLoadTable.getModel();
        this.realScrollPane = new JScrollPane(this.realLoadTable);
        this.realScrollPane.setBounds(10, 20, 654, 165);
        this.realScrollPane.setHorizontalScrollBarPolicy(30);
        realLoadPanel.add(this.realScrollPane);
        this.btnEnable(false);
        this.btnLogin.setEnabled(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (LoginModule.m_hLoginHandle.longValue() != 0L) {
                    VTODemo.this.logout();
                }
                LoginModule.cleanup();
                VTODemo.this.dispose();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FunctionList demo = new FunctionList();
                        demo.setVisible(true);
                    }
                });
            }
        });
    }

    public void btnEnable(boolean enable) {
        this.btnLogin.setEnabled(enable);
        this.btnLogout.setEnabled(enable);
        this.btnRealPlay.setEnabled(enable);
        this.btnStopplay.setEnabled(enable);
        this.btnTalk.setEnabled(enable);
        this.btnStoptalk.setEnabled(enable);
        this.btnOpendoor.setEnabled(enable);
        this.btnClosedoor.setEnabled(enable);
        this.btnOperate.setEnabled(enable);
        this.btnStartlisten.setEnabled(enable);
        this.btnStoplisten.setEnabled(enable);
        this.btnStartrealload.setEnabled(enable);
        this.btnStoprealload.setEnabled(enable);
    }

    public JTable tableInit(Object[][] data, String[] columnName) {
        DefaultTableModel model = new DefaultTableModel(data, columnName);
        JTable table = new JTable(model){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        model = (DefaultTableModel)table.getModel();
        table.setSelectionMode(0);
        DefaultTableCellRenderer dCellRenderer = new DefaultTableCellRenderer();
        dCellRenderer.setHorizontalAlignment(0);
        table.setDefaultRenderer(Object.class, dCellRenderer);
        return table;
    }

    public boolean login() {
        if (!LoginModule.login(this.ipTextField.getText(), Integer.parseInt(this.portTextField.getText()), this.userNameTextField.getText(), new String(this.passwordField.getPassword()))) {
            JOptionPane.showMessageDialog(null, Res.string().getLoginFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return false;
        }
        this.btnEnable(true);
        this.btnLogin.setEnabled(false);
        this.btnRealPlay.setEnabled(true);
        this.btnStopplay.setEnabled(false);
        this.btnStartlisten.setEnabled(true);
        this.btnStoplisten.setEnabled(false);
        this.btnStartrealload.setEnabled(true);
        this.btnStoprealload.setEnabled(false);
        this.btnTalk.setEnabled(true);
        this.btnStoptalk.setEnabled(false);
        return true;
    }

    public void logout() {
        if (b_RealPlay) {
            this.stopPlay();
        }
        if (TalkModule.m_hTalkHandle != null) {
            this.stopTalk();
        }
        if (this.isListen) {
            this.stopListen();
            this.isListen = false;
        }
        this.stopRealLoad();
        LoginModule.logout();
        this.btnEnable(false);
        ((DefaultTableModel)this.alarmTable.getModel()).setRowCount(0);
        ((DefaultTableModel)this.realLoadTable.getModel()).setRowCount(0);
        this.imagePanel.setImage(null);
        this.imagePanel.repaint();
        this.btnLogin.setEnabled(true);
    }

    public void realPlay() {
        if (!b_RealPlay) {
            this.m_hPlayHandle = RealPlayModule.startRealPlay(0, 0, this.realPlay);
            if (this.m_hPlayHandle.longValue() != 0L) {
                b_RealPlay = true;
                this.btnRealPlay.setEnabled(false);
                this.btnStopplay.setEnabled(true);
            } else {
                JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            }
        }
    }

    public void stopPlay() {
        if (b_RealPlay) {
            RealPlayModule.stopRealPlay(this.m_hPlayHandle);
            this.realPlay.repaint();
            b_RealPlay = false;
            this.btnRealPlay.setEnabled(true);
            this.btnStopplay.setEnabled(false);
        }
    }

    public void talk() {
        if (TalkModule.startTalk(0, 0)) {
            this.btnTalk.setEnabled(false);
            this.btnStoptalk.setEnabled(true);
        } else {
            JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
        }
    }

    public void stopTalk() {
        TalkModule.stopTalk();
        this.btnTalk.setEnabled(true);
        this.btnStoptalk.setEnabled(false);
    }

    public void openDoor() {
        NetSDKLib.NET_CTRL_ACCESS_OPEN openInfo = new NetSDKLib.NET_CTRL_ACCESS_OPEN();
        openInfo.nChannelID = 0;
        openInfo.emOpenDoorType = 1;
        Memory pointer = new Memory(openInfo.size());
        ToolKits.SetStructDataToPointer(openInfo, pointer, 0L);
        boolean ret = LoginModule.netsdk.CLIENT_ControlDeviceEx(LoginModule.m_hLoginHandle, 254, pointer, null, 10000);
        if (!ret) {
            JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return;
        }
    }

    public void closeDoor() {
        NetSDKLib.NET_CTRL_ACCESS_CLOSE close = new NetSDKLib.NET_CTRL_ACCESS_CLOSE();
        close.nChannelID = 0;
        close.write();
        Memory pointer = new Memory(close.size());
        boolean result = LoginModule.netsdk.CLIENT_ControlDeviceEx(LoginModule.m_hLoginHandle, 260, close.getPointer(), null, 5000);
        close.read();
        if (!result) {
            JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
        }
    }

    public boolean startListen() {
        if (!AlarmListenModule.startListen(VTOMessageCallBack.getINSTANCE(this.alarmTable, null))) {
            JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            return false;
        }
        this.btnStartlisten.setEnabled(false);
        this.btnStoplisten.setEnabled(true);
        return true;
    }

    public void stopListen() {
        if (this.isListen) {
            if (AlarmListenModule.stopListen()) {
                this.isListen = false;
                this.btnStartlisten.setEnabled(true);
                this.btnStoplisten.setEnabled(false);
            } else {
                JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), 0);
            }
        }
    }

    public void startRealLoad() {
        this.m_attachHandle = GateModule.realLoadPic(0, VTOAnalyzerCallBack.getINSTANCE(this.realLoadTable, this.imagePanel));
        if (this.m_attachHandle != null && this.m_attachHandle.longValue() != 0L) {
            this.btnStartrealload.setEnabled(false);
            this.btnStoprealload.setEnabled(true);
        }
    }

    public void stopRealLoad() {
        if (this.m_attachHandle != null && this.m_attachHandle.longValue() != 0L) {
            GateModule.stopRealLoadPic(this.m_attachHandle);
            this.m_attachHandle.setValue(0L);
            this.btnStartrealload.setEnabled(true);
            this.btnStoprealload.setEnabled(false);
        }
    }
}

