/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.module;

import com.netsdk.demo.module.LoginModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.ptr.IntByReference;

public class CapturePictureModule {
    public static boolean localCapturePicture(NetSDKLib.LLong hPlayHandle, String picFileName) {
        if (!LoginModule.netsdk.CLIENT_CapturePictureEx(hPlayHandle, picFileName, 1)) {
            System.err.printf("CLIENT_CapturePicture Failed!" + ToolKits.getErrorCodePrint(), new Object[0]);
            return false;
        }
        System.out.println("CLIENT_CapturePicture success");
        return true;
    }

    public static boolean remoteCapturePicture(int chn) {
        return CapturePictureModule.snapPicture(chn, 0, 0);
    }

    public static boolean timerCapturePicture(int chn) {
        return CapturePictureModule.snapPicture(chn, 1, 2);
    }

    public static boolean stopCapturePicture(int chn) {
        return CapturePictureModule.snapPicture(chn, -1, 0);
    }

    private static boolean snapPicture(int chn, int mode, int interval) {
        NetSDKLib.SNAP_PARAMS stuSnapParams = new NetSDKLib.SNAP_PARAMS();
        stuSnapParams.Channel = chn;
        stuSnapParams.mode = mode;
        stuSnapParams.Quality = 3;
        stuSnapParams.InterSnap = interval;
        stuSnapParams.CmdSerial = 0;
        IntByReference reserved = new IntByReference(0);
        if (!LoginModule.netsdk.CLIENT_SnapPictureEx(LoginModule.m_hLoginHandle, stuSnapParams, reserved)) {
            System.err.printf("CLIENT_SnapPictureEx Failed!" + ToolKits.getErrorCodePrint(), new Object[0]);
            return false;
        }
        System.out.println("CLIENT_SnapPictureEx success");
        return true;
    }

    public static void setSnapRevCallBack(NetSDKLib.fSnapRev cbSnapReceive) {
        LoginModule.netsdk.CLIENT_SetSnapRevCallBack(cbSnapReceive, null);
    }
}

