/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.module;

import com.netsdk.demo.module.LoginModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.netsdk.lib.enumeration.EM_SEND_SEARCH_TYPE;
import com.netsdk.lib.structure.NET_IN_STARTSERACH_DEVICE;
import com.netsdk.lib.structure.NET_OUT_STARTSERACH_DEVICE;
import com.sun.jna.Callback;
import com.sun.jna.Memory;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class DeviceSearchModule {
    public static NetSDKLib.LLong multiBroadcastDeviceSearch(NetSDKLib.fSearchDevicesCBEx cbSearchDevices, String szlocalIp) throws SocketException {
        NET_IN_STARTSERACH_DEVICE pInparm = new NET_IN_STARTSERACH_DEVICE();
        pInparm.cbSearchDevices = cbSearchDevices;
        System.arraycopy(szlocalIp.getBytes(), 0, pInparm.szLocalIp, 0, szlocalIp.getBytes().length);
        pInparm.emSendType = EM_SEND_SEARCH_TYPE.EM_SEND_SEARCH_TYPE_MULTICAST_AND_BROADCAST.ordinal();
        Memory pInBuf = new Memory(pInparm.size());
        ToolKits.SetStructDataToPointer(pInparm, pInBuf, 0L);
        NET_OUT_STARTSERACH_DEVICE pOutparm = new NET_OUT_STARTSERACH_DEVICE();
        Memory pOutBuf = new Memory(pOutparm.size());
        ToolKits.SetStructDataToPointer(pOutparm, pOutBuf, 0L);
        return LoginModule.netsdk.CLIENT_StartSearchDevicesEx(pInBuf, pOutBuf);
    }

    public static void stopDeviceSearch(NetSDKLib.LLong m_DeviceSearchHandle) {
        if (m_DeviceSearchHandle.longValue() == 0L) {
            return;
        }
        LoginModule.netsdk.CLIENT_StopSearchDevices(m_DeviceSearchHandle);
        m_DeviceSearchHandle.setValue(0L);
    }

    public static boolean unicastDeviceSearch(String localIp, String startIP, int nIpNum, NetSDKLib.fSearchDevicesCB cbSearchDevices) throws SocketException {
        String[] szIPStr = startIP.split("\\.");
        NetSDKLib.DEVICE_IP_SEARCH_INFO deviceSearchInfo = new NetSDKLib.DEVICE_IP_SEARCH_INFO();
        deviceSearchInfo.nIpNum = nIpNum;
        for (int i = 0; i < deviceSearchInfo.nIpNum; ++i) {
            System.arraycopy(DeviceSearchModule.getIp(szIPStr, i).getBytes(), 0, deviceSearchInfo.szIPArr[i].szIP, 0, DeviceSearchModule.getIp(szIPStr, i).getBytes().length);
        }
        if (LoginModule.netsdk.CLIENT_SearchDevicesByIPs(deviceSearchInfo, (Callback)cbSearchDevices, null, localIp, 6000)) {
            System.out.println("SearchDevicesByIPs Succeed!");
            return true;
        }
        return false;
    }

    public static String getIp(String[] ip, int num) {
        String szIp = "";
        szIp = Integer.parseInt(ip[3]) >= 255 ? ip[0] + "." + ip[1] + "." + String.valueOf(Integer.parseInt(ip[2]) + 1) + "." + String.valueOf(Integer.parseInt(ip[3]) + num - 255) : ip[0] + "." + ip[1] + "." + ip[2] + "." + String.valueOf(Integer.parseInt(ip[3]) + num);
        return szIp;
    }

    public static List<String> getHostAddress() throws SocketException {
        ArrayList<String> ipList = new ArrayList<String>();
        if (NetworkInterface.getNetworkInterfaces() == null) {
            return ipList;
        }
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || !(inetAddress instanceof Inet4Address)) continue;
                String localname = inetAddress.getHostName();
                String localip = inetAddress.getHostAddress();
                ipList.add(localip);
            }
        }
        return ipList;
    }
}

