/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.module;

import com.netsdk.demo.module.LoginModule;
import com.netsdk.lib.NativeString;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.Memory;
import com.sun.jna.Structure;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class FaceRecognitionModule {
    private static NetSDKLib.LLong m_FindHandle = null;
    public static int nToken = 0;
    private static NetSDKLib.LLong lFindHandle = new NetSDKLib.LLong(0L);

    public static NetSDKLib.LLong realLoadPicture(int channel, NetSDKLib.fAnalyzerDataCallBack callback) {
        int bNeedPicture = 1;
        NetSDKLib.LLong m_hAttachHandle = LoginModule.netsdk.CLIENT_RealLoadPictureEx(LoginModule.m_hLoginHandle, channel, 1, bNeedPicture, callback, null, null);
        if (m_hAttachHandle.longValue() == 0L) {
            System.err.println("CLIENT_RealLoadPictureEx Failed, Error:" + ToolKits.getErrorCodePrint());
        } else {
            System.out.println("\u901a\u9053[" + channel + "]\u8ba2\u9605\u6210\u529f\uff01");
        }
        return m_hAttachHandle;
    }

    public static void stopRealLoadPicture(NetSDKLib.LLong m_hAttachHandle) {
        if (m_hAttachHandle.longValue() != 0L) {
            LoginModule.netsdk.CLIENT_StopLoadPic(m_hAttachHandle);
            m_hAttachHandle.setValue(0L);
        }
    }

    public static NetSDKLib.NET_FACERECONGNITION_GROUP_INFO[] findGroupInfo(String groupId) {
        NetSDKLib.NET_FACERECONGNITION_GROUP_INFO[] groupInfoRet = null;
        NetSDKLib.NET_IN_FIND_GROUP_INFO stuIn = new NetSDKLib.NET_IN_FIND_GROUP_INFO();
        System.arraycopy(groupId.getBytes(), 0, stuIn.szGroupId, 0, groupId.getBytes().length);
        int max = 20;
        Structure[] groupInfo = new NetSDKLib.NET_FACERECONGNITION_GROUP_INFO[max];
        for (int i = 0; i < max; ++i) {
            groupInfo[i] = new NetSDKLib.NET_FACERECONGNITION_GROUP_INFO();
        }
        NetSDKLib.NET_OUT_FIND_GROUP_INFO stuOut = new NetSDKLib.NET_OUT_FIND_GROUP_INFO();
        stuOut.pGroupInfos = new Memory(groupInfo[0].size() * groupInfo.length);
        stuOut.pGroupInfos.clear(groupInfo[0].size() * groupInfo.length);
        stuOut.nMaxGroupNum = groupInfo.length;
        ToolKits.SetStructArrToPointerData(groupInfo, stuOut.pGroupInfos);
        if (LoginModule.netsdk.CLIENT_FindGroupInfo(LoginModule.m_hLoginHandle, stuIn, stuOut, 4000)) {
            ToolKits.GetPointerDataToStructArr(stuOut.pGroupInfos, groupInfo);
            if (stuOut.nRetGroupNum > 0) {
                groupInfoRet = new NetSDKLib.NET_FACERECONGNITION_GROUP_INFO[stuOut.nRetGroupNum];
                for (int i = 0; i < stuOut.nRetGroupNum; ++i) {
                    groupInfoRet[i] = groupInfo[i];
                }
            }
        } else {
            System.err.println("\u67e5\u8be2\u4eba\u5458\u4fe1\u606f\u5931\u8d25" + ToolKits.getErrorCodePrint());
            return null;
        }
        return groupInfoRet;
    }

    public static boolean addGroup(String groupName) {
        NetSDKLib.NET_ADD_FACERECONGNITION_GROUP_INFO addGroupInfo = new NetSDKLib.NET_ADD_FACERECONGNITION_GROUP_INFO();
        try {
            System.arraycopy(groupName.getBytes("GBK"), 0, addGroupInfo.stuGroupInfo.szGroupName, 0, groupName.getBytes("GBK").length);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        NetSDKLib.NET_IN_OPERATE_FACERECONGNITION_GROUP stuIn = new NetSDKLib.NET_IN_OPERATE_FACERECONGNITION_GROUP();
        stuIn.emOperateType = 1;
        stuIn.pOPerateInfo = addGroupInfo.getPointer();
        NetSDKLib.NET_OUT_OPERATE_FACERECONGNITION_GROUP stuOut = new NetSDKLib.NET_OUT_OPERATE_FACERECONGNITION_GROUP();
        addGroupInfo.write();
        boolean bRet = LoginModule.netsdk.CLIENT_OperateFaceRecognitionGroup(LoginModule.m_hLoginHandle, stuIn, stuOut, 4000);
        addGroupInfo.read();
        if (bRet) {
            System.out.println("\u4eba\u5458\u7ec4ID : " + new String(stuOut.szGroupId).trim());
        }
        return bRet;
    }

    public static boolean modifyGroup(String groupName, String groupId) {
        NetSDKLib.NET_MODIFY_FACERECONGNITION_GROUP_INFO modifyGroupInfo = new NetSDKLib.NET_MODIFY_FACERECONGNITION_GROUP_INFO();
        try {
            System.arraycopy(groupName.getBytes("GBK"), 0, modifyGroupInfo.stuGroupInfo.szGroupName, 0, groupName.getBytes("GBK").length);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        System.arraycopy(groupId.getBytes(), 0, modifyGroupInfo.stuGroupInfo.szGroupId, 0, groupId.getBytes().length);
        NetSDKLib.NET_IN_OPERATE_FACERECONGNITION_GROUP stuIn = new NetSDKLib.NET_IN_OPERATE_FACERECONGNITION_GROUP();
        stuIn.emOperateType = 2;
        stuIn.pOPerateInfo = modifyGroupInfo.getPointer();
        NetSDKLib.NET_OUT_OPERATE_FACERECONGNITION_GROUP stuOut = new NetSDKLib.NET_OUT_OPERATE_FACERECONGNITION_GROUP();
        modifyGroupInfo.write();
        boolean bRet = LoginModule.netsdk.CLIENT_OperateFaceRecognitionGroup(LoginModule.m_hLoginHandle, stuIn, stuOut, 4000);
        modifyGroupInfo.read();
        if (bRet) {
            System.out.println("\u4fee\u6539\u4eba\u8138\u5e93\u6210\u529f.");
        }
        return bRet;
    }

    public static boolean deleteGroup(String groupId) {
        NetSDKLib.NET_DELETE_FACERECONGNITION_GROUP_INFO deleteGroupInfo = new NetSDKLib.NET_DELETE_FACERECONGNITION_GROUP_INFO();
        System.arraycopy(groupId.getBytes(), 0, deleteGroupInfo.szGroupId, 0, groupId.getBytes().length);
        NetSDKLib.NET_IN_OPERATE_FACERECONGNITION_GROUP stuIn = new NetSDKLib.NET_IN_OPERATE_FACERECONGNITION_GROUP();
        stuIn.emOperateType = 3;
        stuIn.pOPerateInfo = deleteGroupInfo.getPointer();
        NetSDKLib.NET_OUT_OPERATE_FACERECONGNITION_GROUP stuOut = new NetSDKLib.NET_OUT_OPERATE_FACERECONGNITION_GROUP();
        deleteGroupInfo.write();
        boolean bRet = LoginModule.netsdk.CLIENT_OperateFaceRecognitionGroup(LoginModule.m_hLoginHandle, stuIn, stuOut, 4000);
        deleteGroupInfo.read();
        if (bRet) {
            System.out.println("\u5220\u9664\u4eba\u8138\u5e93\u6210\u529f.");
        }
        return bRet;
    }

    public static boolean putDisposition(String groupId, HashMap<Integer, Integer> hashMap) {
        int i = 0;
        NetSDKLib.NET_IN_FACE_RECOGNITION_PUT_DISPOSITION_INFO stuIn = new NetSDKLib.NET_IN_FACE_RECOGNITION_PUT_DISPOSITION_INFO();
        System.arraycopy(groupId.getBytes(), 0, stuIn.szGroupId, 0, groupId.getBytes().length);
        for (Map.Entry<Integer, Integer> entry : hashMap.entrySet()) {
            stuIn.stuDispositionChnInfo[i].nChannelID = entry.getKey() - 1;
            stuIn.stuDispositionChnInfo[i].nSimilary = entry.getValue();
            ++i;
        }
        stuIn.nDispositionChnNum = hashMap.size();
        NetSDKLib.NET_OUT_FACE_RECOGNITION_PUT_DISPOSITION_INFO stuOut = new NetSDKLib.NET_OUT_FACE_RECOGNITION_PUT_DISPOSITION_INFO();
        boolean bRet = LoginModule.netsdk.CLIENT_FaceRecognitionPutDisposition(LoginModule.m_hLoginHandle, stuIn, stuOut, 4000);
        if (bRet) {
            System.out.println("\u901a\u9053\u5e03\u63a7\u7ed3\u679c\u4e2a\u6570:" + stuOut.nReportCnt);
        }
        return bRet;
    }

    public static boolean delDisposition(String groupId, ArrayList<Integer> arrayList) {
        NetSDKLib.NET_IN_FACE_RECOGNITION_DEL_DISPOSITION_INFO stuIn = new NetSDKLib.NET_IN_FACE_RECOGNITION_DEL_DISPOSITION_INFO();
        System.arraycopy(groupId.getBytes(), 0, stuIn.szGroupId, 0, groupId.getBytes().length);
        for (int i = 0; i < arrayList.size(); ++i) {
            stuIn.nDispositionChn[i] = arrayList.get(i) - 1;
        }
        stuIn.nDispositionChnNum = arrayList.size();
        NetSDKLib.NET_OUT_FACE_RECOGNITION_DEL_DISPOSITION_INFO stuOut = new NetSDKLib.NET_OUT_FACE_RECOGNITION_DEL_DISPOSITION_INFO();
        boolean bRet = LoginModule.netsdk.CLIENT_FaceRecognitionDelDisposition(LoginModule.m_hLoginHandle, stuIn, stuOut, 4000);
        if (bRet) {
            System.out.println("\u901a\u9053\u64a4\u63a7\u7ed3\u679c\u4e2a\u6570:" + stuOut.nReportCnt);
        }
        return bRet;
    }

    public static void GetGroupInfoForChannel(int channel) {
        NetSDKLib.NET_IN_GET_GROUPINFO_FOR_CHANNEL stIn = new NetSDKLib.NET_IN_GET_GROUPINFO_FOR_CHANNEL();
        stIn.nChannelID = channel;
        NetSDKLib.NET_OUT_GET_GROUPINFO_FOR_CHANNEL stOut = new NetSDKLib.NET_OUT_GET_GROUPINFO_FOR_CHANNEL();
        if (LoginModule.netsdk.CLIENT_GetGroupInfoForChannel(LoginModule.m_hLoginHandle, stIn, stOut, 4000)) {
            for (int i = 0; i < stOut.nGroupIdNum; ++i) {
                System.out.println("\u4eba\u8138\u5e93ID\uff1a" + new String(stOut.szGroupIdArr[i].szGroupId).trim());
                System.out.println("\u76f8\u4f3c\u5ea6\uff1a" + stOut.nSimilary[i] + "\n");
            }
        } else {
            System.err.println("\u83b7\u53d6\u5e03\u63a7\u5728\u89c6\u9891\u901a\u9053\u7684\u7ec4\u4fe1\u606f\u5931\u8d25, " + ToolKits.getErrorCodePrint());
        }
    }

    public static void SetGroupInfoForChannel(int channel, String[] groupIds, int[] similarys) {
        NetSDKLib.NET_IN_SET_GROUPINFO_FOR_CHANNEL stIn = new NetSDKLib.NET_IN_SET_GROUPINFO_FOR_CHANNEL();
        stIn.nChannelID = channel;
        stIn.nGroupIdNum = groupIds.length;
        stIn.nSimilaryNum = similarys.length;
        for (int i = 0; i < groupIds.length; ++i) {
            System.arraycopy(groupIds[i].getBytes(), 0, stIn.szGroupIdArr[i].szGroupId, 0, groupIds[i].getBytes().length);
            stIn.nSimilary[i] = similarys[i];
        }
        NetSDKLib.NET_OUT_SET_GROUPINFO_FOR_CHANNEL stOut = new NetSDKLib.NET_OUT_SET_GROUPINFO_FOR_CHANNEL();
        if (LoginModule.netsdk.CLIENT_SetGroupInfoForChannel(LoginModule.m_hLoginHandle, stIn, stOut, 4000)) {
            // empty if block
        }
    }

    public static int startFindPerson(String groupId, boolean isStartBirthday, String startTime, boolean isEndBirthday, String endTime, String personName, int sex, int idType, String idNo) {
        m_FindHandle = null;
        nToken = 0;
        int nTotalCount = 0;
        NetSDKLib.NET_IN_STARTFIND_FACERECONGNITION stuIn = new NetSDKLib.NET_IN_STARTFIND_FACERECONGNITION();
        stuIn.bPersonExEnable = 1;
        System.arraycopy(groupId.getBytes(), 0, stuIn.stPersonInfoEx.szGroupID, 0, groupId.getBytes().length);
        try {
            System.arraycopy(personName.getBytes("GBK"), 0, stuIn.stPersonInfoEx.szPersonName, 0, personName.getBytes("GBK").length);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        stuIn.stPersonInfoEx.bySex = (byte)sex;
        stuIn.stPersonInfoEx.byIDType = (byte)idType;
        System.arraycopy(idNo.getBytes(), 0, stuIn.stPersonInfoEx.szID, 0, idNo.getBytes().length);
        stuIn.stFilterInfo.nGroupIdNum = 1;
        System.arraycopy(groupId.getBytes(), 0, stuIn.stFilterInfo.szGroupIdArr[0].szGroupId, 0, groupId.getBytes().length);
        stuIn.stFilterInfo.emFaceType = 1;
        if (isStartBirthday) {
            String[] startTimeStr = startTime.split("-");
            stuIn.stFilterInfo.stBirthdayRangeStart.dwYear = Integer.parseInt(startTimeStr[0]);
            stuIn.stFilterInfo.stBirthdayRangeStart.dwMonth = Integer.parseInt(startTimeStr[1]);
            stuIn.stFilterInfo.stBirthdayRangeStart.dwDay = Integer.parseInt(startTimeStr[2]);
        }
        if (isEndBirthday) {
            String[] endTimeStr = endTime.split("-");
            stuIn.stFilterInfo.stBirthdayRangeEnd.dwYear = Integer.parseInt(endTimeStr[0]);
            stuIn.stFilterInfo.stBirthdayRangeEnd.dwMonth = Integer.parseInt(endTimeStr[1]);
            stuIn.stFilterInfo.stBirthdayRangeEnd.dwDay = Integer.parseInt(endTimeStr[2]);
        }
        stuIn.stFilterInfo.nRangeNum = 1;
        stuIn.stFilterInfo.szRange[0] = 2;
        NetSDKLib.NET_OUT_STARTFIND_FACERECONGNITION stuOut = new NetSDKLib.NET_OUT_STARTFIND_FACERECONGNITION();
        stuIn.write();
        stuOut.write();
        if (LoginModule.netsdk.CLIENT_StartFindFaceRecognition(LoginModule.m_hLoginHandle, stuIn, stuOut, 4000)) {
            m_FindHandle = stuOut.lFindHandle;
            nTotalCount = stuOut.nTotalCount;
            nToken = stuOut.nToken;
        } else {
            System.out.println("CLIENT_StartFindFaceRecognition Failed, Error:" + ToolKits.getErrorCodePrint());
        }
        return nTotalCount;
    }

    public static NetSDKLib.CANDIDATE_INFOEX[] doFindPerson(int beginNum, int nCount) {
        NetSDKLib.NET_IN_DOFIND_FACERECONGNITION stuIn = new NetSDKLib.NET_IN_DOFIND_FACERECONGNITION();
        stuIn.lFindHandle = m_FindHandle;
        stuIn.nCount = nCount;
        stuIn.nBeginNum = beginNum;
        NetSDKLib.NET_OUT_DOFIND_FACERECONGNITION stuOut = new NetSDKLib.NET_OUT_DOFIND_FACERECONGNITION();
        stuOut.bUseCandidatesEx = 1;
        for (int i = 0; i < nCount; ++i) {
            stuOut.stuCandidatesEx[i].stPersonInfo.szFacePicInfo[0].nFilePathLen = 256;
            stuOut.stuCandidatesEx[i].stPersonInfo.szFacePicInfo[0].pszFilePath = new Memory(256L);
        }
        stuIn.write();
        stuOut.write();
        if (LoginModule.netsdk.CLIENT_DoFindFaceRecognition(stuIn, stuOut, 4000)) {
            stuIn.read();
            stuOut.read();
            if (stuOut.nCadidateExNum == 0) {
                return null;
            }
            NetSDKLib.CANDIDATE_INFOEX[] stuCandidatesEx = new NetSDKLib.CANDIDATE_INFOEX[stuOut.nCadidateExNum];
            for (int i = 0; i < stuOut.nCadidateExNum; ++i) {
                stuCandidatesEx[i] = new NetSDKLib.CANDIDATE_INFOEX();
                stuCandidatesEx[i] = stuOut.stuCandidatesEx[i];
            }
            return stuCandidatesEx;
        }
        System.out.println("CLIENT_DoFindFaceRecognition Failed, Error:" + ToolKits.getErrorCodePrint());
        return null;
    }

    public static boolean doFindPerson() {
        boolean bRet = false;
        if (m_FindHandle.longValue() != 0L) {
            bRet = LoginModule.netsdk.CLIENT_StopFindFaceRecognition(m_FindHandle);
        }
        return bRet;
    }

    public static boolean addPerson(String groupId, Memory memory, String personName, int sex, boolean isBirthday, String birthday, int byIdType, String idNo) {
        NetSDKLib.NET_IN_OPERATE_FACERECONGNITIONDB stuIn = new NetSDKLib.NET_IN_OPERATE_FACERECONGNITIONDB();
        stuIn.emOperateType = 1;
        stuIn.bUsePersonInfoEx = 1;
        System.arraycopy(groupId.getBytes(), 0, stuIn.stPersonInfoEx.szGroupID, 0, groupId.getBytes().length);
        if (isBirthday) {
            String[] birthdays = birthday.split("-");
            stuIn.stPersonInfoEx.wYear = (short)Integer.parseInt(birthdays[0]);
            stuIn.stPersonInfoEx.byMonth = (byte)Integer.parseInt(birthdays[1]);
            stuIn.stPersonInfoEx.byDay = (byte)Integer.parseInt(birthdays[2]);
        }
        stuIn.stPersonInfoEx.bySex = (byte)sex;
        try {
            System.arraycopy(personName.getBytes("GBK"), 0, stuIn.stPersonInfoEx.szPersonName, 0, personName.getBytes("GBK").length);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        stuIn.stPersonInfoEx.byIDType = (byte)byIdType;
        System.arraycopy(idNo.getBytes(), 0, stuIn.stPersonInfoEx.szID, 0, idNo.getBytes().length);
        if (memory != null) {
            stuIn.stPersonInfoEx.wFacePicNum = 1;
            stuIn.stPersonInfoEx.szFacePicInfo[0].dwFileLenth = (int)memory.size();
            stuIn.stPersonInfoEx.szFacePicInfo[0].dwOffSet = 0;
            stuIn.nBufferLen = (int)memory.size();
            stuIn.pBuffer = memory;
        }
        NetSDKLib.NET_OUT_OPERATE_FACERECONGNITIONDB stuOut = new NetSDKLib.NET_OUT_OPERATE_FACERECONGNITIONDB();
        stuIn.write();
        boolean bRet = LoginModule.netsdk.CLIENT_OperateFaceRecognitionDB(LoginModule.m_hLoginHandle, stuIn, stuOut, 3000);
        stuIn.read();
        if (bRet) {
            System.out.println("szUID :\u3000" + new String(stuOut.szUID).trim());
        } else {
            System.err.println(ToolKits.getErrorCodePrint());
        }
        return bRet;
    }

    public static boolean modifyPerson(String groupId, String uid, Memory memory, String personName, int sex, boolean isBirthday, String birthday, int byIdType, String idNo) {
        NetSDKLib.NET_IN_OPERATE_FACERECONGNITIONDB stuIn = new NetSDKLib.NET_IN_OPERATE_FACERECONGNITIONDB();
        stuIn.emOperateType = 3;
        stuIn.bUsePersonInfoEx = 1;
        System.arraycopy(groupId.getBytes(), 0, stuIn.stPersonInfoEx.szGroupID, 0, groupId.getBytes().length);
        System.arraycopy(uid.getBytes(), 0, stuIn.stPersonInfoEx.szUID, 0, uid.getBytes().length);
        if (isBirthday) {
            String[] birthdays = birthday.split("-");
            stuIn.stPersonInfoEx.wYear = (short)Integer.parseInt(birthdays[0]);
            stuIn.stPersonInfoEx.byMonth = (byte)Integer.parseInt(birthdays[1]);
            stuIn.stPersonInfoEx.byDay = (byte)Integer.parseInt(birthdays[2]);
        }
        stuIn.stPersonInfoEx.bySex = (byte)sex;
        try {
            System.arraycopy(personName.getBytes("GBK"), 0, stuIn.stPersonInfoEx.szPersonName, 0, personName.getBytes("GBK").length);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        stuIn.stPersonInfoEx.byIDType = (byte)byIdType;
        System.arraycopy(idNo.getBytes(), 0, stuIn.stPersonInfoEx.szID, 0, idNo.getBytes().length);
        if (memory != null) {
            stuIn.stPersonInfoEx.wFacePicNum = 1;
            stuIn.stPersonInfoEx.szFacePicInfo[0].dwFileLenth = (int)memory.size();
            stuIn.stPersonInfoEx.szFacePicInfo[0].dwOffSet = 0;
            stuIn.nBufferLen = (int)memory.size();
            stuIn.pBuffer = memory;
        }
        NetSDKLib.NET_OUT_OPERATE_FACERECONGNITIONDB stuOut = new NetSDKLib.NET_OUT_OPERATE_FACERECONGNITIONDB();
        stuIn.write();
        if (!LoginModule.netsdk.CLIENT_OperateFaceRecognitionDB(LoginModule.m_hLoginHandle, stuIn, stuOut, 3000)) {
            System.err.println("\u4fee\u6539\u4eba\u5458\u5931\u8d25" + ToolKits.getErrorCodePrint());
            return false;
        }
        stuIn.read();
        return true;
    }

    public static boolean delPerson(String groupId, String sUID) {
        NetSDKLib.NET_IN_OPERATE_FACERECONGNITIONDB stuIn = new NetSDKLib.NET_IN_OPERATE_FACERECONGNITIONDB();
        stuIn.emOperateType = 2;
        stuIn.bUsePersonInfoEx = 1;
        System.arraycopy(groupId.getBytes(), 0, stuIn.stPersonInfoEx.szGroupID, 0, groupId.getBytes().length);
        System.arraycopy(sUID.getBytes(), 0, stuIn.stPersonInfoEx.szUID, 0, sUID.getBytes().length);
        NetSDKLib.NET_OUT_OPERATE_FACERECONGNITIONDB stuOut = new NetSDKLib.NET_OUT_OPERATE_FACERECONGNITIONDB();
        boolean bRet = LoginModule.netsdk.CLIENT_OperateFaceRecognitionDB(LoginModule.m_hLoginHandle, stuIn, stuOut, 3000);
        if (!bRet) {
            System.err.println(LoginModule.netsdk.CLIENT_GetLastError());
        }
        return bRet;
    }

    public static boolean downloadPersonPic(String szFileName, String pszFileDst) {
        NetSDKLib.NET_IN_DOWNLOAD_REMOTE_FILE stuIn = new NetSDKLib.NET_IN_DOWNLOAD_REMOTE_FILE();
        stuIn.pszFileName = new NativeString(szFileName).getPointer();
        stuIn.pszFileDst = new NativeString(pszFileDst).getPointer();
        NetSDKLib.NET_OUT_DOWNLOAD_REMOTE_FILE stuOut = new NetSDKLib.NET_OUT_DOWNLOAD_REMOTE_FILE();
        if (!LoginModule.netsdk.CLIENT_DownloadRemoteFile(LoginModule.m_hLoginHandle, stuIn, stuOut, 5000)) {
            System.err.println("\u4e0b\u8f7d\u56fe\u7247\u5931\u8d25!" + ToolKits.getErrorCodePrint());
            return false;
        }
        return true;
    }

    public static void renderPrivateData(NetSDKLib.LLong m_hRealPlayHandle, int bTrue) {
        if (m_hRealPlayHandle.longValue() != 0L) {
            LoginModule.netsdk.CLIENT_RenderPrivateData(m_hRealPlayHandle, bTrue);
        }
    }

    public static boolean findFile(int nChn, String startTime, String endTime) {
        int type = 3;
        NetSDKLib.MEDIAFILE_FACERECOGNITION_PARAM findContion = new NetSDKLib.MEDIAFILE_FACERECOGNITION_PARAM();
        String[] starts = startTime.split(" ");
        findContion.stStartTime.dwYear = Integer.parseInt(starts[0].split("-")[0]);
        findContion.stStartTime.dwMonth = Integer.parseInt(starts[0].split("-")[1]);
        findContion.stStartTime.dwDay = Integer.parseInt(starts[0].split("-")[2]);
        findContion.stStartTime.dwHour = Integer.parseInt(starts[1].split(":")[0]);
        findContion.stStartTime.dwMinute = Integer.parseInt(starts[1].split(":")[1]);
        findContion.stStartTime.dwSecond = Integer.parseInt(starts[1].split(":")[2]);
        String[] ends = endTime.split(" ");
        findContion.stEndTime.dwYear = Integer.parseInt(ends[0].split("-")[0]);
        findContion.stEndTime.dwMonth = Integer.parseInt(ends[0].split("-")[1]);
        findContion.stEndTime.dwDay = Integer.parseInt(ends[0].split("-")[2]);
        findContion.stEndTime.dwHour = Integer.parseInt(ends[1].split(":")[0]);
        findContion.stEndTime.dwMinute = Integer.parseInt(ends[1].split(":")[1]);
        findContion.stEndTime.dwSecond = Integer.parseInt(ends[1].split(":")[2]);
        findContion.nChannelId = nChn;
        findContion.write();
        lFindHandle = LoginModule.netsdk.CLIENT_FindFileEx(LoginModule.m_hLoginHandle, type, findContion.getPointer(), null, 3000);
        if (lFindHandle.longValue() == 0L) {
            System.err.println("FindFileEx Failed!" + ToolKits.getErrorCodePrint());
            return false;
        }
        findContion.read();
        return true;
    }

    public static NetSDKLib.MEDIAFILE_FACERECOGNITION_INFO[] findNextFile(int nFindCount) {
        Structure[] msg = new NetSDKLib.MEDIAFILE_FACERECOGNITION_INFO[nFindCount];
        for (int i = 0; i < msg.length; ++i) {
            msg[i] = new NetSDKLib.MEDIAFILE_FACERECOGNITION_INFO();
            msg[i].bUseCandidatesEx = 1;
        }
        int MemorySize = msg[0].size() * nFindCount;
        Memory pointer = new Memory(MemorySize);
        pointer.clear(MemorySize);
        ToolKits.SetStructArrToPointerData(msg, pointer);
        int nRetCount = LoginModule.netsdk.CLIENT_FindNextFileEx(lFindHandle, nFindCount, pointer, MemorySize, null, 3000);
        ToolKits.GetPointerDataToStructArr(pointer, msg);
        if (nRetCount <= 0) {
            System.err.println("FindNextFileEx failed!" + ToolKits.getErrorCodePrint());
            return null;
        }
        NetSDKLib.MEDIAFILE_FACERECOGNITION_INFO[] retInfo = new NetSDKLib.MEDIAFILE_FACERECOGNITION_INFO[nRetCount];
        for (int i = 0; i < retInfo.length; ++i) {
            retInfo[i] = new NetSDKLib.MEDIAFILE_FACERECOGNITION_INFO();
            retInfo[i] = msg[i];
        }
        return retInfo;
    }

    public static void findCloseFile() {
        if (lFindHandle.longValue() != 0L) {
            LoginModule.netsdk.CLIENT_FindCloseEx(lFindHandle);
            lFindHandle.setValue(0L);
        }
    }
}

