/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.lib;

import com.netsdk.lib.DynamicParseUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;

public class LibraryLoad {
    private static final String ARCH_WINDOWS = "win";
    private static final String ARCH_LINUX = "linux";
    private static final String ARCH_MAC = "mac";
    private static final int PREFIX_64 = 64;
    private static final int PREFIX_32 = 32;
    private static final String PREFIX_ARM = "ARM";
    private static final String EXTERNAL_WIN = ".dll";
    private static final String EXTERNAL_LINUX = ".so";
    private static final String EXTERNAL_MAC = ".dylib";
    private static DynamicParseUtil dynamicParseUtil;
    private static String currentFold;
    private static String EXTRACT_PATH;
    private static boolean written;
    private static String INNER_PATH;

    public static void setExtractPath(String path) {
        EXTRACT_PATH = path;
    }

    public static String getExtractPath() {
        return EXTRACT_PATH;
    }

    private static String extractNetSDKLib(String libName) {
        return LibraryLoad.extractLibrary(libName);
    }

    public static String getLoadLibrary(String libraryName) {
        currentFold = LibraryLoad.getLibraryFold();
        if (dynamicParseUtil == null) {
            try {
                dynamicParseUtil = new DynamicParseUtil(LibraryLoad.class.getClassLoader().getResourceAsStream("dynamic-lib-load.xml"));
                if (!written) {
                    for (String libName : dynamicParseUtil.getLibsSystem(currentFold)) {
                        LibraryLoad.extractLibrary(libName);
                    }
                    written = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String fullName = LibraryLoad.getLibraryName(libraryName);
        String path = EXTRACT_PATH;
        if (!EXTRACT_PATH.endsWith("/") && !EXTRACT_PATH.endsWith("\\")) {
            path = EXTRACT_PATH + "/";
        }
        System.out.println("load library: " + path + fullName);
        return path + fullName;
    }

    private static String extractLibrary(String libName) {
        return LibraryLoad.extractLibrary("", libName);
    }

    private static String extractLibrary(String relativePath, String libName) {
        if (libName.trim().equals("")) {
            return "";
        }
        String libFullName = LibraryLoad.getLibraryName(libName);
        String dir = LibraryLoad.getLibraryFold();
        if (!relativePath.endsWith("/") && !relativePath.endsWith("\\")) {
            relativePath = relativePath + "/";
        }
        String fileName = relativePath + dir + "/" + libFullName;
        InputStream in = LibraryLoad.class.getResourceAsStream(fileName);
        File extractedLibFile = null;
        try {
            int len;
            String nativeTempDir;
            if (in == null) {
                in = new FileInputStream(fileName);
            }
            if (!(nativeTempDir = EXTRACT_PATH).endsWith("/") && !nativeTempDir.endsWith("\\")) {
                nativeTempDir = nativeTempDir + "/";
            }
            extractedLibFile = new File(nativeTempDir + libFullName);
            BufferedInputStream reader = new BufferedInputStream(in);
            FileOutputStream writer = new FileOutputStream(extractedLibFile);
            byte[] buffer = new byte[1024];
            while ((len = reader.read(buffer)) != 0 && len != -1) {
                writer.write(buffer, 0, len);
            }
            reader.close();
            writer.close();
            in.close();
        }
        catch (Exception e) {
            System.out.println("dynamic file[ " + fileName + " ] not found in project.please ensure you need this library.");
        }
        return extractedLibFile != null ? extractedLibFile.getAbsolutePath() : "";
    }

    private static String getLibraryName(String libName) {
        String dir = currentFold;
        String libPrefix = "";
        String libExtension = EXTERNAL_WIN;
        if (!dir.contains(ARCH_WINDOWS)) {
            libPrefix = "lib";
            libExtension = dir.contains(ARCH_LINUX) ? EXTERNAL_LINUX : EXTERNAL_MAC;
        }
        libName = dynamicParseUtil.compareLibName(currentFold, libName);
        return (libName.startsWith("lib") ? "" : libPrefix) + libName + libExtension;
    }

    private static String getLibraryFold() {
        String osName = System.getProperty("os.name");
        String osType = osName.toLowerCase().startsWith(ARCH_LINUX) ? ARCH_LINUX : (osName.toLowerCase().startsWith(ARCH_MAC) || osName.toLowerCase().startsWith("darwin") ? ARCH_MAC : (osName.toLowerCase().startsWith("windows") ? ARCH_WINDOWS : ""));
        String arch = System.getProperty("os.arch");
        if ("i386".equals(arch = arch.toLowerCase().trim()) || "i686".equals(arch) || "x86".equals(arch)) {
            arch = "32";
        } else if ("x86_64".equals(arch) || "amd64".equals(arch)) {
            arch = "64";
        } else if (arch.startsWith("arm")) {
            arch = PREFIX_ARM;
        }
        return osType + arch;
    }

    static {
        EXTRACT_PATH = System.getProperty("java.io.tmpdir");
        written = false;
    }
}

